<?php

//---------------------------------------------------------------------------------------------------------
// 03/Abril/2019
// Versión 1.0 Fichero totalmente reescrito para que muestre una dirección de envío con el formato que el usuario elija
//---------------------------------------------------------------------------------------------------------
function widget_direcciones_envio(){
		//Aquí definimos una serie de parámetros que necesitamos
		$funcion_por_defecto = 'direccion_envio';
		$parametros_por_defecto = array();
		$parametros_recibidos = func_get_args();
		if (count($parametros_recibidos) == 0){
			$parametros_recibidos[0] = $funcion_por_defecto;
		}else{
			if ( ($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL) ){
				$parametros_recibidos[0] = $funcion_por_defecto;
			}
		}
		$parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
		$retorno = false;
		//Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
		if (count($parametros_recibidos) > 0){
			//Recogemos el nombre de la función de entre el resto de parámetros
			$nombre_funcion = $parametros_recibidos[0];
			//Quitamos el primer elemento de los parámetros, pues es el nombre de la función
			$parametros_recibidos = array_slice($parametros_recibidos, 1);
			//Si la función existe la ejecutamos
			if(function_exists($nombre_funcion)){
				$retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
			}
		}
		return($retorno);
	}


function direccion_envio($opciones = NULL) {
    $obj_direccion_envio = NULL;
    $fichero_direccion = 'direccion_envio';
    $usuario = Usuario::logueado();
    if (is_a($opciones, 'OpcionesWidget')) {
		$obj_direccion_envio = ($opciones->configuracion->obj_direccion_envio !== NULL) ? $opciones->configuracion->obj_direccion_envio : $obj_direccion_envio;
		$fichero_direccion = ($opciones->configuracion->fichero_direccion !== NULL) ? $opciones->configuracion->fichero_direccion : $fichero_direccion;
		$usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
    }
    //Vamos a generar un ID único para esta capa. Hay que tener en cuenta que debe ser selecionabel por el código de la línea y además debe permitir obtener el tipo de fichero
    $id = 'codigo_' . $obj_direccion_envio->codigo . '_' . date('His') . substr((string) microtime(), 4, 4) . '_' . $fichero_direccion;
    ?>
    <div class="<?= (__FUNCTION__); ?>" reference="<?= $id; ?>">
        <?php
        $ruta = Theme::findFile($fichero_direccion . '.php');
        if ($ruta != NULL) {
            include($ruta);
        }
        if (is_int($usuario)) {
            $usuario = new Usuario($usuario);
        }
        $usuario_a_mostrar = $usuario;
        ?>
    </div>
    <?php
}
