<?php
	//---------------------------------------------------------------------------------------------------------
	// 08/Octubre/2014
	// Versión 1.0 Este php contiene la función encargada de mostrar la miga según el caso
	//---------------------------------------------------------------------------------------------------------
	// 16/Octubre/2014
	// Versión 2.0 Creamos esta opcion web como widget. Se pasa como parámetro la función a ejecutar (el tipo de objeto que queremos crear)
	//---------------------------------------------------------------------------------------------------------

	

	function widget_lanzador_widget($nombre_funcion = 'lanzador_widget', $objetivo = '', $texto_a_mostrar = '', $tipo = 'a', $accion='click', $clase = 'lanzador_widget', $id = '', $identificador_interno = NULL){
		include('comunes/globals.php');
		$retorno = false;
		//Vamos a empezar haciendo una comprobación de los elementos que tenemos
		$elementos_permitidos = array('body', 'section', 'nav', 'article', 'aside', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'footer', 'address', 'main', 'p', 'hr', 'pre', 'blockquote', 'ol', 'ul', 'li', 'dl', 'dt', 'dd', 'figure', 'figcaption', 'div', 'a', 'em', 'strong', 'small', 's', 'cite', 'q', 'dfn', 'abbr', 'data', 'time', 'code', 'var', 'samp', 'kbd', 'sub', 'sup', 'i', 'b', 'u', 'mark', 'ruby', 'rt', 'rp', 'bdi', 'bdo', 'span', 'br', 'wbr', 'ins', 'del', 'img', 'iframe', 'embed', 'object', 'param', 'video', 'audio', 'source', 'track', 'canvas', 'map', 'area', 'svg', 'math', 'table', 'caption', 'colgroup', 'col', 'tbody', 'thead', 'tfoot', 'tr', 'td', 'th', 'form', 'fieldset', 'legend', 'label', 'input', 'button', 'select', 'datalist', 'optgroup', 'option', 'textarea', 'keygen', 'output', 'progress', 'meter', 'details', 'summary', 'command', 'menu');
		//$eventos_permitidos = array( 'onclick', 'ondblclick', 'onmousedown', 'onmouseup', 'onmouseover', "onmousemove", "onmouseout", "onkeypress", "onkeydown", "onkeyup", "onfocus", "onblur", "onload", "onunload", "onchange", "onselect", "onmouseenter", "onmouseleave");
		$eventos_permitidos = array( 'click', 'dblclick', 'mousedown', 'mouseup', 'mouseover', 'mousemove', 'mouseout', 'keypress', 'keydown', 'keyup', 'focus', 'blur', 'load', 'unload', 'change', 'select', 'mouseenter', 'mouseleave');
		if (!in_array($tipo, $elementos_permitidos)){
			$tipo = 'a';
		}
		//Hemos adaptado los eventos a jquery, así que hay que quitar la palabra 'on' a la acción
		$accion = str_replace('on', '', $accion);
		if (!in_array($accion, $eventos_permitidos)){
			$accion = 'click';
		}

		//Comprobamos si existe la función que nos han pasado y si existe la ejecutamos
		if(function_exists($nombre_funcion)){
			$retorno = $nombre_funcion($objetivo, $texto_a_mostrar, $tipo, $accion, $clase, $id, $identificador_interno);
		}
		return($retorno);
	}

	function lanzador_widget($objetivo, $texto_a_mostrar = '', $tipo = '', $accion = '', $clase = '', $id = '', $identificador_interno = NULL){
		include('comunes/globals.php');
                if (($objetivo != NULL) && (is_a($objetivo, "OpcionesWidget"))) {
                    $opciones = $objetivo;
                    $objetivo = NULL;
                    $texto_a_mostrar = '';
                    $tipo = '';
                    $accion = '';
                    $clave = '';
                    $id = '';
                    $identificador_interno = NULL;
                    if (is_a($opciones, 'OpcionesWidget')) {
                        $objetivo = ($opciones->configuracion->objetivo != NULL) ? $opciones->configuracion->objetivo : $objetivo;
                        $texto_a_mostrar = ($opciones->configuracion->texto_a_mostrar != NULL) ? $opciones->configuracion->texto_a_mostrar : $texto_a_mostrar;
                        $tipo = ($opciones->configuracion->tipo != NULL) ? $opciones->configuracion->tipo : $tipo;
                        $accion = ($opciones->configuracion->accion != NULL) ? $opciones->configuracion->accion : $accion;
                        $clase = ($opciones->configuracion->clase != NULL) ? $opciones->configuracion->clase : $clase;
                        $id = ($opciones->configuracion->id != NULL) ? $opciones->configuracion->id : $id;
                        $identificador_interno = ($opciones->configuracion->identificador_interno != NULL) ? $opciones->configuracion->identificador_interno : $identificador_interno;
                    }
                }
		//Creamos el lanzador utilizando el tipo
		if ($id != ""){
			$id = ' id="' . $id . '" ';
		}
		if ($clase != ""){
			$clase = ' class="' . $clase . '" ';
		}
		if (is_string($objetivo)){
			$id_objetivo = $objetivo;
		}else{
			$id_objetivo = $objetivo->mostrar();
		}

		//Atributos opcionales
		$atributos_opcionales = "";
		if ($tipo == "a"){
			$atributos_opcionales = ' href="javascript:void(0);" ';
		}
		
?>
	<<?=$tipo;?> <?=$id;?> <?=$clase;?> <?=$atributos_opcionales;?>>
<?php
		//Ojo, es posible que el $texto_a_mostrar sea un objeto, en cuyo caso hay que comprobar si se puede "mostrar()";
		if (gettype($texto_a_mostrar) == 'object'){
			if (method_exists($texto_a_mostrar, 'mostrar') ){
				$texto_a_mostrar->mostrar();
			}
		}else if (gettype($texto_a_mostrar) == 'string'){
			echo($texto_a_mostrar);
		}

		//Tenemos que obtener la clase del objetivo del widget:
		$origen_widget = explode('_', $id_objetivo);
		//El ID puede tener guiones bajos, así que vamos a crear una cadena con todos los elementos menos el último
		$cadena = '';
		for ($i = 0; $i < (count($origen_widget)-1); $i++){
			$cadena .= (($cadena != '') ? '_' : '') . $origen_widget[$i];
		}
		$origen_widget = $cadena;
		//Voy a buscar mensajes de este lanzador de widget, para ello necesito el array de búsqueda con el origen y con el identificador interno igual a la clase
		$array_busqueda_mensaje = array('origen' => "/^$origen_widget$/");
		if ($identificador_interno != NULL){
			$array_busqueda_mensaje["funcion"] = "/^$identificador_interno$/";
		}
		//echo("<pre>Busqueda:\n");
		//print_r($array_busqueda_mensaje);
		//print_r($listaSysMsg);
		//echo("</pre>");
		
		//Cómo siempre tenemos un ID, vamos a quitarle la palabra id y los " "
		$buscar = array("id=", '"');
		$reemplazo = array("", "");
		$id = str_replace($buscar, $reemplazo, $id);
?>
	</<?=$tipo;?>>
<?php
		//Vamos a asignar un ID al script
		$script_id = 'script_' . incrementa_contador(true);
?>
	<script type="text/javascript" id="<?=$script_id;?>">
	document.addEventListener('WSLE', function(event) {
		//Cambiamos a una funcion anonima
		;(function() {
			var widgetObjetive = getLastHtmlObject('<?=$script_id;?>');
			widgetObjetive.on('<?=$accion?>', function(event){
				componentList.show('<?=$id_objetivo;?>');
			});
		}());
	});
	</script>
<?php
//Pedro 01/Febrero/2019 ==> La clase de lista de mensajes del sistema tiene que desaparecer
/*	
		//Tenemos que localizar un mensaje de del origen de este widget
        $mensajes_de_este_widget = $listaSysMsg->findElement($array_busqueda_mensaje);
		if ($mensajes_de_este_widget != NULL){
			//echo("<pre>El origen es: $origen_widget</pre>");
			//Hay un mensaje pendiente para este widget. Hay que lanzarlo
?>
<script type="application/javascript">
document.addEventListener('WSLE', function(event) {
	componentList.show('<?=$id_objetivo;?>');
});
</script>
<?php
		}
		*/
	}