<?php

//---------------------------------------------------------------------------------------------------------
// 21/Mayo/2015
// Versión 1.0 Widget que se usa para mostrar información referente a los lotes
//---------------------------------------------------------------------------------------------------------



function widget_lotes() {
	include('comunes/globals.php');
	//Aquí definimos una serie de parámetros que necesitamos
	$funcion_por_defecto = 'muestra_lote';
	$parametros_por_defecto = array();
	$parametros_recibidos = func_get_args();
	if (count($parametros_recibidos) == 0) {
		$parametros_recibidos[0] = $funcion_por_defecto;
	} else {
		if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
			$parametros_recibidos[0] = $funcion_por_defecto;
		}
	}
	$parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
	$retorno = false;
	//Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
	if (count($parametros_recibidos) > 0) {
		//Recogemos el nombre de la función de entre el resto de parámetros
		$nombre_funcion = $parametros_recibidos[0];
		//Quitamos el primer elemento de los parámetros, pues es el nombre de la función
		$parametros_recibidos = array_slice($parametros_recibidos, 1);
		//Si la función existe la ejecutamos
		if (function_exists($nombre_funcion)) {
			$retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
		}
	}
	return($retorno);
}

function muestra_lote($codigo_lote = 0) {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (($codigo_lote != NULL) && (is_a($codigo_lote, "OpcionesWidget"))) {
		$opciones = $codigo_lote;
		$codigo_lote = 0;
		if (is_a($opciones, 'OpcionesWidget')) {
			$codigo_lote = ($opciones->configuracion->codigo_lote != NULL) ? $opciones->configuracion->codigo_lote : $codigo_lote;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	$obj_lote = new Lote($codigo_lote);
	$retorno = false;
	if ($obj_lote->codigo > 0) {
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
			<div class="<?= (__FUNCTION__); ?>">
				<?php
			}
			?>
			<?php
			/*
			  echo '<pre>';
			  print_r($obj_lote);
			  echo '</pre>'; */
			?>
			<?php
			if (!$ocultarCabecera) {
				?>
			</div>
			<?php
		}
		?>
		<?php
	}
	return($retorno);
}

function venta_lote($codigo_lote = 0, $fichero = 'linea_venta_lote') {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	$lote_a_mostrar = NULL;
	$lote_a_mostrar = new Lote($codigo_lote);

	if (($codigo_lote != NULL) && (is_a($codigo_lote, "OpcionesWidget"))) {
		$opciones = $codigo_lote;
		$codigo_lote = 0;
		$fichero = 'linea_venta_lote';
		if (is_a($opciones, 'OpcionesWidget')) {
			$codigo_lote = ($opciones->configuracion->codigo_lote != NULL) ? $opciones->configuracion->codigo_lote : $codigo_lote;
			$fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : $fichero;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<form class="form_venta_lote" action="<?= Shop::$configuracion->url; ?>cesta" method="post">
			<input type="hidden" value="<?= $lote_a_mostrar->codigo; ?>" name="cod_lote" />
			<?php
			//Vamos a mirar si ya hay descuento de lote
			if (!is_numeric($codigo_lote)) {
				$indice_dto_lote = lote::codigo_de_nombre($codigo_lote);
			} else {
				$indice_dto_lote = $codigo_lote;
			}
			$indice_dto_lote = lote::buscar_dto_lote($indice_dto_lote);
			$cod_dto_lote_actual = "";
			$porcen_dto_actual = 0;
			if ($indice_dto_lote > -1) {
				$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
				$cod_dto_lote_actual = explode('|', $array_descuentos_lotes[$indice_dto_lote]);
				$porcen_dto_actual = $cod_dto_lote_actual[1];
				$cod_dto_lote_actual = $cod_dto_lote_actual[2];
			}
			?>
			<input type="hidden" name="porcen_dto_lote" value="<?= $porcen_dto_actual; ?>" />
			<input type="hidden" name="cod_dto_lote" value="<?= $cod_dto_lote_actual; ?>" />
			<?php
			$contador_lineas = 0;
			/* echo("<!--");
			  print_r($lote_a_mostrar);
			  echo("-->");
			 */
			foreach ($lote_a_mostrar->lineas_lote as $clave => $valor) {
				$articulo_a_mostrar = $valor->articulo;
				$linea_lote_a_mostrar = $valor;
				?>
				<fieldset class="linea_venta_lote">
					<div class="lote_menos">
						<a class="boton_menos" href="javascript:void(0);">-</a>
						<script type="text/javascript" >
						document.addEventListener('WSLE', function(event) {
							//Cuando hagamos click en este elemento, vamos a restar 1 a la cantidad
							;(function () {
								var elementObjetive = getLastHtmlObject();
								elementObjetive.on("click", function (event) {
									//Hay que encontrar el input
									var objetoInput = $("input[name='cantidad_lote[<?= $contador_lineas; ?>]']");
									var cantidad_actual = objetoInput.val();
									if (cantidad_actual > 0) {
										objetoInput.val(cantidad_actual - 1);
									}
								});
							}());
						});
						</script>
					</div>
					<input type="number" class="linea_lote_cantidad" name="cantidad_lote[<?= $contador_lineas; ?>]" value="<?= articulo_cantidad_en_lote($linea_lote_a_mostrar); ?>" />
					<input type="hidden" class="linea_lote_multiplicador" name="multiplicador_lote[<?= $contador_lineas; ?>]" value="<?= $linea_lote_a_mostrar->cantidad; ?>" />
					<div class="lote_mas">
						<a class="boton_mas" href="javascript:void(0);">+</a>
						<script type="text/javascript" >
						document.addEventListener('WSLE', function(event) {
							//Cuando hagamos click en este elemento, vamos a restar 1 a la cantidad
							;(function () {
								var elementObjetive = getLastHtmlObject();
								elementObjetive.on("click", function (event) {
									//Hay que encontrar el input
									var objetoInput = $("input[name='cantidad_lote[<?= $contador_lineas; ?>]']");
									var cantidad_actual = objetoInput.val();
									cantidad_actual++;
									objetoInput.val(cantidad_actual);
								});
							}());
						});
						</script>
					</div>
					<?php
					// lote_contenedor_cantidad($articulo_a_mostrar, $lote_a_mostrar->codigo);
					$ruta = Theme::findFile($fichero . '.php');
					if ($ruta != NULL) {
						include($ruta);
					}
					?>
					<input type="hidden" name="articulo_lote[<?= $contador_lineas; ?>]" value="<?= $articulo_a_mostrar->codigo; ?>" />
				</fieldset>
				<?php
				$contador_lineas++;
			}
			?>
			<input type="submit" name="Comprar" value="Comprar" />
		</form>
		<?php
        $nombre_script = 'script_' . incrementa_contador();
		?>
		<script id="<?=$nombre_script;?>">
		document.addEventListener('WSLE', function(event) {
			;(function () {
				var elementObjetive = getLastHtmlObject('<?=$nombre_script;?>');
				elementObjetive.on("submit", function (event) {
					var suma = 0;
					$(this).find("input[name*='cantidad_lote']").each(function () {
						suma += parseInt($(this).val());
					});
					if (suma == 0) {
						event.preventDefault();
					}
				});
			}());
		});
		</script>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
	unset($lote_a_mostrar);
	return(true);
}

function lote_mostrar_colegios($opciones = NULL) {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (is_a($opciones, 'OpcionesWidget')) {
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
	}
	//Esta select es para coger el nombre del colegio
	//$sentencia_sql = "SELECT SUBSTRING_INDEX( nombre,  '/' , -1 ) FROM mc_lotes LIMIT 0 , 30";
	$sentencia_sql = "SELECT DISTINCT nombre_lote FROM
							(SELECT SUBSTRING_INDEX( nombre,  '/' , 1 ) nombre_lote, visible_web FROM mc_lotes) consulta
							WHERE visible_web = 1 ORDER BY nombre_lote ASC";
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		if ($conexionBD) {
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
				while ($fila = mysqli_fetch_array($resultado)) {
					?>
					<a href="<?= Shop::$configuracion->url; ?>cursos/<?= corregir_url($fila['nombre_lote']); ?>" title="<?= traducir('Seleccionar colegio') . ' ' . $fila['nombre_lote']; ?>"><?= $fila["nombre_lote"]; ?></a>
					<?php
				}
			}
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

function lote_mostrar_cursos($colegio = "") {
	$ocultarCabecera = false;

	if (($colegio != NULL) && (is_a($colegio, "OpcionesWidget"))) {
		$opciones = $colegio;
		$colegio = "";
		if (is_a($opciones, 'OpcionesWidget')) {
			$colegio = ($opciones->configuracion->colegio != NULL) ? $opciones->configuracion->colegio : $colegio;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	if ($colegio != "") {
		//Si el colegio tiene "_" hay que cambiarlos por espacios
		include('comunes/globals.php');
		//Esta select es para coger el nombre del curso
		$sentencia_sql = "SELECT DISTINCT nombre_lote, nombre FROM
								(SELECT SUBSTRING_INDEX( nombre,  '/' , -1 ) nombre_lote, nombre, visible_web FROM mc_lotes WHERE nombre LIKE '%$colegio%' AND visible_web = 1) consulta
								WHERE visible_web = 1 ORDER BY nombre_lote ASC";
		if (!$ocultarCabecera) {
			?>
			<div class="<?= (__FUNCTION__); ?>">
				<?php
			}
			?>
			<?php
			if ($conexionBD) {
				if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
					while ($fila = mysqli_fetch_array($resultado)) {
						?>
						<a href="<?= Shop::$configuracion->url; ?>venta_lote/<?= corregir_url($fila['nombre']); ?>" title="<?= traducir('Seleccionar curso') . ' ' . $fila['nombre_lote']; ?>"><?= $fila['nombre_lote']; ?></a>
						<?php
					}
				}
			}
			?>
			<?php
			if (!$ocultarCabecera) {
				?>
			</div>
			<?php
		}
		?>
		<?php
	}
}

function lote_pedir_cod_descuento($codigo_lote = NULL) {
	$ocultarCabecera = false;

	if (($codigo_lote != NULL) && (is_a($codigo_lote, "OpcionesWidget"))) {
		$opciones = $codigo_lote;
		$codigo_lote = NULL;
		if (is_a($opciones, 'OpcionesWidget')) {
			$codigo_lote = ($opciones->configuracion->codigo_lote != NULL) ? $opciones->configuracion->codigo_lote : $codigo_lote;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}

	if ($codigo_lote != NULL) {
		if (!is_numeric($codigo_lote)) {
			$codigo_lote = lote::codigo_de_nombre($codigo_lote);
		}
		//Si el colegio tiene "_" hay que cambiarlos por espacios
		include('comunes/globals.php');
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
			<div class="<?= (__FUNCTION__); ?>">
				<?php
			}
			?>
			<form action="<?= Shop::$configuracion->url ?>comunes/consultas/descuento_lote_verificar.php" method="post" class="formulario_descuento_lote">
				<?php
				//Vamos a ver si tenemos el lote ya con un dto
				$indice_dto_lote = lote::buscar_dto_lote($codigo_lote);
				$cod_dto_lote_actual = "";
				$porcen_dto_actual = 0;
				if ($indice_dto_lote > -1) {
					$array_descuentos_lotes = Sesion::get('array_descuentos_lotes');
					$cod_dto_lote_actual = explode('|', $array_descuentos_lotes[$indice_dto_lote]);
					$porcen_dto_actual = $cod_dto_lote_actual[1];
					$cod_dto_lote_actual = $cod_dto_lote_actual[2];
				}
				?>
				<fieldset >
					<label><?= traducir('Si dispone de un código de descuento, introdúzcalo y pulse el botón ') . '<strong>' . traducir("'verificar código de descuento'") . '</strong>'; ?></label>
					<input type="text" name="cod_descuento_lote" value="<?= $cod_dto_lote_actual; ?>" <?= ($cod_dto_lote_actual != "") ? 'disabled="disabled"' : ""; ?>/>
					<input type="hidden" name="lote" value="<?= $codigo_lote; ?>" />
					<input type="submit" name="enviar" value="<?= traducir('Verificar código de descuento'); ?>" style="<?= ($cod_dto_lote_actual != '') ? 'display:none;' : ''; ?>"/>
				</fieldset>
			</form>
			<?php
			$nombre_script = 'script_' . incrementa_contador();
			?>
			<script id="<?= $nombre_script; ?>">
			document.addEventListener('WSLE', function(event) {
				;(function () {
					var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
					elementObjetive.on("submit", function (event) {
						//Lo primero es cancelar el evento
						event.preventDefault();
						//Vamos a coger los objtos que necesitamos
						var submitBTN = $(this).find("input[type='submit']");
						var capa_verificando = $(this).parent("div").find(".verificando_cod_dto");
						var capa_resultado = $(this).parent("div").find(".resultado_cod_dto");
						var capa_anular = $(this).parent("div").find(".anular_cod_dto_lote");
						var campo_dto_lote = $(this).find("input[name='porcen_dto_lote']");
						var campo_codigo = $(this).find("input[name='cod_descuento_lote']");
						//Ocultamos el input y mostramos el texto de "cargando"
						submitBTN.hide('fast');
						capa_verificando.show('show');
						capa_resultado.hide('fast');
						capa_resultado.html("");

						//Obtenemos los datos del formulario
						var url = $(this).attr("action");
						var cod_descuento_lote = campo_codigo.val();
						var lote = $(this).find("input[name='lote']").val();
						//Vamos a realizar la consulta
						var parametros = "lote=" + lote + "&cod_descuento_lote=" + cod_descuento_lote + "&hash=<?= genera_cod_seguridad(); ?>";
						realizar_solicitud(url, parametros, function (respuesta) {
							//console.log(respuesta);
							capa_verificando.hide('show');
							var texto_resultado = "";
							if (respuesta > 0) {
								texto_resultado = '<div class="codigo_correcto"><p><?= traducir("El código de descuento proporcionado es correcto"); ?>.</p> <p><?= traducir("Descuento a aplicar "); ?> <strong>' + respuesta + "</strong><span>%</span>.</p></div>";
								capa_resultado.find("a").show('fast');
								campo_dto_lote.val(respuesta);
								capa_anular.show('fast');
								$("input[name='porcen_dto_lote']").val(respuesta);
								$("input[name='cod_dto_lote']").val(cod_descuento_lote);
								campo_codigo.prop("disabled", "disabled");
							} else {
								submitBTN.show('fast');
								texto_resultado = '<div class="codigo_incorrecto"><?= traducir("Código de descuento incorrecto."); ?></div>';
							}
							capa_resultado.html(texto_resultado);
							capa_resultado.show('fast');
						});
					});
				}());
			});
			</script>
			<div class="verificando_cod_dto" style="display:none;"><?= traducir("Verificando código de descuento"); ?></div>
			<div class="resultado_cod_dto" style="<?= ($cod_dto_lote_actual != "") ? "" : 'display:none;'; ?>">
				<?php
				if ($cod_dto_lote_actual != "") {
					?>
					<p><?= traducir('El código de descuento proporcionado es correcto'); ?>.</p><p> <?= traducir('Descuento a aplicar '); ?> <strong><?= $porcen_dto_actual; ?></strong><span>%</span>.</p>
					<?php
				}
				?>
			</div>
			<div class="anular_cod_dto_lote" style="<?= ($cod_dto_lote_actual != '') ? '' : 'display:none;'; ?>">
				<a href="javascript:void(0);" title="<?= traducir("Anular descuento"); ?>" class="boton"><?= traducir('Anular descuento'); ?></a>
				<script id="<?= $nombre_script; ?>">
				document.addEventListener('WSLE', function(event) {
					;(function () {
						var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
						elementObjetive.on("click", function () {
							$(this).parent("div").parent("div").find("input[type='submit']").show("fast");
							$(this).parent("div").parent("div").find("div.resultado_cod_dto").hide("fast");
							$(this).parent("div").parent("div").find("div.anular_cod_dto_lote").hide("fast");
							$("input[name='porcen_dto_lote']").val(0);
							$("input[name='cod_dto_lote']").val("");
							$(this).parent("div").parent("div").find("input[name='cod_descuento_lote']").removeProp("disabled");
						});
					}());
				});
				</script>
			</div>
			<?php
			if (!$ocultarCabecera) {
				?>
			</div>
			<?php
		}
		?>
		<?php
	}
}

//Busqueda de por lote
function busqueda_lote($opciones = NULL) {
	include 'comunes/globals.php';
	$ocultarCabecera = false;
	if (is_a($opciones, 'OpcionesWidget')) {
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
	}
	?>
	<?php
	if ($ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<form name="busqueda_lotes" id="busqueda_lote" class="busqueda_lote" method="post" action="<?= Shop::$configuracion->url ?>">
			<fieldset>
				<input type="text" name="lote_buscar" value="<?= $lote_buscar; ?>" placeholder="Introduce tu colegio"/>
				<input type="submit" id="btn_buscar_lote" value="<?= traducir("Buscar mis libros"); ?>" class="boton" />
			</fieldset>
		</form>
		<?php
        $nombre_script = 'script_' . incrementa_contador();
		?>
		<script id="<?= $nombre_script; ?>">
		document.addEventListener('WSLE', function(event) {
			;(function () {
				var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
				elementObjetive.on("submit", function (evt) {
					evt.preventDefault();
					var valor = $("input[name='lote_buscar']").val();
					if (valor) {
						$(location).attr('href', "<?= Shop::$configuracion->url ?>busqueda_lote/" + valor);
					}
				});
			}());
		});
		</script>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

function resultado_busqueda_lote($opciones = NULL) {
	include 'comunes/globals.php';

	$ocultarCabecera = false;
	if (is_a($opciones, 'OpcionesWidget')) {
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
	}

	$nombre = ($opciones->configuracion->nombre_lote != NULL) ? $opciones->configuracion->nombre_lote : "1";
	$fichero = $fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : "mostrar_lote";
	?>
	<?php
	if ($ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		if ($conexionBD) {
			$sentencia = 'SELECT * FROM  `mc_lotes` WHERE visible_web = 1 AND `nombre` LIKE "%' . $nombre . '%"';
			//echo $sentencia;
			$ruta_fichero = Theme::findFile($fichero . ".php");
			$resultado = mysqli_query($conexionBD, $sentencia);
			while ($fila = mysqli_fetch_array($resultado)) {
				$url = Shop::$configuracion->url . 'venta_lote/';
				$codigo = $fila['codigo'];
				$nombre = $fila['nombre']; //estoy reciclando la variable
				$trabaja_cantidades = $fila['trabaja_cantidades'];
				$observaciones = $fila['observaciones'];
				$total = $fila['total'];
				$cantidad = $fila['cantidad'];
				$codigo_anterior = $fila['codigo_anterior'];
				$ano_lote = $fila['ano_lote'];
				$precio_lote = $fila['precio_lote'];
				$visible_web = $fila['visible_web'];
				// Hacemos un strstr para buscar la primera aparicion de la / si no esta devuelve false, por lo que el lote no sale.
				if (strstr($nombre, '/')) {
					$partes = explode('/', $nombre);
					$url .= $partes[0] . '/' . $partes[1];
					include($ruta_fichero);
				}
			}
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

//---------------------------------------------------------------------------------------------------------------
// FUNCIONES QUE UTILIZAMOS EN ESTE WIDGET
//---------------------------------------------------------------------------------------------------------------
function articulo_cantidad_en_lote($linea_lote = NULL) {
	$retorno = 0;
	//No hacemos nada si el lote es nulo o el ean 0
	if ($linea_lote != NULL) {
		$array_cantidades_cesta = Sesion::get('array_cantidades_cesta');
		$indice = busca_articulo_cesta($linea_lote->articulo->codigo, $linea_lote->mc_lote);
		/* if ($indice === -1){
		  echo 0;
		  }
		 */
		for ($i = 0; $i < sizeof($array_cantidades_cesta); $i++) {
			if ($i === $indice) {
				//Las líneas de lote llevan una cantidad, hay que dividirla
				$retorno = $array_cantidades_cesta[$i] / $linea_lote->cantidad;
			}
		}
	}
	//Por si el retorno es decimal:
	$retorno = round($retorno);
	return($retorno);
}
?>