<?php

//---------------------------------------------------------------------------------------------------------
// 08/Octubre/2014
// Versión 1.0 Este php contiene la función encargada de mostrar la miga según el caso
//---------------------------------------------------------------------------------------------------------
// 16/Octubre/2014
// Versión 2.0 Creamos esta opcion web como widget. Se pasa como parámetro la función a ejecutar (el tipo de objeto que queremos crear)
//---------------------------------------------------------------------------------------------------------



function widget_paginador() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'paginador';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function paginador($enlace, $total_elementos = 0, $pagina_actual = 0, $elementos_por_pagina = NULL) {
    include('comunes/globals.php');
    $ocultarCabecera = false;
	$filtro = '';
    if (($enlace != NULL) && (is_a($enlace, "OpcionesWidget"))) {
        $opciones = $enlace;
        $enlace = NULL;
        $total_elementos = 0;
		$pagina_actual = Sections::getParam('pagina', 0);
        $elementos_por_pagina = NULL;
		$filtro = '';
        if (is_a($opciones, 'OpcionesWidget')) {
            $enlace = ($opciones->configuracion->enlace != NULL) ? $opciones->configuracion->enlace : $enlace;
            $total_elementos = ($opciones->configuracion->total_elementos != NULL) ? $opciones->configuracion->total_elementos : $total_elementos;
            $pagina_actual = ($opciones->configuracion->pagina_actual != NULL) ? $opciones->configuracion->pagina_actual : $pagina_actual;
            $elementos_por_pagina = ($opciones->configuracion->elementos_por_pagina != NULL) ? $opciones->configuracion->elementos_por_pagina : $elementos_por_pagina;
			$filtro = ($opciones->configuracion->filtro != NULL) ? $opciones->configuracion->filtro : $filtro;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }
    $total_elementos = ($total_elementos == NULL) ? 0 : $total_elementos;
    $pagina_actual = ($pagina_actual == NULL) ? (Sections::getParam('pagina', 0)) : $pagina_actual;
    $elementos_por_pagina = ($elementos_por_pagina == NULL) ? Shop::$configuracion->elementos_por_pagina : $elementos_por_pagina;
    ?>
    <?php
    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
        }
        ?>
        <?php
        $ultimo_elemento_pagina = min($total_elementos, (($pagina_actual + 1) * $elementos_por_pagina));
        $primer_elemento_pagina = ($pagina_actual * $elementos_por_pagina) + 1;
        ?>
        <span class="num_elementos"><?= traducir('Se han encontrado'); ?> <strong><?= $total_elementos; ?></strong> <?= traducir('elementos'); ?>. <?= traducir('Mostrando del') . ' ' . $primer_elemento_pagina . ' ' . traducir('al') . ' ' . $ultimo_elemento_pagina; ?></span>
        <span class="texto_normal"><?= traducir('Páginas: '); ?></span>
        <?= extraer_paginacion($enlace, $total_elementos, $pagina_actual, $elementos_por_pagina, $filtro); ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
    <?php
    return(true);
}

function paginador_movil($enlace, $total_elementos = 0, $pagina_actual = 0, $selector_pagina = false) {
    include('comunes/globals.php');
    $ocultarCabecera = false;

    if (($enlace != NULL) && (is_a($enlace, "OpcionesWidget"))) {
        $opciones = $enlace;
        $enlace = NULL;
        $total_elementos = 0;
        $pagina_actual = 0;
        $elementos_por_pagina = false;
        if (is_a($opciones, 'OpcionesWidget')) {
            $enlace = ($opciones->configuracion->enlace != NULL) ? $opciones->configuracion->enlace : $enlace;
            $total_elementos = ($opciones->configuracion->total_elementos != NULL) ? $opciones->configuracion->total_elementos : $total_elementos;
            $pagina_actual = ($opciones->configuracion->pagina_actual != NULL) ? $opciones->configuracion->pagina_actual : $pagina_actual;
            $elementos_por_pagina = ($opciones->configuracion->elementos_por_pagina != NULL) ? $opciones->configuracion->elementos_por_pagina : $elementos_por_pagina;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }
    ?>
    <?php
    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
        }
        ?>
        <div class="pagina_anterior">
            <?php
            if ($pagina_actual > 0) {
                $enlace_pagina = '-p' . ($pagina_actual - 1);
                ?>
                <a href="<?= $enlace . $enlace_pagina; ?>" title="<?= traducir("Página anterior"); ?>"><?= traducir('Anterior'); ?></a>
                <?php
            }
            ?>
        </div>
        <div class="pagina_siguiente">
            <?php
            $ultima_pagina = floor($total_elementos / Shop::$configuracion->elementos_por_pagina); //Redondeando hacia abajo
            if (($total_elementos % Shop::$configuracion->elementos_por_pagina) > 0) {
                $ultima_pagina++;
            }
            $ultima_pagina--;
            if ($pagina_actual < $ultima_pagina) {
                $enlace_pagina = "-p" . ($pagina_actual + 1);
                ?>
                <a href="<?= $enlace . $enlace_pagina; ?>" title="<?= traducir('Página siguiente'); ?>"><?= traducir('Siguiente'); ?></a>
                <?php
            }
            $pagina_actual++;
            ?>
        </div>
        <div class="pagina_actual"><p><?= $pagina_actual; ?></p></div>
                <?php
                if (!$ocultarCabecera) {
                    ?>
        </div>
        <?php
    }
    ?>
    <?php
}

//---------------------------------------------------------------------------------------------------------
// Esta es una función estandar que genera el contenido de la paginación con un formato estandar
//Si quisiesemos personalizarlo crearíamos otra función o la parametrizaríamos
//---------------------------------------------------------------------------------------------------------
function extraer_paginacion($enlace, $total_elementos = 0, $pagina_actual = 0, $elementos_por_pagina = NULL, $filtro = '') {
    include('comunes/globals.php');
	//Vamos a hacer una correción: si el filtro tiene algo y no empieza por "/", debe hacerlo:
	if ($filtro != ''){
		if (substr($filtro, 0, 1) != '/'){
			$filtro = '/' . $filtro;
		}
	}
    $retorno = '';
    //Comenzamos calculando cuantas páginas hay
    $elementos_por_pagina = ($elementos_por_pagina == NULL) ? Shop::$configuracion->elementos_por_pagina : $elementos_por_pagina;
    $ultima_pagina = floor($total_elementos / $elementos_por_pagina); //Redondeando hacia abajo
    if (($total_elementos % $elementos_por_pagina) > 0) {
        $ultima_pagina++;
    }
    $ultima_pagina--;

    //El inicio del paginador se hace siempre tres páginas antes que la actual
    $inicio = $pagina_actual - 3;
    if ($inicio <= 0) {
        $fin = Shop::$configuracion->paginas_a_mostrar - 1;
        $inicio = 0;
        if ($fin >= $ultima_pagina) {
            $fin = $ultima_pagina;
        }
    } else {
        $fin = $pagina_actual + Shop::$configuracion->paginas_a_mostrar;
        if ($fin >= $ultima_pagina) {
            $inicio = $ultima_pagina - (Shop::$configuracion->paginas_a_mostrar - 1);
            $fin = $ultima_pagina;
        }
        if ($inicio < 0) {
            $inicio = 0;
        }
    }

    //Vamos con el bucle
    for ($i = $inicio; $i <= $fin; $i++) {
        $clase_pagina = '';
        if ($i == $pagina_actual) {
            $clase_pagina = 'class="selecionado"';
        } else {
            $clase_pagina = '';
        }
        if ($i > 0) {
            $enlace_pagina = '-p' . $i;
        } else {
            $enlace_pagina = '';
        }
        if ($i == $fin) {
            $retorno .= ' <a href="' . $enlace . $enlace_pagina . $filtro . '" ' . $clase_pagina . ' title="' . traducir("página ") . ($i + 1) . '">' . ($i + 1) . "</a>";
        } else {
            $retorno .= ' <a href="' . $enlace . $enlace_pagina . $filtro . '" ' . $clase_pagina . ' title="' . traducir("página ") . ($i + 1) . '">' . ($i + 1) . "</a> " . '<span class="guion">-</span> ';
        }
    }
    $retorno = '<span>' . $retorno . '</span>';
    //echo $enlace;
    //Vamos a añadir el enlace al primer elemento y a los 10 anteriores al actual (si procede)
    if ($inicio > 1) {
        $retorno = '<a href="' . $enlace . '-p' . ($inicio - 1) . $filtro . '" ' . ' title="' . traducir("Retroceder") . '" class="atras">&lt;&lt;</a>' . "  " . $retorno;
    }
    if ($inicio != 0) {
        $retorno = '<a href="' . $enlace . $filtro . '" title="ir a la primera" class="inicio">' . traducir("Primera") . '</a>' . '<span class="guion">-</span> ' . $retorno;
    }
    if ($fin < $ultima_pagina) {
        $retorno .= ' <a href="' . $enlace . '-p' . ($fin + 1) . $filtro  . '" title="' . traducir("Avanzar") . '" class="adelante">&gt;&gt;</a>' . "";
    }
    if ($fin != $ultima_pagina) {
        $retorno .= '  <a href="' . $enlace . '-p' . $ultima_pagina . $filtro . '" title="' . traducir("Ir a la última página") . '" class="ultima">' . traducir("Última") . '</a>' . "";
    }
    echo($retorno);
}
?>