<?php
	//---------------------------------------------------------------------------------------------------------
	// 20/Julio/2015
	// Versión 1.0 Extensión del widget de pedidos de clientes
	// 30/Octubre/2015
	// Versión 2.0 => Remodelamos esta extensión por completo
	//---------------------------------------------------------------------------------------------------------
	
	
	
	function resumen_pedido($opciones = NULL){
		include('comunes/globals.php');
		$fichero_resumen = 'resumen_pedido';
		$codigo_pedido = 0;
		if (is_a($opciones, 'OpcionesWidget')){
			$fichero_resumen = ($opciones->configuracion->fichero_resumen !== NULL) ? $opciones->configuracion->fichero_resumen : $fichero_resumen;
			$codigo_pedido = ($opciones->configuracion->codigo_pedido !== NULL) ? $opciones->configuracion->codigo_pedido : $codigo_pedido;
			if (is_numeric($codigo_pedido)){
				//$codigo_pedido = new PedidoCliente($codigo_pedido);
			}
		}
		if (is_a($codigo_pedido, 'PedidoCliente')){
			$ruta_fichero = Theme::findFile($fichero_resumen . '.php');
			if ($ruta_fichero != NULL){
				$mc_pedcli = $codigo_pedido;
				include($ruta_fichero);
			}
		}
		
	}

	function pedidos_pendientes_cliente($opciones = NULL){
		include('comunes/globals.php');
		//Como siempre en V2, procesamos las opciones. Pero en esta función, estas opciones se meterán en el objeto para usarlo después
		$codigo_usuario = 0;
		$fichero_linea = 'linea_pedidos_pendientes';
		$fichero_cabecera = '';
		$fichero_pie = '';
		$ocultar_eliminados = true;
		
		$permitir_anular = Shop::$configuracion->permitir_anular_pedidos_pendientes;
		$pagado = NULL;
		//Vamos a coger el filtro de las fechas
		$filtro_fecha = '';
		$fecha_inicio = Sesion::get('fecha_inicio_pedidos_ptes');
		$fecha_fin = Sesion::get('fecha_fin_pedidos_ptes');
		if ( ($fecha_inicio !== NULL) && ($fecha_fin !== NULL) ){
			$filtro_fecha = "$fecha_inicio $fecha_fin";
		}
		
		$orden = Sesion::get('orden_pedidos_ptes');
		if ($orden == NULL){	$orden = 'fecha';	}
		$tipo_orden = Sesion::get('tipo_orden_pedidos_ptes');
		if ($tipo_orden == NULL){	$tipo_orden = 'DESC';	}

		$cliente = Usuario::logueado();
		if ($cliente !== NULL){
			$codigo_usuario = $cliente->codigo;
		}
		
		$solo_libros_pedidos_ptes = Sesion::get('solo_libros_pedidos_ptes');
		if ($solo_libros_pedidos_ptes == NULL){	$solo_libros_pedidos_ptes = '';	}
		$solo_papeleria_pedidos_ptes = Sesion::get('solo_papeleria_pedidos_ptes');
		if ($solo_papeleria_pedidos_ptes == NULL){	$solo_papeleria_pedidos_ptes = '';	}
		
		if (is_a($opciones, 'OpcionesWidget')){
			$cliente = ($opciones->configuracion->cliente !== NULL) ? $opciones->configuracion->cliente : $cliente;
			if (is_numeric($cliente)){
				$cliente = new usuario($cliente);
			}
			$codigo_usuario = ($opciones->configuracion->codigo_usuario !== NULL) ? $opciones->configuracion->codigo_usuario : $cliente->codigo;
			$fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;
			$fichero_cabecera = ($opciones->configuracion->fichero_cabecera !== NULL) ? $opciones->configuracion->fichero_cabecera : $fichero_cabecera;
			$fichero_pie = ($opciones->configuracion->fichero_pie !== NULL) ? $opciones->configuracion->fichero_pie : $fichero_pie;
			$ocultar_eliminados = ($opciones->configuracion->ocultar_eliminados !== NULL) ? $opciones->configuracion->ocultar_eliminados : $ocultar_eliminados;
			
			$filtro_fecha = ($opciones->configuracion->filtro_fecha !== NULL) ? $opciones->configuracion->filtro_fecha : $filtro_fecha;
			$orden = ($opciones->configuracion->orden !== NULL) ? $opciones->configuracion->orden : $orden;
			$permitir_anular = ($opciones->configuracion->permitir_anular !== NULL) ? $opciones->configuracion->permitir_anular : $orden;
			$solo_libros_pedidos_ptes = ($opciones->configuracion->solo_libros_pedidos_ptes !== NULL) ? $opciones->configuracion->solo_libros_pedidos_ptes : $solo_libros_pedidos_ptes;
			$solo_papeleria_pedidos_ptes = ($opciones->configuracion->solo_papeleria_pedidos_ptes !== NULL) ? $opciones->configuracion->solo_papeleria_pedidos_ptes : $solo_papeleria_pedidos_ptes;
		}else{
			$opciones = new OpcionesWidget();
		}
		
		//Vamos a hacer ahora la carga
		if ($cliente !== NULL){
			if ($cliente->codigo > 0){
				$codigo_usuario = $cliente->codigo;
				$filtro_fecha = trim($filtro_fecha);
				$orden = trim($orden);//Determina el orden en el que queremos mostrar los datos, campo y modo(ASC o DESC).
				//Vamos a componer la select:
				$sentencia_sql = "SELECT ml_pedcli.codigo codigo, mc_pedcli 
								FROM mc_pedcli, ml_pedcli, articulo
								WHERE mc_pedcli.cliente = '$codigo_usuario' AND mc_pedcli.codigo = ml_pedcli.mc_pedcli AND (pendiente_sinlib > 0 OR pagado > 0)
								AND (deposito = 0)
								AND (
								CAST(ml_pedcli.cantidad AS SIGNED ) - CAST(ml_pedcli.recibida AS SIGNED ) - CAST(ml_pedcli.retirada AS SIGNED )) > 0 
									AND ml_pedcli.articulo = articulo.codigo ";
				if ($ocultar_eliminados){
					$sentencia_sql .= " AND mc_pedcli.pedido_eliminado = 0 ";
				}
				if ($pagado !== NULL){
					$sentencia_sql .= " AND mc_pedcli.pagado = $pagado ";
				}
				if($filtro_fecha != ""){
					$array_fechas = explode(" ", $filtro_fecha);
					$sentencia_sql .= " AND fecha BETWEEN '$array_fechas[0]' AND '$array_fechas[1]' ";
				}
				
				//Los filtros por tipo de artículo, se hacen sólo si son distintos los flags:
				if ($solo_libros_pedidos_ptes != $solo_papeleria_pedidos_ptes){
					if($solo_libros_pedidos_ptes != ""){
						$sentencia_sql .= " AND articulo.tipo = 'L' ";
					}
					
					if($solo_papeleria_pedidos_ptes != ""){
						$sentencia_sql .= " AND articulo.tipo = 'P' ";
					}
				}

				//Necesitamos saber cuantos elementos hay para poder hacer la paginación
				$total_elementos = mysqli_query($conexionBD, $sentencia_sql);
				$total_elementos = mysqli_num_rows($total_elementos);

				//Vamos con el orden. ESTAMOS TENIENDO EN CUENTA QUE SÓLO SE PUEDE ORDENADR POR UN CRITERIO
				//Primero miramos la cabecera:
				$cadena_orden_cabecera = "";
				$cadena_orden_lineas = "";
				$cadena_orden = "";
				if ($fichero_cabecera != ""){
					$cadena_orden_cabecera = " ml_pedcli.mc_pedcli DESC, ml_pedcli.codigo ASC "; //Los pedidos en orden descendente para que los últimos estén los primeros
				}

				if (( $orden != "") && ($tipo_orden != "") ){
					//echo("El orden es: $orden");
					//Tenemos que saber si el orden es en la cabecera o en las líneas
					$cadena_orden = $orden . " " . $tipo_orden . " ";
					if (strpos($orden, 'mc_pedcli.') !== false){
						//Para la cabecera
						$cadena_orden_cabecera = $cadena_orden . ( ($cadena_orden_cabecera != '') ? ', ' : '' ) . $cadena_orden_cabecera;
					}else{
						$cadena_orden_lineas = $cadena_orden;
					}
				}
				$cadena_orden = $cadena_orden_cabecera . ( ($cadena_orden_lineas != '') ? ', ' . $cadena_orden_lineas : '' );
				$cadena_orden = ($cadena_orden != '') ? " ORDER BY $cadena_orden " : $cadena_orden;
				//echo("$sentencia_sql<br />\n");
				//Falta por añadir la paginación
				$pagina = Sections::getParam('pagina', 0);
				$enlace = Shop::$configuracion->url . 'pedidos_pendientes';
				$sentencia_sql .= $cadena_orden . ' LIMIT ' . ($pagina * Shop::$configuracion->elementos_pedidos_pendientes) . ', ' . Shop::$configuracion->elementos_pedidos_pendientes ;
				//echo("$sentencia_sql<br />\n");
				if ($conexionBD){
					if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
						//Comprobamos si tenemos pedidos
						if(mysqli_num_rows($resultado) === 0){
?>
						<p class="error_no_hay_pedidos"><?=traducir('Aún no ha realizado ningún pedido');?></p>
<?php
						}else{
							$total = 0;
							$mostrar_boton_anular = false;
							$ultimo_pedido = new PedidoCliente(0);
							while ($fila = mysqli_fetch_array($resultado)){
								//Vamos a necesitar un objeto con la linea
								//echo $fila["mc_pedcli"]." ". $fila["codigo"]."<br/>";
								$linea_pedido = new LineaPedidoCliente($fila['mc_pedcli'], $fila['codigo'], true);
								//var_dump($linea_pedido);

								//Si cambiamos de pedido, controlamos que se muestre la cabecera
								if ($ultimo_pedido->codigo != $fila['mc_pedcli']){
									//Si el último pedido es distinto de 0, entonces hay que mostrar el pie:
									if($ultimo_pedido->codigo > 0){
										$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $ultimo_pedido, 'fichero_resumen' => $fichero_pie));
                                        new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
									}
									//si hay fichero de cabecera, hacemos el include:
									if ($fichero_cabecera != ''){
										$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $linea_pedido->objeto_pedido, 'fichero_resumen' => $fichero_cabecera));
                                        new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
									}
								}
								//Mostramos los pedidos
                                new Widget($_WH->GW('pedidos_cliente', 'linea_pedido_cliente'), $linea_pedido, $fichero_linea);
								$total += $linea_pedido->importe_con_dto_pendiente;
								$ultimo_pedido = $linea_pedido->objeto_pedido;
							}
							//Mostramos el total siempre después de mostrar los pedidos
							if ($fichero_pie != ''){
								$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $linea_pedido->objeto_pedido, 'fichero_resumen' => $fichero_pie));
                                new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
							}

							//Paginacion:
                            new Widget($_WH->GW('paginador', 'paginador'), $enlace, $total_elementos, $pagina, Shop::$configuracion->elementos_pedidos_pendientes);
							//Ahora mostramos el botón para solicitar anulación con su script correspondiente
							if ($mostrar_boton_anular){
							}
						}
					}
				}
			}
		}
	}

	//------------------------------------------------------------------------------------------------
	//Botón que para solicitar la anulación
	//------------------------------------------------------------------------------------------------
	function boton_anular($opciones = NULL){
		include('comunes/globals.php');
		$opcionesSlider = NULL;
		if (is_a($opciones, 'OpcionesWidget')){
			$opcionesSlider = ($opciones->configuracion->opcionesSlider !== NULL) ? $opciones->configuracion->opcionesSlider : $opcionesSlider;
		}
		if ($opcionesSlider == NULL){
			$opcionesSlider = new OpcionesSlider();
			$opcionesSlider->fixedPosition = 'true';
			$opcionesSlider->transBackground = 'true';
			$opcionesSlider->centerH = 'true';
			$opcionesSlider->centerV = 'true';
			$opcionesSlider->closeButton = 'true';
			$opcionesSlider->inSpeed = "'slow'";
			$opcionesSlider->outSpeed = "'fast'";
			$opcionesSlider->zindex = '101';
		}
?>
<div id='capa_contacto'>
<?php
        $widgetContacto = new Widget($_WH->GW('contacto'), array('informacion_extra'), array(), false, array(), array('informacion_extra'), array('textarea'), false);
		$cadena_opciones = $opcionesSlider->muestra_opciones('opciones_boton');
		//Quitamos el símbolo del dolar a las opciones
		$cadena_opciones = str_replace('$', '', $cadena_opciones);
		$nombre_script = 'script_' . incrementa_contador();
?>
</div>
<script type="text/javascript" id="<?=$nombre_script;?>">
document.addEventListener('WSLE', function(event) {
	;(function() {
		var elemento = getLastHtmlObject('<?=$nombre_script;?>');
		<?=$cadena_opciones?>
		componentList.add(elemento, opciones_boton);
	})();
});
</script>
<form action="<?=parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH);?>" method="post" class="form_solicitar_anulacion_pedido">
	<fieldset>
		<input type="submit" class="boton" name="solicitar_anulacion_pedido" value="<?=traducir('Anular');?>"/>
	</fieldset>
</form>
<?php
		$nombre_script = 'script_' . incrementa_contador();
?>
<script id="<?=$nombre_script;?>">
document.addEventListener('WSLE', function(event) {
;(function() {
	var formulario = getLastHtmlObject('<?=$nombre_script;?>');
	formulario.on("submit", function(event){
		//Cancelamos el envío del formulario
		event.preventDefault();
		//No seguimos si no hay elementos marcados
		if ($("input.check_anular_linea_pedido:checked").length > 0){
			//A la capa de contacto, tenemos que modificarle la información extra, empezamos por sacar los productos que se quieren anular
			var texto = "";
			$("input.check_anular_linea_pedido:checked").each(function(index, element) {
				var contenido = $(this).attr("name").split("_");
				if (contenido.length >= 4){
					contenido = contenido[3];
					contenido = contenido.split("-");
					if (contenido.length >= 3){
						texto += "<?=html_entity_decode(traducir("Pedido número"));?>: " + contenido[0] + ", <?=html_entity_decode(traducir("línea"));?> " + contenido[1] + ". <?=html_entity_decode(traducir("Producto"));?>: " + contenido[2] + "\n";
					}
				}
			});
			if (texto != ""){
				texto = "<?=html_entity_decode(traducir("Anulación referente a"));?>: \n" + texto;
<?php
			$usuario = Usuario::logueado();
			if ($usuario != NULL){
?>
				texto = "<?=html_entity_decode(traducir("El cliente con código"));?> <?=$usuario->codigo;?> - <?=html_entity_decode($usuario->nombre_legal);?> <?=html_entity_decode(traducir("desea realizar"));?>: \n" + texto;
<?php
			}
?>
				$("#capa_contacto textarea[name='informacion_extra']").val(texto);
			}
			componentList.show('capa_contacto');
		}else{
			
		}
	});
})();
});
</script>
<?php
	}
	//------------------------------------------------------------------------------------------------
	//check que permite anular pedidos/reservas
	//------------------------------------------------------------------------------------------------
	function check_anular($opciones = NULL){
		//var_dump($opciones->configuracion->linea_pedido);
		include('comunes/globals.php');
		
		if ($opciones == NULL){
			$opciones = new OpcionesWidget();
		}
		
		if (is_a($opciones, 'OpcionesWidget')){
			$linea_pedido = NULL;
			$anulacion_directa = false;
			$tener_en_cuenta_dias = true;
			$solicitar_motivo = true;
			$texto_unico = '';
			//Vamos a preparar el formulario de contacto en el que se solicita la anulación del pedido
			$opcionesSlider = new OpcionesSlider();
			$opcionesSlider->fixedPosition = 'true';
			$opcionesSlider->transBackground = 'true';
			$opcionesSlider->centerH = 'true';
			$opcionesSlider->centerV = 'true';
			$opcionesSlider->closeButton = 'true';
			$opcionesSlider->inSpeed = "'slow'";
			$opcionesSlider->outSpeed = "'fast'";
			$opcionesSlider->zindex = '101';
			$usuario = Usuario::logueado();
			$linea_pedido = ($opciones->configuracion->linea_pedido !== NULL) ? $opciones->configuracion->linea_pedido : $linea_pedido;
			$anulacion_directa = ($opciones->configuracion->anulacion_directa !== NULL) ? $opciones->configuracion->anulacion_directa : $anulacion_directa;
			$tener_en_cuenta_dias = ($opciones->configuracion->tener_en_cuenta_dias !== NULL) ? $opciones->configuracion->tener_en_cuenta_dias : $tener_en_cuenta_dias;
			$opcionesSlider = ($opciones->configuracion->opcionesSlider !== NULL) ? $opciones->configuracion->opcionesSlider : $opcionesSlider;
			$solicitar_motivo = ($opciones->configuracion->solicitar_motivo !== NULL) ? $opciones->configuracion->solicitar_motivo : $solicitar_motivo;
			$texto_unico = ($opciones->configuracion->texto_unico !== NULL) ? $opciones->configuracion->texto_unico : $texto_unico;
			//var_dump($linea_pedido);
			if ($linea_pedido != NULL){
				$mostrar_boton_anular = true;
				if ($tener_en_cuenta_dias){
					$mostrar_boton_anular = false;
					//Controlamos que la fecha actual menos la del pedido, no pase de los días permitidos
					$fecha_pedido = explode(' ', $linea_pedido->objeto_pedido->fecha);
					$fecha_pedido = $fecha_pedido[0];
					$hoy = getdate();
					$hoy = $hoy['year'] . '/' . $hoy['mon'] . '/' . $hoy['mday'];
					$dias = (strtotime($fecha_pedido)-strtotime($hoy))/86400;
					$dias = abs($dias);
					$dias = floor($dias);
					$limite = 0;
					switch($linea_pedido->tipo){
						case 'L':
							$limite = Shop::$configuracion->dias_borrado_pedidos_libros;
						break;
						case 'P':
							$limite = Shop::$configuracion->dias_borrado_pedidos_papeleria;
						break;
					}
					//Hay que tener cuidado con el tipo
					if ($dias < $limite){
						$mostrar_boton_anular = true;
					}
				}
				if ($mostrar_boton_anular){
					//Vamos a crear un script que ejecute el ajax
					$contador = incrementa_contador(true);
					$dato = ($linea_pedido->codigo_articulo != '') ? $linea_pedido->codigo_articulo : $linea_pedido->ean;
?>
<span class="dummie"></span>
<script type="text/javascript" id="script_<?=$contador;?>">
	function anular_pedido_<?=$contador;?>(){
		var elemento = getLastHtmlObject('script_<?=$contador;?>');
		var linea_pedido = elemento.closest("div.contenedor_pedido_<?=$dato?>_<?=$linea_pedido->lote->codigo;?>").closest("div.linea_pedido");
		var fichero_linea_pedido = linea_pedido.data('fichero');
		var direccion = "<?=Shop::$configuracion->url;?>comunes/consultas/anular_linea_pedido.php";
		var parametros = "cod_pedido=<?=$linea_pedido->objeto_pedido->codigo;?>&cod_linea=<?=$linea_pedido->codigo;?>&hash=<?=genera_cod_seguridad();?>&fichero=" + fichero_linea_pedido;
<?php
					if ($anulacion_directa){
?>
						parametros += '&borrar=1';
<?php
					}else{
?>
						parametros += '&anular=1';
<?php
					}
					
?>
		//console.log("Estos son los parametros: "+parametros);
		realizar_solicitud(direccion, parametros, function(respuesta){
			//Respuesta es el código html que vamos a insertar en la web
			//console.log(respuesta);
			var dato = $(respuesta).html();
			if (dato == ""){
				//console.log("Hay que eliminar el contenido");
				linea_pedido.html("");
			}else{
				linea_pedido.html(dato);
			}
			
			//Cerramos los residuos que se hayan quedado abiertos del formulario de contacto:
			componentList.hideAll();
		});
	}
</script>

<div class="<?=(__FUNCTION__);?>">
<?php
					//if (!$anulacion_directa){
					if ($solicitar_motivo){
?>
<div id="capa_contacto_<?=$contador;?>">
<?php
		if ($texto_unico == ""){
			$texto_unico = html_entity_decode(traducir('El cliente con código ')) . $usuario->codigo_sinlib . ' - ' . html_entity_decode($usuario->nombre_legal) . ' ' . html_entity_decode(traducir('desea realizar')) . '\n'; 
			$texto_unico .= html_entity_decode(traducir('Anulación referente a \n'));
			$texto_unico .= html_entity_decode(traducir('Pedido número')) . ': ' . $linea_pedido->objeto_pedido->codigo_sinlib . ', ' . html_entity_decode(traducir('línea')) . ' ' . $linea_pedido->codigo_sinlib . '. ' . html_entity_decode(traducir('Producto')) . ': ' . $linea_pedido->codigo_articulo . '\n';
		}
		$opcionesW = new OpcionesWidget(array(
			'array_campos' => array('informacion_extra','asunto'),
			'captcha' => false,
			'valores_x_defecto' => array('informacion_extra' => $texto_unico,'asunto' => (!$anulacion_directa)?'Solicitud de anulacion' : 'Un cliente ha borrado un pedido' ),
			'campos_no_editables' => array('informacion_extra'),
			'tipos' => array('textarea','input'),
			'callback' => 'anular_pedido_$contador',
			'mostrar_condiciones_privacidad' => false
		));
		
        $widgetContacto = new Widget($_WH->GW('contacto'), $opcionesW );
		$cadena_opciones = $opcionesSlider->muestra_opciones('opciones_boton');
		//Quitamos el símbolo del dolar a las opciones
		$cadena_opciones = str_replace('$', '', $cadena_opciones);
		$nombre_script = 'script_' . incrementa_contador(true);
?>
</div>
<script type="text/javascript" id="<?=$nombre_script;?>">
document.addEventListener('WSLE', function(event) {
	;(function() {
		var elemento = getLastHtmlObject('<?=$nombre_script;?>');
		<?=$cadena_opciones?>
		componentList.add(elemento, opciones_boton);
	})();
});
</script>
<?php
		}else{
					//si no se solicita el motivo, ejetutamos la consulta directamente
?>

<?php
					}
					
?>
<a href="javascript:void(0);" onclick="componentList.show('capa_contacto_<?=$contador;?>');">Anular</a>
<?php
/*
?>

<input type="checkbox" class="check_anular_linea_pedido" name="anular_linea_pedido_<?=$linea_pedido->objeto_pedido->codigo_sinlib . '-' . $linea_pedido->codigo_sinlib . "-" . $linea_pedido->articulo->ean;?>" />
<?php
*/
				}
?>
</div>
<?php
			}
		}
	}

	//------------------------------------------------------------------------------------------------
	//Reservas
	//------------------------------------------------------------------------------------------------
	function reservas_cliente($opciones = NULL){
		include("comunes/globals.php");
		//Como siempre en V2, procesamos las opciones. Pero en esta función, estas opciones se meterán en el objeto para usarlo después
		$codigo_usuario = 0;
		$fichero_linea = 'linea_reserva';
		$fichero_cabecera = '';
		$fichero_pie = '';
		$ocultar_eliminados = true;

		//Vamos a coger el filtro de las fechas
		$filtro_fecha = '';
		$fecha_inicio = Sesion::get('fecha_inicio_reservas');
		$fecha_fin = Sesion::get('fecha_fin_reservas');
		if ( ($fecha_inicio !== NULL) && ($fecha_fin !== NULL) ){
			$filtro_fecha = "$fecha_inicio $fecha_fin";
		}

		$orden = Sesion::get('orden_reservas');
		if ($orden == NULL){ $orden = 'codigo';	}
		$tipo_orden = Sesion::get('tipo_orden_reservas');
		if ($tipo_orden == NULL){	$tipo_orden = 'DESC';	}

		$cliente = Usuario::logueado();
		if ($cliente !== NULL){
			$codigo_usuario = $cliente->codigo;
		}

		$solo_libros_reservas = Sesion::get('solo_libros_pedidos_ptes');
		if ($solo_libros_reservas == NULL){	$solo_libros_reservas = '';	}
		$solo_papeleria_reservas = Sesion::get('solo_papeleria_pedidos_ptes');
		if ($solo_papeleria_reservas == NULL){	$solo_papeleria_reservas = '';	}


		if (is_a($opciones, 'OpcionesWidget')){
			$cliente = ($opciones->configuracion->cliente !== NULL) ? $opciones->configuracion->cliente : $cliente;
			if (is_numeric($cliente)){
				$cliente = new usuario($cliente);
			}
			$codigo_usuario = ($opciones->configuracion->codigo_usuario !== NULL) ? $opciones->configuracion->codigo_usuario : $cliente->codigo;
			$fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero;
			$fichero_cabecera = ($opciones->configuracion->fichero_cabecera !== NULL) ? $opciones->configuracion->fichero_cabecera : $fichero_cabecera;
			$fichero_pie = ($opciones->configuracion->fichero_pie !== NULL) ? $opciones->configuracion->fichero_pie : $fichero_pie;
			$ocultar_eliminados = ($opciones->configuracion->ocultar_eliminados !== NULL) ? $opciones->configuracion->ocultar_eliminados : $ocultar_eliminados;

			$filtro_fecha = ($opciones->configuracion->filtro_fecha !== NULL) ? $opciones->configuracion->filtro_fecha : $filtro_fecha;
			$orden = ($opciones->configuracion->orden !== NULL) ? $opciones->configuracion->orden : $orden;
			$solo_libros_reservas = ($opciones->configuracion->solo_libros_reservas !== NULL) ? $opciones->configuracion->solo_libros_reservas : $solo_libros_reservas;
			$solo_papeleria_reservas = ($opciones->configuracion->solo_papeleria_reservas !== NULL) ? $opciones->configuracion->solo_papeleria_reservas : $solo_papeleria_reservas;
		}else{
			$opciones = new OpcionesWidget();
		}

		//Vamos a hacer ahora la carga
		if ($cliente !== NULL){
			if ($cliente->codigo > 0){
				$codigo_usuario = $cliente->codigo;
				$filtro_fecha = trim($filtro_fecha);
				$orden = trim($orden);//Determina el orden en el que queremos mostrar los datos, campo y modo(ASC o DESC).
				//Vamos a componer la select:
				$sentencia_sql = "SELECT ml_pedcli.codigo codigo, mc_pedcli 
								FROM mc_pedcli, ml_pedcli, articulo
								WHERE mc_pedcli.cliente = '$codigo_usuario' AND mc_pedcli.codigo = ml_pedcli.mc_pedcli
								AND (pendiente_sinlib > 0 OR pagado > 0)
								AND (deposito = 0)
								AND (CAST(ml_pedcli.recibida AS SIGNED ) - CAST(ml_pedcli.retirada AS SIGNED )) > 0  
								AND ml_pedcli.articulo = articulo.codigo ";
				if($filtro_fecha != ""){
					$array_fechas = explode(" ", $filtro_fecha);
					$sentencia_sql .= " AND fecha BETWEEN '$array_fechas[0]' AND '$array_fechas[1]'";
				}
				
				if ($ocultar_eliminados){
					$sentencia_sql .= ' AND mc_pedcli.pedido_eliminado = 0 ';
				}
				
				if ($solo_libros_reservas != $solo_papeleria_reservas){
					if($solo_libros_reservas != ''){
						$sentencia_sql .= " AND articulo.tipo = 'L' ";
					}
		
					if($solo_papeleria_reservas != ''){
						$sentencia_sql .= " AND articulo.tipo = 'P' ";
					}
				}
				
				//Necesitamos saber cuantos elementos hay para poder hacer la paginación
				//echo("$sentencia_sql<br />\n");
				$total_elementos = 0;
				if ($total_elementos = mysqli_query($conexionBD, $sentencia_sql)){
					$total_elementos = mysqli_num_rows($total_elementos);
				}
				
				$cadena_orden_cabecera = "";
				$cadena_orden_lineas = "";
				$cadena_orden = "";
				if ($fichero_cabecera != ""){
					$cadena_orden_cabecera = 'ml_pedcli.mc_pedcli DESC'; //Los pedidos siempre en orden descendente
				}
				
				if (( $orden != '') && ($tipo_orden != '') ){
					//Tenemos que saber si el orden es en la cabecera o en las líneas
					$cadena_orden = $orden . ' ' . $tipo_orden . ' ';
					if (strpos($orden, 'mc_pedcli.') !== false){
						//Para la cabecera
						$cadena_orden_cabecera = $cadena_orden . ( ($cadena_orden_cabecera != '') ? ', ' : '' ) . $cadena_orden_cabecera;
					}else{
						$cadena_orden_lineas = $cadena_orden;
					}
				}
				
				
				if (( $orden != '') && ($tipo_orden != '') ){
					$cadena_orden .= ( ($cadena_orden != '') ? ' , ' : '' ) . $orden . ' ' . $tipo_orden . ' ';
				}

				$cadena_orden = ($cadena_orden != '') ? " ORDER BY $cadena_orden " : $cadena_orden;

				//Paginación
				$pagina = Sections::getParam('pagina', 0);
				$enlace = Shop::$configuracion->url . 'reservas';
				$sentencia_sql .= $cadena_orden . ' LIMIT ' . ($pagina * Shop::$configuracion->elementos_reservas) . ', ' . Shop::$configuracion->elementos_reservas;

				//echo("$sentencia_sql<br />\n");
				if ($conexionBD){
					if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
						//Comprobamos si tenemos pedidos
						if(mysqli_num_rows($resultado) === 0){
?>
						<p class="error_no_hay_pedidos"><?=traducir('Aún no ha realizado ningún pedido');?></p>
<?php
						}else{
							$ultimo_pedido = new PedidoCliente(0);
							$total = 0;
							while ($fila = mysqli_fetch_array($resultado)){
								//Vamos a necesitar un objeto con la linea
								$linea_pedido = new LineaPedidoCliente($fila['mc_pedcli'], $fila['codigo'], true);
								if ($ultimo_pedido->codigo != $fila['mc_pedcli']){
									//Si el último pedido es distinto de 0, entonces hay que mostrar el pie:
									if($ultimo_pedido->codigo > 0){
										$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $ultimo_pedido, 'fichero_resumen' => $fichero_pie));
                                        new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
									}
									//si hay fichero de cabecera, hacemos el include:
									if ($fichero_cabecera != ''){
										$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $linea_pedido->objeto_pedido, 'fichero_resumen' => $fichero_cabecera));
                                        new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
									}
								}
								
								//Mostramos las reservas
                                new Widget($_WH->GW('pedidos_cliente', 'linea_pedido_cliente'), $linea_pedido, $fichero_linea);
								$total += $linea_pedido->importe_con_dto_reservado;
								$ultimo_pedido = $linea_pedido->objeto_pedido;
							}
							//Mostramos el total siempre después de mostrar los pedidos
							if ($fichero_pie != ''){
								$opciones_resumen = new OpcionesWidget(array('codigo_pedido' => $linea_pedido->objeto_pedido, 'fichero_resumen' => $fichero_pie));
                                new Widget($_WH->GW('pedidos_cliente', 'resumen_pedido'), $opciones_resumen);
							}

							//Paginacion:
                            new Widget($_WH->GW('paginador', 'paginador'), $enlace, $total_elementos, $pagina, Shop::$configuracion->elementos_reservas);
						}
					}
				}
			}
		}
	}
?>