<?php

//---------------------------------------------------------------------------------------------------------
// 15/Enero/2015
// Versión 1.0 Widget que contiene todo lo referente al usuario. Los parámetros de cada widget pueden ser diferentes y variables
//06/07/2016
// Añadido un else en la función dame_valores
//---------------------------------------------------------------------------------------------------------



function widget_usuario() {
	include('comunes/globals.php');

	//Aquí definimos una serie de parámetros que necesitamos
	$funcion_por_defecto = 'login';
	$parametros_por_defecto = array();
	$parametros_recibidos = func_get_args();
	if (count($parametros_recibidos) == 0) {
		$parametros_recibidos[0] = $funcion_por_defecto;
	} else {
		if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
			$parametros_recibidos[0] = $funcion_por_defecto;
		}
	}
	$parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
	$retorno = false;
	//Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
	if (count($parametros_recibidos) > 0) {
		//Recogemos el nombre de la función de entre el resto de parámetros
		$nombre_funcion = $parametros_recibidos[0];
		//Quitamos el primer elemento de los parámetros, pues es el nombre de la función
		$parametros_recibidos = array_slice($parametros_recibidos, 1);
		//Si la función existe la ejecutamos
		if (function_exists($nombre_funcion)) {
			//echo("function $nombre_funcion SI encontrada");
			$retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
		} else {
			//echo("function $nombre_funcion no encontrada");
		}
	}
	return($retorno);
}

function login($texto_cabecera = '', $addBtnRegistro = false) {
	include('comunes/globals.php');
	$ocultarCabecera = false;

	if (($texto_cabecera != NULL) && (is_a($texto_cabecera, "OpcionesWidget"))) {
		$opciones = $texto_cabecera;
		$texto_cabecera = '';
		$addBtnRegistro = false;
		if (is_a($opciones, 'OpcionesWidget')) {
			$texto_cabecera = ($opciones->configuracion->texto_cabecera != NULL) ? $opciones->configuracion->texto_cabecera : $texto_cabecera;
			$addBtnRegistro = ($opciones->configuracion->addBtnRegistro != NULL) ? $opciones->configuracion->addBtnRegistro : $addBtnRegistro;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}

	$email_por_defecto = Sesion::get('email_login');
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		/* <form action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" method="post" class="login_simple"> */
		?>
		<form action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" method="post" class="login_simple">
			<?php
			//Vamos a coger el mensaje que hubiese para el widget de usuario:
			/*$mensajes_de_este_widget = $listaSysMsg->findElement(array('origen' => '/^widget_usuario$/', 'funcion' => '/^login$/'));
			if ($mensajes_de_este_widget != NULL) {
				//Vamos a ver que mensajes son
				$error_email = '';
				$error_password = '';
				for ($i = 0; $i < count($mensajes_de_este_widget); $i++) {
					if ($mensajes_de_este_widget[$i]->getClase() == 'email') {
						$error_email = $mensajes_de_este_widget[$i]->getCuerpo();
					}
					if ($mensajes_de_este_widget[$i]->getClase() == 'password') {
						$error_password = $mensajes_de_este_widget[$i]->getCuerpo();
					}
				}

				if (($error_email != '') || ($error_password != '')) {
					?>
					<p class="cab_error_login"><?= traducir('Datos incorrectos. Inténtelo de nuevo'); ?></p>
					<?php
				}
				if ($error_email != '') {
					?>
					<p class="error_login"><?= traducir('No existe ningún usuario con esa dirección de email.'); ?></p>
					<p class="error_login"><?= traducir('Si no está registrado, vaya al apartado de registro'); ?></p>
					<?php
				} else if ($error_password != '') {
					?>
					<p class="error_login"><?= traducir('La contraseña que ha introducido no es correcta.'); ?></p>
					<p class="error_login"><?= traducir('Si no recuerda su contraseña, pinche en el enlace recuperar contraseña.'); ?></p>
					<?php
				}
			}*/
			//Vamos a controlar que haya o no que poner el place holder
			$placeHolder = true;
			?>
			<fieldset>
				<p><?= $texto_cabecera ?></p>
				<?php
				if (!$placeHolder) {
					?>
					<label><?= traducir('Email'); ?></label>
					<?php
				}
				?>
				<input type="email" name="usuario" value="<?= $email_por_defecto; ?>" required <?= ($placeHolder) ? 'placeholder="' . traducir('Email') . '"' : ''; ?> />
				<?php
				if (!$placeHolder) {
					?>
					<label><?= traducir('Contraseña'); ?></label>
					<?php
				}
				?>
				<input type="password" name="password" value='' required <?= ($placeHolder) ? 'placeholder="' . traducir("Contraseña") . '"' : ''; ?>  />
				<input type="submit" name="enviar" class="boton" value="<?= traducir('Entrar'); ?>"/>
				<input type="reset" name="cancelar" class="boton"  value="<?= traducir('Cancelar'); ?>" onClick="componentList.hideAll();"/>
			</fieldset>
		</form>
		<?php
        $nombre_script = 'script_' . incrementa_contador();
		?>
        <script type="text/javascript" id="<?= $nombre_script; ?>">
		document.addEventListener('WSLE', function(event) {
			;(function () {
				var form_login = getLastHtmlObject('<?= $nombre_script; ?>');
				form_login.on("submit", function (event) {
					var login_correcto = true;
					//No estamos ni en chrome ni en firefox, así que hay que controlar los campos obligatorios
					$(form_login).on("submit", function (event) {
						login_correcto = true;
						var fieldset = $(this).children("fieldset")[0];
						//Comrobaciones sólo para IE y resto de navegadores que no sean chrome o firefox

						var lista_input = $(fieldset).children("input[required]");
						var total = lista_input.length;
						for (var i = 0; (i < total) && (login_correcto); i++) {
							var elemento = lista_input[i];
							if ($(elemento).prop("value") == '') {
								login_correcto = false;
								$(elemento).focus();
								poner_sombra($(elemento));
							}
						}
						//Ahora vamos a controlar si hubiese un campo email y si todo es correcto
						if (login_correcto) {
							lista_input = $(this).children("fieldset").children("input[type='email']");
							var total = lista_input.length;
							for (var i = 0; (i < total) && (login_correcto); i++) {
								//Comprobamos que tiene un arroba
								var elemento = lista_input[i];
								var contenido = $(elemento).prop("value");
								if (contenido.split("@").length != 2) {
									login_correcto = false;
									$(elemento).focus();
									poner_sombra($(elemento));
								}
							}
						}
						if (!login_correcto) {
							event.preventDefault();
						}
					});

					//Vamos a crear un "listener" para que cuando cambie un input, si el borde es rojo, que se ponga en su borde inicial
					$(form_login).children("fieldset").children("input[required]").on("input", function () {
						quitar_sombra($(this));
					});



				});

			}());
		});
		</script>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
	//Si hay que añadir el botón de registro, lo hacemos:
	if ($addBtnRegistro) {
		new Widget($_WH->GW('usuario', 'btnRegistro'));
	}
	return(true);
}

function menu_inicio_sesion($texto_cab_login = '', $separador = '', $tipo_login = 'modal', $tipo_registro = 'modal') {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (($texto_cab_login != NULL) && (is_a($texto_cab_login, "OpcionesWidget"))) {
		$opciones = $texto_cab_login;
		$texto_cab_login = '';
		$separador = '';
		$tipo_login = 'modal';
		$tipo_registro = 'modal';
		if (is_a($opciones, 'OpcionesWidget')) {
			$texto_cab_login = ($opciones->configuracion->texto_cab_login != NULL) ? $opciones->configuracion->texto_cab_login : $texto_cab_login;
			$separador = ($opciones->configuracion->separador != NULL) ? $opciones->configuracion->separador : $separador;
			$tipo_login = ($opciones->configuracion->tipo_login != NULL) ? $opciones->configuracion->tipo_login : $tipo_login;
			$tipo_registro = ($opciones->configuracion->tipo_registro != NULL) ? $opciones->configuracion->tipo_registro : $tipo_registro;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		//Si el tipo es PHP lo mostramos sin más
		if ($tipo_login == 'php') {
			//Componemos el widget de login
			$widget_login = new Widget($_WH->GW('usuario', 'login', $tipo_login, false), $texto_cab_login);
			$widget_login->record();
			new Widget($_WH->GW('usuario', 'btnRecuperarPass'));
			$widget_login->record(true);
			$widget_login->mostrar();
		} else {
			//Si no es PHP, puede que sean los parametros de configuración de un componente js
			if (is_a($tipo_login, 'OpcionesSlider')) {
				if ($tipo_login->type == NULL) {
					$tipo_login->type = "'modal'";
				}
				$widget_login = new Widget($_WH->GW('usuario', 'login', $tipo_login->type, false, $tipo_login), $texto_cab_login);
				$widget_login->record();
				new Widget($_WH->GW('usuario', 'btnRecuperarPass'));
				$widget_login->record(true);
			} else {
				$widget_login = new Widget($_WH->GW('usuario', 'login', $tipo_login, false), $texto_cab_login);
				$widget_login->record();
				new Widget($_WH->GW('usuario', 'btnRecuperarPass'));
				$widget_login->record(true);
			}
			new Widget(LW_params(), $widget_login, traducir('Entrar'), 'a', 'onclick', 'lanzador_widget', '', 'login');
		}
		?>
		<span class="separador_acceso_usuario"><?= $separador; ?></span>
		<?php
		//Formulario de registro
		new Widget($_WH->GW('usuario', 'btnRegistro'), $tipo_registro);
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

function btnRegistro($modo = 'php') {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (($modo != NULL) && (is_a($modo, "OpcionesWidget"))) {
		$opciones = $modo;
		$modo = 'php';
		if (is_a($opciones, 'OpcionesWidget')) {
			$modo = ($opciones->configuracion->modo != NULL) ? $opciones->configuracion->modo : $modo;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		//Si el modo es incrustado es un href normal. Si no lo es hay que utilizar el widget lanzador
		if (($modo == 'php') || ($modo == 'incrustado')) {
			?>
			<a href="<?= Shop::$configuracion->url; ?>registro" class="boton"><?= traducir('Registrarse'); ?></a>
			<?php
		} else {
			//Si no es PHP, puede que sean los parametros de configuración de un componente js
			if (is_a($modo, 'OpcionesSlider')) {
				if ($modo->type == NULL) {
					$modo->type = "'modal'";
				}
				$widget_registro = new Widget($_WH->GW('usuario', 'registro', $modo->type, false, $modo)); //No le paso los campos del registro para que coja los que tiene por defecto la función
			} else {
				$widget_registro = new Widget($_WH->GW('usuario', 'registro', $modo, false)); //No le paso los campos del registro para que coja los que tiene por defecto la función
			}
			new Widget(LW_params(), $widget_registro, traducir('Registrarse'), 'a', 'onmouseclick', 'lanzador_widget', '', 'registro');
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

function btnRecuperarPass($modo = 'php') {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (($modo != NULL) && (is_a($modo, "OpcionesWidget"))) {
		$opciones = $modo;
		$modo = 'php';
		if (is_a($opciones, 'OpcionesWidget')) {
			$modo = ($opciones->configuracion->modo != NULL) ? $opciones->configuracion->modo : $modo;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		//Si el modo es incrustado es un href normal. Si no lo es hay que utilizar el widget lanzador
		if (($modo == 'php') || ($modo == 'incrustado')) {
			?>
			<a href="<?= Shop::$configuracion->url; ?>recuperar_pass" class="recuperar_pass"><?= traducir('Recuperar contraseña'); ?></a>
			<?php
		} else {
			//Si no es PHP, puede que sean los parametros de configuración de un componente js
			if (is_a($modo, 'OpcionesSlider')) {
				if ($modo->type == NULL) {
					$modo->type = "'modal'";
				}
				$widget_rec_pass = new Widget($_WH->GW('usuario', 'recuperar_pass', $modo->type, false, $modo)); //No le paso los campos del registro para que coja los que tiene por defecto la función
			} else {
				$widget_rec_pass = new Widget($_WH->GW('usuario', 'recuperar_pass', $modo, false)); //No le paso los campos del registro para que coja los que tiene por defecto la función
			}
			new Widget(LW_params(), $widget_rec_pass, traducir('Recuperar contraseña'), 'a', 'onmouseclick', 'lanzador_widget', '', 'recuperar_pass');
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

function recuperar_pass($txt_cab_login = '') {
	include('comunes/globals.php');
	$ocultarCabecera = false;

	if (($txt_cab_login != NULL) && (is_a($txt_cab_login, "OpcionesWidget"))) {
		$opciones = $txt_cab_login;
		$txt_cab_login = '';
		if (is_a($opciones, 'OpcionesWidget')) {
			$txt_cab_login = ($opciones->configuracion->txt_cab_login != NULL) ? $opciones->configuracion->txt_cab_login : $txt_cab_login;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}

	$email_por_defecto = Sesion::get('email_login');
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>

		<p class="cabecera"><?= traducir('Introduzca su dirección de email y pulse sobre el botón "Recuperar". Si es un usuario registrado generaremos una nueva contraseña para usted y se la enviaremos a esa dirección de correo electrónico.'); ?></p>
		<form action="<?= Shop::$configuracion->url; ?>comunes/consultas/recuperar_pass.php" method="post" class="recuperar_pass_simple">
			<fieldset class="recuperar_pass_capa_input">
				<label><?= traducir('Dirección email'); ?>:</label>
				<input type="email" name="email" value="<?= $email_por_defecto; ?>" required/>
				<input type="submit" name="enviar" value="<?= traducir('Recuperar'); ?>"/>
			</fieldset>
			<div class="recuperar_pass_capa_espera" style="display:none;">
				<p><?= traducir('Enviando password. Espere por favor'); ?>.</p>
			</div>
			<div class="recuperar_pass_capa_resultado" style="display:none;">
				<p>.</p>
				<a class="boton" href="javascript:void(0);" onclick="$(this).closest('form').children('fieldset').show();
						$(this).parent().hide();"><?= traducir('Reintentar'); ?></a>
			</div>
		</form>
		<?php
        $nombre_script = 'script_' . incrementa_contador();
		?>
        <script type="text/javascript" id="<?= $nombre_script; ?>">
		document.addEventListener('WSLE', function(event) {
			;(function () {
				var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
				//Asociamos un "quitar sombra al elemento cuando cambie
				elementObjetive.find("input[name='email']").on("changue", function () {
					quitar_sombra($(this));
				});
				//Al formulario le asociamos el evento de control en el submit
				elementObjetive.on("submit", function (event) {
					event.preventDefault();
					var elemento = $(this).find("input[name='email']");
					//Vamos a obtener la dirección email para evaluarla
					var direccion_email = elemento.val();
					direccion_email = direccion_email.trim();
					if (direccion_email == '') {
						//Lo primero es que no esté vacía
						$(elemento).focus();
						poner_sombra($(elemento));
					} else if ((direccion_email.split("@").length != 2) && (direccion_email.split(".").length != 2)) {
						//Lo segundo es comprobar que sea correcta
						$(elemento).focus();
						poner_sombra($(elemento));
					} else {
						//Email apropiado, vamos a hacer la consulta
						$(this).find("fieldset").hide();
						$(this).find("div.recuperar_pass_capa_espera").show();
						var direccion = $(this).prop("action");
						//Vamos a lanzar la consulta
						var parametros = "email=" + direccion_email + "&hash=<?= genera_cod_seguridad(); ?>";
						realizar_solicitud(direccion, parametros, function (respuesta) {
							if (respuesta == "CORRECTO") {
								elementObjetive.nextAll("div.form_login_recu_pass").show();
								//Ocultamos el formulario de recuperar password y el párrafo anterior
								elementObjetive.hide();
								elementObjetive.prevAll("p.cabecera").hide();
							} else {
								elementObjetive.children("div.recuperar_pass_capa_resultado").children("p").html("<?= traducir("Ha ocurrido un error al recuperar su contraseña. Es posible que el email introducido no exista. Inténtelo de nuevo y si el problema persiste póngase en contacto con nosotros."); ?>");
								//Mostramos la capa de "reintentar"
								elementObjetive.children("div.recuperar_pass_capa_resultado").children("a.reintentar").show();
								elementObjetive.children("div.recuperar_pass_capa_resultado").show();
							}
							elementObjetive.children("div.recuperar_pass_capa_espera").hide();
						});
					}
				});
			}());
		});
		</script>
		<div class="form_login_recu_pass" style="display:none;">
			<p><?= traducir('Hemos enviado en email con su contraseña a la cuenta facilitada. Revise su bandeja de entrada.'); ?></p>
			<?php
			//Añadimos aquí el formulario de login
			new Widget($_WH->GW('usuario', 'login'), $txt_cab_login);
			?>
		</div>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
	return(true);
}

function registro($campos_registro = array('nombre_legal', 'email', 'password', 'repeticion_password', 'direccion', 'cod_postal', 'localidad', 'provincia', 'fecha_nacimiento'), $campos_obligatorios = array('nombre_legal', 'email', 'password', 'repeticion_password')) {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (($campos_registro != NULL) && (is_a($campos_registro, "OpcionesWidget"))) {
		$opciones = $campos_registro;
		$campos_registro = array('nombre_legal', 'email', 'password', 'repeticion_password', 'direccion', 'cod_postal', 'localidad', 'provincia', 'fecha_nacimiento');
		$campos_obligatorios = array('nombre_legal', 'email', 'password', 'repeticion_password');
		if (is_a($opciones, 'OpcionesWidget')) {
			$campos_registro = ($opciones->configuracion->campos_registro != NULL) ? $opciones->configuracion->campos_registro : $campos_registro;
			$campos_obligatorios = ($opciones->configuracion->campos_obligatorios != NULL) ? $opciones->configuracion->campos_obligatorios : $campos_obligatorios;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		//obtenemos cualquier mensaje de registro que nos puedan haber mandado
		/*$mensaje_registro_correcto = $listaSysMsg->findElement(array('origen' => '/^widget_usuario$/', 'clase' => '/^correcto$/'));
		$registro_correcto = false;
		if ($mensaje_registro_correcto != NULL) {
			$registro_correcto = true;
		}*/
		//Si el mensaje recibido del registro no es correcto, hacemso esto
		if (!$registro_correcto) {
			?>
			<p class="cabecera"><?= traducir('Formulario de registro'); ?></p>
			<p class="texto_aclaracion_registro"><?= traducir('Para registrarse en nuestra web y disfrutar de las ventajas de ser un usuario registrado, rellene los siguientes campos y pulse el botón "Registrarse". Los campos marcados con * (asterisco) son obligatorios.'); ?></p>
			<form action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" method="post" class="registro_simple">
				<fieldset>
					<?php
					//Recorremos el array de campos
					foreach ($campos_registro as $clave => $valor) {
						//Vamos a asignar un tipo de campo, y a decidir si es obligatorio o no
						$tipo_campo = 'text';
						$texto_requerido = '';
						$asterisco = '';
						$nombre_campo_formulario = 'campo_registro_' . $valor;
						$fecha_nacimiento = false;
						switch ($valor) {
							case 'email':
								$tipo_campo = 'email';
								break;
							case 'telefono':
								$tipo_campo = 'tel';
								break;
							case 'repeticion_password':
								$nombre_campo_formulario = $valor;
							case 'password':
								$tipo_campo = 'password';
								break;
							case 'fecha_nacimiento':
								$fecha_nacimiento = true;
								break;
						}
						if (in_array($valor, $campos_obligatorios)) {
							$texto_requerido = 'required';
							$asterisco = ' <span class="asterisco">*</span>';
						}
						if ($fecha_nacimiento == true) {
							?>
							<label><?= traduce_campo_registro($valor); ?></label>
							<input type="<?= $tipo_campo; ?>" class="fecha_nac_usuario" name="fecha_nac_usuario" placeholder="00/00/0000" value='' class="campo_<?= $valor; ?>" <?= $texto_requerido; ?> />
							<input type="hidden" class="fecha_nac" name="<?= $nombre_campo_formulario; ?>" value='' class="campo_<?= $valor; ?>" <?= $texto_requerido; ?> />
							<?php
							$nombre_script = 'script_' . incrementa_contador();
							?>
							<script id="<?= $nombre_script; ?>">
							document.addEventListener('WSLE', function(event) {
								;(function () {
									var fecha_nac = getLastHtmlObject('<?= $nombre_script; ?>');
									var fecha_nac_usuario = fecha_nac.prev();
									var fecha = new Date();
									var year = fecha.getFullYear();
									fecha_nac_usuario.datepick($.extend(
											{pickerClass: 'my-picker'}, $.datepick.regionalOptions['es'],
											'option', {dateFormat: ' d/MM/yyyy'},
											{yearRange: 'c-85:' + year},
											{showTrigger: '#calImg', altField: fecha_nac.attr("class"), altFormat: 'yyyy/mm/dd'})
											);
								})();
							});
							</script>
							<?php
						} else {
							?>
							<label><?= traduce_campo_registro($valor); ?><?= $asterisco; ?></label>
							<input type="<?= $tipo_campo; ?>" name="<?= $nombre_campo_formulario; ?>" value='' class="campo_<?= $valor; ?>" <?= $texto_requerido; ?> />
							<?php
						}
					}
					?>
					<input type="checkbox" name="aceptar_condiciones" value='' required/>
					<label class="condiciones_registro"><?= traducir('Acepto las condiciones de la política de privacidad'); ?>&nbsp;<a href="<?= Shop::$configuracion->url; ?>privacidad" title="<?= traducir("Política de privacidad"); ?>"><?= traducir("Leer política de privacidad"); ?></a></label>
					<input type="checkbox" name="aceptar_boletin" value="true" checked/>
					<label class="boletin_novedades"><?= traducir('Deseo inscribirme en el boletín de novedades'); ?></label>
					<input type="hidden" name="accion" value="registro" />
					<p class="error_registro">&nbsp;</p>
					<input type="submit" name="enviar" value="<?= traducir('Registrarse'); ?>"/>
					<input type="hidden" name="todo_correcto" value="false" />
				</fieldset>
			</form>

			<?php
			$nombre_script = 'script_' . incrementa_contador();
			?>
			<script type="text/javascript" id="<?= $nombre_script; ?>">
			document.addEventListener('WSLE', function(event) {
				;(function () {
					var elementObjetive = getLastHtmlObject('<?= $nombre_script; ?>');
					var parrafo_error_registro = elementObjetive.find("p.error_registro");
					elementObjetive.on("submit", function (event) {
						//No seguimos si está todo correcto
						var todo_correcto = elementObjetive.find("input[name='todo_correcto']").val();
						if (todo_correcto == "false") {
							var txt_error_registro = '';
							var correcto = true;
							//Vamos a empezar con los "required"
							var lista_input = $(this).children("fieldset").children("input[required]");
							var i = 0;
							for (i = 0; (i < lista_input.length) && correcto; i++) {
								var elemento = lista_input[i];
								//Si el elemento no es check
								var tipo = $(elemento).prop("type");
								if (tipo != "checkbox") {
									if ($(elemento).prop("value") == '') {
										correcto = false;
										$(elemento).focus();
										poner_sombra($(elemento));
									}
								} else {
									//Si es un check, comprobamos que esté chequeado
									if (!($(elemento).is(":checked"))) {
										correcto = false;
										$(elemento).focus();
										poner_sombra($(elemento));
									}
								}
							}
							if (!correcto) {
								//Aquí paramos
								event.preventDefault();
								txt_error_registro = "<?= traducir("Campos obligatorios incorrectos. Revise los datos facilitados."); ?>";
							} else {
								//Ahora toca hacer la comprobación de los campos tipo email
								lista_input = $(this).children("fieldset").children("input[type='email']");
								var total = lista_input.length;
								for (var i = 0; (i < total) && (correcto); i++) {
									//Comprobamos que tiene un arroba
									var elemento = lista_input[i];
									var contenido = $(elemento).prop("value");
									if (contenido.split("@").length != 2) {
										correcto = false;
										$(elemento).focus();
										poner_sombra($(elemento));
									}
								}

								if (!correcto) {
									event.preventDefault();
									txt_error_registro = "<?= traducir('No ha introducido un email válido.'); ?>";
								} else {
									//ahora toca la comprobación de que los passwords sean iguales
									var campo_password = $(this).children("fieldset").children("input[name='campo_registro_password']").prop("value");
									var repe_password = $(this).children("fieldset").children("input[name='repeticion_password']").prop("value");
									if (campo_password != repe_password) {
										correcto = false;
										$(this).children("fieldset").children("input[name='campo_registro_password']").focus();
										poner_sombra($(this).children("fieldset").children("input[name='campo_registro_password']"));
									}
									if (!correcto) {
										event.preventDefault();
										txt_error_registro = "<?= traducir('Las contraseñas introducidas no coinciden.'); ?>";
									} else {
										//Ahora comprobamos que el check de aceptar las condiciones esté marcado
										if (!$("input[name='aceptar_condiciones'").is(":checked")) {
											correcto = false;
										}
										if (!correcto) {
											event.preventDefault();
											txt_error_registro = "<?= traducir('Debe aceptar las condiciones de la política de privacidad.'); ?>";
										} else {
											//Paramos el submit, pues esta última función es asíncrona
											event.preventDefault();
											//Por último, nos vamos a asegurar de que el email no esté repetido
											var elemento = $(this).children("fieldset").children("input[type='email']");
											var direccion = elemento.prop("value");
											//Sólo comprobamos esto si la dirección NO está vacía
											if (direccion != '') {
												var parametros = "email=" + direccion + "&hash=<?= genera_cod_seguridad(); ?>";
												realizar_solicitud("<?= Shop::$configuracion->url; ?>comunes/consultas/email_comprueba_existe.php", parametros, function (respuesta) {
													if (parseInt(respuesta) > 0) {
														//El email no es correcto
														elemento.focus();
														poner_sombra($(elemento[0]));
														txt_error_registro = "<?= traducir("Ya existe un cliente con esa dirección de email. Si ya se encuentra registrado en nuestra web pruebe a recuperar contraseña. En caso contrario, compruebe que ha escrito bien su dirección de correo electrónico y corríjala."); ?>";
														parrafo_error_registro.html(txt_error_registro);
														parrafo_error_registro.show();
														elementObjetive.find("input[name='todo_correcto']").val("false");
													} else {
														//Hacemos el submit
														if (elementObjetive != null) {
															elementObjetive.find("input[name='todo_correcto']").val("true");
															elementObjetive.submit();
														}
													}
												});
											}
										}
									}
								}
								//si ha habido algún error por el camino, mostramos el error
								if (!correcto) {
									parrafo_error_registro.html(txt_error_registro);
									parrafo_error_registro.show();
									//Hay que indicar que todo no está correcto
									elementObjetive.find("input[name='todo_correcto']").val("false");
								}
							}
						}
					});

					elementObjetive.find("input[required]").on("input", function () {
						quitar_sombra($(this));
						parrafo_error_registro.html("&nbsp;");
						parrafo_error_registro.hide();
					});

					elementObjetive.find("input[name='campo_registro_cod_postal']").on("blur", function () {
						var elemento = $(this);
						if (elemento.prop("value") != '') {
							var parametros = "cod_postal=" + elemento.prop("value") + "&hash=<?= genera_cod_seguridad(); ?>";
							realizar_solicitud("<?= Shop::$configuracion->url; ?>comunes/consultas/cod_postal_get_localidad.php", parametros, function (respuesta) {
								if (respuesta != "0") {
									//Tenemos localidad y provincia
									var array_datos = respuesta.split("|");
									var localidad = array_datos[0];
									var provincia = array_datos[1];
									//Vamos a asginar la localidad y provincia
									var campo_localidad = elementObjetive.find("[name='campo_registro_localidad']");
									if (campo_localidad.prop("value") == '') {
										campo_localidad.prop("value", localidad);
									}
									var campo_provincia = elementObjetive.find("[name='campo_registro_provincia']");
									if (campo_provincia.prop("value") == '') {
										campo_provincia.prop("value", provincia);
									}
								}
							});
						}
					});
				}());
			});
			</script>
			<?php
		} else {
			//Mostramos el mensaje
			?>
			<p><?= $mensaje_registro_correcto[0]->getCuerpo(); ?></p>
			<?php
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
	//Aquí llega el momento de limpiar todos los mensajes que haya en el registro, que no sean de widget, claro
	return(true);
}

function panel_usuario($usuario_a_mostrar = 0, $elementos_a_mostrar = array('datos', 'direcciones', 'pedidos'), $separador = '', $opciones_component = NULL, $ficheroLanzador = '') {
	include('comunes/globals.php');
	$ocultarCabecera = false;

	//Vamos a convertir este widget en un V2
	if (is_a($usuario_a_mostrar, 'OpcionesWidget')) {
		$opciones = $usuario_a_mostrar;
		$usuario_a_mostrar = ($opciones->configuracion->usuario_a_mostrar != NULL) ? $opciones->configuracion->usuario_a_mostrar : Usuario::logueado();
		$elementos_a_mostrar = ($opciones->configuracion->elementos_a_mostrar != NULL) ? $opciones->configuracion->elementos_a_mostrar : array('datos', 'direcciones', 'pedidos');
		$separador = ($opciones->configuracion->usuario_a_mostrar != NULL) ? $separador->configuracion->usuario_a_mostrar : '';
		$opciones_component = ($opciones->configuracion->opciones_component != NULL) ? $opciones->configuracion->opciones_component : NULL;
		$ficheroLanzador = ($opciones->configuracion->ficheroLanzador != NULL) ? $opciones->configuracion->ficheroLanzador : '';
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
	}

	if (!is_object($usuario_a_mostrar)) {
		//Si el usuario a mostrar es 0, entonces hay que cargar los datos del usuario
		if ($usuario_a_mostrar == 0) {
			$usuario_a_mostrar = $datos_usuario;
		}
		//Antes de seguir, vamos a comprobar si se nos ha pasado un usuario
		$tipo_dato = gettype($usuario_a_mostrar);
		//echo("El tipo de dato recibido es: $tipo_dato<br />\n");
		if (($tipo_dato == 'integer') || ($tipo_dato == 'string')) {
			//Cargamos el objeto
			$usuario_a_mostrar = new Usuario($usuario_a_mostrar);
		}
	}
	if (gettype($usuario_a_mostrar) == 'object') {
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
			<div class="<?= (__FUNCTION__); ?>">
				<?php
			}
			?>
			<?php
			//Si el componente no recibe opciones, creamos unas por defecto
			if ($opciones_component == NULL) {
				$opciones_component = new OpcionesSlider();
				$opciones_component->centerH = 'false';
				$opciones_component->centerV = 'false';
				$opciones_component->transBackground = 'false';
				$opciones_component->closeButton = 'false';
				$opciones_component->inSpeed = "'slow'";
				$opciones_component->positionY = "'parent_b'";
				$opciones_component->positionX = "'parent_l'";
				$opciones_component->pivot = "'lt'";
				$opciones_component->type = "'dropDown'";
			}
			if ($opciones_component->type == NULL) {
				$opciones_component->type = "'dropDown'";
			}
			//Voy a crear un widget vacío y voy a grabar en él el panel de usuario del cliente
			$widget_panel_usuario = new Widget();
			$widget_panel_usuario->record();
			// COMIENZO GRABACIÓN------------------------------------------------------------------------------------------
			$personalizado = true;
			$ruta_fichero = Theme::findFile($ficheroLanzador . '.php');
			if (($ficheroLanzador == '') || ( $ruta_fichero == NULL)) {
				$personalizado = false;
			}
			if (!$personalizado) {
				?>
				<span class="nombre_usuario"><?= $usuario_a_mostrar->nombre_legal; ?></span>
				<span class="mi_cuenta"><?= traducir('Mi cuenta'); ?></span>
				<?php
			} else {
				include($ruta_fichero);
			}
			// FIN GRABACIÓN------------------------------------------------------------------------------------------
			$widget_panel_usuario->record();
			//Ahora creamos un widget con las opciones de usuario
			$widget_menu_usuario = new Widget($_WH->GW('usuario', 'menu_usuario', $opciones_component->type, false, $opciones_component), $elementos_a_mostrar, $separador);
			//Ahora creo un widget que lanze el widget anteior
			new Widget(LW_params(), $widget_menu_usuario, $widget_panel_usuario, 'div', 'onmouseenter', 'lanzador_widget', '', 'menu_usuario');
			?>
			<?php
			if (!$ocultarCabecera) {
				?>
			</div>
			<?php
		}
		?>
		<?php
	}
}

function menu_usuario($elementos_a_mostrar = array('datos', 'direcciones', 'pedidos'), $separador = '') {
	include('comunes/globals.php');
	$ocultarCabecera = false;

	if (($elementos_a_mostrar != NULL) && (is_a($elementos_a_mostrar, "OpcionesWidget"))) {
		$opciones = $elementos_a_mostrar;
		$elementos_a_mostrar = array('datos', 'direcciones', 'pedidos');
		$separador = '';
		if (is_a($opciones, 'OpcionesWidget')) {
			$elementos_a_mostrar = ($opciones->configuracion->elementos_a_mostrar != NULL) ? $opciones->configuracion->elementos_a_mostrar : $elementos_a_mostrar;
			$separador = ($opciones->configuracion->separador != NULL) ? $opciones->configuracion->separador : $separador;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	//Vamos a crear una capa donde meter las opciones
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<span class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		foreach ($elementos_a_mostrar as $clave => $valor) {
			dame_opcion_menu_usuario($valor);
			?>
			<span class="separador"><?= $separador; ?></span>
			<?php
		}
		?>
		<form class="form_cerrar_sesion" method="post" action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>"><input type="hidden" value="1" name="cerrar_sesion" /><input type="submit"  value="<?= traducir("Cerrar sesión"); ?>" name="Enviar"/></form>
		<?php
		if (!$ocultarCabecera) {
			?>
		</span>
		<?php
	}
	?>
	<?php
}

function acceso_usuario($elementos_a_mostrar = array('datos', 'direcciones', 'pedidos'), $texto_cab_login = '', $menu_dropDown = true, $separador = '', $tipo_login = 'modal', $tipo_registro = 'modal') {
	include('comunes/globals.php');
	$ocultarCabecera = false;

	if (($elementos_a_mostrar != NULL) && (is_a($elementos_a_mostrar, "OpcionesWidget"))) {
		$opciones = $elementos_a_mostrar;
		$elementos_a_mostrar = array('datos', 'direcciones', 'pedidos');
		$texto_cab_login = '';
		$menu_dropDown = true;
		$separador = '';
		$tipo_login = 'modal';
		$tipo_registro = 'modal';
		if (is_a($opciones, 'OpcionesWidget')) {
			$elementos_a_mostrar = ($opciones->configuracion->elementos_a_mostrar != NULL) ? $opciones->configuracion->elementos_a_mostrar : $elementos_a_mostrar;
			$texto_cab_login = ($opciones->configuracion->texto_cab_login != NULL) ? $opciones->configuracion->texto_cab_login : $texto_cab_login;
			$menu_dropDown = ($opciones->configuracion->menu_dropDown != NULL) ? $opciones->configuracion->menu_dropDown : $menu_dropDown;
			$separador = ($opciones->configuracion->separador != NULL) ? $opciones->configuracion->separador : $separador;
			$tipo_login = ($opciones->configuracion->tipo_login != NULL) ? $opciones->configuracion->tipo_login : $tipo_login;
			$tipo_registro = ($opciones->configuracion->tipo_registro != NULL) ? $opciones->configuracion->tipo_registro : $tipo_registro;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		//Según si el usuario está o no logueado, hacemos una cosa u otra
		if ($datos_usuario->codigo > 0) {
			//es posible que en vez de que nos digan que el menú es dropDown, nos pasen los parámetros de configuración
			if ((is_a($menu_dropDown, 'OpcionesSlider')) || ($menu_dropDown === true)) {
				if ($menu_dropDown === true) {
					//Nos vamos a componer un slider a manubrio
					$menu_dropDown = new OpcionesSlider();
					$menu_dropDown->centerH = 'false';
					$menu_dropDown->centerV = 'false';
					$menu_dropDown->transBackground = 'false';
					$menu_dropDown->closeButton = 'false';
					$menu_dropDown->inSpeed = "'slow'";
					$menu_dropDown->positionY = "'parent_b'";
					$menu_dropDown->positionX = "'parent_l'";
					$menu_dropDown->pivot = "'lt'";
					$menu_dropDown->type = "'dropDown'";
				}
				if ($menu_dropDown->type == NULL) {
					$menu_dropDown->type = "'dropDown'";
				}
				//creamos el widget
				new Widget($_WH->GW('usuario', 'panel_usuario'), $datos_usuario, $elementos_a_mostrar, $separador, $menu_dropDown);
			} else {
				?>
				<div class="bloque_datos_usuario">
					<span class="datos_usuario">
						<span class="nombre_usuario"><?= $datos_usuario->nombre_legal; ?></span>
						<span class="separador"><?= $separador; ?></span>
					</span>
					<?php
					new Widget($_WH->GW('usuario', 'menu_usuario'), $elementos_a_mostrar, $separador);
					?>
				</div>
				<?php
			}
		} else {
			new Widget($_WH->GW('usuario', 'menu_inicio_sesion'), $texto_cab_login, $separador, $tipo_login, $tipo_registro);
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
	return(true);
}

function mod_datos_basico($campos_registro = array('nombre_legal', 'email', 'direccion', 'cod_postal', 'localidad', 'provincia'), $campos_obligatorios = array('nombre_legal', 'email')) {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (($campos_registro != NULL) && (is_a($campos_registro, "OpcionesWidget"))) {
		$opciones = $campos_registro;
		$campos_registro = array('nombre_legal', 'email', 'direccion', 'cod_postal', 'localidad', 'provincia');
		$campos_obligatorios = array('nombre_legal', 'email');
		if (is_a($opciones, 'OpcionesWidget')) {
			$array_campos = ($opciones->configuracion->array_campos != NULL) ? $opciones->configuracion->array_campos : $array_campos;
			$campos_obligatorios = ($opciones->configuracion->campos_obligatorios != NULL) ? $opciones->configuracion->campos_obligatorios : $campos_obligatorios;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	//Vamos a calcular la dirección de envío. En este caso consiste en obtener el último elemento del camino seguido
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		$widget_mod_datos = new Widget($_WH->GW('usuario', 'mod_datos_personales'));
		$widget_mod_pass = new Widget($_WH->GW('usuario', 'mod_password_usuario'));
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
	return(true);
}

function mod_password_usuario($opciones = NULL) {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (is_a($opciones, 'OpcionesWidget')) {
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
	}
	/*$mensajes_de_este_widget = $listaSysMsg->findElement(array('origen' => '/^widget_usuario$/', 'funcion' => '/^mod_password_usuario$/'));
	$texto_a_mostrar = '';
	$correcto = '';
	//Cargamos el primero que haya, si lo hay
	if ($mensajes_de_este_widget != NULL) {
		$mensajes_de_este_widget = $mensajes_de_este_widget[0];
		$texto_a_mostrar = $mensajes_de_este_widget->getCuerpo();
		$correcto = $mensajes_de_este_widget->getClase();
	}*/
	?>
	<?php
	if ($ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>

		<h3><?= traducir('Contraseña'); ?></h3>
		<?php
		//Si todo ha sido correcto no muestro el texto introductorio, si no que muestro un P indicando que todo ha sido correcto
		if ($correcto == 'correcto') {
			?>
			<p class="mod_datos_correcto"><?= $texto_a_mostrar; ?></p>
			<?php
		} else {
			?>
			<p><?= traducir('Para modificar su password escriba su password actual y posteriormente escriba el nuevo password. Por seguridad debe repetir la nueva contraseña en el tercer campo. Una vez introducidos pulse sobre el botón "Modificar password".'); ?></p>			
			<?php
			if ($correcto == 'error') {
				?>
				<p class="error_mod_datos"><?= $texto_a_mostrar; ?></p>
				<?php
			}
		}
		?>
		<form action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" method="post" class="mod_datos_simple">
			<fieldset>
				<label><?= traducir('Contraseña actual'); ?></label>
				<input type="password" name="password_actual" value='' class="campo_password" required>
				<label><?= traducir('Nueva contraseña'); ?></label>
				<input type="password" name="campo_registro_password" value='' class="campo_password" required>
				<label><?= traducir('Repetir contraseña'); ?></label>
				<input type="password" name="repeticion_password" value='' class="campo_repeticion_password" required>
				<input type="submit" name="enviar" value="<?= traducir('Modificar password'); ?>"/>
				<input type="hidden" name="cliente" value="<?= $datos_usuario->codigo; ?>" />
				<input type="hidden" name="accion" value="mod_password" />
			</fieldset>
			<p class="error_mod_pass">&nbsp;</p>
		</form>
		<?php
		crear_script_control_mod_pass();
		?>
		<p class="error_mod_pass">&nbsp;</p>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

function mod_datos_personales($campos_registro = array('nombre_legal', 'email', 'direccion', 'cod_postal', 'localidad', 'provincia', 'fecha_nacimiento'), $campos_obligatorios = array('nombre_legal', 'email')) {
	include('comunes/globals.php');
	$ocultarCabecera = false;
	if (($campos_registro != NULL) && (is_a($campos_registro, "OpcionesWidget"))) {
		$opciones = $campos_registro;
		$campos_registro = array('nombre_legal', 'email', 'direccion', 'cod_postal', 'localidad', 'provincia', 'fecha_nacimiento');
		$campos_obligatorios = array('nombre_legal', 'email');
		if (is_a($opciones, 'OpcionesWidget')) {
			$campos_registro = ($opciones->configuracion->campos_registro != NULL) ? $opciones->configuracion->campos_registro : $campos_registro;
			$campos_registro = ($opciones->configuracion->campos_obligatorios != NULL) ? $opciones->configuracion->campos_obligatorios : $campos_obligatorios;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	//Cargamos el mensaje si lo hubiese
	/*$mensajes_de_este_widget = $listaSysMsg->findElement(array('origen' => '/^widget_usuario$/', 'funcion' => '/^mod_datos_personales$/'));
	$texto_a_mostrar = '';
	$correcto = '';
	//Cargamos el primero que haya, si lo hay
	if ($mensajes_de_este_widget != NULL) {
		$mensajes_de_este_widget = $mensajes_de_este_widget[0];
		$texto_a_mostrar = $mensajes_de_este_widget->getCuerpo();
		$correcto = $mensajes_de_este_widget->getClase();
	}*/
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<h3><?= traducir('Modificación de datos'); ?></h3>
		<?php
		//Si tenemos un "correcto" entonces mostramos aquí la el mensaje
		if ($correcto == 'correcto') {
			?>
			<p class="mod_datos_correcto"><?= $texto_a_mostrar; ?></p>
			<?php
		} else {
			?>
			<p><?= traducir('Estos son sus datos de usuario. Para modificarlos, cambie el dato que necesite y pulse sobre el botón "Modificar datos"'); ?></p>
			<?php
			if ($correcto == 'error') {
				?>
				<p class="error_mod_datos"><?= $texto_a_mostrar; ?></p>
				<?php
			}
		}
		//Si el resgistro está supervisado, activamos el readonly:
		$readonly = '';
		if (Shop::$configuracion->registro_supervisado) {
			$readonly = 'readonly';
		}
		?>
		<form action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" method="post" class="mod_datos_simple">
			<fieldset>
				<?php
				//Recorremos el array de campos
				foreach ($campos_registro as $clave => $valor) {
					//Vamos a asignar un tipo de campo, y a decidir si es obligatorio o no
					$tipo_campo = "text";
					$texto_requerido = '';
					$asterisco = '';
					$nombre_campo_formulario = 'campo_registro_' . $valor;
					$fecha_nacimiento = false;
					switch ($valor) {
						case 'email':
							$tipo_campo = 'email';
							break;
						case 'telefono':
							$tipo_campo = 'tel';
							break;
						case 'fecha_nacimiento':
							$fecha_nacimiento = true;
							break;
					}
					if (in_array($valor, $campos_obligatorios)) {
						$texto_requerido = 'required';
						$asterisco = ' <span class="asterisco">*</span>';
					}
					if ($fecha_nacimiento == true) {
						//Insertamos el campo fecha utilizando el conversor de fechas;
						?>
						<label><?= traduce_campo_registro($valor); ?></label>
						<input type="<?= $tipo_campo; ?>" id="fecha_nac_usuario" value="<?= $datos_usuario->$valor; ?>" class="campo_<?= $valor; ?>" <?= $texto_requerido; ?> <?= $readonly; ?> />
						<input type="hidden" id="fecha_nac" name="<?= $nombre_campo_formulario; ?>" value="<?= $datos_usuario->$valor; ?>" class="campo_<?= $valor; ?>" <?= $texto_requerido; ?> />
						<script language="javascript">
						document.addEventListener('WSLE', function(event) {
							$("#btn_modificar_datos").on("click", function () {
								convertir("<?= $datos_usuario->$valor; ?>");
								function convertir(fechaLlegada) {
									var arrayFecha = fechaLlegada.split("-");
									arrayFecha.reverse();
									var arrayMesesLetra = ['Enero',
										'Febrero',
										'Marzo',
										'Abril',
										'Mayo',
										'Junio',
										'Julio',
										'Agosto',
										'Septiembre',
										'Octubre',
										'Noviembre',
										'Diciembre'];
									var arrayMesesNumero = [01, 02, 03, 04, 05, 06, 07, 08, 09, 10, 11, 12];
									for (i = 0; i < arrayMesesNumero.length; i++) {
										if (arrayFecha[1] == arrayMesesNumero[i]) {
											arrayFecha[1] = arrayMesesLetra[i];
											fecha = arrayFecha.toString();
											fecha = fecha.replace(",", "/");
											fecha = fecha.replace(",", "/");
											document.getElementById("fecha_nac_usuario").value = fecha;
											document.getElementById("fecha_nac").value = fechaLlegada;
										}
									}
								}
							});
						});
						</script>
						<?php
					} else {
						?>
						<label><?= traduce_campo_registro($valor); ?><?= $asterisco; ?></label>
						<input type="<?= $tipo_campo; ?>" name="<?= $nombre_campo_formulario; ?>" value="<?= $datos_usuario->$valor; ?>" class="campo_<?= $valor; ?>" <?= $texto_requerido; ?>  <?= $readonly; ?>/>
						<?php
					}
				}
				?>
				<input type="hidden" name="accion" value="mod_datos" />
				<?php if (!Shop::$configuracion->registro_supervisado) {// Pasara cuando el registro este a 0 ?>
					<input type="submit" name="enviar" value="<?= traducir('Modificar datos'); ?>"/>
				<?php } ?>
				<input type="hidden" name="cliente" value="<?= $datos_usuario->codigo; ?>" />
			</fieldset>
			<p class="error_registro">&nbsp;</p>
		</form>
		<?php
		if (!Shop::$configuracion->registro_supervisado) {
			crear_script_control_mod_datos();
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

function muestra_datos_personales($campos_registro = array('email', 'nombre_legal', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono', 'fecha_nacimiento')) {
	include('comunes/globals.php');
	$ocultarCabecera = false;

	$ocultarCabecera = false;
	if (($campos_registro != NULL) && (is_a($campos_registro, "OpcionesWidget"))) {
		$opciones = $campos_registro;
		$campos_registro = array('email', 'nombre_legal', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono', 'fecha_nacimiento');
		if (is_a($opciones, 'OpcionesWidget')) {
			$campos_registro = ($opciones->configuracion->campos_registro != NULL) ? $opciones->configuracion->campos_registro : $campos_registro;
			$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
		}
	}
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<h3><?= traducir('Datos de registro'); ?></h3>
		<div class="ver_datos_usuario">
			<?php
			//Recorremos el array de campos
			foreach ($campos_registro as $clave => $valor) {
				//Vamos a asignar un tipo de campo, y a decidir si es obligatorio o no
				$nombre_campo_formulario = 'campo_registro_' . $valor;
				?>
				<p class="campo_<?= $valor; ?>">
					<span><?= traduce_campo_registro($valor); ?></span>
					<?php
					if ($valor == "fecha_nacimiento" && $datos_usuario->$valor != "0000-00-00") {
						//Si el campo a mostrar es la fecha, modificamos el formato de la misma.
						?>
						<strong>
							<?php
							$date = date_create($datos_usuario->$valor);
							echo date_format($date, 'j/');
							echo traducir(date_format($date, 'F'));
							echo date_format($date, '/Y');
							?>
						</strong>
						<?php
					} else {
						?>
						<strong><?= $datos_usuario->$valor; ?></strong>
						<?php
					}
					?>
				</p>
				<?php
			}
			?>
		</div>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

function confirmacion_registro($opciones = NULL) {
	include('comunes/globals.php');
	$ocultarCabecera = false;

	if (is_a($opciones, 'OpcionesWidget')) {
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
	}
	?>
	<?php
	if (!$ocultarCabecera) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<?php
		}
		?>
		<?php
		//Vamos a ver el mensaje de registro que nos han pasado desde los widgets
		/*$mensajes_de_este_widget = $listaSysMsg->findElement(array('origen' => '/^widget_usuario$/', 'funcion' => '/^confirmacion_registro$/'));
		$texto_a_mostrar = '';
		$correcto = '';
		//Cargamos el primero que haya, si lo hay
		if ($mensajes_de_este_widget != NULL) {
			$mensajes_de_este_widget = $mensajes_de_este_widget[0];
			$texto_a_mostrar = $mensajes_de_este_widget->getCuerpo();
			$correcto = $mensajes_de_este_widget->getClase();
		}
		*/
		//Si el mensaje es correcto mostramos el texto junto con el formulario de login
		if ($correcto == 'correcto') {
			//Como la confirmación ha sido correcta, mostramos el mensaje que lo indica y el formulario de login
			?>
			<p class="confirmacion_correcta"><?= $texto_a_mostrar; ?></p>
			<?php
			//Vamos a mostrar el formulario de login
			new Widget('usuario');
		} else if ($correcto == 'error') {
			?>
			<p class="confirmacion_erronea"><?= $texto_a_mostrar; ?></p>
			<?php
		}
		?>
		<?php
		if (!$ocultarCabecera) {
			?>
		</div>
		<?php
	}
	?>
	<?php
}

//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Funciones que usamos en este widget
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function crear_script_control_login() {
	include('comunes/globals.php');
	//Esta función crea el script que controla que el registro esté bien
	?>
	<script type="text/javascript">
	document.addEventListener('WSLE', function(event) {
		//A partir de este script, vamos a cargar el fomulario de registro
		var scripts = document.getElementsByTagName('script');
		var thisScriptTag_login = scripts[ scripts.length - 1 ];
		var form_login = $(thisScriptTag_login).prev();
		var login_correcto = true;
		//No estamos ni en chrome ni en firefox, así que hay que controlar los campos obligatorios
		$(form_login).on("submit", function (event) {
			login_correcto = true;
			var fieldset = $(this).children("fieldset")[0];
			//Comrobaciones sólo para IE y resto de navegadores que no sean chrome o firefox

			var lista_input = $(fieldset).children("input[required]");
			var total = lista_input.length;
			for (var i = 0; (i < total) && (login_correcto); i++) {
				var elemento = lista_input[i];
				if ($(elemento).prop("value") == '') {
					login_correcto = false;
					$(elemento).focus();
					poner_sombra($(elemento));
				}
			}
			//Ahora vamos a controlar si hubiese un campo email y si todo es correcto
			if (login_correcto) {
				lista_input = $(this).children("fieldset").children("input[type='email']");
				var total = lista_input.length;
				for (var i = 0; (i < total) && (login_correcto); i++) {
					//Comprobamos que tiene un arroba
					var elemento = lista_input[i];
					var contenido = $(elemento).prop("value");
					if (contenido.split("@").length != 2) {
						login_correcto = false;
						$(elemento).focus();
						poner_sombra($(elemento));
					}
				}
			}
			if (!login_correcto) {
				event.preventDefault();
			}
		});

		//Vamos a crear un "listener" para que cuando cambie un input, si el borde es rojo, que se ponga en su borde inicial
		$(form_login).children("fieldset").children("input[required]").on("input", function () {
			quitar_sombra($(this));
		});
	});
	</script>
	<?php
}

function crear_script_control_registro() {
	include('comunes/globals.php');
	?>

	<?php
}

//Esta función recibe un campo del registro y devuelve su nombre traducido
function traduce_campo_registro($campo) {
	$retorno = $campo;
	$lista_nombres_campos = array(
		'nombre_legal' => traducir('Nombre'),
		'nombre' => traducir('Nombre'),
		'email' => traducir('Email'),
		'password' => traducir('Contraseña'),
		'repeticion_password' => traducir('Escriba de nuevo su contraseña'),
		'direccion' => traducir('Dirección'),
		'cod_postal' => traducir('Código postal'),
		'localidad' => traducir('Localidad'),
		'email' => traducir('Email'),
		'provincia' => traducir('Provincia'),
		'pais' => traducir('País'),
		'telefono' => traducir('Teléfono'),
		'fecha_nacimiento' => traducir('Fecha de nacimiento'),
		'nombre_solo' => traducir('Nombre'),
		'apellidos_solo' => traducir('Apellidos')
	);
	if (array_key_exists($campo, $lista_nombres_campos)) {
		$retorno = $lista_nombres_campos[$campo];
	}
	return($retorno);
}

function crear_script_control_mod_datos() {
	include('comunes/globals.php');
	?>
	<script type="text/javascript">
	document.addEventListener('WSLE', function(event) {
		//A partir de este script, vamos a cargar el fomulario de registro
		var scripts = document.getElementsByTagName('script');
		var thisScriptTag_mod_datos = scripts[ scripts.length - 1 ];
		var form_registro = $(thisScriptTag_mod_datos).prev();
		var correcto_mod_datos = true;
		var parrafo_error_mod_datos = form_registro.children("p.error_mod_datos");
		var txt_error_registro = '';
		var todo_esta_correcto = false;

		//No estamos ni en chrome ni en firefox, así que hay que controlar los campos obligatorios
		$(form_registro).on("submit", function (event) {
			//Si todo está correcto, no hacemos esto
			if (!todo_esta_correcto) {
				//No dejamos que se haga el submit. Hay que hacerlo si todo está bien
				event.preventDefault();
				correcto_mod_datos = true;
				var fieldset = $(this).children("fieldset")[0];
				//Comrobaciones sólo para IE y resto de navegadores que no sean chrome o firefox
				var lista_input = $(fieldset).children("input[required]");
				var total = lista_input.length;
				for (var i = 0; (i < total) && (correcto_mod_datos); i++) {
					var elemento = lista_input[i];
					if ($(elemento).prop("value") == '') {
						correcto_mod_datos = false;
						$(elemento).focus();
						poner_sombra($(elemento));
						txt_error_registro = "<?= traducir("Campos obligatorios incorrectos. Revise los datos facilitados."); ?>";
					}
				}
				//Ahora vamos a controlar si hubiese un campo email y si todo es correcto
				if (correcto_mod_datos) {
					lista_input = $(this).children("fieldset").children("input[type='email']");
					var total = lista_input.length;
					for (var i = 0; (i < total) && (correcto_mod_datos); i++) {
						//Comprobamos que tiene un arroba
						var elemento = lista_input[i];
						var contenido = $(elemento).prop("value");
						if (contenido.split("@").length != 2) {
							correcto_mod_datos = false;
							$(elemento).focus();
							poner_sombra($(elemento));
							txt_error_registro = "<?= traducir("No ha introducido un email válido."); ?>";
						}
					}
				}
				//Comprobamos si hay dos campos de password y si son iguales si todo ha sido correcto
				if (correcto_mod_datos) {
					var campo_password = $(this).children("fieldset").children("input[name='campo_registro_password']").prop("value");
					var repe_password = $(this).children("fieldset").children("input[name='repeticion_password']").prop("value");
					if (campo_password != repe_password) {
						correcto_mod_datos = false;
						$(this).children("fieldset").children("input[name='campo_registro_password']").focus();
						poner_sombra($(this).children("fieldset").children("input[name='campo_registro_password']"));
						txt_error_registro = "<?= traducir("Las contraseñas introducidas no coinciden."); ?>";
					}
				}
				//Ahora comprobamos que el email no exista
				if (correcto_mod_datos) {
					var email = $(form_registro).children("fieldset").children("input[type='email']").prop("value");
					var cliente = $(form_registro).children("fieldset").children("input[name='cliente']").prop("value");
					//if ($(form_registro).children("fieldset").children("input[type='email']").length > 0){
					check_email_cliente(email, cliente, $(form_registro).children("fieldset").children("input[type='email']"), $(this));
					/*}else{
					 //Si no hay email no hay que comprobar nada más, enviamos el formulario
					 todo_esta_correcto = true;
					 $(this).trigger("submit");
					 }*/
				}

				if (!correcto_mod_datos) {
					parrafo_error_mod_datos.html(txt_error_registro);
				}
			}
		});

		//Vamos a crear un "listener" para que cuando cambie un input, si el borde es rojo, que se ponga en su borde inicial
		$(form_registro).children("fieldset").children("input[required]").on("input", function () {
			quitar_sombra($(this));
			parrafo_error_mod_datos.html("&nbsp;	");
		});

		//Cuando pierda el foco el email, vamos a comprobar que hay disponibilidad
		$(form_registro).children("fieldset").children("input[type='email']").on("blur", function () {
			var email = $(form_registro).children("fieldset").children("input[type='email']").prop("value");
			var cliente = $(form_registro).children("fieldset").children("input[name='cliente']").prop("value");
			//En esta petición no enviamos el formulario para que no se haga el submit
			correcto_mod_datos = check_email_cliente(email, cliente, $(form_registro).children("fieldset").children("input[type='email']"));
		});
		$(form_registro).children("fieldset").children("input[name='campo_registro_cod_postal']").on("blur", function () {
			var elemento = $(this);
			var parametros = "cod_postal=" + elemento.prop("value") + "&hash=<?= genera_cod_seguridad(); ?>";
			realizar_solicitud("<?= Shop::$configuracion->url; ?>comunes/consultas/cod_postal_get_localidad.php", parametros, function (respuesta) {
				if (respuesta != "0") {
					//Tenemos localidad y provincia
					var array_datos = respuesta.split("|");
					var localidad = array_datos[0];
					var provincia = array_datos[1];
					//Vamos a asginar la localidad y provincia
					var campo_localidad = elemento.siblings("[name='campo_registro_localidad']");
					if (campo_localidad.prop("value") == '') {
						campo_localidad.prop("value", localidad);
					}
					var campo_provincia = elemento.siblings("[name='campo_registro_provincia']");
					if (campo_provincia.prop("value") == '') {
						campo_provincia.prop("value", provincia);
					}
				}
			});
		});

		function check_email_cliente(direccion, cliente, elemento, formulario) {
			var parametros = "email=" + direccion + "&cliente=" + cliente + "&hash=<?= genera_cod_seguridad(); ?>";
			realizar_solicitud("<?= Shop::$configuracion->url; ?>comunes/consultas/email_cliente_comprueba_existe.php", parametros, function (respuesta) {
				if (parseInt(respuesta) != 0) {
					//El email no es correcto
					retorno = false;
					elemento.focus();
					poner_sombra($(elemento[0]));
					txt_error_registro = "<?= traducir("Ya existe otro cliente con esa dirección de email. Para cambiar su dirección de email debe especificar una dirección que no esté utilizando ningún cliente registrado en nuestra web."); ?>";
					parrafo_error_mod_datos.html(txt_error_registro);
					parrafo_error_mod_datos.show();
				} else {
					//Hacemos el submit
					if (formulario != null) {
						todo_esta_correcto = true;
						formulario.submit();
					}
				}
			});
			return(0);
		}
	});
	</script>
	<?php
}

function crear_script_control_mod_pass() {
	include('comunes/globals.php');
	?>	
	<script type="text/javascript">
	document.addEventListener('WSLE', function(event) {
		var scripts = document.getElementsByTagName('script');
		var thisScriptTag_pass = scripts[ scripts.length - 1 ];
		var form_mod_pass = $(thisScriptTag_pass).prev();
		var parrafo_error_mod_pass = form_mod_pass.children("p.error_mod_pass");
		var correcto_pass = true;
		//Controlamos  que se hayan rellenado los tres campos de password y que ambos pass sean iguales
		$(form_mod_pass).on("submit", function (event) {
			var txt_error = '';
			var password = $(form_mod_pass).find('[name="password_actual"]').prop("value");
			var nuevo_password = $(form_mod_pass).find('[name="campo_registro_password"]').prop("value");
			var repe_password = $(form_mod_pass).find('[name="repeticion_password"]').prop("value");
			if ((password == '') || (nuevo_password == '') || (repe_password == '')) {
				correcto_pass = false;
				txt_error = "<?= traducir("Debe rellenar los tres campos para continuar"); ?>";
				$(form_mod_pass).find('[name="password_actual"]').focus();
				poner_sombra($(form_mod_pass).find('[name="password_actual"]'));
				poner_sombra($(form_mod_pass).find('[name="repeticion_password"]'));
			}
			if (nuevo_password != repe_password) {
				correcto_pass = false;
				txt_error = "<?= traducir("La nueva contraseña no coincide con el campo de repetición de contraseña."); ?>";
				//Hay que poner el foco en el "campo_registro_password" y ponerle la sombra
				$(form_mod_pass).find('[name="campo_registro_password"]').focus();
				poner_sombra($(form_mod_pass).find('[name="campo_registro_password"]'));
			}
			if (!correcto_pass) {
				event.preventDefault();
				parrafo_error_mod_pass.html(txt_error);
				correcto_pass = true;
				parrafo_error_mod_pass.show();
			}
		});
		$(form_mod_pass).find('[required]').on("input", function () {
			quitar_sombra($(this));
			parrafo_error_mod_pass.html("&nbsp;");
			parrafo_error_mod_pass.hide();
		});
	});
	</script>
	<?php
}

function dame_opcion_menu_usuario($opcion = NULL) {
	include ('comunes/globals.php');
	$clase_enlce = 'no_seleccionado';
	if ($opcion == $seccion) {
		$clase_enlce = 'seleccionado';
	}
	?>
	<!-- <?= $seccion; ?> -->
	<?php
	//Según la opción recibida, mostramos el enlace correspondiente
	if ($opcion == 'datos') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>mis_datos" title="<?= traducir("Mis datos personales"); ?>" class="<?= $clase_enlce; ?>"><?= traducir("Mis datos personales"); ?></a>
		<?php
	} else if ($opcion == 'direcciones') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>mis_direcciones" title="<?= traducir("Mis direcciones de envío"); ?>" class="<?= $clase_enlce; ?>"><?= traducir("Mis direcciones de envío"); ?></a>
		<?php
	} else if ($opcion == 'favoritos') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>favoritos" title="<?= traducir("Favoritos"); ?>" class="<?= $clase_enlce; ?>"><?= traducir("Favoritos"); ?></a>
		<?php
	} else if ($opcion == 'pedidos_ptes') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>pedidos_pendientes" title="<?= traducir("Pedidos pendientes"); ?>" class="<?= $clase_enlce; ?>"><?= traducir("Pedidos pendientes"); ?></a>
		<?php
	} else if ($opcion == 'reservas') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>reservas" title="<?= traducir("Mis reservas"); ?>" class="<?= $clase_enlce; ?>"><?= traducir("Mis reservas"); ?></a>
		<?php
	} else if ($opcion == 'hco_pedidos') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>historico_pedidos" title="<?= traducir("Histórico de pedidos"); ?>" class="<?= $clase_enlce; ?>"><?= traducir("Histórico de pedidos"); ?></a>
		<?php
	} else if ($opcion == 'cesta') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>cesta" title="<?= traducir("Mi cesta"); ?>" class="<?= $clase_enlce; ?>"><?= traducir("Mi cesta"); ?></a>
		<?php
	} else if ($opcion == 'albaranes') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>albaranes" title="<?= traducir('Albaranes'); ?>" class="<?= $clase_enlce; ?>"><?= traducir('Albaranes'); ?></a>
		<?php
	} else if ($opcion == 'facturas') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>facturas" title="<?= traducir("Mis facturas"); ?>" class="<?= $clase_enlce; ?>"><?= traducir("Mis facturas"); ?></a>
		<?php
	} else if ($opcion == 'depositos') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>depositos" title="<?= traducir('Mis depósitos'); ?>" class="<?= $clase_enlce; ?>"><?= traducir('Mis depósitos'); ?></a>
		<?php
	} else if ($opcion == 'catalogos') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>catalogos" title="<?= traducir("Catálogos"); ?>" class="<?= $clase_enlce; ?>"><?= traducir("Catálogos"); ?></a>
		<?php
	} else if ($opcion == 'suscripciones') {
		?>
		<a href="<?= Shop::$configuracion->url; ?>suscripciones" title="<?= traducir('Suscripciones'); ?>" class="<?= $clase_enlce; ?>"><?= traducir('Suscripciones'); ?></a>
		<?php
	}
}

include('usuario_extra.php');
include('usuarioV2.php');
?>
