<?php
/*
	Clase SuperBusqueda
	@version 1.0
*/

class SuperBusqueda extends Apartado{
	//Esta clase se usa para hacer búsquedas y podre mostrar los resultados
	public $busqueda_simple = '';
	public $titulo = '';
	public $nombre = ''; //El nombre lo usamos en la búsqueda avanzada, lo cambiamos por el título
	public $editorial = '';
	public $autor = '';
	public $isbn = '';
	public $ean = '';
	public $nombreColeccion = '';
	public $categoria = '';
	public $tbusqueda = 'simple';/*0 = Normal 1 = Avanzada*/	
	
	public static function getCampos($soloPrincipal = NULL){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		$aliasTabla = self::getAlias();
		//Los campos son los mismos que en la ficha del producto
		if (self::$nombreTabla != ''){
			$campos = Articulo::getCampos();
			self::$camposSelect = $campos;
		}
		
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		$idioma = WSLocale::$idioma;
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		$nombre_tabla = static::$nombreTabla; //El nombre de la tabla se coge del nombre del padre
		//Cogemos las tablas de artículo más la de 'search_index'
		$consulta = $nombre_tabla . ' as `' .  static::getAlias() . '`, ' . Articulo::getNombreTabla();
		static::$nombreTabla = $consulta;
		return($consulta);
	}
	
	public static function getWhereTabla(){
		//La where aún no está definido como se compone
		$argumentos = func_get_args();
		//Siempre hay que filtrar "no web"
		static::$whereSelect = ' `' .  Articulo::getAlias() . '`.`no_web` = 0 ';
		//El primer argumento es la búsqueda simple o bien un array con los pares de parámetro =>  valor
		$txt_busqueda = isset($argumentos[0]) ? $argumentos[0] : '';
		if (!is_array($txt_busqueda)){
			if ($txt_busqueda != ''){
				//Necesitamos descomponer el texto de búsqueda:
				static::$whereSelect .= static::prepararCadenaBusqueda($txt_busqueda);
			}
		}else{
			//Vamos a descomponer el array para hacer la búsqueda
			foreach($txt_busqueda as $campoBusqueda => $valorBusqueda){
				$camposArticulo = array('autor', 'titulo', 'editorial', 'coleccion', 'isbn', 'ean');
				if (in_array($campoBusqueda, $camposArticulo)){
					//Ojo, si nos pasan la palabra "título", la cambiamos por "nombre":
					$campoBusqueda = ($campoBusqueda == 'titulo') ? 'nombre' : $campoBusqueda;
					//En este caso son campos de la ficha del artículo, el alias a coger es de la propia ficha
					static::$whereSelect .= static::prepararCadenaBusqueda($valorBusqueda, $campoBusqueda, 'Articulo');
				}else if(strtoupper($campoBusqueda) == 'CATEGORIA'){
					
				}
			}
		}
		/*
		
		if (Shop::$configuracion->ocultar_stock_0) {
			self::$whereSelect .= (self::$whereSelect != '') ? ' AND ' : '';
			self::$whereSelect .= ' `' .  self::getAlias() . '`.`stock` > 0';
		}
		if ($limitar){
			self::$whereSelect .= ' LIMIT 0,1 ';
		}
		*/
		//Ojo que siempre tenemos que fusionar ambas tablas:
		static::$whereSelect .= ' AND `' . self::getAlias() . '`.`articulo` = `' . Articulo::getAlias() . '`.`codigo` ';
		return(static::$whereSelect);
	}
	
	private static function prepararCadenaBusqueda($txt_busqueda, $campo = 'valor', $tabla = NULL){
		$resultado = '';
		$aliasTabla = self::getAlias();
		if ($tabla != NULL){
			$aliasTabla = $tabla::getAlias();
		}
		$txt_busqueda = explode(' ', $txt_busqueda);
		if (count($txt_busqueda) > 0){
			$words = array(array(), array());
			foreach($txt_busqueda as $clave => $palabra){
				//Si la palabra es de menos de tres letras, entonces va al array de shorts:
				if (strlen($palabra) < 3){
					$words[0][] = ' (`' . $aliasTabla . '`.`' . $campo . '` like \'' . $palabra . '%\' OR ' . $campo . ' like \'% ' . $palabra . '%\'' . ' OR ' . $campo . ' like \'%.' . $palabra . '%\'' . ' OR ' . $campo . ' like \'%,' . $palabra . '%\' ) ';
				}else{
					$words[1][] = ' (`' . $aliasTabla . '`.`' . $campo . '` like \'%' . $palabra . '%\') ';
				}
			}
			//Ahora recorremos el array largo y después el corto:
			foreach($words as $keyWords => $wordType){
				foreach($wordType as $kewWord => $wherePart){
					$resultado .= ' AND '  . $wherePart;
				}
			}
		}
		return($resultado);
	}
	
	function __construct($opciones){
		//A partir de ahora la búsqueda recibe un "OpcionesWidget"
		$this->busqueda_simple = '';
		$filtrado_actual = '';
		$this->autor = '';
		$this->editorial = '';
		$this->titulo = '';
		$this->isbn = '';
		$this->categoria = '';
		$this->ean = '';
		$this->nombreColeccion = '';
		if (is_a($opciones, 'OpcionesWidget')){
			$this->busqueda_simple = ($opciones->configuracion->busqueda_simple != NULL) ? $opciones->configuracion->busqueda_simple : $this->busqueda_simple;
			$this->autor = ($opciones->configuracion->autor != NULL) ? $opciones->configuracion->autor : $this->autor;
			$this->editorial = ($opciones->configuracion->editorial != NULL) ? $opciones->configuracion->editorial : $this->editorial;
			$this->titulo = ($opciones->configuracion->titulo != NULL) ? $opciones->configuracion->titulo : $this->titulo;
			$this->isbn = ($opciones->configuracion->isbn != NULL) ? $opciones->configuracion->isbn : $this->isbn;
			$this->categoria = ($opciones->configuracion->categoria != NULL) ? $opciones->configuracion->categoria : $this->categoria;
			$this->ean = ($opciones->configuracion->ean != NULL) ? $opciones->configuracion->ean : $this->ean;
			$filtrado_actual = ($opciones->configuracion->filtrado_actual != NULL) ? $opciones->configuracion->filtrado_actual : $filtrado_actual;			
		}
			
		$this->adaptarFiltrado($filtrado_actual, true); //==> Encargado de generar los filtrados de sesión o temporales del usuario
		$this->filtradoGlobal();						//==> Encargado de generar los filtrados globales de la web
		//}
		//Ahora, según los valores recibidos, vamos a hacer una cosa u otra
		if ($this->busqueda_simple != ''){
			self::getWhereTabla($this->busqueda_simple);
			//Vamos a componer los datos seo
			$this->title_seo = traducir('Resultado de la búsqueda de') . ' ' . $this->busqueda_simple . ' ' . traducir('en') . ' ' . Shop::$empresa->nombre;
			$this->descripcion_seo = traducir('Estos son los productos encontrados en nuestra web con los términos de búsqueda ') . ' ' . $this->busqueda_simple;
			$this->keywords_seo = traducir('Resultado de la búsqueda de') . ' ' . $this->busqueda_simple . ' ' . traducir('en') . ' ' . Shop::$empresa->nombre;
			//Creamos la url de esta búsqueda
			$this->url = Shop::$configuracion->url . 'buscar/' . str_replace(' ', '-', $this->busqueda_simple);
		}else{
			$arrayBusqueda = array();
			//Vamos a crear la condición según el resto de parámetros
			if ($this->autor != ''){
				$arrayBusqueda['autor'] = $this->autor;
			}
			if ($this->editorial != ''){
				$arrayBusqueda['editorial'] = $this->editorial;
			}
			if ($this->titulo != ''){
				$arrayBusqueda['titulo'] = $this->titulo;
			}
			if ($this->isbn != ''){
				$arrayBusqueda['isbn'] = $this->isbn;
			}
			if ($this->ean != ""){
				$arrayBusqueda['ean'] = $this->ean;
			}
			if ($this->nombreColeccion != ""){
				$arrayBusqueda['coleccion'] = $this->coleccion;
			}
			self::getWhereTabla($arrayBusqueda);
		}
		//---------------------------------------------------------------------------------------------
		//Inicializamos la consulta que dará pie a una lista de productos asociada:
		//---------------------------------------------------------------------------------------------
		$this->nombreTablas = self::getNombreTabla();
		$this->camposTabla = self::getCampos(NULL);
		$this->whereTabla = self::$whereSelect;
		//Creamos el orden:
		$this->crea_orden('ORDER BY `' . self::getAlias() . '`.`articulo` DESC ');
		//Y la paginación
		$this->crea_paginacion();
	}

	public static function indexProducts($id = 0){
		//Por ahora voy a crear el índice completo de forma poco eficiente, ya optimizaré este proceso
		$camposFijos = array( array('articulo.nombre', 0), array('articulo.editorial', 1), array('articulo.ean', 2));
		$camposFijosIdioma = array();
		$camposVariables = array();
		$camposVariablesIdioma = array();
		//Según el tratamiento de los campos se hace una cosa u otra:
			//--Campos fijos, aquellos que no superan los 255
			//--Campos Variables, Aquellos que hay que partir
			//--Idioma => Campos que tienen traducción
		if (count($camposFijos) > 0){
			//Por ahora vamos a rellenar sólo este caso:
			//Necesito coger los idiomas activos:
			$idiomasActivos = WSLocale::$idiomasActivos;
			$sentenciaInsert = '';
			//Esto habrá que cambiarlo en el futuro para añadir campos de otras tablas
			foreach($idiomasActivos as $claveIdioma => $idioma){
				$lista_campos = array();
				$lista_tablas = array('articulo' => true);
				foreach($camposFijos as $claveCampo => $campo){
					//Vamos a analizar si nos han pasado campos con su tabla o sólo los campos:
					if (strpos($campo[0], '.') !== false){
						$partido = explode('.', $campo[0]);
						$lista_tablas[$partido[0]] = true;
						$lista_campos[] = '`' . $partido[0] . '`.`' . $partido[1] . '`';
					}else{
						$lista_campos[] = '`articulo`.`' . $campo[0] . '`';
					}
				}
				//Tenemos la lista de campos, vamos a hacer una select que nos dé esos campos para el o los artículos seleccionados:
				$lista_campos = implode($lista_campos, ', \' \', ');
				$sentencia = 'SELECT `codigo`, CONCAT(' . $lista_campos . ') suma ';
				$sentencia .= ' FROM `articulo` ';
				foreach($lista_tablas as $nombreTabla => $dummy){
					if ($nombreTabla != 'articulo'){
						$sentencia .= ' LEFT JOIN `' . $nombreTabla . '` '
						. ' ON `' . $nombreTabla . '`.`articulo`= `articulo`.`codigo` ';
					}
				}

				if ($id > 0){
					$sentencia .= ' AND `articulo`.`codigo` = ' . $id . ';';
				}

				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$sentenciaBorrado = '';
					$listaInsert = '';
					//echo("$sentencia\n");
					$bd->setConsultaSQL($sentencia);
					$lista_articulos = array();
					while($fila = $bd->getFila()){
						$codigoArticulo = $fila['codigo'];
						$cadena = addslashes(trim($fila['suma']));
						//Vamos a modificar la sentencia de borrado:
						//$sentenciaBorrado .= 'DELETE FROM `search_index` WHERE `articulo` = \'' . $codigoArticulo . '\';';
						$lista_articulos[] = $codigoArticulo;
						$listaInsert .= (($listaInsert != '') ? ', ' : '') . "\n" . ' ( \''. $codigoArticulo . '\', \'' . $cadena . '\', \'' . $idioma . '\' ) ';
					}
					//si hay sentencia de borrado, vamos a ello:
					if (count($lista_articulos) > 0){
						//echo("$sentenciaBorrado\n");
						$sentenciaBorrado = 'DELETE FROM `search_index` WHERE `articulo` IN ( ' . implode($lista_articulos, ', ') . ' );';
						$bd->setConsultaSQL($sentenciaBorrado);
					}
					if ($listaInsert != ''){
						$sentenciaInsert = 'INSERT INTO `search_index` ( `articulo`, `valor`, `idioma`) '
							. ' VALUES ' . $listaInsert . "; \n";
					}
				}
				//Ejecuto esta sentencia para coger los datos de los productos a insertar:
				
			}
			//"Si ejecuto "sentenciaProducto tengo una macro sentencia que me llenará la tabla:
			if ($sentenciaInsert != ''){
				//En este caso tengo que eliminar de la tabla toda referencia del producto o productos:
				$bd = new BaseDatos();
				if ($bd->isConectado()) {
					//ejecutamos la insert:
					//echo("$sentenciaInsert\n");
					$bd->setConsultaSQL($sentenciaInsert);
					//echo($sentenciaInsert);
				}
			}
			
		}
		if (count($camposFijosIdioma) > 0){
			
		}
		if (count($camposVariables) > 0){
			
		}
		if (count($camposVariablesIdioma) > 0){
			
		}
		
	}
	
	function __destruct(){
		
	}
}
?>