<?php
/*
	Este controlador se encarga de las operaciones relacionadas con envío de emails. Su funcionamiento es el siguiente:
	Cuando se instancie enviándole parámetros de email, se dará de alta una tupla en la tabla homónima y se quedará relacionada la instancia con la tupla creada.
	Cuando se instancie enviándole un código de email se cargará dicho email
	Cuando se ejecute la función de enviar email, se guardará en la tupla asociada de la BD el resultado del envío así como la fecha y la hora del último intento
	Para su correcto funcionamiento, esta clase utilizará la clase "PHPmailer" que no es nativa de WebStore y por tanto se almacena en la carpeta de librerías. Es 
	por ello que la clase necesita una variable dónde almacenar un objeto PHPmailer instanciado. Mediante métodos mágicos hará el get/set correspondiente para modificar los valores de dicho objeto creado
	Además incluye unas funciones estáticas que permiten enviar un email pasando sólo el destinatario, de manera que se obtenga el resto de datos de la configuración de webStore. Este método estático instanciará
	esta misma clase para enviar el email.
	Añadiremos otra función estática que intentará enviar todos los emails que haya fallidos en la web.
	@version 1.0
*/

//La clase email necesita a su vez la clase Php mailer. Pero esta clase es externa a webStore, no la ha programado arminet, y por tanto la ubicamos en la carpeta "librerías"
require_once(_WS_LIB_DIR_ . _WS_EMAIL_LIB . '/' . _WS_EMAIL_LIB . '.php');	// ==> Podría haberme creado un controlador con el nombre de la librería que haga esto, pero es intentar quitarle las esquinas a un círculo
	//Si la librería sólo la uso aquí, mejor definirla aquí
	
class SuperEmail extends Objeto{
	//Variables:
	private $libreriaEmail = NULL;
	private $nombreLibreriaEmail = _WS_EMAIL_LIB . '\\' . _WS_EMAIL_LIB . '\\' . _WS_EMAIL_LIB;
	private $libSendFunction = 'Send';
	private $libSendFunctionParams = NULL;
	private $destinatario = '';
	private $bcc = '';
	private $asunto = '';
	private $contenido = '';
	private static $lastError = '';
	private $templateFile = 'email.php';	//Esta variable define el fichero a utilizar para el cuerpo del email. Si no se especifica, se añade el texto plano
	//Datos de la tabla
	private $ID = 0;
	private $fecha = 0;
	private $texto_error = '';
	private $ultimo_intento = '';
	private $enviado = 0;
	//Variable privada que contiene el último email, para que cualquier clase pueda consultarlo
	private static $lastEmail = NULL;
	
	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= self::$nombreTabla . ' as `' .  self::getAlias() . '` ';
		}
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			self::$nombreTabla = $consulta;
		}
		return($consulta);
	}

	//Funciones de carga en la BD, van aquí arriba
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$id = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$estado = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		
		//include('comunes/globals.php');
		self::$whereSelect = '';
		if ($id !== NULL) {
			self::$whereSelect = ' `' . self::getAlias() . '`.`codigo` = "' . $id . '" ';
		}
		if ($estado !== NULL) {
			self::$whereSelect = ' `' . self::getAlias() . '`.`enviado` = "' . (($estado) ? 1 : 0) . '" ';
		}
		if ($limitar){
			self::$whereSelect .= ' LIMIT 0,1 ';
		}
		return(self::$whereSelect);
	}
	
	//Aquí colocaremos las variables esenciales por ahora (destinatario, remitente, servidor, usuario, password, cc, cco, etc... :
	
	//Constructor: Crea un nuevo objeto email recibiendo los parámetros de conexión (servidor smtp, usuario, pass, , asunto etc.
		//El constructor además grabará el email en la tabla o lo cargará de la misma
		//Si el constructor recibe como parámetro un código de email lo cargará de la tabla

	function __construct($params){
		//Si recibimos un número entero, cargamos el email por ese código, si no, tenemos que ver el OpcionesWidget
		if (is_int($params)){
			$this->ID = $params;
		}
		//Nos aseguramos de que siempre se lee el fichero de OpcionesWidget. Si no nos lo han pasado, lo creamos
		$params = (is_a($params, 'OpcionesWidget')) ? $params : new OpcionesWidget();
		$this->ID = ($params->configuracion->ID != null) ? $params->configuracion->ID : $this->ID;	//Si no hay ID aquí, ya lo habremos recibido
		$filaEmail = ($params->configuracion->filaEmail != null) ? $params->configuracion->filaEmail : NULL;	//Es el resultado de una consulta MYSQL que contiene una fila de email. Es útil cuando la select ya se ha hecho
		//Parámetros básicos
		$this->destinatario = ($params->configuracion->destinatario != null) ? $params->configuracion->destinatario : '';
		$this->asunto = ($params->configuracion->asunto != null) ? $params->configuracion->asunto : '';
		$this->contenido = ($params->configuracion->contenido != null) ? $params->configuracion->contenido : '';
		$this->bcc = ($params->configuracion->bcc != null) ? $params->configuracion->bcc : '';
		$this->templateFile = ($params->configuracion->templateFile != null) ? $params->configuracion->templateFile : $this->templateFile;

		//En caso de que sea necesario cargar el email de la BD, vamos a hacerlo aquí:
		//Si hemos recibido una fila, esta se cargará aunque hayamos recibido otro ID, la velocidad lo primero:
		$fila = NULL;
		
		if ($filaEmail == NULL){
			if ($this->ID > 0) {
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
									FROM ' . self::getNombreTabla() . '
									WHERE ' . self::getWhereTabla($this->ID);
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}else{
			$fila = $filaEmail;
		}
		if($fila != null){
			$this->extractData($fila);
		}
		
		
		//Ahora instanciamos la clase libreriaEmail:
		$this->libreriaEmail = new $this->nombreLibreriaEmail();
		//$this->configLib();
		//Al final del constructor, asignamos a lastEmail el valor del email para que se pueda consultar
		self::$lastEmail = $this;
    }
	
	private function extractData($fila){
		//Fila es un array asociativo. De él obtenemos los valores a asignar a los campos. OJO, el índice contiene el alias de la tabla. Tenemos una función que nos facilita la tarea de extacción:
		//$this->getProp($fila, 'nombre_original_del_campo');
			//En el caso del email, puede que nos hayan pasado asunto, destinatario o texto a enviar. En este caso tendremos en cuentaq que no estén vacíos:
			$this->ID = $this->getProp($fila, 'codigo');
			$this->destinatario = ($this->destinatario != '') ? $this->destinatario : $this->getProp($fila, 'destinatarios'); // => Es el pluran porque es una cadena tal que así: web@arminet.es,web arminet;pedro@arminet.es Pedro Carranza
			//Modificado por Pedro el 06/Febrero/2019 ==> En la tabla guardamos el contenido de manera serializada porque puede ser un objeto
			$this->asunto = ($this->asunto != '') ? $this->asunto : unserialize($this->getProp($fila, 'asunto'));
			$this->contenido = ($this->contenido != '') ? $this->contenido : $this->getProp($fila, 'texto');
			$this->bcc = ($this->bcc != '') ? $this->bcc : $this->getProp($fila, 'bcc'); 
			//Ahora cargamos el resto de campos..........................
			/*Datos de la tabla*/
			$this->fecha = $this->getProp($fila, 'fecha'); 
			$this->ultimo_intento = $this->getProp($fila, 'ultimo_intento'); 
			$this->texto_error = $this->getProp($fila, 'texto_error');
			$this->enviado = $this->getProp($fila, 'enviado');
			
	}
	
		//enviar email: Esta función envía el email actual y devuelve true o false según si se ha podido enviar o no
		//Actualiza, en la tabla de emails el resultado del envío así como la fecha y la hora
	public function send(){
		//Aquí vamos a intentar enviar el email:
		//todo sendmail
		//Volvemos a configurar la librería por si las moscas
		$this->configLib();
		//Enviamos el email
		$retorno = $this->libreriaEmail->{$this->libSendFunction}($this->libSendFunctionParams); // Hecho así ya por Pedro para utilizar la función personalizada
		$error = "";
		$enviado = 1;
		if (!$retorno){
			//Necesitamos obtener el error
			$enviado = 0;
			$error = self::$lastError = $this->ErrorInfo;
		}
		//Sea cual sea el resultado, es el momento de guardarlo en la BD.
			//SI el ID ES 0, es un email nuevo (INSERT INTO ....)
			//SI el ID NO es 0, entonces hay que hacer un UPDATE
		//todo insert or update (consultar esta función con Pedro)
		//KOSOVITO
		//Vamos a parsear el contenido del email:
		//Modificado por Pedro el 06/Febrero/2019 ==> En la tabla guardamos el contenido de manera serializada porque puede ser un objeto
		$sentencia_sql = 'INSERT INTO `' . self::getNombreTablaSinAlias() . '`
				(`codigo`,`destinatarios`,`asunto`,`texto`,`texto_error`,`bcc`,`enviado`) 
				VALUES (\'' . $this->ID . '\',\'' . $this->destinatario . '\',\'' . $this->asunto . '\',\'' . serialize($this->contenido) . '\',\'' . $error . '\',\'' . $this->bcc . '\',\'' . $enviado . '\') 
				ON DUPLICATE KEY UPDATE ' . '
				`codigo` = VALUES(`codigo`),
				`destinatarios` = VALUES(`destinatarios`),
				`asunto` = VALUES(`asunto`),
				`texto` = VALUES(`texto`),
				`texto_error` = VALUES(`texto_error`),
				`bcc` = VALUES(`bcc`),
				`enviado` = VALUES(`enviado`)';

		$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
			}
		return($retorno);
	}
	//Función set ==> Aquí utilizaremos los métodos mágicos de PHP para establecer los valores del objeto PHPmailer instanciado
	public function __set($variable, $valor){
		//Esta función es invocada cuando intentemos asignar el valor de una propiedad del objeto Email que no esté definida arriba.
		//Lo que vamos a hacer es que según la propiedad, asignaremos este valor al objeto "libreriaEmail"
		$retorno = false;
		if ($this->libreriaEmail != NULL){
			if (property_exists($this->libreriaEmail, $variable)){
				$this->libreriaEmail->$variable = $valor;
				$retorno = true;
			}
		}
		return($retorno);
	}
	//Función get ==> Aquí utilizaremos los métodos mágicos de PHP para obtener los valores del objeto PHPmailer instanciado
	public function __get($variable){
		//Esta función es invocada cuando intentemos asignar el valor de una propiedad del objeto Email que no esté definida arriba.
		//Lo que vamos a hacer es que según la propiedad, asignaremos este valor al objeto "libreriaEmail"
		$retorno = NULL;
		if ($this->libreriaEmail != NULL){
			if (property_exists($this->libreriaEmail, $variable)){
				$retorno = $this->libreriaEmail->$variable;
			}
		}
		return($retorno);
	}
	//función estática de envío de emails: Función que sólo recibe los datos básicos de un email (destinatario, asunto y texto) y lo envía utilizando los datos de configuración
	public static function sendMail($opciones){
		$opciones = (is_a($opciones, 'OpcionesWidget')) ? $opciones : new OpcionesWidget();
		$email = new Email($opciones);
		$retorno = $email->send();
		
		return($retorno);
	}
	
	//función estática de envío de emails pendientes: Carga la tabla de emails entera y con cada línea crea un objeto de esta misma clase e intenta enviarlo.
	public static function sendFailedEmails(){
		//Nos componemos la select de los emails:
		$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
									FROM ' . self::getNombreTabla() . '
									WHERE ' .self::getWhereTabla(NULL, 0, false);
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while($fila = $bd->getFila()){
				$opciones = new OpcionesWidget(array('filaEmail' => $fila));
				$email = new Email($opciones);
				$email->send();
			}
		}
	}
	
	public static function remoteSend($params){
		//Vamos a capturar la salida:
		$retorno = new stdClass();
		//Vamos a extraer de "data" los datos a los que vamos a enviar:
		$data = $params;
		if (is_string($data)){
			$data = json_decode($params);
			if ($data == NULL){
				$data = $params;
			}
		}
		
		//Preparo los datos de envío inicializándolos a los valores por defecto que son los de contactar con la empresa:
		$destinatario = Shop::$empresa->direccion_email . ',' . Shop::$empresa->nombre_legal;
		$asunto = 'Contacto enviado a través de la web ' . Shop::$configuracion->url;
		$texto = (is_string($data)) ? $texto : '';
		//Si en data no hay una cadena de texto, puede que nos hayan pasado los valores de envío:
		if (is_a($data, 'stdClass')){
			$destinatario = (isset($data->destinatario)) ? $data->destinatario : $destinatario;
			$asunto = (isset($data->asunto)) ? $data->asunto : $asunto;
			$texto = (isset($data->texto)) ? $data->texto : $texto;
		}
		
		//Vamos a crear el objeto opciones
		$opciones = new OpcionesWidget(array(
			'destinatario' => $destinatario,
			'asunto' => $asunto,
			'contenido' => $texto
		));
		//Enviamos el email
		$retorno->resultado = self::sendMail($opciones);
		if (!$retorno->resultado){
			//Hacemos un echo con el error para que se guarde en el mensaje
			echo(self::getLastError());
		}
		//Capturamos la salida y la metemos en el msgs
		$retorno = json_encode($retorno);

		return($retorno);
	}
	
	//Con esta función configuraremos la librería de email. Si utilizamos otra diferente a PHPMailer, deberemos sobre escribir esta función
	public function configLib(){
		//Vamos a ponerla en español:
		$this->libreriaEmail->SetLanguage('es', _WS_LIB_DIR_ . _WS_EMAIL_LIB . '/');
		//Indicamos el método a usar
		$this->libreriaEmail->IsSMTP();
		//Ahora asignamos el resto de datos que ya tengamos disponibles:
		//todo asignamos los valores que necesitamos
		$this->Mailer = 'smtp';
		$this->Helo = Shop::$empresa->smtp_email; //Muy importante para que llegue a hotmail y otros
		$this->Port = 587;
		//$this->SMTPSecure = 'ssl';
		$this->SMTPAuth = true;
		$this->Host = Shop::$empresa->smtp_email;
		$this->Username = Shop::$empresa->usuario_email;
		$this->Password = Shop::$empresa->password_email;
		//$this->Password = 'falsa';
		$this->FromName = Shop::$empresa->nombre;
		$this->From = Shop::$empresa->direccion_email;
		$this->Sender = Shop::$empresa->direccion_email;
		$this->ReturnPath = Shop::$empresa->direccion_email;
		//Vamos a obligar al envío con UTF8
		$this->CharSet = 'UTF-8';
		//Vamos a definir los destinatarios y los BCC
		$destinatarios = explode(';', $this->destinatario);
		for ($i = 0; $i < count($destinatarios); $i++) {
			$direccion = explode(',', $destinatarios[$i]);
			if (!isset($direccion[1])) {
				$direccion[1] = '';
			}
			$this->libreriaEmail->AddAddress($direccion[0], $direccion[1]);
		}
		//Vamos ahora con la copia oculta
		//Si es un array no hay que convertir
		$destinatarios = explode(';', $this->bcc);
		for ($i = 0; $i < count($destinatarios); $i++) {
			$direccion = explode(',', $destinatarios[$i]);
			if (!isset($direccion[1])) {
				$direccion[1] = '';
			}
			$this->libreriaEmail->AddAddress($direccion[0], $direccion[1]);
		}

		//Aún faltan por definir algunos parámetros:
		$this->libreriaEmail->IsHTML( ($this->templateFile != '') ? true : false);
		//Añadimos las imágenes que se vayan a utilizar en el mail
		$this->Subject = $this->asunto;
		$this->Body = $this->formatEmail();
		if ($this->templateFile != ''){
			$this->libreriaEmail->MsgHTML($this->Body);
		}
		$this->WordWrap = 50;		
	}
	
	public static function getLastError(){
		return(self::$lastError);
	}
	
	public static function getLastEmail(){
		return(self::$lastEmail);
	}
	
	private function formatEmail(){
		$retorno = $this->contenido;
		//SI tenemos fichero de plantilla de email definido, vamos a ejecutarlo para mostrarlo:
		if ($this->templateFile != ''){
			ob_start();
			Theme::include_file($this->templateFile, $this);
			$retorno = ob_get_clean();
		}
		return($retorno);
	}
	//Unos cuantos getter y setter más:
	public function getAsunto(){
		return($this->asunto);
	}
	public function setAsunto($asunto){
		$this->asunto = $asunto;
	}
	public function getContenido(){
		return($this->contenido);
	}
	public function setContenido($contenido){
		$this->contenido = $contenido;
	}
}
