<?php
/*
  Clase SuperLineaPedidoCliente
 */
 
 //Pedro 22/Febrero/2019 => Quito el precio cesta de esta clase. No tiene sentido:

class SuperLineaCesta extends Objeto{
	public $codigo = 0;
	public $cabecera = 0;
	public $objeto_cabecera = NULL;
	public $ean = '';
	public $codigo_lote = 0;
	public $lote = NULL;
	public $cantidad = 0;
    public $articulo = 0;
	public $objeto_articulo = NULL;
    public $importe = 0;
	public $puntos = 0;
	public $puntos_gastados = 0;
	public $base = 0;
	public $base_unitaria = 0;
    public $pvp_unitario = 0;
    public $descuento = 0;
    public $importe_sin_descuento = 0;
    //public $precio_cesta = 0;
	public $codigo_oferta = 0;
	public $oferta = NULL;
	
	
	public static function getCampos($soloPrincipal = NULL){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//self::$campos_tabla = BaseDatos::$dictionary->{self::$nombreTabla . 'Campos'}; //==> Comento esta línea porque creo que no sirve pa na
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (self::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{self::$nombreTabla . 'Campos'}, self::getAlias());
				$campos .= BaseDatos::dameCamposAlias(self::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' ) . 
				Articulo::getCampos() . ', ' .
				BaseDatos::dameCamposAlias(OfertasRegalo::getNombreTabla());
				//BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{OfertasRegalo::getNombreTabla() . 'Campos'}, OfertasRegalo::getAlias());
			}
			if ($soloPrincipal == NULL){
				self::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= self::$nombreTabla . ' as `' .  self::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= self::getJoin('LineaCesta', 'articulo', 'Articulo', 'codigo'); //Queremos esta tabla con la de artículo
			$consulta .= self::getJoin('LineaCesta', array('codigo_oferta', 'articulo'), 'OfertasRegalo', array('codigo', 'articulo')); //Queremos esta tabla con la de artículo
			$consulta .= Articulo::getNombreTabla(false);								//Cogemos los left join de artículo
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			self::$nombreTabla = $consulta;
		}
		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigoPedido = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$codigoLinea = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		
		//include('comunes/globals.php');
		self::$whereSelect = '';
		if ($codigoPedido !== NULL) {
			self::$whereSelect = ' `' . self::getAlias() . '`.`cabecera` = "' . $codigoPedido . '" ';
		}
		if ($codigoLinea !== NULL) {
			self::$whereSelect = ' `' . self::getAlias() . '`.`codigo` = "' . $codigoLinea . '" ';
		}
		if ($limitar){
			self::$whereSelect .= ' LIMIT 0,1 ';
		}
		return(self::$whereSelect);
	}
	
    function __construct($opciones = NULL) {
		$filaLineaPedido = NULL;
		$codigoPedido = 0;
		$codigoLinea = 0;
		$objetoPedido = NULL;
		$objetoArticulo = NULL;
        if ($opciones != NULL){
			if (is_a($opciones, 'OpcionesWidget')){
				$filaLineaPedido = ($opciones->configuracion->filaLineaPedido != NULL) ? $opciones->configuracion->filaLineaPedido : $filaLineaPedido;
				$codigoPedido = ($opciones->configuracion->codigoPedido != NULL) ? $opciones->configuracion->codigoPedido : $codigoPedido;
				$objetoPedido = ($opciones->configuracion->objetoPedido != NULL) ? $opciones->configuracion->objetoPedido : $objetoPedido;
				$objetoArticulo = ($opciones->configuracion->objetoArticulo != NULL) ? $opciones->configuracion->objetoArticulo : $objetoArticulo;
				$codigoLinea = ($opciones->configuracion->codigoLinea != NULL) ? $opciones->configuracion->codigoLinea : $codigoLinea;
			}
		}
		
		//Si hemos recibido un objeto pedido pero no un codigo de pedido, tenemos que asignarlo:
		if ($codigoPedido == NULL && is_a($objetoPedido, "CabeceraCesta")){
			$codigoPedido = $objetoPedido->codigo;
		}
		
		$fila = NULL;
		if ($filaLineaPedido != NULL){
			$fila = $filaLineaPedido;
		}else{
			if (is_a($objetoPedido, 'CabeceraCesta')){
				$codigoPedido = $objetoPedido->codigo;
			}
			if (intval($codigoPedido) > 0) {
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
									FROM ' . self::getNombreTabla() . '
									WHERE ' . self::getWhereTabla($codigoPedido, $codigoLinea);
				
				//echo("$sentencia_sql <br />\n");

				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}
		$this->codigo = (int) $this->getProp($fila, 'codigo');
		//Si no tenemos objeto de cabecera lo creamos con la fila, pero sin crear las líneas en el mismo
		$this->objeto_cabecera = (is_a($objetoPedido, 'CabeceraCesta')) ? $objetoPedido : new CabeceraCesta(new OpcionesWidget(array('filaCabecera' => $fila, 'cargarLineas' => false)));
		$this->cabecera = ($this->objeto_cabecera->codigo > 0) ? $this->objeto_cabecera->codigo : (int) $this->getProp($fila, 'cabecera');
		//Puede que la cabecera la tuviese vacía:
		if ( ($this->cabecera > 0) && ($this->objeto_cabecera->codigo == 0) ){
			$this->objeto_cabecera = new CabeceraCesta(new OpcionesWidget(array('codigoPedido' => $this->cabecera, 'cargarLineas' => false)));
		}
 		$this->ean = $this->getProp($fila, 'ean');
		//TODO => con los lotes hay que hacer lo mismo que con el artículo y la cabecera
		$this->codigo_lote = (int) $this->getProp($fila, 'codigo_lote');
		$this->lote = NULL;
		$this->cantidad = (float) $this->getProp($fila, 'cantidad');
		$this->objeto_articulo = (is_a($objetoArticulo, 'Articulo')) ? $objetoArticulo : new Articulo(new OpcionesWidget(array('filaArticulo' => $fila)));
		$this->articulo = ($this->objeto_articulo->codigo > 0) ? $this->objeto_articulo->codigo : (int) $this->getProp($fila, 'articulo');
		//Si llegados a este punto no tengo artículo pero sí código hay que generarlo:
		if ( ($this->articulo > 0) && ($this->objeto_articulo->codigo == 0) ){
			$this->objeto_articulo = new Articulo($this->articulo);
		}
		//Si no hemos cargado ean, lo vamos a coger del producto:
		if ( ( ($this->ean == '') || ($this->ean == NULL)) && ($this->objeto_articulo != NULL)){
			$this->ean = $this->objeto_articulo->ean;
		}
		$this->importe = (float) $this->getProp($fila, 'importe');
		$this->puntos = (float) $this->getProp($fila, 'puntos');
		$this->puntos_gastados = (float) $this->getProp($fila, 'puntos_gastados');
		$this->base = (float) $this->getProp($fila, 'base');
		$this->base_unitaria = (float) $this->getProp($fila, 'base_unitaria');
		$this->pvp_unitario = (float) $this->getProp($fila, 'pvp_unitario');
		$this->descuento = (float) $this->getProp($fila, 'descuento');
		$this->importe_sin_descuento = (float) $this->getProp($fila, 'importe_sin_dto');
		//$this->precio_cesta = (float) $this->getProp($fila, 'precio_cesta');
		$this->codigo_oferta = (int) $this->getProp($fila, 'codigo_oferta');
		$this->oferta = new OfertasRegalo(new OpcionesWidget(array('filaOferta' => $fila)));
		//Si llegados a este punto no tengo artículo pero sí código hay que generarlo:
		if ( ($this->codigo_oferta > 0) && ($this->oferta->codigo == 0) ){
			$this->oferta = new OfertasRegalo(new OpcionesWidget(array(
				'articulo' => $this->articulo,
				'codigo' => $this->codigo_oferta
			)));
		}else if ($this->codigo_oferta == 0){
			$this->oferta = NULL;
		}
    }

    function __destruct() {
        
    }

	public function grabar(){
		//Esta función grabará la línea teniendo en cuenta si es un alta/modificación/borrado:
		//Si no hay código, es un insert:
		//echo("Grabamos la linea que tiene, de origen, el codigo: " . $this->codigo . "\n");
		if ($this->codigo == 0){
			//Alta
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$sentencia_sql = ' INSERT INTO `tmp_linea_pedidos` 
					(`cabecera`, `ean`, `codigo_lote`, `cantidad`, `articulo`, `importe`, 
					`puntos`, `puntos_gastados`, `base`, `base_unitaria`, `pvp_unitario`, 
					`descuento`, `importe_sin_dto`, `codigo_oferta`) 
					VALUES 
					("' . $this->cabecera . '", "' . $this->ean . '", "' . $this->codigo_lote . '", "' . $this->cantidad . '", "' . $this->articulo . '", "' . 
					$this->importe . '", "' . $this->puntos . '", "' . $this->puntos_gastados . '", "' . $this->base . '", "' . $this->base_unitaria . '", "' . 
					$this->pvp_unitario . '", "' . $this->descuento . '", "' . $this->importe_sin_descuento . '", "' . $this->codigo_oferta . '");';
				//echo("$sentencia_sql---");
				$bd->setConsultaSQL($sentencia_sql);
				$this->codigo = $bd->getAutonumerico();
				//echo("Se ha insertado una línea con código: " . $this->codigo . "\n");
			}
		}else if ( ($this->codigo > 0) && ($this->cantidad > 0) ){
			//Modificación
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$sentencia_sql = ' UPDATE `tmp_linea_pedidos` SET 
					`cabecera` = "' . $this->cabecera . '", `ean` = "' . $this->ean . '" , `codigo_lote` = "' . $this->codigo_lote . '", 
					`cantidad` = "' . $this->cantidad . '", `articulo` = "' . $this->articulo . '", `importe` = "' . $this->importe . '", 
					`puntos` = "' . $this->puntos . '", `puntos_gastados` = "' . $this->puntos_gastados . '",
					`base` = "' . $this->base . '", `base_unitaria` = "' . $this->base_unitaria . '", `pvp_unitario` = "' . $this->pvp_unitario . '", 
					`descuento` = "' . $this->descuento . '", `importe_sin_dto` = "' . $this->importe_sin_descuento . '", `codigo_oferta` = "' . $this->codigo_oferta . '" 
						WHERE (`cabecera`= ' . $this->cabecera . ' AND `codigo` = ' . $this->codigo . ' ) ;';
				//echo("$sentencia_sql---");
				$bd->setConsultaSQL($sentencia_sql);
			}
		}else if ($this->cantidad <= 0){
			//Borrado:
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$sentencia_sql = ' DELETE FROM `tmp_linea_pedidos` 
					WHERE (`cabecera`= ' . $this->cabecera . ' AND `codigo` = ' . $this->codigo . ' ) ;';
				//echo("$sentencia_sql---");
				$bd->setConsultaSQL($sentencia_sql);
			}
		}
		
		
	}
	
	public static function getList($codigoPedido){
		$lista = array();
		$objetoPedido = NULL;
		//Ojo que nos pueden pasar el objeto pedido en vez del código:
		if (is_a($codigoPedido, 'CabeceraCesta')){
			$objetoPedido = $codigoPedido;
			$codigoPedido = $objetoPedido->codigo;
		}
		$sentencia_sql = 'SELECT ' . self::getCampos() . ' 
							FROM ' . self::getNombreTabla() . '
							WHERE ' . self::getWhereTabla($codigoPedido, false);
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			$arrayOpciones = array();
			//Si nos han pasado un objeto pedido, vamos a meterlo:
			if ($objetoPedido != NULL){
				$arrayOpciones['objetoPedido'] = $objetoPedido;
			}
			while($fila = $bd->getFila()){
				$arrayOpciones['filaLineaPedido'] = $fila;
				$lista[$this->getProp($fila, 'codigo')] = new LineaCesta(new OpcionesWidget($arrayOpciones));
			}
		}
		return($lista);
	}
	
	public function setCantidad($opciones){
		//Mediante esta función modifico la cantidad de una línea de pedido.
		$cantidad = 1;
		$oferta = NULL;
		$lote = NULL;
		$puntos_gastados = 0;
		if ($opciones != NULL){
			if (is_a($opciones, 'OpcionesWidget')){
				//var_dump($opciones->configuracion);
				$cantidad = ($opciones->configuracion->cantidad !== NULL) ? $opciones->configuracion->cantidad : $cantidad;
				$oferta = ($opciones->configuracion->oferta !== NULL) ? $opciones->configuracion->oferta : $oferta;
				$lote = ($opciones->configuracion->lote !== NULL) ? $opciones->configuracion->lote : $lote;
				$puntos_gastados = ($opciones->configuracion->puntos_gastados !== NULL) ? $opciones->configuracion->puntos_gastados : $puntos_gastados;
			}
		}
		//Hay que controlar que si oferta y/o lote son numéricos, hay que cargar el objeto al que pertenecen para tener más info. disponible:
		if (is_numeric($oferta)){
			if ($oferta > 0){
				//Por ahora no tengo esta clase definida
				$oferta = new OfertasRegalo(new OpcionesWidget(array(
					'articulo' => $this->articulo,
					'codigo' => $oferta
				)));
			}
		}
		if (is_numeric($lote)){
			if ($lote > 0){
				//Por ahora no tengo esta clase definida
				$lote = new Oferta(new OpcionesWidget(array('codigoOferta' => $lote)));
			}
		}
		//Los totales los calculamos aquí, para no repetir código
		$this->cantidad = $cantidad;									// Cantidad de productos en la línea
		$this->descuento = $this->objeto_articulo->descuento_cliente;	// Descuento que se aplica en esta línea
		$this->base_unitaria = $this->objeto_articulo->base_final;			// Base del precio unitario del producto (con descuento aplicado)
		$this->pvp_unitario = $this->objeto_articulo->pvp_final;		// ==> El pvp final lleva el descuento aplicado
		//$this->precio_cesta = $this->pvp_unitario;
		$this->base = $this->base_unitaria * $this->cantidad;			// Base del total de la línea
		$this->importe_sin_descuento = $this->objeto_articulo->pvp_final_sin_dto * $this->cantidad;	// ==> Este es el precio general del artículo (sin descuento) por la cantidad
		//Por último vamos a tener en cuenta los descuentos:
		$this->importe = $this->pvp_unitario * $this->cantidad;
		
		//Inicializamos el resto de campos que se modificará después según su caso:
		//En cuanto al precio y al descuento, se tienen que quedar a 0:
		$this->codigo_oferta = 0;
		$this->oferta = NULL;
		$this->codigo_lote = 0;
		$this->lote = NULL;
		$this->puntos = 0;
		$this->puntos_gastados = 0;
		
		//Ahora vamos a insertar los datos.
		//No es lo mismo asignar la cantidad cuando el producto viene de un lote, que cuando viene de una oferta que si no:
		if ($oferta != NULL){
			//En este caso, los cálculos los voy a hacer de la oferta:
			//cargamos la cantidad de la misma.
			$this->codigo_oferta = $oferta->codigo; //==> Aquí anotamos el código de la oferta
			$this->oferta = $oferta; //==> Aquí anotamos el objeto oferta
			//Recalculo los apartados dónde la cantidad afecta:
			$this->cantidad = $cantidad * $oferta->cantidad; //==> después irá multiplicada por la de la oferta
			$this->base = $this->base_unitaria * $this->cantidad;
			$this->importe_sin_descuento = $this->objeto_articulo->pvp * $this->cantidad;
			$this->importe = $this->pvp_unitario * $this->cantidad;
		}else if ($lote != NULL){
			//TODO ==> Hay que hacerlo
			$this->codigo_lote = 0; //==> reasignamos el lote
			$this->lote = NULL;	//=> Reasignamos el lote
		}else if ($puntos_gastados){
			//El precio del producto depende de los puntos gastados TODO
			$this->puntos = 0;
			$this->puntos_gastados = $puntos_gastados;
		}else{
			
		}
	}
}

?>