<?php

class SuperTarifasPorLocalidad {

    public $codigo = 0;
    public $tipo_envio = 0;
    public $localidad = '';
    public $provincia = '';
    public $importe_fijo = 0;
    public $importe_x_unidad = 0;
    public $reembolso = 0;
    public $recargo_reembolso = 0;
    public $porc_recargo_reembolso = 0;

    function __construct($codigo = 0) {
        include('comunes/globals.php');
        $sentencia_sql = 'SELECT codigo, tipo_envio, localidad, provincia, importe_fijo, importe_x_unidad, reembolso, recargo_reembolso, porc_recargo_reembolso  '
                . 'FROM tarifasporlo '
                . 'WHERE codigo = '. $codigo;
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->codigo = $fila['codigo'];
                    $this->tipo_envio = $fila['tipo_envio'];
                    $this->localidad = $fila['localidad'];
                    $this->provincia = $fila['provincia'];
                    $this->importe_fijo = $fila['importe_fijo'];
                    $this->importe_x_unidad = $fila['importe_x_unidad'];
                    $this->reembolso = $fila['reembolso'];
                    $this->recargo_reembolso = $fila['recargo_reembolso'];
                    $this->porc_recargo_reembolso = $fila['porc_recargo_reembolso'];
                }
            }
        }
    }

    function __destruct() {
        unset($this->codigo);
        unset($this->tipo_envio);
        unset($this->localidad);
        unset($this->provincia);
        unset($this->importe_fijo);
        unset($this->importe_x_unidad);
        unset($this->reembolso);
        unset($this->recargo_reembolso);
        unset($this->porc_recargo_reembolso);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>
