<?php
//---------------------------------------------------------------------------------------------------------
// 30/marzo/2019 ==> Aquí se ejecutan las acciones asociadas a este módulo
//---------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------
// Códigos de error:
//	 0 ==> Error sin especificar
//	-1 ==> Usuario ya exsistente
//	-2 ==> Los passwords no coinciden
//	-3 ==> El password introducido no cumple con la norma estabelcida (al menos 6 caracteres, letras y números y una mayúscula y una minúscula
//	-4 ==> Falta por rellenar algún dato
//---------------------------------------------------------------------------------------------------------

	//Este fichero va a hacer lo siguiente:
	//Si un cliente se registra, intentamos hacer el registro en la BD. Según el resultado así devolvemos la info al usuario
	//Para ello utilizamos la sesión y ahí almacenamos el resultado de un registro
	//Hay que tener en cuenta que cuando un usuario se registra hacemos una recarga de la web para asegurarnos de que no haya problemas con el F5
	//Empezamos intentando coger los datos del formulario:
	$accion = Getter::get('accion', NULL);


	$estado_registro = NULL;
	//Si alguno de estos parámetros no es NULL, pasamos a la verificación de datos, siempre y cuando la acción actual sea 'registro':
	if ($accion == 'google_register') {
		$user_email = Getter::get('user_email', NULL);
		$id_token = Getter::get('id_token', NULL);
		$name = Getter::get('name', NULL);
		//Vamos a utilizar una variable que indica a donde redirigir en caso de éxito
		$redirigir_a = Getter::get('redirigir_a', NULL);

		if ( ($user_email != NULL) && ($id_token != NULL) ){
			//Vamos a confirmar que Google nos autentifica:
			if (Usuario::googleAuth($id_token)){
				//Lo primero es registrar el cliente por ese email ==> Si ya tenemos un cliente con ese email le asignamos el código de Google
				$cliente = Usuario::checkGoogleRegister($user_email);
				if ($cliente == NULL){
					//Hay que registrar todos los datos del usuario en uno nuevo:
					$datos_cliente = array(
						'nombre_comercial' => $name,
						'nombre_legal' => $name,
						'email' => $user_email,
						'google_user' => 1,
						'pendiente_sinlib' => 1
					);
					$cliente = Usuario::register($datos_cliente);
					$fichero_email = 'email_registro.php';
					//Aquí añadimos la nueva función de login
					$cliente->logme();
					//Enviamos un email al usuario utilizando la plantilla especificada y cogiendo el destinatario y su nombre del cliente de la sesión (se ha hecho login)
					//No es necesario espeficiar más contenido
					$logueado = Usuario::logueado();
					Email::sendMail(new OpcionesWidget(array(
								'destinatario' => $logueado->email . ',' . $logueado->nombre_comercial, 
								'asunto' => 'Gracias por registrarse en la web ' . Shop::$empresa->nombre . '(' . Shop::$configuracion->url . ')', 
								'contenido' => $cliente,
								'templateFile' => $fichero_email)));
					
					
					//Si hay que redirigir a los usuarios, lo hacemos
					if ($redirigir_a != NULL){
						//Redirigimos desde la sesión para que se haga el "commit" actual
						Sesion::reloadPage(Shop::$configuracion->url . $redirigir_a);
					}
				}else{
					//Si ya hay un cliente con esos datos, directamente logueamos y redirigimos:
					$cliente->logme();
					if ($redirigir_a != NULL){
						//Redirigimos desde la sesión para que se haga el "commit" actual
						Sesion::reloadPage(Shop::$configuracion->url . $redirigir_a);
					}
				}
			}
			//Recargamos la página
			Sesion::setReloadPage(Sesion::getReloadPage() | true);
		}else{
			//Si hay error, no hay que hacer nada, ya lo hace la web sola
		}
	}
	
	if ( $accion == 'google_login'){
		$user_email = Getter::get('user_email', NULL);
		$id_token = Getter::get('id_token', NULL);
		$redirigir_a = Getter::get('redirigir_a', '');
		if (Usuario::googleAuth($id_token)){
			if ( ($user_email != '') && ($id_token != '' ) ){
				$resultado_login = Usuario::checkGoogleLogin($user_email);
				//Login correcto?
				//si:
				if (is_a($resultado_login, 'Usuario')){
					if ($redirigir_a != ''){
						Sesion::reloadPage(Shop::$configuracion->url . $redirigir_a);
					}
				}else{
					//Recargamos la página en caso contrario
					Sesion::setReloadPage(Sesion::getReloadPage() | true);
				}
			}
		}
	}