<?php
//---------------------------------------------------------------------------------------------------------
// 01/Febrero/2019 ==> Aquí se ejecutan las acciones asociadas a este módulo
//---------------------------------------------------------------------------------------------------------
$accion = Getter::get('accion', NULL);

//Solicitud de regenerar el password
if ( $accion == 'regeneratePassword'){
	$email = Getter::get('email', '');
	if ($email != ''){
		$cliente = Usuario::regeneratePassword($email);
		if (is_a($cliente, 'Usuario')){
			$hash = '';
			$hash = $cliente->reestablecer_password;
			if ( $hash != NULL ){
				$resultado_recu_pass = 0;
				//Tenemos que enviar un email al cliente
				//El email se envía al destinatario que tenemos en el objeto cliente, poniendo: "email,nombre cliente"
				//En el asunto indicamos que se ha solicitado la recuperación de contraseña en la web Shop::$empresa->nombre y ponemos entre paréntesis la URL de la tienda (Shop::$configuracion->url)
				//A la clase email se le pede indicar el fichero de contenido del mismo, en este caso tenemos que utilizar el fichero: "email_recu_pass.php"
				//En el texto del email vamos a poner el objeto cliente para que el email sea capaz de cogerlo y utilizarlo en la plantilla
				//Álvaro 060219 TAREA 5177 WEBSTORE: Dentro de la carpeta "modules" estamos preparando los módulos que se podrán instalar/desinstalar de webStore.
				Email::sendMail(new OpcionesWidget(array(
									'destinatario' => $email . ',' . $cliente->nombre_comercial, 
									'asunto' => 'Solicitud de recuperación de contraseña en la web ' . Shop::$empresa->nombre . '(' . Shop::$configuracion->url . ')', 
									'contenido' => $cliente,
									'templateFile' => 'email_recu_pass.php')));
			}else{
				//En caso contrario devolvemos un -1
				$resultado_recu_pass = -1;
			}
		}
		//var_dump($resultado_recu_pass);
		Sesion::set('resultado_recu_pass', $resultado_recu_pass);
		//Recargamos la página
		Sesion::setReloadPage(Sesion::getReloadPage() | true);
	}
}
//--------------------
//Nuevo password
// -1 ==> Los password no coinciden
// -2 ==> El password no cumple con la norma de seguridad
// -3 ==> Error al actualizar el password del cliente
//  0/NULL ==> Que se muestre el formulario sin dar ningún tipo de error
// Objeto cliente ==> Todo correcto
//--------------------
if ( $accion == 'updatePassword'){
	$newPassword = Getter::get('new_password', '');
	$againNewPassword = Getter::get('again_new_password', '');
	$hash = Getter::get('hash', '');
	$user = Getter::get('user', '');
	if ( ($newPassword != '') && ($againNewPassword != '') && ($hash != '' ) && ($user != '' ) ){
		$estado_update_password = NULL;
		//Los passwords han de ser exactamente iguales:
		if ($newPassword != $againNewPassword){
			$estado_update_password = -1;
		}
		//El password tiene que tener caracteres ==> números y letras, maýusculas y minúsculas
		if ($estado_update_password == NULL){
			if ( !(preg_match('/[A-Za-z].*[0-9]|[0-9].*[A-Za-z]/', $newPassword)) ){
				$estado_update_password = -2;
			}
		}
		if ($estado_update_password == NULL){
			//Ahora es cuando vamos a intentar actualizar el password del usuariO:
			$estado_update_password = Usuario::updatePasswordByHash($user, $newPassword, $hash);
		}
		
		if (is_a($estado_update_password, 'Usuario')){
			$cliente = $estado_update_password;
			$estado_update_password = $cliente->codigo;
			//el fichero a utilizar para el envío es: email_update_pass.php
			//en el objeto cliente tenemos el nombre y el email para enviarle el email.
			//Álvaro 060219 TAREA 5177 WEBSTORE: Dentro de la carpeta "modules" estamos preparando los módulos que se podrán instalar/desinstalar de webStore.
			Email::sendMail(new OpcionesWidget(array(
									'destinatario' => $cliente->email . ',' . $cliente->nombre_comercial, 
									'asunto' => 'Contraseña modificada en ' . Shop::$configuracion->url, 
									'contenido' => $cliente,
									'templateFile' => 'email_update_pass.php')));
		}
		Sesion::set('estado_update_password', $estado_update_password);
		//Seteamos las variables que necesitamos que no se pierdan:
		if ($estado_update_password <= 0){	// Sólo si no ha habido éxito
			Sesion::addUrlVariable('hash', $hash);
			Sesion::addUrlVariable('user', $user);
		}
		//Recargamos la página
		Sesion::setReloadPage(Sesion::getReloadPage() | true);
	}
	
}