<?php

//---------------------------------------------------------------------------------------------------------
// 25/marzo/2015
// Versión 1.0 Widget que utilizaremos para mostrar banners
//---------------------------------------------------------------------------------------------------------
/**
 * 	Funcion inicial que carga el widget de Boton arriba
 *
 * 	@version 1.0
 *
 * */



function widget_boton_arriba() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'boton_arriba';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

/**
 * 	Genera el clasico boton de subir al principio del documento
 *
 * 	@version 1.0
 *
 * 	@param String $texto
 * 	@param object $parametros
 * 	@return booblean
 * */
function boton_arriba($texto = 'Volver arriba', $parametros = NULL) {
    include('comunes/globals.php');
    $cont = incrementa_contador();
    $ocultarCabecera = false;
    if (($texto != NULL) && (is_a($texto, "OpcionesWidget"))) {
        $opciones = $texto;
        $texto = "Volver arriba";
        $parametros = NULL;
        if (is_a($opciones, 'OpcionesWidget')) {
            $texto = ($opciones->configuracion->texto != NULL) ? $opciones->configuracion->texto : $texto;
            $parametros = ($opciones->configuracion->parametros != NULL) ? $opciones->configuracion->parametros : $parametros;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }
    if ($parametros == NULL) {
        $parametros = new OpcionesSlider();
        $parametros->fixedPosition = 'true';
        $parametros->transBackground = 'false';
        $parametros->centerH = 'false';
        $parametros->centerV = 'false';
        $parametros->closeButton = 'false';
        $parametros->positionX = "'10'";
        $parametros->positionY = "'10'";
        $parametros->hType = "'right'";
        $parametros->vType = "'bottom'";
        $parametros->inSpeed = "'slow'";
        $parametros->outSpeed = "'slow'";
    }
    $cadena_opciones = $parametros->muestra_opciones('opciones_boton');
    //Quitamos el símbolo del dolar a las opciones
    $cadena_opciones = str_replace('$', '', $cadena_opciones);
    ?>
    <div id="arriba<?= $cont ?>"></div>
    <?php
    if ($ocultarCabecera) {
        ?>
        <div id="<?= (__FUNCTION__) . $cont; ?>" class="<?= (__FUNCTION__); ?>">
            <?php
        }
        ?>
        <a id="enlace_arriba" href="#arriba<?= $cont ?>"><?= $texto ?></a>
        <?php
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
	<?php
	$nombre_script = 'script_' . incrementa_contador();
	?>
    <script type="text/javascript" id="<?=$nombre_script;?>">
	document.addEventListener('WSLE', function(event) {
        ;(function () {
            var elementoPadre = getLastHtmlObject('<?=$nombre_script;?>');
            var elementoHijo = elementoPadre.find("a");
            //componentList.add(elementoPadre, {"fixedPosition" : true, "transBackground" : false, "centerH" : false, "centerV" : false, "closeButton" : false, "positionX" : "10", "positionY" : "10", "hType" : 'right', "vType" : 'bottom', "inSpeed" : 'slow', "outSpeed" : 'slow'});
    <?= $cadena_opciones ?>
            componentList.add(elementoPadre, opciones_boton);
            //detectar scroll hacia abajo
            var obj = $(document);//objeto sobre el que quiero detectar scroll
            var obj_top = obj.scrollTop()//scroll vertical inicial del objeto
            obj.scroll(function () {
                var obj_act_top = $(this).scrollTop();//obtener scroll top instantaneo
                if (obj_act_top > obj_top) {
                    //scroll hacia abajo
                    componentList.show('<?= (__FUNCTION__) . $cont; ?>');
                }
                if (obj_act_top == 0) {
                    //scroll hacia arriba
                    componentList.hide('<?= (__FUNCTION__) . $cont; ?>');
                }
                obj_top = obj_act_top;//almacenar scroll top anterior
            });
            //Efecto scroll hacia arriba, cuando hacemos click en el enlace.
            elementoHijo.click(function (e) {
                e.preventDefault();
                $('html, body').stop().animate({scrollTop: $($(this).attr('href')).offset().top}, 1000);
            });
        }());
	});
    </script>
    <?php
    return(true);
}
?>