<?php

//---------------------------------------------------------------------------------------------------------
// 11/Junio/2015
// Versión 1.0 Funciones extra a añadir al widget de direcciones de envio
//---------------------------------------------------------------------------------------------------------



function muestra_direccion_envio_perso($opciones = NULL) {
    include('comunes/globals.php');
    $obj_direccion_envio = NULL;
    $fichero_direccion = 'direccion_envio';
    $usuario = Usuario::logueado();
    if (is_a($opciones, 'OpcionesWidget')) {
		$obj_direccion_envio = ($opciones->configuracion->obj_direccion_envio !== NULL) ? $opciones->configuracion->obj_direccion_envio : $obj_direccion_envio;
		$fichero_direccion = ($opciones->configuracion->fichero_direccion !== NULL) ? $opciones->configuracion->fichero_direccion : $fichero_direccion;
		$usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
    }
    //Vamos a generar un ID único para esta capa. Hay que tener en cuenta que debe ser selecionabel por el código de la línea y además debe permitir obtener el tipo de fichero
    $id = 'codigo_' . $obj_direccion_envio->codigo . '_' . date('His') . substr((string) microtime(), 4, 4) . '_' . $fichero_direccion;
    ?>
    <div class="<?= (__FUNCTION__); ?>" reference="<?= $id; ?>">
        <?php
        $ruta = Theme::findFile($fichero_direccion . '.php');
        if ($ruta != NULL) {
            include($ruta);
        }
        if (is_int($usuario)) {
            $usuario = new Usuario($usuario);
        }
        $usuario_a_mostrar = $usuario;
        ?>
    </div>
    <?php
}

function lista_direcciones_envio_perso($opciones = NULL) {
    include('comunes/globals.php');
    $usuario = Usuario::logueado();
    $fichero_linea = 'direccion_envio_form';
    $fichero_dir_predeterminada = 'direccion_envio';
    //$ocultar_direcciones = false;
    $ocultar_direcciones = false;
    if (is_a($opciones, 'OpcionesWidget')) {
        $usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
        $fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;
        $ocultar_direcciones = ($opciones->configuracion->ocultar_direcciones !== NULL) ? $opciones->configuracion->ocultar_direcciones : $ocultar_direcciones;
    } else {
        //En caso contrario, siempre creamos un objeto
        $opciones = new OpcionesWidget();
    }

    //Comprobamos que es un entero
    //Obligamos a que sea un entero
    if (is_int($usuario)) {
        $usuario = new Usuario($usuario);
    }
    if (is_a($usuario, 'Usuario')) {
        //Creamos una variable llamada "usuario_a_mostrar" para utilizarla en el widget
        $usuario_a_mostrar = $usuario;
        //Vamos a coger el "fichero_direccion" que tuviesen las opciones
        $fichero_direccion = $opciones->fichero_direccion;
?>
        <div class="<?= (__FUNCTION__); ?>">
            <p class="mensaje_aviso"></p>
<?php
            //Si hay que ocultar las direcciones, vamos a meter aquí un botón para ello
            if ($ocultar_direcciones) {
?>
                <a class="boton" href="javascript:void(0);" title="<?= traducir('Mostrar direcciones'); ?>"><?= traducir('Mostrar direcciones'); ?></a>
				<?php
				$nombre_script = 'script_' . incrementa_contador();
				?>
                <script id="<?=$nombre_script;?>">
				document.addEventListener('WSLE', function(event) {
                    ;(function () {
                        var elemento = getLastHtmlObject('<?=$nombre_script;?>');
                        elemento.on("click", function () {
                            //Si la siguiente capa es visible, entonces la mostramos, si no, la ocultamos
                            if ($("div.lineas_direcciones_envio").is(":visible")) {
                                //Hay que ocultarlo:
                                $("div.lineas_direcciones_envio").hide('fast');
                                //Al hipervínculo le cambiamos el title y el contenido
                                $(this).prop("title", "<?= traducir("Mostrar direcciones"); ?>");
                                $(this).html("<?= traducir("Mostrar direcciones"); ?>");
                            } else {
                                //hay que mostrarlo
                                $("div.lineas_direcciones_envio").show('fast');
                                //Al hipervínculo le cambiamos el title y el contenido
                                $(this).prop("title", "<?= traducir("Ocultar direcciones"); ?>");
                                $(this).html("<?= traducir("Ocultar direcciones"); ?>");
                            }
                        });
                    })();
				});
                </script>
                <div class="lineas_direcciones_envio">
<?php
                }
                for ($i = 0; $i < count($usuario->direcciones); $i++) {
                    //A la dirección predeterminada hay que ponerle un ID
                    $id = "";
                    if ($usuario->direcciones[$i]->codigo == $usuario->direc_predeterminada) {
                        $id = 'id="direc_predeterminada"';
                    }
                    //Mostramos la direccion perso
?>
                    <div class="linea_lista_direcciones_envio_perso" <?= $id; ?>>
<?php
                        $opciones->addProperty('obj_direccion_envio', $usuario->direcciones[$i]);
                        //Necesitamos utilizar el "fichero dirección" por si las moscas
                        $opciones->addProperty('fichero_direccion', $fichero_linea);
                        $opciones->addProperty('usuario', $usuario);
                        new Widget($_WH->GW('direcciones_envio', 'muestra_direccion_envio_perso'), $opciones);
?>
                    </div>
<?php
                }
                //Volvemos a asignar el 'fichero_direccion' que hubiese antes
                $opciones->addProperty('fichero_direccion', $fichero_direccion);
                if ($ocultar_direcciones) {
?>
                </div>
<?php
            }
            ?>
        </div>
        <?php
    }
}

function muestra_datos_dir_predeterminada_perso($opciones = NULL) {
    include('comunes/globals.php');

    $usuario = Usuario::logueado();
    $fichero_dir_predeterminada = 'direccion_envio';
    if (is_a($opciones, 'OpcionesWidget')) {
        $usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
        $fichero_dir_predeterminada = ($opciones->configuracion->fichero_dir_predeterminada !== NULL) ? $opciones->configuracion->fichero_dir_predeterminada : $fichero_dir_predeterminada;
    } else {
        //En caso contrario, siempre creamos un objeto
        $opciones = new OpcionesWidget();
    }
    //Si el usuario es un número entero:
    if (is_int($usuario)) {
        $usuario = new Usuario($usuario);
    }
    if (is_a($usuario, 'Usuario')) {
        //Creamos una variable llamada 'usuario_a_mostrar' para utilizarla en el widget
        $usuario_a_mostrar = $usuario;
        //La dirección predeterminada siempre es la 0.
        if (count($usuario->direcciones) > 0) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
                //Cómo va a haber una "re-asignacion" necesitamos coger el que hay ahora mismo
                $fichero_aux = $opciones->fichero_direccion;
                $opciones->addProperty('obj_direccion_envio', $usuario->direcciones[0]);
                $opciones->addProperty('usuario', $usuario);
                $opciones->addProperty('fichero_dir_predeterminada', $fichero_dir_predeterminada);
                $opciones->addProperty('fichero_direccion', $fichero_dir_predeterminada);
                new Widget($_WH->GW('direcciones_envio', 'muestra_direccion_envio_perso'), $opciones);
                //Volvemos a asignar el que corresponde
                $opciones->addProperty('fichero_direccion', $fichero_aux);
                ?>
            </div>
            <?php
        }
    }
}

function form_nueva_direccion_perso($opciones = NULL) {
    include('comunes/globals.php');
    $usuario = Usuario::logueado();
    $fichero_formulario = 'direccion_envio_nueva_form';
    $fichero_linea = 'direccion_envio_form';
    if (is_a($opciones, 'OpcionesWidget')) {
        $usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
        $fichero_formulario = ($opciones->configuracion->fichero_formulario !== NULL) ? $opciones->configuracion->fichero_formulario : $fichero_formulario;
        $fichero_linea = ($opciones->configuracion->fichero_linea !== NULL) ? $opciones->configuracion->fichero_linea : $fichero_linea;
    } else {
        //En caso contrario, siempre creamos un objeto
        $opciones = new OpcionesWidget();
    }
    if (is_int($usuario)) {
        $usuario = new Usuario($usuario);
    }
    if (is_a($usuario, 'Usuario')) {
        //Creamos una variable llamada 'usuario_a_mostrar' para utilizarla en el widget
        $usuario_a_mostrar = $usuario;
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <p class="texto_aclaracion_nueva_direccion"></p>
            <a href="javascript:void(0);" title="<?= traducir('Añadir dirección'); ?>" class="boton"><?= traducir('Añadir dirección'); ?></a>
            <?php
			$nombre_script = 'script_' . incrementa_contador();
			?>
			<script id="<?=$nombre_script;?>">
			document.addEventListener('WSLE', function(event) {
                ;(function () {
                    var elemento = getLastHtmlObject('<?=$nombre_script;?>');
                    elemento.on("click", function () {
                        var hermano = elemento.next().next();	//Dos next porque este script está en medio
                        if (hermano != null) {
                            elemento.hide("fast");
                            $("p.texto_aclaracion_nueva_direccion").hide();
                            hermano.show();
                            //Hay que ocultar el texto de aclaración nueva dirección
                        }
                    });
                })();
			});
            </script>
            <div class="formulario_nueva_direccion">
                <?php
                //Incluimos el fichero con el formulario
                $ruta = Theme::findFile($fichero_formulario . '.php');
                if ($ruta != NULL) {
                    include($ruta);
                }
                ?>
            </div>
			<?php
			$nombre_script = 'script_' . incrementa_contador();
			?>
            <script id="<?=$nombre_script;?>">
			document.addEventListener('WSLE', function(event) {
                ;(function () {
                    var correcto = true;
                    var elemento = getLastHtmlObject('<?=$nombre_script;?>');
                    elemento = elemento.find("form[action='<?= Shop::$configuracion->url ?>comunes/consultas/crea_mod_direccion_envio.php']");
                    elemento.on("submit", function (event) {
                        event.preventDefault();
                        correcto = true;
                        var fieldset = elemento.children("fieldset")[0];
                        //Comrobaciones sólo para IE y resto de navegadores que no sean chrome o firefox
                        var lista_input = $(fieldset).children("input[required]");
                        var total = lista_input.length;
                        for (var i = 0; (i < total) && (correcto); i++) {
                            var elemento_lista = lista_input[i];
                            if ($(elemento_lista).prop("value") == "") {
                                correcto = false;
                                $(elemento_lista).focus();
                                poner_sombra($(elemento_lista));
                            }
                        }
                        //Si todo está correcto, vamos a recoger los valores para hacer el sumbit
                        var codigo = elemento.find("input[name='mod_codigo']").prop("value");
                        var accion = "nueva";
                        var cliente = <?= $usuario_a_mostrar->codigo; ?>;
                        var nombre = elemento.find("textarea[name='campo_direccion_nombre']").prop("value");
                        var direccion = elemento.find("textarea[name='campo_direccion_direccion']").prop("value");
                        var cod_postal = elemento.find("input[name='campo_direccion_cod_postal']").prop("value");
                        var localidad = elemento.find("input[name='campo_direccion_localidad']").prop("value");
                        var provincia = elemento.find("input[name='campo_direccion_provincia']").prop("value");
                        var pais = elemento.find("input[name='campo_direccion_pais']").prop("value");
                        var telefono = elemento.find("input[name='campo_direccion_telefono']").prop("value");
                        //Vamos a recoger los valores del formulario en el orden en el que están
                        var formParams = "";
                        elemento.find("textarea[name^='campo_direccion_']").each(function () {
                            //en el atributo name tenemos el nombre del campo
                            var nombre = $(this).attr("name").replace("campo_direccion_", "");
                            //var nombre = $(this).attr("name").split("campo_direccion_")[0];
                            var valor = $(this).val();
                            formParams += "&" + nombre + "=" + valor;
                        });
                        elemento.find("input[name^='campo_direccion_']").each(function () {
                            //en el atributo name tenemos el nombre del campo
                            var nombre = $(this).attr("name").replace("campo_direccion_", "");
                            //var nombre = $(this).attr("name").split("campo_direccion_")[0];
                            var valor = $(this).val();
                            formParams += "&" + nombre + "=" + valor;
                        });
                        //Datos del cliente
                        var parametros = "codigo=" + codigo + "&cliente=" + cliente;
                        //Datos de la dirección a crear/modificar
                        parametros += formParams;
                        //Fichero "perso" a utilizar
                        parametros += "&fichero_perso=<?= $fichero_linea; ?>";
                        //Parametro con la acción y el hash de seguridad
                        parametros += "&accion=" + accion + "&hash=<?= genera_cod_seguridad(); ?>";
                        var url = "<?= Shop::$configuracion->url; ?>comunes/consultas/crea_mod_direccion_envio.php";

                        realizar_solicitud(url, parametros, function (respuesta) {
                            //console.log(respuesta);
                            //$(".lista_direcciones_envio_perso").prepend(respuesta);
                            //Para que se inserte en la línea de direcciones de envío perso, hay que hacer una pequeña modificacion
                            var elemento_auxiliar = $('<div class="linea_lista_direcciones_envio_perso"></div>');
                            elemento_auxiliar.html(respuesta);
                            $(".lista_direcciones_envio_perso .linea_lista_direcciones_envio_perso").first().before(elemento_auxiliar);
                            $("p.texto_aclaracion_nueva_direccion").html('<?= traducir("Dirección añadida satisfactoriamente"); ?>');
                            $("p.texto_aclaracion_nueva_direccion").show();
                            //Vamos a hacer que este texto se vaya al rato de añadir una dirección
                            window.setTimeout(function () {
                                $("p.texto_aclaracion_nueva_direccion").hide('slow');
                            }, 3000);
                            //Vaciamos los campos al cancelar
                            elemento.find("textarea[name='campo_direccion_nombre']").prop("value", "");
                            elemento.find("textarea[name='campo_direccion_direccion']").prop("value", "");
                            elemento.find("input[name='campo_direccion_cod_postal']").prop("value", "");
                            elemento.find("input[name='campo_direccion_localidad']").prop("value", "");
                            elemento.find("input[name='campo_direccion_provincia']").prop("value", "");
                            elemento.find("input[name='campo_direccion_pais']").prop("value", "");
                            elemento.find("input[name='campo_direccion_telefono']").prop("value", "");
                            //Hay que ocultar el formulario y mostrar el botón
                            elemento.parent().hide('fast');
                            var hermano = elemento.parent().prev().prev();	//Dos prev porque hay un script en medio
                            hermano.show();
							//Vamos a recargar la página para que aparezca todo correcto:
							location.reload();
                        });

                    });

                    elemento.find("input[name='cancelar']").on("click", function (event) {
                        var hermano = elemento.parent().prev().prev();	//Dos prev porque hay un script en medio
                        elemento.parent().hide('fast');
                        hermano.show();
                        //Vaciamos los campos al cancelar
                        elemento.find("textarea[name='campo_direccion_nombre']").prop("value", "");
                        elemento.find("textarea[name='campo_direccion_direccion']").prop("value", "");
                        elemento.find("input[name='campo_direccion_cod_postal']").prop("value", "");
                        elemento.find("input[name='campo_direccion_localidad']").prop("value", "");
                        elemento.find("input[name='campo_direccion_provincia']").prop("value", "");
                        elemento.find("input[name='campo_direccion_pais']").prop("value", "");
                        elemento.find("input[name='campo_direccion_telefono']").prop("value", "");
                    });
                })();
			});
            </script>
        </div>
        <?php
    }
}

function panel_direcciones_movil($usuario = NULL, $fichero = 'direccion_envio') {
    include('comunes/globals.php');
    //Comprobamos que es un entero
    //Obligamos a que sea un entero
    $usuario = (int) $usuario;
    if (is_int($usuario)) {
        if ($usuario != NULL) {
            $usuario_a_mostrar = new Usuario($usuario);
        } else {
            $usuario_a_mostrar = $datos_usuario;
        }
        if (is_a($usuario_a_mostrar, 'Usuario')) {
            if ($usuario_a_mostrar != NULL) {
                ?>
                <div class="<?= (__FUNCTION__); ?>">
                    <?php
                    //Insertamos el widget que muestra la direccion de envio predeterminada
                    new Widget($_WH->GW('direcciones_envio', 'muestra_datos_dir_predeterminada_perso'), $usuario_a_mostrar->codigo, $fichero);
                    //Agregamos los botones para ver la lista de direcciones y el agregar direccion
                    ?>
                    <a class="mis_direcciones" href="javascript:void(0)" title="<?= traducir('Mis direcciones') ?>"><?= traducir('Mis direcciones') ?></a>
                    <a class="agregar_direccion" href="javascript:void(0)" title="<?= traducir('Agregar dirección') ?>"><?= traducir('Agregar dirección') ?></a>
                    <?php
                    //Agregamos el widget que muestra la lista de direcciones
                    new Widget($_WH->GW('direcciones_envio', 'lista_direcciones_envio_perso'), $usuario_a_mostrar->codigo);
                    //Añadimos el widget que muestra el formulario para añadir una nueva direccion
                    //new Widget($_WH->GW('direcciones_envio', 'form_nueva_direccion'));
                    new Widget($_WH->GW('direcciones_envio', 'form_nueva_direccion_perso'), $usuario_a_mostrar->codigo, 'direccion_envio_nueva_form');
                    ?>
                </div>
				<?php
				$nombre_script = 'script_' . incrementa_contador();
				?>
                <script id="<?= $nombre_script; ?>">
				document.addEventListener('WSLE', function(event) {
                    ;(function () {
                        var correcto = true;
                        var elemento = getLastHtmlObject('<?= $nombre_script; ?>');
                        //elemento = elemento.find("form[action='<?= Shop::$configuracion->url ?>comunes/consultas/crea_mod_direccion_envio.php']");
                        elemento.find('.lista_direcciones_envio_perso').hide('fast');
                        elemento.find(".form_nueva_direccion_perso").hide('fast');
                        //Mostramos las direcciondes de envio
                        elemento.find("a[class='mis_direcciones']").on("click", function (event) {
                            if (elemento.find('.lista_direcciones_envio_perso').is(':hidden')) {
                                elemento.find('.lista_direcciones_envio_perso').show('fast');
                            } else if (!elemento.find('.lista_direcciones_envio_perso').is(':hidden')) {
                                elemento.find('.lista_direcciones_envio_perso').hide('fast');
                            }
                        });

                        elemento.find("a[class='agregar_direccion']").on("click", function (event) {
                            var texto = "<?= traducir("Introduzca los datos de la nueva dirección de envío y pulse sobre el botón 'Guardar'. La dirección de envío introducida se sumará a las direcciones existentes."); ?>";
                            elemento.find(".texto_aclaracion_nueva_direccion").html(texto);
                            if (elemento.find('.form_nueva_direccion_perso').is(":hidden")) {
                                elemento.find('.form_nueva_direccion_perso').show('fast');
                                elemento.find('.texto_aclaracion_nueva_direccion').show('fast');
                                //Ocultamos el aviso
                                //limpiar_aviso_direccion();
                            } else if (!elemento.find(".form_nueva_direccion_perso").is(':hidden')) {
                                elemento.find(".form_nueva_direccion_perso").hide('fast');
                            }
                        });
                    })();
				});
                </script>
                <?php
            }
        }
    }
}

function panel_direcciones_perso($opciones) {
    include('comunes/globals.php');
    $fichero_panel = 'panel_direcciones_envio';
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero_panel = ($opciones->configuracion->fichero_panel != NULL) ? $opciones->configuracion->fichero_panel : $fichero_panel;
        $ruta_fichero = Theme::findFile($fichero_panel . '.php');
        if ($ruta_fichero != NULL) {
            //No hacemos nada de esto si no existe el fichero
            //hacemos el include del fichero en cuestión
            include($ruta_fichero);
        }
    }
}

function guardar_modificaciones_direccion_envio($opciones = NULL) {
    ?>
    <div class="<?= (__FUNCTION__); ?>">
        <input type="button" name="enviar" class="boton" value="<?= traducir("Guardar"); ?>" onClick="modificaDireccionEnvio(this, <?= Usuario::logueado()->codigo; ?>);"/>
        <input type="button" name="cancelar" class="boton" value="<?= traducir("Cancelar"); ?>" onClick="cancelarModificaDireccionEnvio(this);"/>
    </div>
    <?php
}

function botones_mod_borrar_direccion_envio($opciones = NULL) {
    include('comunes/globals.php');
    //Recogemos las opciones cómo siempre
    $obj_direccion_envio = NULL;
    $usuario = Usuario::logueado();
    $fichero_dir_predeterminada = 'direccion_envio';
    if (is_a($opciones, 'OpcionesWidget')) {
        $obj_direccion_envio = ($opciones->configuracion->obj_direccion_envio !== NULL) ? $opciones->configuracion->obj_direccion_envio : $obj_direccion_envio;
        $usuario = ($opciones->configuracion->usuario !== NULL) ? $opciones->configuracion->usuario : $usuario;
        $fichero_dir_predeterminada = ($opciones->configuracion->fichero_dir_predeterminada !== NULL) ? $opciones->configuracion->fichero_dir_predeterminada : $fichero_dir_predeterminada;
    }
    if (is_int($usuario)) {
        $usuario = new Usuario($usuario);
    }
    if ((is_a($usuario, 'Usuario')) && (is_a($obj_direccion_envio, 'Direcciones'))) {
        ?>
         <div class="<?= (__FUNCTION__); ?>">
          <?php
              //Las opciones de borrar y modificar sólo se muestran cuando no es la dirección de registro
              if ($obj_direccion_envio->codigo > 0) {
                  ?>
                    <input type="button" name="modificar" class="boton" value="<?= traducir('Modificar'); ?>" onClick="mostrarModificarDireccionEnvio(this);"/>
                    <input type="button" name="borrar" class="boton" value="<?= traducir('Borrar'); ?>" onClick="borrarDireccionenvio(this, <?= Usuario::logueado()->codigo; ?>);"/>
                <?php
              }else{
                ?>
                <p class="aclaracion_direcciones"><?= traducir('Esta es su dirección de registro. Para modificarla acceda a su area privada.'); ?></p>
                <?php
              }
        ?>
            <input type="button" name="seleccionar" class="boton" value="<?= traducir('Seleccionar'); ?>" onClick="seleccionarDireccionEnvio(this, <?= Usuario::logueado()->codigo; ?>, <?= $obj_direccion_envio->codigo; ?>, '<?= $fichero_dir_predeterminada; ?>');"/>
          </div>
        <?php
    }
    }


function addDatoDireccion($opciones = NULL) {
       $disabled= false;
    if (is_a($opciones, 'OpcionesWidget') ){
        $disabled = ($opciones->configuracion->disabled != NULL)? $opciones->configuracion->disabled: false;
        }
    ?>
    <input type="button" class="boton" value="+" onclick="cloneCampo($(this))" <?= ($disabled)?'disabled':''; ?>/>
    <?php
}
function deleteCampo($opciones = NULL) {
    $disabled= false;
    if (is_a($opciones, 'OpcionesWidget') ){
        $disabled = ($opciones->configuracion->disabled != NULL)? $opciones->configuracion->disabled: false;
        }
    ?>
    <input type="button" class="boton" value="-"  onclick="deleteCampo($(this))" <?=($disabled)? 'disabled':''; ?>/>

<?php

}
?>