<?php
/*
  Clase SuperConfiguracion
  @version 1.5
  //En la configuración se carga SIEMPRE la BD y después machacamos las propiedades con las del configuración.xml
	//Quitados valores:
				color_de_fondo
				opacidad_fondo
				logo_email
				
  */

class SuperConfiguracion extends Objeto{
    public static $campos_tabla = array();
    public static $alias = '';
    public static $nombreTabla = '';
    public static $camposSelect = '';
    public static $whereSelect = '';
    public static $publicFieldList = array(
            'importe_minimo' => 'importe_minimo',
            'elementos_por_pagina' => 'elementos_por_pagina',
            'decimales' => 'decimales_importe',
            'num_novedades' => 'novedades_en_pagina',
            'paginas_a_mostrar' => 'paginas_escaparate',
            'descripcion' => 'descripcion',
            'meta' => 'meta',
            'busquedas_papeleria' => 'busquedas_papeleria',
            'url_sin_idioma' => 'url',
            'password_encriptado' => 'password_encriptado',
            'datos_obligatorios' => 'datos_obligatorios',
            'elementos_relacionados' => 'elementos_relacionados',
            'pedidos_sin_login' => 'pedidos_sin_login',
            'tipo_envio' => 'tipo_envio',
            'dto_dia_libro' => 'dto_dia_libro',
            'dto_papeleria' => 'dto_papeleria',
            'franquicia_feran' => 'franquicia_feran',
            'dto_texto' => 'dto_texto',
            'dto_texto_libre' => 'dto_texto_libre',
            'mes_inicio_texto' => 'mes_inicio_texto',
            'mes_fin_texto' => 'mes_fin_texto',
            'captchaSiteKey' => 'captchaSiteKey',
            'captchaClaveSecreta' => 'captchaClaveSecreta',
            'cesta_login_inicio' => 'cesta_login_inicio',
            'dias_borrado_pedidos_libros' => 'dias_borrado_pedidos_libros',
            'dias_borrado_pedidos_papeleria' => 'dias_borrado_pedidos_papeleria',
            'permitir_anular_pedidos_pendientes' => 'permitir_anular_pedidos_pendientes',
            'elementos_hco_pedidos' => 'elementos_hco_pedidos',
            'elementos_reservas' => 'elementos_reservas',
            'elementos_pedidos_pendientes' => 'elementos_pedidos_pendientes',
            'elementos_facturas' => 'elementos_facturas',
            'elementos_albaranes' => 'elementos_albaranes',
            'elementos_depositos' => 'elementos_depositos',
            'segundos_sesion' => 'segundos_sesion',
            'cookies_rules' =>  'cookies_rules',
            'multi_idioma' =>  'multi_idioma',
            'registro_supervisado' =>  'registro_supervisado',
            'registro_con_confirmacion' => 'registro_con_confirmacion',
            'campos_busqueda' => 'campos_busqueda',
            'controlar_stock' => 'controlar_stock',
            'ocultar_stock_0' => 'ocultar_stock_0',
            'cliente_contado' => 'cliente_contado',
            'guardar_pedidos_bd' => 'guardar_pedidos_bd',
            'segundaMano' => 'segundaMano',
            'filtroGlobal' => 'filtroGlobal',
            'url_ebooks' => 'url_ebooks',
            'limite_descargas_ebook' => 'limite_descargas_ebook',
            'servidor_portadas' => 'servidor_portadas',
            'no_foto' => 'no_foto',
            'trabaja_descuentos' => 'trabaja_descuentos',
            'https_on' => 'https_on',
            'sha1_password' => 'sha1_password',
            'google_api_id' => 'google_api_id',
            'guardar_sesion_al_modificar' => 'guardar_sesion_al_modificar',
            'blowfish' => 'blowfish',
            'envio_recogida_tienda' => 'envio_recogida_tienda',
            'descuentoGlobal' => 'descuentoGlobal',
            'cliente_arminet' => 'cliente_arminet',
            'pais' => 'pais',
            'tarifas_multiples' => 'tarifas_multiples',
            'igic_trabaja' => 'igic_trabaja',
    );

    public $codigo = 0;
    public $idioma = ''; //X
    public $importe_minimo = 0; //X
    public $elementos_por_pagina = 10; //V
    public $decimales = 2; //V
    public $num_novedades = 4;  //X
    public $paginas_a_mostrar = 8; //V
    public $descripcion = '';
    public $meta = '';
    public $busquedas_papeleria = 1; //V
    public $url_sin_idioma = ''; //V
    public $password_encriptado = 1; //V
    public $datos_obligatorios = ''; //X
    public $elementos_relacionados = 3; //V
    public $pedidos_sin_login = 0; //X
    public $tipo_envio = 0; //X
    public $dto_dia_libro = 0; //X
    public $dto_papeleria = 0; //X
    public $franquicia_feran = 0; //X
    public $dto_texto = 0; //X
	public $dto_texto_libre = 0; //X
    public $mes_inicio_texto = 0; //X
    public $mes_fin_texto = 0; //X
    public $captchaSiteKey = '';
    public $captchaClaveSecreta = '';
    public $cesta_siempre_paso1 = false;
    public $programa_arminet = 0;
    public $cesta_login_inicio = 0;
    public $dias_borrado_pedidos_libros = 0;
    public $dias_borrado_pedidos_papeleria = 0;
    public $permitir_anular_pedidos_pendientes = false;
    public $elementos_hco_pedidos = 0;
    public $elementos_reservas = 0;
    public $elementos_pedidos_pendientes = 0;
    public $elementos_facturas = 0;
    public $elementos_albaranes = 0;
    public $elementos_depositos = 0;
    public $segundos_sesion = 0;
    public $cookies_rules = false;
    public $multi_idioma = false;
    public $registro_supervisado = false;
    public $registro_con_confirmacion = true;
    public $campos_busqueda = '';
    public $controlar_stock = 0;
    public $ocultar_stock_0 = false;
    public $cliente_contado = 0;
    public $guardar_pedidos_bd = false;
    public $segundaMano = false;
    public $filtroGlobal = '';
    private $tam_portadas = array(); //V
	//Pedro 05/Febrero/2018 ==> Añadimos la posibilidad de descargar ebooks
	public $url_ebooks = '';
	public $limite_descargas_ebook = 0;
	public $servidor_portadas = '';
	public $no_foto = '';
	public $trabaja_descuentos = false;
	public $https_on = false;
	public $sha1_password = true;
	//Pedro 21/Marzo2019 ==> Identificación en google
	public $google_api_id = '';
	//Pedro 09/Abril/2019 ==> Controlamos si toda la sesión se actualiza o sólo aquellos campos que se han modificado
	public $guardar_sesion_al_modificar = false;
	//Pedro 08/Mayo/2019 ==> Creamos una clave especial para crear firmas
	private $blowfish = 'elPerroDelHortelano';
	//Pedro 15/Mayo/2019 ==> Tipo de envío que sirve para el "recoger en tienda"
	public $envio_recogida_tienda = 0;
    //Pedro 20/Septiembre/2019 ==> Descuento global para la web y cliente arminet
    public $descuentoGlobal = 0;
    public $cliente_arminet = 0;
    //Marina 16/Enero/2020 código del pais por defecto del cliente(ej: 34 para españa)
    public $pais = 0;
    //Pedro 11/Febrero/2020 ==> añadimos las tarifas múltiples
    public $tarifas_multiples = false;
    //Pedro 20/Febrero/2020 ==> Definimos si se trabaja con IGIC o con IVA
    public $igic_trabaja = false;
    //---------------------------------------
    //----------------VERSION----------------
    //---------------------------------------
	private static $version = '2.8.6';
	public static function getVersion(){
		return(self::$version);
	}

    public static function getCampos($soloPrincipal = NULL){
        static::$nombreTabla = strtolower(get_called_class());
        static::getTablaRelacionada();
        //Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
        $campos = BaseDatos::dameCamposAlias(static::$nombreTabla);
        return($campos);
    }
    
    public static function getNombreTabla($soloPrincipal = NULL, $tablasOrigen = NULL){
        static::$nombreTabla = strtolower(get_called_class());
        static::getTablaRelacionada();
        $consulta = ' `' . static::$nombreTabla . '` as `' .  static::getAlias() . '` ';

        return($consulta);
    }

    public static function getWhereTabla(){
        $argumentos = func_get_args();
        $codigo = isset($argumentos[0]) ? $argumentos[0] : NULL;
        if ($codigo != NULL){
            static::$whereSelect = ' `' . static::getAlias() . '`.`codigo` = ' . $codigo . ' ';
        }
        return(static::$whereSelect);
    }

    private function cargar_configuracionBD() {
        $resultado = false;

        $sentencia_sql = 'SELECT ' . static::getCampos() . ' 
                            FROM ' . static::getNombreTabla();/* . '
                            WHERE ' . static::getWhereTabla();*/
        //echo("$sentencia_sql<br />\n");
        $bd = new BaseDatos();
        if ($bd->isConectado()){
            $bd->setConsultaSQL($sentencia_sql);
            $fila = $bd->getFila();
            $this->extractData($fila);
             $resultado = true;
        }
         //Vamos a cargar los tamaños de las portadas
        $sentencia_sql = 'SELECT funcion, alto, ancho, calidad FROM tam_portadas WHERE 1';
        //echo('$sentencia_sql<br />\n');
        $bd->setConsultaSQL($sentencia_sql);
        while($fila = $bd->getFila()){
            $portadaArray = array();
            $portadaArray['funcion'] = $fila['funcion'];
            $portadaArray['alto'] = $fila['alto'];
            $portadaArray['ancho'] = $fila['ancho'];
            $portadaArray['calidad'] = $fila['calidad'];
            $this->tam_portadas[] = $portadaArray;
        }
        //print_r($this->tam_portadas);
        return($resultado);
    }


    public function extractData($fila){
        if ($fila != NULL) {
            $this->codigo = $this->getProp($fila, 'codigo');
            $this->idioma = $this->getProp($fila, 'idioma');
            $this->importe_minimo = $this->getProp($fila, 'importe_minimo');
            $this->elementos_por_pagina = $this->getProp($fila, 'elementos_por_pagina');
            $this->decimales = $this->getProp($fila, 'decimales_importe');
            $this->num_novedades = $this->getProp($fila, 'novedades_en_pagina');
            $this->paginas_a_mostrar = $this->getProp($fila, 'paginas_escaparate');
            $this->descripcion = $this->getProp($fila, 'descripcion');
            $this->meta = $this->getProp($fila, 'meta');
            $this->busquedas_papeleria = $this->getProp($fila, 'busquedas_papeleria');
            $this->url_sin_idioma = $this->getProp($fila, 'url');
            $this->password_encriptado = $this->getProp($fila, 'password_encriptado');
            $this->datos_obligatorios = $this->getProp($fila, 'datos_obligatorios');
            $this->elementos_relacionados = $this->getProp($fila, 'elementos_relacionados');
            $this->pedidos_sin_login = $this->getProp($fila, 'pedidos_sin_login');
            $this->tipo_envio = $this->getProp($fila, 'tipo_envio');
            $this->dto_dia_libro = $this->getProp($fila, 'dto_dia_libro');
            $this->dto_papeleria = $this->getProp($fila, 'dto_papeleria');
            $this->franquicia_feran = $this->getProp($fila, 'franquicia_feran');
            $this->dto_texto = $this->getProp($fila, 'dto_texto');
            $this->dto_texto_libre = $this->getProp($fila, 'dto_texto_libre');
            $this->mes_inicio_texto = $this->getProp($fila, 'mes_inicio_texto');
            $this->mes_fin_texto = $this->getProp($fila, 'mes_fin_texto');
            $this->captchaSiteKey = $this->getProp($fila, 'captchaSiteKey');
            $this->captchaClaveSecreta = $this->getProp($fila, 'captchaClaveSecreta');
            $this->cesta_siempre_paso1 = $this->getProp($fila, 'cesta_siempre_paso1');
            $this->programa_arminet = $this->getProp($fila, 'programa_arminet');
            $this->cesta_login_inicio = $this->getProp($fila, 'cesta_login_inicio');
            $this->dias_borrado_pedidos_libros = $this->getProp($fila, 'dias_borrado_pedidos_libros');
            $this->dias_borrado_pedidos_papeleria = $this->getProp($fila, 'dias_borrado_pedidos_papeleria');
            $this->permitir_anular_pedidos_pendientes = ( $this->getProp($fila, 'permitir_anular_pedidos_pendientes') == 0) ? false : true;
            $this->elementos_hco_pedidos = $this->getProp($fila, 'elementos_hco_pedidos');
            $this->elementos_reservas = $this->getProp($fila, 'elementos_reservas');
            $this->elementos_pedidos_pendientes = $this->getProp($fila, 'elementos_pedidos_pendientes');
            $this->elementos_facturas = $this->getProp($fila, 'elementos_facturas');
            $this->elementos_albaranes = $this->getProp($fila, 'elementos_albaranes');
            $this->elementos_depositos = $this->getProp($fila, 'elementos_depositos');
            $this->segundos_sesion = $this->getProp($fila, 'segundos_sesion');
            $this->cookies_rules = ($this->getProp($fila, 'cookies_rules') == 0) ? false : true;
            $this->multi_idioma = ($this->getProp($fila, 'multi_idioma') == 0) ? false : true;
            $this->registro_supervisado = ($this->getProp($fila, 'registro_supervisado') == 0) ? false : true;
            $this->registro_con_confirmacion = ($this->getProp($fila, 'registro_con_confirmacion') == 0) ? false : true;
            $this->campos_busqueda = $this->getProp($fila, 'campos_busqueda');
            $this->controlar_stock = ($this->getProp($fila, 'controlar_stock') == 0) ? false : true;
            $this->ocultar_stock_0 = ($this->getProp($fila, 'ocultar_stock_0') == 0) ? false : true;
            $this->cliente_contado = $this->getProp($fila, 'cliente_contado');
            $this->guardar_pedidos_bd = ($this->getProp($fila, 'guardar_pedidos_bd') == 0) ? false : true;
            $this->segundaMano = ($this->getProp($fila, 'segundaMano') == 0) ? false : true;
            $this->filtroGlobal = $this->getProp($fila, 'filtroGlobal');
            $this->url_ebooks = $this->getProp($fila, 'url_ebooks');
            $this->limite_descargas_ebook = $this->getProp($fila, 'limite_descargas_ebook');
            $this->servidor_portadas = $this->getProp($fila, 'servidor_portadas');
            $this->no_foto = $this->getProp($fila, 'no_foto');
            $this->trabaja_descuentos = $this->getProp($fila, 'trabaja_descuentos');
            $this->https_on = ($this->getProp($fila, 'https_on') == 0) ? false : true;
            $this->sha1_password = $this->getProp($fila, 'sha1_password');
            $this->google_api_id = $this->getProp($fila, 'google_api_id');
            $this->guardar_sesion_al_modificar = ($this->getProp($fila, 'guardar_sesion_al_modificar') == 0) ? false : true;
            $this->blowfish = $this->getProp($fila, 'blowfish');
            $this->envio_recogida_tienda = $this->getProp($fila, 'envio_recogida_tienda');
            $this->descuentoGlobal = $this->getProp($fila, 'descuentoGlobal');
            $this->cliente_arminet = $this->getProp($fila, 'cliente_arminet');
            $this->pais = $this->getProp($fila, 'pais');
            $this->tarifas_multiples = ($this->getProp($fila, 'tarifas_multiples') == 0) ? false : true;
            $this->igic_trabaja = ($this->getProp($fila, 'igic_trabaja') == 0) ? false : true;
        }
    }


    //Constructor y destructor
    function __construct($ruta_configXML = NULL) {
        //Si existe un fichero xml no cargamos la configuracion de la base de datos
		//Pedro 11/Febrero/2019 ==> Siempre cargamos de la BD y después, si hay fichero machacamos:
		$resultado = $this->cargar_configuracionBD();
		//var_dump($ruta_configXML);
        if ($ruta_configXML != NULL) {
            $resultado = $this->cargar_configuracionXML($ruta_configXML);
        }
        if (!$resultado) {
            echo('Ha ocurrido un error al cargar la configuraci&oacute;n de la web<br />\n');
        } else {
            //Ahora vamos a inicializar ciertos campos necesarios
            if ($this->campos_busqueda == '') {
                $this->campos_busqueda = 'nombre,autor,editorial';
            }
        }
		
		//Según si el cliente tiene https o no, vamos a generar la URL:
		$this->url_sin_idioma = str_replace(array('https://', 'http://'), '', $this->url_sin_idioma);
		$this->url_sin_idioma = 'http' . ( ($this->https_on) ? 's' : '') . '://' . $this->url_sin_idioma;
		
		//Ahora vamos a asegurarnos de que la url SIEMPRE termine en /
		if (substr($this->url_sin_idioma, -1) != '/'){
			$this->url_sin_idioma .= '/';
		}
    }

    function __destruct() {
        
    }

    public function __get($name) {
        $retorno = NULL;
        //Si alguien quiere la url de la web tenemos que ver si hay multi idioma y si este está definido
        include('comunes/globals.php');
        if ($name == 'url') {
            if ($this->multi_idioma) {
                $idioma = Sesion::get('idioma');
                if (isset($idioma)) {
                    $retorno = $this->url_sin_idioma . $idioma . '/';
                } else {
                    $retorno = $this->url_sin_idioma;
                }
            } else {
                $retorno = $this->url_sin_idioma;
            }
        }
        //Si no hay retorno aún, vamos a ver si está definida la propiedad
        if (($retorno == NULL) && (isset($this->$name))) {
            $retorno = $this->$name;
        }
        return($retorno);
    }

    public function tam_portada($nombre_funcion) {
        $encontrado = 0;
        $retorno = array(100, 100);
        for ($i = 0; ($i < count($this->tam_portadas)) && ($encontrado == 0); $i++) {
            if ($this->tam_portadas[$i]['funcion'] == $nombre_funcion) {
                $retorno[0] = $this->tam_portadas[$i]['ancho'];
                $retorno[1] = $this->tam_portadas[$i]['alto'];
				$retorno[2] = $this->tam_portadas[$i]['calidad'];
            }
        }
        return($retorno);
    }

    private function cargar_configuracionXML($ruta_fichero) {
        $retorno = false;
        if (file_exists($ruta_fichero)) {
            $datos = simplexml_load_file($ruta_fichero);
            $this->idioma = isset($datos->idioma) ? (string) $datos->idioma : $this->idioma;
            $this->importe_minimo = isset($datos->importe_minimo) ? (float) $datos->importe_minimo : $this->importe_minimo;
            $this->elementos_por_pagina = isset($datos->elementos_por_pagina) ? (int) $datos->elementos_por_pagina : $this->elementos_por_pagina;
            $this->decimales = isset($datos->decimales_importe) ? (int) $datos->decimales_importe : $this->decimales;
            $this->num_novedades = isset($datos->novedades_en_pagina) ? (int) $datos->novedades_en_pagina : $this->num_novedades;
            $this->paginas_a_mostrar = isset($datos->paginas_escaparate) ? (int) $datos->paginas_escaparate : $this->paginas_a_mostrar;
            $this->descripcion = isset($datos->descripcion) ? (string) $datos->descripcion : $this->descripcion;
            $this->meta = isset($datos->meta) ? (string) $datos->meta : $this->meta;
            $this->busquedas_papeleria = isset($datos->busquedas_papeleria) ? (int) $datos->busquedas_papeleria : $this->busquedas_papeleria;
            $this->url_sin_idioma = isset($datos->url) ? (string) $datos->url : $this->url_sin_idioma;
            $this->password_encriptado = isset($datos->password_encriptado) ? (int) $datos->password_encriptado : $this->password_encriptado;
            $this->datos_obligatorios = isset($datos->datos_obligatorios) ? (string) $datos->datos_obligatorios : $this->datos_obligatorios;
            $this->elementos_relacionados = isset($datos->elementos_relacionados) ? (int) $datos->elementos_relacionados : $this->elementos_relacionados;
            $this->pedidos_sin_login = isset($datos->pedidos_sin_login) ? (int) $datos->pedidos_sin_login : $this->pedidos_sin_login;
            $this->tipo_envio = isset($datos->tipo_envio) ? (int) $datos->tipo_envio : $this->tipo_envio;
            $this->dto_dia_libro = isset($datos->dto_dia_libro) ? (int) $datos->dto_dia_libro : $this->dto_dia_libro;
            $this->dto_papeleria = isset($datos->dto_papeleria) ? (int) $datos->dto_papeleria : $this->dto_papeleria;
            $this->franquicia_feran = isset($datos->franquicia_feran) ? (int) $datos->franquicia_feran : $this->franquicia_feran;
            $this->dto_texto = isset($datos->dto_texto) ? (int) $datos->dto_texto : $this->dto_texto;
			$this->dto_texto_libre = isset($datos->dto_texto_libre) ? (int) $datos->dto_texto_libre : $this->dto_texto_libre;
            $this->mes_inicio_texto = isset($datos->mes_inicio_texto) ? (int) $datos->mes_inicio_texto : $this->mes_inicio_texto;
            $this->mes_fin_texto = isset($datos->mes_fin_texto) ? (int) $datos->mes_fin_texto : $this->mes_fin_texto;
            $this->captchaSiteKey = isset($datos->captchaSiteKey) ? (string) $datos->captchaSiteKey : $this->captchaSiteKey;
            $this->captchaClaveSecreta = isset($datos->captchaClaveSecreta) ? (string) $datos->captchaClaveSecreta : $this->captchaClaveSecreta;
            $this->cesta_siempre_paso1 = isset($datos->cesta_siempre_paso1) ? (int) $datos->cesta_siempre_paso1 : $this->cesta_siempre_paso1;
            $this->programa_arminet = isset($datos->programa_arminet) ? (int) $datos->programa_arminet : $this->programa_arminet;
            $this->cesta_login_inicio = isset($datos->cesta_login_inicio) ? (int) $datos->cesta_login_inicio : $this->cesta_login_inicio;
            $this->dias_borrado_pedidos_libros = isset($datos->dias_borrado_pedidos_libros) ? (int) $datos->dias_borrado_pedidos_libros : $this->dias_borrado_pedidos_libros;
            $this->dias_borrado_pedidos_papeleria = isset($datos->dias_borrado_pedidos_papeleria) ? (int) $datos->dias_borrado_pedidos_papeleria : $this->dias_borrado_pedidos_papeleria;
            $this->permitir_anular_pedidos_pendientes = isset($datos->permitir_anular_pedidos_pendientes) ? (((int) $datos->permitir_anular_pedidos_pendientes == 0) ? false : true) : $this->permitir_anular_pedidos_pendientes;
            $this->elementos_hco_pedidos = isset($datos->elementos_hco_pedidos) ? (int) $datos->elementos_hco_pedidos : $this->elementos_hco_pedidos;
            $this->elementos_reservas = isset($datos->elementos_reservas) ? (int) $datos->elementos_reservas : $this->elementos_reservas;
            $this->elementos_pedidos_pendientes = isset($datos->elementos_pedidos_pendientes) ? (int) $datos->elementos_pedidos_pendientes : $this->elementos_pedidos_pendientes;
            $this->elementos_facturas = isset($datos->elementos_facturas) ? (int) $datos->elementos_facturas : $this->elementos_facturas;
            $this->elementos_albaranes = isset($datos->elementos_albaranes) ? (int) $datos->elementos_albaranes : $this->elementos_albaranes;
            $this->elementos_depositos = isset($datos->elementos_depositos) ? (int) $datos->elementos_depositos : $this->elementos_depositos;
            $this->segundos_sesion = isset($datos->segundos_sesion) ? (int) $datos->segundos_sesion : $this->segundos_sesion;
            $this->cookies_rules = isset($datos->cookies_rules) ? (((int) $datos->cookies_rules == 0) ? false : true) : $this->cookies_rules;
            $this->multi_idioma = isset($datos->multi_idioma) ? (((int) $datos->multi_idioma == 0) ? false : true) : $this->multi_idioma;
            $this->registro_supervisado = isset($datos->registro_supervisado) ? (((int) $datos->registro_supervisado == 0) ? false : true) : $this->registro_supervisado;
            $this->registro_con_confirmacion = isset($datos->registro_con_confirmacion) ? (((int) $datos->registro_con_confirmacion == 0) ? false : true) : $this->registro_con_confirmacion;
            $this->campos_busqueda = isset($datos->campos_busqueda) ? (String) $datos->campos_busqueda : $this->campos_busqueda;
            $this->controlar_stock = isset($datos->controlar_stock) ? (((int) $datos->controlar_stock == 0) ? false : true) : $this->controlar_stock;
            $this->ocultar_stock_0 = isset($datos->ocultar_stock_0) ? (((int) $datos->ocultar_stock_0 == 0) ? false : true) : $this->ocultar_stock_0;
            $this->cliente_contado = isset($datos->cliente_contado) ? (int) $datos->cliente_contado : $this->cliente_contado;
            $this->guardar_pedidos_bd = isset($datos->guardar_pedidos_bd) ? (((int) $datos->guardar_pedidos_bd == 0) ? false : true) : $this->guardar_pedidos_bd;
            $this->segundaMano = isset($datos->segundaMano) ? (((int) $datos->segundaMano == 0) ? false : true ): $this->segundaMano;
            $this->filtroGlobal = isset($datos->filtroGlobal) ? (string) $datos->filtroGlobal : $this->filtroGlobal;
			$this->url_ebooks = isset($datos->url_ebooks) ? (string) $datos->url_ebooks : $this->url_ebooks;
			$this->limite_descargas_ebook = isset($datos->limite_descargas_ebook) ? (int) $datos->limite_descargas_ebook : $this->limite_descargas_ebook;
			$this->servidor_portadas = isset($datos->servidor_portadas) ? $datos->servidor_portadas : $this->servidor_portadas;
			$this->no_foto = isset($datos->no_foto) ? $datos->no_foto : $this->no_foto;
			$this->trabaja_descuentos = isset($datos->trabaja_descuentos) ? $datos->trabaja_descuentos : $this->trabaja_descuentos;
			$this->https_on = isset($datos->https_on) ? (($datos->https_on == 0) ? false : true) : $this->https_on;
			$this->sha1_password = isset($datos->sha1_password) ? $datos->sha1_password : $this->sha1_password;
			$this->google_api_id = isset($datos->google_api_id) ? $datos->google_api_id : $this->google_api_id;
			$this->guardar_sesion_al_modificar = isset($datos->guardar_sesion_al_modificar) ? (((int) $datos->guardar_sesion_al_modificar == 0) ? false : true) : $this->guardar_sesion_al_modificar;
			$this->blowfish = isset($datos->blowfish) ? $datos->blowfish : $this->blowfish;
			$this->envio_recogida_tienda = isset($datos->envio_recogida_tienda) ? $datos->envio_recogida_tienda : $this->envio_recogida_tienda;
            $this->descuentoGlobal = isset($datos->descuentoGlobal) ? $datos->descuentoGlobal : $this->descuentoGlobal;
            $this->cliente_arminet = isset($datos->cliente_arminet) ? $datos->cliente_arminet : $this->cliente_arminet;
            $this->pais = isset($datos->pais) ? $datos->pais : $this->pais;
            $this->tarifas_multiples = isset($datos->tarifas_multiples) ? (($datos->tarifas_multiples == 0) ? false : true) : $this->tarifas_multiples;
            $this->igic_trabaja = isset($datos->igic_trabaja) ? (($datos->igic_trabaja == 0) ? false : true) : $this->igic_trabaja;
			$resultado = true;

            /*
			  echo('<pre>');
              echo('$this->dias_borrado_pedidos_libros\n$this->dias_borrado_pedidos_papeleria\n');
              echo('</pre>');
			*/
            //Vamos con los tamaños de las portadas
            $i = 0;
			if (isset($datos->tam_portadas->portada)){
				foreach ($datos->tam_portadas->portada as $clave => $valor) {
					$this->tam_portadas[$i] = array();
					$this->tam_portadas[$i]['funcion'] = (string) $valor->funcion;
					$this->tam_portadas[$i]['alto'] = (int) $valor->alto;
					$this->tam_portadas[$i]['ancho'] = (int) $valor->ancho;
					$this->tam_portadas[$i]['calidad'] = (int) $valor->calidad;
					$i++;
				}
			}
            $retorno = true;
        }else{
			echo("Fichero xml no cargado");
		}
        return($retorno);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (gettype($value) == 'string') {
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (is_object($value)) {
                    if (method_exists('"' . get_class($value) . '"', 'getJson')) {
                        $ejecutarJson = false;
                    }
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
            $resp = substr($resp, 0, -1) . "}";
            return $resp;
        }
    }
	
	//PEdro 08/Mayo/2019 ==> Con esta función firmamos utilizando la clave privada
	public function sign($string){
		$string .= $this->blowfish;
		return(password_hash($string, PASSWORD_DEFAULT));
	}
	
	public function checkSign($originalString, $hash){
		$originalString .= $this->blowfish;
		return(password_verify($originalString, $hash));
	}

}

?>