<?php

class SuperPedidoCliente extends Objeto{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();


    public $codigo = 0;
    public $codigo_sinlib = 0;
    public $cliente = 0;
    public $nombre_legal = '';
    public $email = '';
    public $direccion = '';
    public $cod_postal = '';
    public $localidad = '';
    public $provincia = '';
    public $telefono = '';
    public $telefono2 = '';
    public $cif = '';
    public $pendiente_sinlib = 0;
    public $fecha = 0;
    public $fecha_date_format = 0;
    public $cadena_fecha = '';
    public $fecha_pago = 0;
    public $fecha_envio = 0;
    public $pagado = 0;
    public $referencia = '';
    public $enviado = 0;
    public $observaciones = '';
	public $codigo_tipo_envio = NULL;
    public $tipo_envio = NULL;
    public $no_revisado = 1;
    public $pedido_preparado = 0;
    public $pais = 0;
    public $datos_facturacion = '';
    public $factura = 0;
    public $descuento = 0;
    public $envolver_regalo = 0;
    public $comercial = 0;
    public $g_envio = 0;
    public $forma_pago = 0;
    public $pendiente_paypal = 0;
    public $oculto = 0;
    public $forma_pago_nombre = '';
    public $tipo_envio_nombre = '';
    public $reembolso = 0;
    public $transferencia = 0;
    public $sin_pago = 0;
    public $cuenta_bancaria = '';
    public $cantidad_total = 0;
    public $cantidad_pendiente = 0;
    public $cantidad_reservada = 0;
    public $total_pvp = 0;
	public $base = 0;
    public $total_pvp_pendiente = 0;
    public $total_pvp_reservado = 0;
    public $total_pvp_con_dto = 0;
    public $total_pvp_con_dto_pendiente;
    public $total_pvp_con_dto_reservado = 0;
    public $importe_total = 0;
    public $importe_total_pendiente = 0;
    public $importe_total_reservado = 0;
    public $lineas = array();
    public $tipo_pasarela = 0;
	public $emailEnviado = false;
	public $numero_pedido = 0;
	private $lotes = array();	//Pedro 15/Julio/2019 ==> aquí guardo los lotes asociados al pedido
    private $flag_utf8 = false;

	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la select
		
		$campos = '';
		if (static::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias());
				$campos .= BaseDatos::dameCamposAlias(static::$nombreTabla);

			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				/*$campos .= ( (trim($campos) != ' ') ? ', ' : '' ) . 
				BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{TraduccionArticulo::getNombreTabla() . 'Campos'}, TraduccionArticulo::getAlias()) . ', ' .
				BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{SeoArticulo::getNombreTabla() . 'Campos'}, SeoArticulo::getAlias()) . ', ' .
				BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{Familia::getNombreTabla() . 'Campos'}, Familia::getAlias());*/
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' ) . 
				BaseDatos::dameCamposAlias(TipoEnvioCliente::getNombreTablaSinAlias(true)) . ', ' .
				BaseDatos::dameCamposAlias(FormasPago::getNombreTablaSinAlias(true)) . ', ' .
				Usuario::getCampos();
			}
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
	
		return($campos);
	}

	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= static::getJoin('PedidoCliente', 'cliente', 'Usuario', 'codigo'); 				//Cogemos el cliente
			$consulta .= static::getJoin('PedidoCliente', 'tipo_envio', 'TipoEnvioCliente', 'codigo');	//Cogemos el tipo de envío
			$consulta .= static::getJoin('PedidoCliente', 'forma_pago', 'FormasPago', 'codigo');	//Cogemos el tipo de envío
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo_pedido_cliente = isset($argumentos[0]) ? $argumentos[0] : '';
		$pagado = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$usuario = isset($argumentos[2]) ? $argumentos[2] : NULL;
		$pendienteSinlib = isset($argumentos[3]) ? $argumentos[3] : NULL;
		$numero_pedido = isset($argumentos[4]) ? $argumentos[4] : 0;
		include('comunes/globals.php');
		static::$whereSelect = '';
		
		if ($codigo_pedido_cliente != '') {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' . static::getAlias() . '`.`codigo` = \'' . $codigo_pedido_cliente . '\' ';
		}
		if ($pagado !== NULL) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' . static::getAlias() . '`.`pagado` = ' . $pagado . ' ';
		}
		if ($pendienteSinlib !== NULL) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' . static::getAlias() . '`.`pendiente_sinlib` > 0 ';
		}
		if ($usuario !== NULL) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' . static::getAlias() . '`.`cliente` = \'' . $usuario . '\' ';
		}
		if ($numero_pedido > 0) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' . static::getAlias() . '`.`numero_pedido` = \'' . $numero_pedido . '\' ';
		}
							
		return(static::$whereSelect);
	}
	
	
	
    function __construct($codigo_pedido_cliente = '', $pagado = NULL, $con_detalle = true, $finalizado = NULL) {
		include('comunes/globals.php');
        $filaPedido = NULL;
		$opciones = NULL;
		$numero_pedido = 0;
		if (is_a($codigo_pedido_cliente, 'OpcionesWidget')) {
			$opciones = $codigo_pedido_cliente;
			$codigo_pedido_cliente = ($opciones->configuracion->codigo_pedido_cliente != NULL) ? $opciones->configuracion->codigo_pedido_cliente : '';
			$pagado = ($opciones->configuracion->pagado != NULL) ? $opciones->configuracion->pagado : $pagado;
			$con_detalle = ($opciones->configuracion->con_detalle != NULL) ? $opciones->configuracion->con_detalle : $con_detalle;
			$finalizado = ($opciones->configuracion->finalizado != NULL) ? $opciones->configuracion->finalizado : $finalizado;
			$filaPedido = ($opciones->configuracion->filaPedido != NULL) ? $opciones->configuracion->filaPedido : $filaPedido;
			$numero_pedido = ($opciones->configuracion->numero_pedido != NULL) ? $opciones->configuracion->numero_pedido : $numero_pedido;
		}
		$fila = NULL;
		if ($filaPedido == NULL){
			$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . ' 
								WHERE ' . static::getWhereTabla($codigo_pedido_cliente, $pagado, NULL, NULL, $numero_pedido);
			/*echo("<pre>");
			echo($sentencia_sql);
			echo("</pre>");*/
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaPedido;
		}
		if ($fila != NULL){
			$this->extracData($fila);
		}
		//var_dump($this);
		
		//Ahora vamos con las líneas si lo queremos con detalle, claro
		if ($con_detalle) {
			$this->cargarDetalle();
		} else {
			//Cargamos las líneas pero no creamos los objetos
			//TODO ==> Hay que cargar el lote para ver el total del mismo
			$sentencia_sql = "SELECT pvp, cantidad, recibida, reservada, pvp_con_dto, importe_con_dto, iva, base FROM  ml_pedcli WHERE mc_pedcli = '$codigo_pedido_cliente'";
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
				while ($fila = mysqli_fetch_array($resultado)) {
					$pendiente = $fila["cantidad"] - $fila['recibida'] - $fila['reservada'];
					$reservado = $fila['recibida'];
					$this->total_pvp += $fila['pvp'] * $fila['cantidad'];
					$this->total_pvp_pendiente += $fila['pvp'] * $pendiente;
					$this->total_pvp_reservado += $fila['pvp'] * $reservado;
					$this->total_pvp_con_dto += $fila['importe_con_dto'];
					$this->base += round($fila['base'], 2);
					$this->total_pvp_con_dto_pendiente += $fila['pvp_con_dto'] * $pendiente;
					$this->total_pvp_con_dto_reservado += $fila['pvp_con_dto'] * $reservado;
					$this->cantidad_total += $fila['cantidad'];
					$this->cantidad_pendiente += $pendiente;
					$this->cantidad_reservada += $reservado;
				}
			}
		}

		$this->importe_total = Price::setDiscount($this->total_pvp_con_dto, $this->descuento);
		$this->importe_total_pendiente = Price::setDiscount($this->total_pvp_con_dto_pendiente, $this->descuento);
		$this->importe_total_reservado = Price::setDiscount($this->total_pvp_con_dto_reservado, $this->descuento);

    }

	public function extracData($fila){
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->codigo_sinlib = $this->getProp($fila, 'cod_sinlib');
		//$this->cliente = new Usuario($fila[PedidoCliente::getAlias() . '_' . 'cliente']);
		$this->cliente = new Usuario(new OpcionesWidget(Array('filaUsuario' => $fila)));
		$this->nombre_legal =  $this->getProp($fila, 'nombre_legal');
		$this->email =  $this->getProp($fila, 'email');
		$this->direccion = $this->getProp($fila, 'direccion');
		$this->cod_postal = $this->getProp($fila, 'cod_postal');
		$this->localidad = $this->getProp($fila, 'localidad');
		$this->provincia = $this->getProp($fila, 'provincia');
		$this->telefono = $this->getProp($fila, 'telefono');
		$this->telefono2 = $this->getProp($fila, 'telefono2');
		$this->cif = $this->getProp($fila, 'cif');
		$this->pendiente_sinlib = $this->getProp($fila, 'pendiente_sinlib');
		$this->fecha = $this->getProp($fila, 'fecha');
		$this->fecha_date_format = date_create($this->fecha);
		$aux_fecha = new DateTime($this->fecha);
		$this->cadena_fecha = dame_dia_de_la_semana($aux_fecha->format('w')) . ' <strong>' . $aux_fecha->format('d') . '</strong> de <strong>' . dame_mes($aux_fecha->format('n')) . '</strong> a las ' . $aux_fecha->format('H:i') . 'h';
		$this->fecha_pago = $this->getProp($fila, 'fecha_pago');
		$this->fecha_envio = $this->getProp($fila, 'fecha_envio');
		$this->pagado = $this->getProp($fila, 'pagado');
		$this->referencia = $this->getProp($fila, 'referencia');
		$this->enviado = $this->getProp($fila, 'enviado');
		$this->observaciones = $this->getProp($fila, 'observaciones');
		$this->no_revisado = $this->getProp($fila, 'no_revisado');
		$this->pedido_preparado = $this->getProp($fila, 'pedido_preparado');
		$this->pais = $this->getProp($fila, 'pais');
		$this->datos_facturacion = $this->getProp($fila, 'datos_facturacion');
		$this->factura = $this->getProp($fila, 'factura');
		$this->descuento = $this->getProp($fila, 'descuento');
		$this->envolver_regalo = $this->getProp($fila, 'envolver_regalo');
		$this->comercial = $this->getProp($fila, 'comercial');
		$this->g_envio = $this->getProp($fila, 'g_envio');
		$this->pendiente_paypal = $this->getProp($fila, 'pendiente_paypal');
		$this->oculto = $this->getProp($fila, 'oculto');
		$this->emailEnviado = ($this->getProp($fila, 'emailEnviado') == 1); // Lo hacemos así para asignar un valor booleano
		$this->numero_pedido = $this->getProp($fila, 'numero_pedido');
		
		//Tipo de envío
		//$this->tipo_envio = $fila[PedidoCliente::getAlias() . '_' . 'tipo_envio'];
		$this->tipo_envio = new TipoEnvioCliente(new OpcionesWidget(Array('filaTipoEnvio' => $fila)));
		$this->codigo_tipo_envio = $this->tipo_envio->codigo;
		$this->tipo_envio_nombre = $this->getProp($fila, 'nombre', TipoEnvioCliente::getAlias());
		$this->cuenta_bancaria = $this->getProp($fila, 'cuenta_bancaria', TipoEnvioCliente::getAlias());
		$this->reembolso = $this->getProp($fila, 'reembolso', TipoEnvioCliente::getAlias());
		$this->transferencia = $this->getProp($fila, 'transferencia', TipoEnvioCliente::getAlias());
		$this->sin_pago = $this->getProp($fila, 'sin_pago', TipoEnvioCliente::getAlias());
		//formas de pago
		//$this->forma_pago = $fila[PedidoCliente::getAlias() . '_' . 'forma_pago'];
		$this->forma_pago = new FormasPago(new OpcionesWidget(Array('filaFormaPago' => $fila)));
		$this->forma_pago_nombre = $this->getProp($fila, 'nombre', FormasPago::getAlias() );
		if ($fila[FormasPago::getAlias() . '_cuenta_bancaria'] != '') {
			$this->cuenta_bancaria = $this->getProp($fila, 'cuenta_bancaria', FormasPago::getAlias() );
		}
		if ($fila[FormasPago::getAlias() . '_transferencia'] != '') {
			$this->transferencia = $this->getProp($fila, 'transferencia', FormasPago::getAlias() );
		}
		$this->tipo_pasarela = $this->getProp($fila, 'tipo_pasarela', FormasPago::getAlias() );
	}
	public function cargarDetalle(){
		//Limpiamos las líneas si contienen algo:
		if (count($this->lineas) > 0){
			$this->cleanLines();
		}
		//Compondremos aquí una nueva select que nos dé todas las líneas de pedido ya con los campos y el resto de datos:
		$sentencia_sql = 'SELECT ' . LineaPedidoCliente::getCampos() . ' 
							FROM ' . LineaPedidoCliente::getNombreTabla() . '
							WHERE ' . LineaPedidoCliente::getWhereTabla($this->codigo, NULL, false);	// ==> No indicamos código de línea y no limitamos
		//echo("$sentencia_sql<br />\n");
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while($fila = $bd->getFila()){
				$linea = new LineaPedidoCliente(new OpcionesWidget(array(
					'filaLineaPedido' => $fila,
					'objetoPedido' => $this
				)));
				$this->lineas[] = $linea;
				//TODO ==> Añadimos el lote
				$this->addLote($linea->cod_lote);
			}
		}
		//Recalculamos los totales
		$this->recalculate();
	}
	
	public function cargarProductos(){
		foreach ($this->lineas as $clave => $valor) {
			$valor->cargarArticulo();
		}
	}
	
	private function cleanLines(){
		foreach ($this->lineas as $clave => $valor) {
			unset($this->lineas[$clave]);
		}
		unset($this->lineas);
		$this->lineas = array();
	}
	
    public function recalculate() {
        //El recálculo lo vamos a hacer de los datos que hay en las líneas. Así todo se hace siempre por el mismo camino
		//Ponemos a 0 los acumulados de la tabla:
		$this->total_pvp = 0;
		$this->total_pvp_pendiente = 0;
		$this->total_pvp_reservado = 0;
		$this->total_pvp_con_dto = 0;
		$this->total_pvp_con_dto_pendiente = 0;
		$this->total_pvp_con_dto_reservado = 0;
		$this->cantidad_total = 0;
		$this->cantidad_pendiente = 0;
		$this->cantidad_reservada = 0;
		//Ahora toca recorrer las líneas para calcular los totales
		foreach ($this->lineas as $clave => $valor) {
			//Primero calculamos las cantidades
			$this->cantidad_total += $valor->cantidad;
			$this->cantidad_pendiente += $valor->pendiente;
			$this->cantidad_reservada += $valor->recibida;
			$importe_sumar = $valor->pvp;	//Aquí ya tengo el precio del lote, así se guardó en la tabla
			$importe_sumar_con_dto = $valor->importe_con_dto;	//Aquí ya tengo el precio del lote, así se guardó en la tabla
			$base_sumar = $valor->base;
			//El lote tiene Precio web? Si es afirmativo, no sumamos:
			if ($valor->lote != NULL && $valor->lote->precio_web > 0){
				$importe_sumar = $importe_sumar_con_dto = $base_sumar = 0;
			}
			//Ahora sumamos:
			$this->total_pvp += ($importe_sumar * $valor->cantidad);
			$this->total_pvp_pendiente += ($importe_sumar * $valor->pendiente);
			$this->total_pvp_reservado += ($importe_sumar * $valor->recibida);
			$this->base += ($base_sumar * $valor->cantidad);
			$this->total_pvp_con_dto += $importe_sumar_con_dto;
			$this->total_pvp_con_dto_pendiente += ($importe_sumar_con_dto * $valor->pendiente);
			$this->total_pvp_con_dto_reservado += ($importe_sumar_con_dto * $valor->recibida);
		}
		//Ahora tenemos que cargar los lotes y sumar los importes de los mismos:
		foreach($this->lotes as $codigo_lote => $lote){
			//Pedro 12/Julio/2019 ==> Por ahora el iva de los anticipos lo cobramos al 21%
			$this->base += $lote->base_precio_web;
			$this->total_pvp += $lote->precio_web;
			$this->total_pvp_con_dto += $lote->precio_web;
		}
    }

	//------------------------------------------
	//	Damos un pedido por finalizado
	//------------------------------------------
	public function finalizado(){
		return(static::darPorFinalizado($this));
	}
	public static function darPorFinalizado($codPedido){
		//Si hemos recibido un objeto pedido, extraemos el código:
		$mc_pedcli = NULL;
		if (is_a($codPedido, 'PedidoCliente')){
			$mc_pedcli = $codPedido;
			$codPedido = $codPedido->codigo;
		}
		//Vamos a dar el pedido por finalizado.
		$retorno = false;
		$sentencia_sql = 'UPDATE `mc_pedcli` SET `pendiente_sinlib` = 1 WHERE `codigo` = \'' . $codPedido . '\'; ';
		$bd = new BaseDatos();
		//Para hacer pruebas, no actualizo el pedido
		$bd->setConsultaSQL($sentencia_sql);
		if ($bd->getNumeroFilas() > 0){
			$retorno = true;
		}

		if($retorno){
			//Necesitamos un objeto pedido cliente:
			if ($mc_pedcli == NULL){
				$mc_pedcli = new PedidoCliente($codPedido);
			}
			//si todo ha ido bien, vamos a hacer más recálculos
			//Si los productos comprados itenen ficheros adjuntos
			$listaFicheros = array();
			foreach($mc_pedcli->lineas as $clave => $valor){
				if ($valor->articulo == NULL){
					$valor->cargarArticulo();
				}
				$valor->articulo->venderAdjuntos($mc_pedcli->cliente->codigo);
			}
			//var_dump($listaFicheros);
		}

		return($retorno);
	}
	
	//------------------------------------------
	//	Damos un pedido por pagado
	//------------------------------------------
	public function pagado(){
		return(static::darPorPagado($this));
	}
	public static function darPorPagado($codPedido){
		//Si hemos recibido un objeto pedido, extraemos el código:
		$mc_pedcli = NULL;
		if (is_a($codPedido, 'PedidoCliente')){
			$mc_pedcli = $codPedido;
			$codPedido = $codPedido->codigo;
		}
		//Vamos a dar el pedido por finalizado.
		$retorno = false;
		$sentencia_sql = 'UPDATE `mc_pedcli` SET `pagado` = 1 WHERE `codigo` = \'' . $codPedido . '\'; ';
		$bd = new BaseDatos();
		$bd->setConsultaSQL($sentencia_sql);
		if ($bd->getNumeroFilas() > 0){
			$retorno = true;
		}
		return($retorno);
	}

	//------------------------------------------
	//	Damos un pedido por pagado y finalizado
	//------------------------------------------
	public function pagadoFinalizado(){
		return(static::darPorpagadoFinalizado($this));
	}
	public static function darPorpagadoFinalizado($codPedido){
		$retorno = static::darPorPagado($codPedido) | static::darPorFinalizado($codPedido);
		return($retorno);
	}
	
	//------------------------------------------
	//	Indicamos que el email de aviso de un pedido ya se ha enviado
	//------------------------------------------
	public function pedidoEmailEnviado(){
		return(static::darPedidoEmailEnviado($this));
	}
	public static function darPedidoEmailEnviado($codPedido){
		//Si hemos recibido un objeto pedido, extraemos el código:
		$mc_pedcli = NULL;
		if (is_a($codPedido, 'PedidoCliente')){
			$mc_pedcli = $codPedido;
			$codPedido = $codPedido->codigo;
		}
		$retorno = false;
		$sentencia_sql = 'UPDATE `mc_pedcli` SET `emailEnviado` = 1 WHERE `codigo` = \'' . $codPedido . '\'; ';
		$bd = new BaseDatos();
		$bd->setConsultaSQL($sentencia_sql);
		if ($bd->getNumeroFilas() > 0){
			$retorno = true;
		}
		return($retorno);
	}
	
	//------------------------------------------
	//	Actualizamos el stock de los productos de un pedido:
	//------------------------------------------
/*
	public static function SactualizarStockPedido($codigoPedido){
		$obpedido = new PedidoCliente($codigoPedido);
		$obpedido->actualizarStockPedido();
	}
*/
	public function actualizarStockPedido(){
		//include('coumes/globals.php');
		$sentencia_sql = '';
		foreach($this->lineas as $clave => $valor){
			$sentencia_sql .= ' UPDATE articulo SET stock = stock - ' . $valor->cantidad . ' WHERE codigo = \'' . $valor->articulo . '\'; ';
		}
		if ($sentencia_sql != ''){
			$bd = new BaseDatos();
			$bd->setConsultaSQL($sentencia_sql);
		}
	}
	
	//------------------------------------------
	//	Extraemos una lista de pedidos de un cliente
	//------------------------------------------
	public static function getPedidosCliente($cliente = NULL, $pagado = NULL, $pendienteSinlib = NULL, $orden = NULL, $limitar = NULL){
		include('comunes/globals.php');
		$orden = ($orden == NULL) ? ' ORDER BY `' . static::getAlias() . '`.`codigo` DESC ' : '';
		$listaPedidos = array();
		if ($cliente == NULL){
			$cliente = Usuario::logueado();
		}
		if ($cliente != NULL){
			if (is_numeric($cliente)){
				$cliente = new $usuario();
			}
			if (is_a($cliente, 'Usuario')){
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM ' . static::getNombreTabla() . ' 
									WHERE ' . static::getWhereTabla(NULL, $pagado, $cliente->codigo, $pendienteSinlib)
									. $orden . ' ' 
									. $limitar;
				//echo($sentencia_sql);
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					while($fila = $bd->getFila()){
						array_push($listaPedidos, new PedidoCliente(new OpcionesWidget(array('filaPedido' => $fila))));
					}
				}
			}				
		}
		return($listaPedidos);
	}
	
	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

	public static function newOrderFromCart($objetoCesta){
		$retorno = NULL;
		//Si el objeto de la cesta no está listo para pedir, no seguimos:
		//echo("-----------Comprobación-------------");
		$ready = $objetoCesta->readyToFinish();
		//echo("Ready es : {$ready}<br/>");
		$objPedido = NULL;
		if ( ( $ready == 200) || ($ready == 201) ){	//Pedro 15/Mayo/2019 ==> 200 es correcto, cualquier otro valor es incorrecto
			//Necesitamos una direccion
				//Pedro 27/Mayo/2019 ==> Cogemos la dirección de la cesta y NO del cliente
			//$direccion = $objetoCesta->objeto_cliente->getCurrentDirection();
			$direccion = $objetoCesta->getCurrentShippingDestination();
			//Cogemos el tipo de envío y la forma de pago
				//Pedro 27/05/2019 ==> El objeto "tipo_envio" está ya en la cesta, lo cogemos de ahí
			//$tipo_envio = Sesion::get('tipo_envio'); //TODO ==> Hay que cogerlo del objeto de la cesta
			//$obTipoEnvio = new TipoEnvioCliente($tipo_envio);
			//$obTipoEnvio = $objetoCesta->objeto_tipo_envio;
			//vamos a ver si este pedido está pendiente de ser exportado (siempre que no haya que pagarlo por pasarela):
			//$pendienteSinlib = ($obTipoEnvio->pasarela > 0) ? 0 : 1;
				//Pedro 27/Mayo/2019 ==> Cuando un pedido se inserta, se pone automáticamente "pendiente sinlib"
			//No necesitamos comprobaciones, Vamos a inicializar los valores a insertar en la tabla:
			$camposInsert = ' '
				. '`cliente`, '
				. '`nombre_legal`, '
				. '`email`, '
				. '`direccion`, '
				. '`cod_postal`, '
				. '`localidad`, '
				. '`provincia`, '
				. '`telefono`, '
				. '`telefono2`, '
				. '`cif`, '
				. '`pais`, '
				. '`pendiente_sinlib`, '
				. '`pagado`, '
				. '`tipo_envio`, '
				. '`forma_pago`, '
				. '`cliente_sinlib`, '
				. '`g_envio`, '
				. '`numero_pedido` ';
			$valoresInsert = ' '
			. '\'' . $objetoCesta->cliente . '\', '
			. '\'' . $direccion->nombre . '\', '
			. '\'' . $objetoCesta->objeto_cliente->email . '\', '
			. '\'' . $direccion->direccion . '\', '
			. '\'' . $direccion->cod_postal . '\', '
			. '\'' . $direccion->localidad . '\', '
			. '\'' . $direccion->provincia . '\', '
			. '\'' . $direccion->telefono . '\', '
			. '\'' . $objetoCesta->objeto_cliente->telefono2 . '\', '
			. '\'' . $objetoCesta->objeto_cliente->cif . '\', '
			. '\'' . $objetoCesta->objeto_cliente->pais . '\', '
			. '\'1\', '	//Pendiente Sinlib siempre 1
			. '\'0\', '	//Pagado
			. '\'' . $objetoCesta->tipo_envio . '\', '
			. '\'' . $objetoCesta->forma_pago . '\', '
			. '\'' . $objetoCesta->objeto_cliente->codigo_sinlib . '\', '
			. '\'' . $objetoCesta->shippingCosts() . '\', '	//Gastos de envío
			. '\'' . $objetoCesta->numero_pedido . '\' ';	//Número de pedido que se ha utilizado en la pasarela

			//Generamos una sentencia para insertar los valores en la tabla de pedidos:
			$sentenciaInsert = ' INSERT INTO `mc_pedcli` (' . $camposInsert . ') values (' . $valoresInsert . ');';
			//echo("$sentenciaInsert<br>\n");
			$codigoPedido = '';
			//Hagamos la insert y cojamos el código:
			$bd = new BaseDatos();
			if ($bd->isConectado()){
					$bd->setConsultaSQL($sentenciaInsert);
				/*
					//11/Enero/2019 ==> Esto no funciona pues ya no hay código autonumérico en la tabla. Es por ello que vamos a cargar en este preciso instante el último pedido
					//creado por este cliente
					$codigoPedido = $bd->getAutonumerico('mc_pedcli');
					//echo("\nEl último código insertado es: $codigoPedido.\n");
				*/
				//Pedro 28/Noviembre/2019 ==> Vamos a cargar el código de pedido desde el número de pedido
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . ' 
								WHERE ' . static::getWhereTabla(NULL, NULL, NULL, NULL, $objetoCesta->numero_pedido);
				//echo("$sentencia_sql<br>\n");
				$bd->setConsulta($sentencia_sql);
				if ($fila = $bd->getFila()){
					$codigoPedido =  static::sGetProp($fila, 'codigo');
				}
			}
			if ($codigoPedido != ''){
				//Si tenemos código de pedido vamos a generar una insert global como dios manda:
				$valoresLineas = '';
				$camposLineas = '';
				$coma = '';
				foreach ($objetoCesta->lineas as $clave => $linea){

					  $valoresLineas .= $coma . ' ( '
					  . '\'' . $codigoPedido . '\','
					  . '\'' . $linea->articulo . '\','
					  . '\'' . $linea->cantidad . '\','
					  . '\'' . $linea->pvp_unitario . '\','
					  . '\'0\','	// ==> Cantidad recibida, por defecto es siempre 0
					  . '\'0\','	// ==> Cantidad retirada, por defecto es siempre 0
					  . '\'' . $linea->descuento . '\','
					  . '\'' . $linea->importe_sin_descuento . '\','
					  . '\'' . $linea->importe / $linea->cantidad . '\','
					  . '\'' . $linea->importe . '\','
					  . '\'' . $linea->codigo_lote . '\','
					  . '\'0\','	// ==> Descuento del lote, hay que calcular más tarde
					  . '\'1\''		// ==> Pendiente SINLIB
					  . ' ) ';
					  $coma = ',' . "\n";
					  //Vamos a controlar que haya una oferta, en cuyo caso tenemos que añadir una línea más con precio 
					  //var_dump($linea->oferta);
					  if ($linea->oferta != NULL){
						//Pedro 30/Julio/2019 ==> Hay que tener en cuenta las unidades de regalo, por eso dividimos
						  $valoresLineas .= $coma . ' ( '
						  . '\'' . $codigoPedido . '\','
						  . '\'' . $linea->articulo . '\','
						  . '\'' . $linea->oferta->cantidad_regalo * ($linea->cantidad / $linea->oferta->cantidad) . '\','
						  . '\'' . $linea->pvp_unitario . '\','	//Pedro 17/Julio/2019 ==> Guardamos la línea con el precio normal y el DTO al 100%
						  . '\'0\','	// ==> Cantidad recibida, por defecto es siempre 0
						  . '\'0\','	// ==> Cantidad retirada, por defecto es siempre 0
						  . '\'100\','
						  . '\'' . $linea->importe_sin_descuento . '\','
						  . '\'0\','	// ==> Importe unitario
						  . '\'0\','	// ==> importe
						  . '\'0\','	// ==> lote
						  . '\'0\','	// ==> Descuento del lote, hay que calcular más tarde
						  . '\'1\''		// ==> Pendiente SINLIB
						  . ' ) ';
					  }
				}
				if ($valoresLineas != ''){
					$camposLineas = ''
						. ' `mc_pedcli`, '
						. ' `articulo`, '
						. ' `cantidad`, '
						. ' `pvp`, '
						. ' `recibida`, '
						. ' `retirada`, '
						. ' `descuento`, '
						. ' `importe`, '
						. ' `pvp_con_dto`, '
						. ' `importe_con_dto`, '
						. ' `lote`, '
						. ' `dto_lote`, '
						. ' `pendiente_sinlib` ';
				}
				
				$sentenciaInsert = ' INSERT INTO `ml_pedcli` (' . $camposLineas . ') values ' . $valoresLineas . ';';
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentenciaInsert);
				}
				$objPedido = new PedidoCliente($codigoPedido);
				//Vaciamos el carrito:
				CabeceraCesta::remoteDeleteCart(); // ==> para las pruebas no borramos
				//envia_email_pedido($codigoPedido, "email_pedido");
				//Vamos a enviar dos emails, uno al cliente:
				Email::sendMail(new OpcionesWidget(array(
									'destinatario' => $objetoCesta->objeto_cliente->email . ',' . $direccion->nombre, 
									'asunto' => 'Confirmación de pedido en la web ' . Shop::$empresa->nombre . '(' . Shop::$configuracion->url . ')', 
									'contenido' => $objPedido,
									'templateFile' => 'email_pedido_cliente.php')));
				Email::sendMail(new OpcionesWidget(array(
									'destinatario' => Shop::$empresa->email_empresa . ',' . Shop::$empresa->nombre_legal,
									//'destinatario' => $objetoCesta->objeto_cliente->email . ',' . $direccion->nombre,
									'asunto' => 'Hemos recibido un pedido de: ' . $direccion->nombre . '(' . $objetoCesta->objeto_cliente->email . ')', 
									'contenido' => $objPedido,
									'templateFile' => 'email_pedido_empresa.php')));
				
				//Si hay que actualizar el stock, lo hacemos: 
				if(Shop::$configuracion->controlar_stock){
					$objPedido->actualizarStockPedido();
				}
			}
		}
		return($objPedido);
	}
	
	public static function associateEmptyClientsCode(){
		$sentencia_sql = 'UPDATE `mc_pedcli` `pedidos_cliente` SET `cliente_sinlib` = 
								( SELECT `codigo_sinlib` FROM `cliente` WHERE `cliente`.`codigo` = `pedidos_cliente`.`cliente` LIMIT 1) 
							WHERE `mc_pedcli`.`cliente_sinlib` = 0';
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
		}
	}
	
	public static function getCount($cliente = NULL, $pagado = NULL, $pendienteSinlib = NULL){
		$total = 0;
		if ($cliente == NULL){
			$cliente = Usuario::logueado();
		}
		if ($cliente != NULL){
			if (is_numeric($cliente)){
				$cliente = new $usuario();
			}
			if (is_a($cliente, 'Usuario')){
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM ' . static::getNombreTabla() . ' 
									WHERE ' . static::getWhereTabla(NULL, $pagado, $cliente->codigo, $pendienteSinlib);
				//echo($sentencia_sql);
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$total = $bd->getNumeroFilas();
				}
			}
		}
		return($total);
	}
	
	//Estos van a aser los "array filter" que uso para obtener, de la cesta, las líneas con y sin lote:
	public static function sin_lotes($valor){
		$return = false;
		if (is_a($valor, 'LineaPedidoCliente')){
			if ($valor->cod_lote == 0){
				$return = true;
			}
		}
		return($return);
	}
	public static function con_lotes($valor){
		$return = false;
		if (is_a($valor, 'LineaPedidoCliente')){
			if ($valor->cod_lote > 0){
				$return = true;
			}
		}
		return($return);
	}
	
	//Tratamiento de lotes:
	public function addLote($lote){
		$return = false;
		if (is_numeric($lote)){
			$lote = new Lote($lote);
		}
		if (is_a($lote, 'Lote')){
			$cod_lote = $lote->codigo;
			if (!isset($this->lotes[$cod_lote])){
				$this->lotes[$cod_lote] = $lote;
				$return = true;
			}
		}
		returN($return);
	}
	
	public function getLote($lote){
		$return = NULL;
		if (is_a($lote, 'Lote')){
			$lote = $lote->codigo;
		}
		if (is_numeric($lote)){
			if (!isset($this->lotes[$lote])){
				$return = $this->lotes[$lote];
			}
		}
		return($return);
	}
	
	public function removeLote($lote){
		$return = false;
		if (is_a($lote, 'Lote')){
			$lote = $lote->codigo;
		}
		if (is_numeric($lote)){
			if (isset($this->lotes[$lote])){
				unset($this->lotes[$lote]);
				$return = true;
			}
		}
		return($return);
	}
	
	//25/Noviembre/2019 Métodos mágicos que voy a utilizar para cuando se serializa/desserializa esto
	public function __sleep(){
		return(array(
		'codigo', 'cliente', 'nombre_legal', 'email', 'direccion', 'cod_postal', 'localidad', 'provincia', 'telefono', 'telefono2', 'cif', 'pendiente_sinlib',
		'fecha', 'fecha_date_format', 'cadena_fecha', 'fecha_pago', 'fecha_envio', 'pagado', 'referencia', 'enviado', 'observaciones', 'codigo_tipo_envio', 'no_revisado',
		'pedido_preparado', 'pais', 'datos_facturacion', 'factura', 'descuento', 'envolver_regalo', 'comercial', 'g_envio', 'forma_pago', 'pendiente_paypal', 'oculto', 
		'forma_pago_nombre', 'tipo_envio_nombre', 'reembolso', 'transferencia', 'sin_pago', 'cuenta_bancaria', 'cantidad_total', 'cantidad_pendiente', 'cantidad_reservada',
		'total_pvp', 'base', 'total_pvp_pendiente', 'total_pvp_reservado', 'total_pvp_con_dto', 'total_pvp_con_dto_pendiente', 'total_pvp_con_dto_reservado', 'importe_total',
		'importe_total_pendiente', 'importe_total_reservado', 'lineas', 'tipo_pasarela', 'emailEnviado', 'numero_pedido'
		));
	}
	public function __wakeup (){
		//TODO ==> hay que cargar el objeto tipo de envío así como el array de lotes asociados
	}
}

?>