<?php

/*
  Clase SuperConfigFiles
  @version 1.1
 */
 
 //Modificada por Pedro el 31/Enero/2019 ==> Esta clase va a ser capaz de realizar el control del timestamp
 // por ella sola
class SuperConfigFile extends BasicObject{

	private $name = '';
	private $path = _WS_DYNAMIC_DIR_ . 'ConfigFiles/';
		
	public function setName($name = ''){
		$this->name = $name;
	}

	
    //Constructor y destructor
    public function __construct() {
		
		//Vamos a recibir los parámetros:
		$numargs = func_num_args();
		$this->setName(($numargs >= 1) ? func_get_arg(0) : '');
		$cargar = ($numargs >= 2) ? func_get_arg(1) : true;
		$newPath = ($numargs >=3) ? func_get_arg(2) : '';
		
		if ($newPath != ''){
			$this->path = _WS_DYNAMIC_DIR_ . $newPath . ((substr($newPath, -1, 1) != '/' )? '/' : '');
		}
		
		
		//Lo último es cargar los datos del objeto
		if ($cargar){
			$this->load();
		}
		
		//Ejecutamos el constructor
		parent::__construct(...func_get_args());
    }

    public function __destruct() {
        
    }
	
	public function getRealNamePath(){
		return($this->path . crc32($this->name));
	}
	
	//Vamos a proteger los parámetros privados:
	public function __set($name, $value){
		$retorno = false;
		$valoresNoPermitidos = array('name', 'path', 'realFilePath');
		if (!in_array($name, $valoresNoPermitidos)){
			parent::__set($name, $value);
		}
		return($retorno);
	}

	public function save(){
		$retorno = false;
		//Abrimos el fichero para guardar:
		$path = $this->path . crc32($this->name);
		if ($file = fopen($path, 'w')){
			fwrite($file, serialize($this));
			$retorno = true;
		}else{
			echo("<br />Error al abrir el fichero " . $path);
		}
		return($retorno);
	}
	
	public function load(){
		$retorno = false;
		/*if ($file = fopen(_WS_DIR_ . 'test.txt', 'a+')){
			fputs($file, 'guardamos: ' . $this->path . $this->name . "\n");
			fclose($file);
		}*/
		$file_name = $this->path . crc32($this->name);
		if (file_exists($file_name)){
			$content = file_get_contents($file_name);
			//Desserializamos el contenido:
			if ($content = unserialize($content)){
				//si es un objeto del tipo "ConfigFile vamos a insertarlo:
				if (is_a($content, 'ConfigFile')){
					$list_fields = get_object_vars($content);
					foreach($list_fields as $clave => $valor){
						$this->$clave = $valor;
					}
					$retorno = true;
				}
			}
		}
		return($retorno);
	}

}
