<?php

//---------------------------------------------------------------------------------------------------------
// 13/Febrero/2015
// Versión 1.0 Con este widget gesionamos la información referente a un pedido ya hecho
//---------------------------------------------------------------------------------------------------------



function widget_filtrado() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'filtrado';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function filtrado($array_campos = array('autor', 'editorial', 'stock_disponible', 'pvp', 'tipo', 'texto'), $objeto_contenedor = NULL, $maxElements = 5) {
    $ocultarCabecera = false;
    if (($array_campos != NULL) && (is_a($array_campos, "OpcionesWidget"))) {
        $opciones = $array_campos;
        $array_campos = array('autor', 'editorial', 'stock_disponible', 'pvp', 'tipo', 'texto');
        $objeto_contenedor = NULL;
        $maxElements = 5;
        if (is_a($opciones, 'OpcionesWidget')) {
            $array_campos = ($opciones->configuracion->array_campos != NULL) ? $opciones->configuracion->array_campos : $array_campos;
            $objeto_contenedor = ($opciones->configuracion->objeto_contenedor != NULL) ? $opciones->configuracion->objeto_contenedor : $objeto_contenedor;
            $maxElements = ($opciones->configuracion->maxElements != NULL) ? $opciones->configuracion->maxElements : $maxElements;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }
    if (is_a($objeto_contenedor, 'Escaparate') || is_a($objeto_contenedor, 'Busqueda')) {
        $elementos_permitidos = array('autor', 'editorial'); //El pvp no se hace con el bucle, se hace a parte
        include('comunes/globals.php');

        //Las clases "escaparate" y búsqueda contienen las select originales que dieron lugar a dicho escaparate/búsqueda
        //A partir de esa select y los campos que nos han pasado, vamos a generar los group by
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
            }
            ?>
            <?php
			//Vamos a empezar por los campos asociados de manera directa en la tabla de artículos (editorial, autor)
            foreach ($array_campos as $clave => $valor) {
                if (in_array($valor, $elementos_permitidos)) {
					$nueva_select = 'SELECT `' .Articulo::getAlias() . '`.`' . $valor . '`, count(`' .Articulo::getAlias() . '`.`' . $valor . '`) totales '
					. ' FROM ' . $objeto_contenedor->nombreTablas
					. ' WHERE ' . $objeto_contenedor->whereTabla
					. ( ($objeto_contenedor->filtrado_global != '') ? ' AND ' . $objeto_contenedor->filtrado_global : '' )
					. ' GROUP BY `' . Articulo::getAlias() . '`.`' . $valor . '` HAVING `' . Articulo::getAlias() . '`.`' . $valor . '` != \'\''
					. ' ORDER BY totales DESC LIMIT 0, ' . $maxElements;
                    if ($conexionBD) {
                        ?>
                        <form class="filtrado_<?= $valor; ?>" action="javascript:void(0)">
                            <p><?= traducir('Filtrar por'); ?> <?= $valor; ?></p>
                            <?php
                            if ($resultado = mysqli_query($conexionBD, $nueva_select)) {
                                while ($fila = mysqli_fetch_array($resultado)) {
                                    //Vamos a ver si el check tiene que estar marcado o no
                                    $checked = '';
                                    //echo(strtolower($filtrado_actual) . "----" . strtolower(str_replace(" ", "_", $fila[$valor])) . "<br />\n");
                                    if (strpos(strtolower($filtrado_actual), strtolower(str_replace(" ", "_", $fila[$valor]))) !== false) {
                                        $checked = 'checked="checked"';
                                    }
                                    ?>
                                    <fieldset class="filtrar_<?= strtolower(str_replace(" ", "_", $valor)); ?>" id="fieldset_<?= strtolower(str_replace(" ", "_", $fila[$valor])); ?>" >
                                        <input type="checkbox" name="filtrar_<?= strtolower(str_replace(" ", "_", $valor)); ?>" class="filtrar_<?= strtolower(str_replace(" ", "_", $valor)); ?>" value="<?= $fila[$valor]; ?>" id="check_<?= strtolower(str_replace(" ", "_", $fila[$valor])); ?>" <?= $checked; ?>/>
                                        <label class="filtrar_<?= strtolower(str_replace(" ", "_", $valor)); ?>" id="label_<?= strtolower(str_replace(" ", "_", $fila[$valor])); ?>" onClick="$(this).siblings('input[type=checkbox]').trigger('click');"><?= $fila[$valor]; ?> <span class="cantidad">(<?= $fila["totales"]; ?>)</span></label>
                                    </fieldset>	
                                    <?php
                                }
                            }
                            ?>
                        </form>
                        <?php
                    }
                }
            }
            //Filtrado por tipo de artículo
            if (in_array('tipo', $array_campos)) {
                $checked_libros = '';
                $checked_papeleria = '';
                if (strpos(strtolower($filtrado_actual), 'tipo_articulo:libros-papeleria') !== false) {
                    $checked_libros = 'checked="checked"';
                    $checked_papeleria = 'checked="checked"';
                } else if (strpos(strtolower($filtrado_actual), 'tipo_articulo:libro') !== false) {
                    $checked_libros = 'checked="checked"';
                } elseif (strpos(strtolower($filtrado_actual), 'tipo_articulo:papeleria') !== false) {
                    $checked_papeleria = 'checked="checked"';
                }
                ?>
                <form class="filtrado_tipo_arti" action="javascript:void(0)">
                    <fieldset class="filtrado_tipo_arti">
                        <input type="checkbox" class="filtrar_tipo_articulo" <?= $checked_libros; ?> name="filtrar_tipo_articulo" value="libros" id="check_libros"/>
                        <label class="ver_solo_libros"><?= traducir("Libros"); ?></label>
                        <input type="checkbox" class="filtrar_tipo_articulo" <?= $checked_papeleria; ?> name="filtrar_tipo_articulo" value="papeleria" id="check_papeleria"/>
                        <label class="ver_solo_papeleria"><?= traducir("Papelería"); ?></label>
                    </fieldset>
                </form>
                <?php
            }

            //filtrado por Letra nombre
            if (in_array('primeraLetra_nombre', $array_campos)) {
                //Filtrado por Primera letra del nombre del articulo
                $letras; // Creamos un array con las letras con un hueco para simbolos y numeros.
                $letras['#'] = 0;
                $letras['0-9'] = 0;
                for ($letra = ord('A'); $letra <= ord('Z'); $letra++) {
                    if ($conexionBD) {
                        $sentencia_sql = 'SELECT codigo FROM  `articulo` WHERE ( nombre LIKE ' . "'" . chr($letra) . "%')";
                        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                            $letras[chr($letra)] = mysqli_num_rows($resultado);
                        }
                    }
                    if (chr($letra) == "N") {
                        $letras["Ñ"] = 0;
                    }
                }
                $letra_select = '';
                if ($filtrado_actual) {
                    $tmp = explode(':', $filtrado_actual);
                    //var_dump($tmp);
                    $letra_select = $tmp[1];
                }
                foreach ($letras as $key => $valor) {
                    ?>
                    <form class="filtrado_primeraLetra_nombre" action="javascript:void(0)">
                        <fieldset class="fieldset_filtrado_letra <?= ( $valor > 0) ? 'letra_visible' : 'letra_invisible'; ?> <?= ($key == $letra_select) ? 'letra_seleccionada' : ''; ?> ' <?= ( $valor > 0) ? '' : 'disabled'; ?>>
                                  <label class="label_letra" for="check_<?= $key ?>"><?= $key ?></label><span class="numero_letra">(<?= $valor ?>)</span>
                            <input type="checkbox" class="filtrar_primeraLetra_nombre" name="primeraLetra_nombre" value="<?= $key ?>" id="check_<?= $key ?>"/>
                        </fieldset>
                    </form>
                    <?php
                }
            }
            //Filtrado por AUTOR
            if (in_array('primeraLetra_autor', $array_campos)) {
                //Filtrado por Primera letra del nombre del autor
                $letras; // Creamos un array con las letras con un hueco para simbolos y numeros.
                //Primero buscamos los numeros y los caracteres raros pero entendemos que los autores no vana a empezar por caracteres raros.
                $letras['#'] = 0;
                //
                $sentencia_sql = 'SELECT codigo, autor FROM  `articulo` WHERE  autor regexp "^[0-9](.*)"';
                if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                    $letras['0-9'] = mysqli_num_rows($resultado);
                } else {
                    $letras['0-9'] = 0;
                }

                for ($letra = ord('A'); $letra <= ord('Z'); $letra++) {
                    $letras[chr($letra)] = 0;
                    if ($conexionBD) {
                        $sentencia_sql = 'SELECT codigo FROM  `articulo` WHERE ( autor LIKE ' . "'" . chr($letra) . "%') AND  no_web = 0 AND stock > 0 AND ean != '' ";
                        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                            $letras[chr($letra)] = mysqli_num_rows($resultado);
                        }
                    }
                    if (chr($letra) == 'N') {
                        $letras['Ñ'] = 0;
                    }
                }
                $letra_select = '';
                if ($filtrado_actual) {
                    $tmp = explode(':', $filtrado_actual);
                    //var_dump($tmp);
                    $letra_select = $tmp[1];
                }
                foreach ($letras as $key => $valor) {
                    ?>
                    <form class="filtrado_primeraLetra_autor" action="javascript:void(0)">
                        <fieldset class="fieldset_filtrado_letra <?= ( $valor > 0) ? 'letra_visible' : 'letra_invisible'; ?> <?= ($key == $letra_select) ? 'letra_seleccionada' : ''; ?> " <?= ( $valor > 0) ? '' : 'disabled'; ?>>
                            <label class="label_letra" for="check_<?= $key ?>"><?= $key ?></label><span class="numero_letra">(<?= $valor ?>)</span>
                            <input type="checkbox" class="filtrar_primeraLetra_autor" name="primeraLetra_autor" value="<?= $key ?>" id="check_<?= $key ?>"/>
                        </fieldset>
                    </form>
                    <?php
                }
            }
            //Filtrado por stock
            if (in_array('stock_disponible', $array_campos)) {
                ?>
                <form class="filtrado_stock" action="javascript:void(0)">
                    <?php
                    //Vamos a controlar si hay precio y qué precio hay
                    $checked = "";
                    if (strpos(strtolower($filtrado_actual), 'stock_disponible') !== false) {
                        $checked = 'checked="checked"';
                    }
                    ?>
                    <p><?= traducir("Stock"); ?></p>
                    <fieldset class="filtrado_stock_disponible">
                        <input type="checkbox" name="filtrar_stock_disponible" class="filtrar_stock_disponible" value="filtrar_stock_disponible" <?= $checked; ?>/>
                        <label class="desde_pvp"><?= traducir('Sólo con stock'); ?></label>
                    </fieldset>
                </form>
                <?php
            }

            //Si hay que hacer el filtrado por pvp entonces utilizamos otra fórmula
            if (in_array('pvp', $array_campos)) {
                ?>
                <form class="filtrado_pvp" action="javascript:void(0)">
                    <?php
                    //Vamos a controlar si hay precio y qué precio hay
                    $cadena_desde = '';
                    $cadena_hasta = '';
                    if (strpos($filtrado_actual, 'pvp') !== false) {
                        //Vamos a dividir la cadena en dos:
                        $cadena_filtro = explode('pvp:', $filtrado_actual);
                        if ($cadena_filtro[1] != '') {
                            $cadena_filtro = explode('-', $cadena_filtro[1]);
                            if ((floatval($cadena_filtro[0]) <= floatval($cadena_filtro[1])) && ( floatval($cadena_filtro[0] > 0) || floatval($cadena_filtro[1] > 0))) {
                                $cadena_desde = $cadena_filtro[0];
                                $cadena_hasta = $cadena_filtro[1];
                            }
                        }
                    }
                    ?>
                    <p><?= traducir('Precio'); ?></p>
                    <fieldset class="desde_pvp">
                        <label class="desde_pvp"><?= traducir('desde'); ?></label>
                        <input class="desde_pvp" name="desde_pvp" value="<?= ($cadena_desde != '') ? number_format($cadena_desde, 2) : ''; ?>" type="number" step="any" min="0"/>
                    </fieldset>
                    <fieldset class="hasta_pvp">
                        <label class="hasta_pvp"><?= traducir('hasta'); ?></label>
                        <input class="hasta_pvp" name="hasta_pvp" value="<?= ($cadena_desde != "") ? number_format($cadena_hasta, 2) : ''; ?>" type="number" step="any" min="0"/>
                    </fieldset>
                    <a href="javascritp:void(0);" class="eliminar_filtro_precio" title="Eliminar fitrado de precio">x</a>
                    <input type="submit" value="<?= traducir('filtrar'); ?>" />
                </form>
                <?php
            }
            //Filtrado por edad (de momento fija de 0 a 16 años
            if (in_array("edad", $array_campos)) {
                $cadena_filtro = '-1';
                ?>
                <form class="filtrado_edad" action="javascript:void(0)">
                    <?php
                    if (strpos($filtrado_actual, 'edad') !== false) {
                        //Vamos a dividir la cadena en dos:
                        $cadena_filtro = explode('edad:', $filtrado_actual);
                        if ($cadena_filtro[1] != '') {
                            $cadena_filtro = explode('/', $cadena_filtro[1]);
                            $cadena_filtro = $cadena_filtro[0];
                        } else {
                            $cadena_filtro = 'no';
                        }
                    }
                    ?>
                    <fieldset>
                        <select class="filtrar_edad" name="filtrar_edad">
                            <?php
                            $txt_opcion0 = traducir('Seleccionar edad');
                            if ($cadena_filtro != '-1') {
                                $txt_opcion0 = traducir('No filtrar');
                            }
                            ?>
                            <option value="no" <?= ($cadena_filtro == "-1") ? 'selected="selected"' : ""; ?>><?= $txt_opcion0; ?></option>
                            <?php
                            $sentencia_sql = 'SELECT edad_inicial, edad_final, comentario FROM rango_edad ORDER BY edad_inicial ASC, edad_final ASC';
                            if ($conexionBD) {
                                if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                                    while ($fila = mysqli_fetch_array($resultado)) {
                                        //Vamos a redondear la edad
                                        $edad_inicial = $fila['edad_inicial'];
                                        $edad_final = $fila['edad_final'];
                                        $cad_rango_edad = $edad_inicial . '-' . $edad_final;
                                        $palabra = 'año' . ( (floor($edad_final) != 1) ? 's' : '' );
                                        //Si hay decimales, la magnitud se expresa en meses:
                                        if (($edad_inicial - floor($edad_inicial)) > 0 || ($edad_final - floor($edad_final)) > 0) {
                                            $edad_inicial = $edad_inicial * 12;
                                            $edad_final = $edad_final * 12;
                                            $palabra = 'mes' . ( (floor($edad_final) != 1) ? 'es' : '' );
                                        }
                                        $cad_rango_edad_usuario = 'De ' . floor($edad_inicial) . ' a ' . floor($edad_final) . ' ' . $palabra;
                                        ?>
                                        <option value="<?= $cad_rango_edad; ?>" <?= ($cadena_filtro == $cad_rango_edad) ? 'selected="selected"' : ""; ?>><?= $cad_rango_edad_usuario . " " . (($fila["comentario"] != "") ? $fila["comentario"] : ""); ?></option>
                                        <?php
                                    }
                                }
                            }
                            ?>
                        </select>
                        <script type="text/javascript">
						document.addEventListener('WSLE', function(event) {
                            ;(function () {
                                //Recogemos el elemento inmediatamente anterior a este script
                                var elementObjetive = getLastHtmlObject();
                                var formulario = elementObjetive.closest("form");
                                //console.log(elementObjetive, formulario);
                                elementObjetive.on("change", function () {
                                    formulario.submit();
                                });
                            }());
						});
                        </script>
                    </fieldset>
                </form>
                <?php
            }
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
            </div>
            <?php
        }
        ?>
        <script type="text/javascript">
		document.addEventListener('WSLE', function(event) {
            ;(function () {
                //Recogemos el elemento inmediatamente anterior a este script
                var elementObjetive = getLastHtmlObject();
        <?php
        $url_completa = $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    //Quitamos la paginación que tenga dicha URL
        $url_completa = preg_replace('/-p(\d*)/', '', $url_completa);
        ?>
                var currentURL = ('http://<?= $url_completa; ?>').split("/filtrado")[0];
                elementObjetive.find("a.eliminar_filtro_precio").on("click", function (event) {
                    event.preventDefault();
                    elementObjetive.find("input[name='desde_pvp']").val("0.00");
                    elementObjetive.find("input[name='hasta_pvp']").val("0.00");
                    componer_cadena_redirigir(currentURL);
                });
                elementObjetive.find("form.filtrado_pvp").find("input[type=number]").on("blur", function (event) {
                    var valor = $(this).val();
                    if (valor != "") {
                        valor = number_format(parseFloat(valor.replace(",", ".")), 2, ".");
                        //Hacemos un number format
                        $(this).val(valor);
                    }
                });
                elementObjetive.find("form.filtrado_pvp").on("submit", function (event) {
                    event.preventDefault();
                    componer_cadena_redirigir(currentURL);
                });

                elementObjetive.find("input[type=checkbox]").on("click", function (event) {
                    componer_cadena_redirigir(currentURL);
                });
                elementObjetive.find("form.filtrado_edad").on("submit", function (event) {
                    event.preventDefault();
                    componer_cadena_redirigir(currentURL);
                });
            }());
		});
        </script>
        <?php
    }
    return(true);
}

//Vamos a añadir aquí los filtrados personalizados. Cada filtrado tiene su tipo:
function filtro_edad($opciones = NULL) {
    include('comunes/globals.php');

    //Inicializamos variables:
    $ficheroElemento = 'filtroEdad';
    $extraParams = NULL;

    //Nos aseguramos de que opciones sea un "opcionesWidget"
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    //Seteamos las variables en función de "opciones" y su valor por defecto

    if (is_a($opciones, 'OpcionesWidget')) {
        $ficheroElemento = ($opciones->configuracion->ficheroElemento != NULL) ? $opciones->configuracion->ficheroElemento : $ficheroElemento;
        $extraParams = ($opciones->configuracion->extraParams != NULL) ? $opciones->configuracion->extraParams : $extraParams;
    }

    //Variables que ponemos a disposición del usuario:
    $urlFiltro = $url_sin_parametros . '*edad:no/';
    $cadenaFiltro = 'Todas las edades';
    $comentario = 'Todas las edades';
    $indiceElemento = 0;
    $codigoElemento = 0;
    $actual = false;

    //Vamos a cargar los filtros que hay para hacer el include:
    $rutaFicheroPerso = Theme::findFile($ficheroElemento . '.php');
    if ($rutaFicheroPerso != NULL) {
        //Incluimos el primero que es para quitar los filtros:
        include($rutaFicheroPerso);
        //controlamos el filtrado que se esté ejecutando ahora mismo:
        if (strpos($filtrado_actual, 'edad') !== false) {
            //Vamos a dividir la cadena en dos:
            $cadena_filtro = explode('edad:', $filtrado_actual);
            if ($cadena_filtro[1] != '') {
                $cadena_filtro = explode('/', $cadena_filtro[1]);
                $cadena_filtro = $cadena_filtro[0];
            } else {
                $cadena_filtro = 'no';
                $actual = true;
            }
        }
        $sentencia_sql = 'SELECT codigo, edad_inicial, edad_final, comentario FROM rango_edad ORDER BY edad_inicial ASC, edad_final ASC';
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                while ($fila = mysqli_fetch_array($resultado)) {
                    $indiceElemento++;
                    //Vamos a redondear la edad
                    $edad_inicial = $fila['edad_inicial'];
                    $edad_final = $fila['edad_final'];
                    $cad_rango_edad = $edad_inicial . '-' . $edad_final;
                    $palabra = 'año' . ( (floor($edad_final) != 1) ? 's' : '' );
                    //Si hay decimales, la magnitud se expresa en meses:
                    if (($edad_inicial - floor($edad_inicial)) > 0 || ($edad_final - floor($edad_final)) > 0) {
                        $edad_inicial = $edad_inicial * 12;
                        $edad_final = $edad_final * 12;
                        $palabra = 'mes' . ( (floor($edad_final) != 1) ? 'es' : '' );
                    }
                    $cadenaFiltro = 'De ' . floor($edad_inicial) . ' a ' . floor($edad_final) . ' ' . $palabra;
                    $comentario = $fila['comentario'];
                    $urlFiltro = $url_sin_parametros . '*edad:' . $cad_rango_edad . '/';
                    $codigoElemento = $fila['codigo'];
                    $actual = ($cad_rango_edad == $cadenaFiltro) ? true : false;
                    //Incluimos el fichero:
                    include($rutaFicheroPerso);
                }
            }
        }
    }

    return(true);
}


//------------------------------------------------------------------
// A partir de ahora, vamos a recomponer los filtrados según se necesiten
//	==>Nos crearemos una función llamada ==> filtrado_<<nombre_campo>>
//------------------------------------------------------------------
function filtrado_editorial($objeto_contenedor = NULL, $maxElements = 5){
	filtrado_campo_articulo('editorial', $objeto_contenedor, $maxElements);
}

function filtrado_fabricante($objeto_contenedor = NULL, $maxElements = 5){
	filtrado_campo_articulo('fabricante', $objeto_contenedor, $maxElements);
}

//Marina(05/Diciembre/2019) Creamos una nueva funcion para el filtrado por autor
function filtrado_autor($objeto_contenedor = NULL, $maxElements = 5){
    filtrado_campo_articulo('autor', $objeto_contenedor, $maxElements);
}

//Marina(11/Diciembre/2019) Creamos una nueva funcion para el filtrado por disponibilidad
function filtrado_stock($objeto_contenedor = NULL){
    //Nos hemos dado cuenta que el filtrado global se tiene que aplicar siempre en la web. Es por eso que aquí lo aplicamos también:
    $objeto_contenedor->filtradoGlobal();

    $nueva_select = 'SELECT `' . Articulo::getAlias() . '`.`codigo` '
    . ' FROM ' . $objeto_contenedor->nombreTablas
    . ' WHERE ' . $objeto_contenedor->whereTabla
    . ( ($objeto_contenedor->filtrado_global != '') ? ' AND ' . $objeto_contenedor->filtrado_global : '' )
    . ' AND stock > 0;';

    $total_articulos = 0;
    $bd = new BaseDatos();
    if ($bd->isConectado()){
        $bd->setConsultaSQL($nueva_select);
        $total_articulos = $bd->getNumeroFilas();
        ?>
        <div class="contenedor_principal_filtrados">
            <div class="contenedor_filtrados">
                <div class="formularios_filtrado">
                    <form class="filtrado_stock" action="javascript:void(0)">
                        <?php
                        //Marina(12/diciembre/2019)esta parte comprueba si hemos filtrado por stock para mantener checkeado el campo en el filtrado
                            $checked = '';
                            //si existe el campo stock en el array filtros y a su vez es un array procedemos a recorrerlo 
                            if (isset($objeto_contenedor->array_filtro['stock']) && 
                                (is_array($objeto_contenedor->array_filtro['stock']))){
                                //recorremos el campo stock del array de filtros
                                foreach($objeto_contenedor->array_filtro['stock'] as $indice => $valorCampoFiltro){
                                    //comprobamos si el valor del campo stock es disponible o disponibles y si es asi marcamos el check 
                                    if ( $valorCampoFiltro == 'disponible' || $valorCampoFiltro == 'disponibles' ){
                                        $checked = 'checked="checked"';
                                    }
                                }
                            }
                            //Vamos a utilizar un contador con una marca de tiempo porque los IDs tienen que ser únicos:
                            $contador = microtime(false);
                            $contador = explode(' ', $contador);
                            $contador = $contador[0];
                            $contador = explode('.', $contador);
                            $contador = $contador[1];
                        ?>
                        <fieldset class="filtrar_stock" id="" >
                            <input type="checkbox" name="filtrar_stock" class="filtrar_stock" value="disponible" id="check_stock_<?=$contador;?>" <?=$checked;?>/>
                            <label class="filtrar_stock" id="label_stock_<?=$contador;?>" for="check_stock_<?=$contador;?>" >Ver solo disponibles</label>
                            <span class="cantidad">(<?=$total_articulos;?>)</span>
                        </fieldset> 
                    </form>
                </div>
            </div>
        </div>
        <?php   
        $cadena_filtro = $objeto_contenedor->getStringFiltrado();
        if ($cadena_filtro != ''){
            if (substr($cadena_filtro, 0, 1) != '/'){
                $cadena_filtro = '/' . $cadena_filtro;
            }
        }
        $url_actual = $objeto_contenedor->url . $cadena_filtro;
        
        $nombre_script = 'script_' . incrementa_contador(true);
        ?>
        <script id="<?=$nombre_script;?>">
            document.addEventListener('WSLE', function(event) {
            ;(function () {
                var elementObjetive = getLastHtmlObject('<?=$nombre_script;?>');
                elementObjetive.find('input[type="checkbox"]').on('change', function(){
                    //console.log($(this).val());
                    //Antes de seguir tenemos que ver si estamos marcando o desmarcando:
                    if ($(this).is(":checked")){
                        var cur_val = $(this).val();
                        cur_val = cur_val.replace(' ', '_');
                        window.location.href = "<?=$url_actual;?>" + "/" + $(this).attr("name") + "=" + cur_val;
                    }else{
                        var cur_val = $(this).val();
                        cur_val = cur_val.replace(' ', '_');
                        var cadena_a_quitar = "/" + $(this).attr("name") + "=" + cur_val;
                        //console.log(cadena_a_quitar);
                        var cur_url = "<?=urldecode($url_actual);?>";
                        //console.log(cur_url);
                        //Hay que quitar de la url actual la cadena que nos indican:
                        window.location.href = cur_url.replace(cadena_a_quitar, '');
                    }
                });
            })();
            });
        </script>
        <?php
    } 
}

//Marina(12/Diciembre/2019) Creamos una nueva funcion para el filtrado por precio
function filtrado_pvp($objeto_contenedor = NULL){
    //Nos hemos dado cuenta que el filtrado global se tiene que aplicar siempre en la web. Es por eso que aquí lo aplicamos también:
    $objeto_contenedor->filtradoGlobal();

    $nueva_select = 'SELECT `' . Articulo::getAlias() . '`.`codigo` '
    . ' FROM ' . $objeto_contenedor->nombreTablas
    . ' WHERE ' . $objeto_contenedor->whereTabla
    . ( ($objeto_contenedor->filtrado_global != '') ? ' AND ' . $objeto_contenedor->filtrado_global : '' )
    . ' AND stock > 0;';

    $total_articulos = 0;
    $bd = new BaseDatos();
    if ($bd->isConectado()){
        $bd->setConsultaSQL($nueva_select);
        $total_articulos = $bd->getNumeroFilas();
        ?>
        <div class="contenedor_principal_filtrados">
            <div class="contenedor_filtrados">
                <div class="formularios_filtrado">
                    <form class="filtrado_stock" action="javascript:void(0)">
                      <b>€ 10</b> <input id="ex2" type="text" class="span2" value="" data-slider-min="10" data-slider-max="1000" data-slider-step="5" data-slider-value="[250,450]"/> <b>€ 1000</b>
                    </form>
                </div>
            </div>
        </div>

        <?php   
        $cadena_filtro = $objeto_contenedor->getStringFiltrado();
        if ($cadena_filtro != ''){
            if (substr($cadena_filtro, 0, 1) != '/'){
                $cadena_filtro = '/' . $cadena_filtro;
            }
        }
        $url_actual = $objeto_contenedor->url . $cadena_filtro;
        
        $nombre_script = 'script_' . incrementa_contador(true);
        ?>
        <script id="<?=$nombre_script;?>">
            document.addEventListener('WSLE', function(event) {
            ;(function () {
                var elementObjetive = getLastHtmlObject('<?=$nombre_script;?>');
                elementObjetive.find('input[type="checkbox"]').on('change', function(){
                    //console.log($(this).val());
                    //Antes de seguir tenemos que ver si estamos marcando o desmarcando:
                    if ($(this).is(":checked")){
                        var cur_val = $(this).val();
                        cur_val = cur_val.replace(' ', '_');
                        window.location.href = "<?=$url_actual;?>" + "/" + $(this).attr("name") + "=" + cur_val;
                    }else{
                        var cur_val = $(this).val();
                        cur_val = cur_val.replace(' ', '_');
                        var cadena_a_quitar = "/" + $(this).attr("name") + "=" + cur_val;
                        //console.log(cadena_a_quitar);
                        var cur_url = "<?=urldecode($url_actual);?>";
                        //console.log(cur_url);
                        //Hay que quitar de la url actual la cadena que nos indican:
                        window.location.href = cur_url.replace(cadena_a_quitar, '');
                    }
                });
            })();
            });
        </script>
        <?php
    } 
}

function filtrado_campo_articulo($nombre_campo, $objeto_contenedor = NULL, $maxElements = 5){
	//Puedo recibir un campo que no existe pero que tiene una traduccion, por ejemplo, editorial <=> fabricante
	$nombre_campo_real = $nombre_campo;
	if ($nombre_campo == 'fabricante'){
		$nombre_campo_real = 'editorial';
	}
	
	//Nos hemos dado cuenta que el filtrado global se tiene que aplicar siempre en la web. Es por eso que aquí lo aplicamos también:
	$objeto_contenedor->filtradoGlobal();
	$nueva_select = 'SELECT `' .Articulo::getAlias() . '`.`' . $nombre_campo_real . '`, count(`' .Articulo::getAlias() . '`.`' . $nombre_campo_real . '`) totales '
	. ' FROM ' . $objeto_contenedor->nombreTablas
	. ' WHERE ' . $objeto_contenedor->whereTabla
	. ( ($objeto_contenedor->filtrado_global != '') ? ' AND ' . $objeto_contenedor->filtrado_global : '' )
	. ' GROUP BY `' . Articulo::getAlias() . '`.`' . $nombre_campo_real . '` HAVING `' . Articulo::getAlias() . '`.`' . $nombre_campo_real . '` != \'\''
	. ' ORDER BY totales DESC ';
	if ($maxElements > 0){
		$nueva_select .= ' LIMIT 0, ' . $maxElements;
	}
	$nueva_select .= '; ';
	$bd = new BaseDatos();
	if ($bd->isConectado()){
		//echo("$this->sentencia_sql<br />\n");
		$bd->setConsultaSQL($nueva_select);
		if ($bd->getNumeroFilas() > 1){
			//Vamos a generar un array que es el que vamos a inicialiar para poder reordenar:
			$listaResultados = array();
			while ($fila = $bd->getFila()) {
				$listaResultados[] = array(
					$nombre_campo_real => $fila[$nombre_campo_real], 
					'totales' => $fila['totales']
				);
			}
			//Mostramos la lista con el orden actual
			mostrar_campo_filtrado($nombre_campo, $listaResultados, $objeto_contenedor, $nombre_campo_real);
		}
	}	
}

function filtrado_escaparate_articulo($objeto_contenedor = NULL, $maxElements = 5){
	$nombre_campo = 'categoria';
	//Componemos la select que me va a dar los artículos diferentes que tenemos en esta select:
	$selectArticulos = 'SELECT DISTINCT `' . Articulo::getAlias() . '`.`codigo` ' //Tenemos que componer aún los campos que vamos a sacar
	. ' FROM ' . $objeto_contenedor->nombreTablas
	. ' WHERE ' . $objeto_contenedor->whereTabla
	. ( ($objeto_contenedor->filtrado_global != '') ? ' AND ' . $objeto_contenedor->filtrado_global : '' );

	//Nos hemos dado cuenta que el filtrado global se tiene que aplicar siempre en la web. Es por eso que aquí lo aplicamos también:
	$objeto_contenedor->filtradoGlobal();
	//Vamos a componer una select que nos de las categorías de esta lista:
	$aliasTraduccion = BaseDatos::$dictionary->{'traducesca' . 'Alias'};
	$aliasCategoriasProductos = BaseDatos::$dictionary->{'categorias_productos' . 'Alias'};
	$nueva_select = 'SELECT `' . $aliasCategoriasProductos . '`.`categoria` as codigo, `' 
		. $aliasTraduccion . '`.`nombre` as nombre ,'
		. ' count(`' . $aliasCategoriasProductos . '`.`categoria`) totales '
		. ' FROM `categorias_productos` as `' . $aliasCategoriasProductos . '`, '
		. ' `traducesca` as `' . $aliasTraduccion . '` '
		. ' WHERE `' . $aliasTraduccion . '`.`escaparate` = `' . $aliasCategoriasProductos . '`.`categoria` '
		. ' AND `' . $aliasCategoriasProductos . '`.`articulo` IN ( ' . $selectArticulos . ' ) '
		. ' GROUP BY `' . $aliasCategoriasProductos . '`.`categoria` '
		. ' ORDER BY totales DESC ';
		
		//echo($nueva_select);
	if ($maxElements > 0){
		$nueva_select .= ' LIMIT 0, ' . $maxElements;
	}
	$nueva_select .= '; ';
	
    //	echo($nueva_select . '<br />');
	
	$bd = new BaseDatos();
	if ($bd->isConectado()){
		//echo("$this->sentencia_sql<br />\n");
		$bd->setConsultaSQL($nueva_select);
		if ($bd->getNumeroFilas() > 1){
			while ($fila = $bd->getFila()) {
				$listaResultados[] = array(
					$nombre_campo => $fila['nombre'], 
					'totales' => $fila['totales']
				);
			}
			//Mostramos la lista con el orden actual
			mostrar_campo_filtrado($nombre_campo, $listaResultados, $objeto_contenedor);
		}
	}
}
function mostrar_campo_filtrado($nombre_campo, $listaResultados, $objeto_contenedor, $nombre_campo_real = NULL){
	$nombre_campo_real = (isset($nombre_campo_real))? $nombre_campo_real : $nombre_campo;
	?>
	<div class="contenedor_principal_filtrados">
	<?php
	for($i = 0; $i < 2; $i++){
	?>
		<input id="selector<?='_' . $nombre_campo . '_'. $i;?>" type="radio" name="<?='_' . $nombre_campo;?>" value="" class="selector<?=$i;?>" <?=($i == 0) ? 'checked="checked"' : '';?>>
		<label for="selector<?='_' . $nombre_campo . '_'. $i;?>"></label>
	<?php
	}
	?>
		<div class="contenedor_filtrados">
			<div class="formularios_filtrado">
	<?php
		//Mostramos el <form> con los input en el orden cargado
		mostrar_inputs_campo_filtrado($nombre_campo, $listaResultados, $objeto_contenedor, $nombre_campo_real);
		//Reordenamos por nombre:
		$listaResultados = ordenarArrayDatos($listaResultados, $nombre_campo_real);
		//Y mostramos el formulario con el nombre
		mostrar_inputs_campo_filtrado($nombre_campo, $listaResultados, $objeto_contenedor, $nombre_campo_real);
	?>
			</div>
		</div>
	</div>
	<?php
	$cadena_filtro = $objeto_contenedor->getStringFiltrado();
	if ($cadena_filtro != ''){
		if (substr($cadena_filtro, 0, 1) != '/'){
			$cadena_filtro = '/' . $cadena_filtro;
		}
	}
	$url_actual = $objeto_contenedor->url . $cadena_filtro;
	
	$nombre_script = 'script_' . incrementa_contador(true);
	?>
	<script id="<?=$nombre_script;?>">
	document.addEventListener('WSLE', function(event) {
		;(function () {
			var elementObjetive = getLastHtmlObject('<?=$nombre_script;?>');
			elementObjetive.find('input[type="checkbox"]').on('change', function(){
				//console.log($(this).val());
				//Antes de seguir tenemos que ver si estamos marcando o desmarcando:
				if ($(this).is(":checked")){
					var cur_val = $(this).val();
					cur_val = cur_val.replace(' ', '_');
					window.location.href = "<?=$url_actual;?>" + "/" + $(this).attr("name") + "=" + cur_val;
				}else{
					var cur_val = $(this).val();
					cur_val = cur_val.replace(' ', '_');
					var cadena_a_quitar = "/" + $(this).attr("name") + "=" + cur_val;
					//console.log(cadena_a_quitar);
					var cur_url = "<?=urldecode($url_actual);?>";
					//console.log(cur_url);
					//Hay que quitar de la url actual la cadena que nos indican:
					window.location.href = cur_url.replace(cadena_a_quitar, '');
				}
			});
		})();
	});
	</script>
	<?php
}

function mostrar_inputs_campo_filtrado($nombre_campo, $listaResultados, $objeto_contenedor, $nombre_campo_real = NULL){
	?>
	<form class="filtrado_<?= $nombre_campo; ?>" action="javascript:void(0)">
		<?php
		//No hacemos esto si sólo hay un elemento (por ejemplo una sola editorial)
	
		//while ($fila = $bd->getFila()) {
		foreach($listaResultados as $clave => $fila){
			//Vamos a ver si el check tiene que estar marcado o no
			$checked = '';
			$valor = $fila[$nombre_campo_real];

			if (isset($objeto_contenedor->array_filtro[$nombre_campo])){
				//Tenemos que ver si en el filtro pecador de la pradera está el valor que tenemos aquí:
				foreach($objeto_contenedor->array_filtro[$nombre_campo] as $indice => $valorCampoFiltro){
					//Vamos a comparar el valor obtenido con el valor que cargo de la tabla, pero haciendo las mismas transformaciones para que sean iguales
					if (str_replace(' ', '_', strtoupper(urldecode($valorCampoFiltro))) == str_replace(' ', '_', strtoupper(urldecode($valor)))){
						$checked = 'checked="checked"';
					}
				}

			}
			//Vamos a utilizar un contador con una marca de tiempo porque los IDs tienen que ser únicos:
			$contador = microtime(false);
			$contador = explode(' ', $contador);
			$contador = $contador[0];
			$contador = explode('.', $contador);
			$contador = $contador[1];

			?>
			<fieldset class="filtrar_<?= strtolower(str_replace(" ", "_", $nombre_campo)); ?>" id="fieldset_<?= strtolower(str_replace(" ", "_", $valor)); ?>_<?=$contador;?>" >
				<input type="checkbox" name="filtrar_<?= strtolower(str_replace(" ", "_", $nombre_campo)); ?>" class="filtrar_<?= strtolower(str_replace(" ", "_", $nombre_campo)); ?>" value="<?= str_replace(' ', '_', $valor); ?>" id="check_<?= strtolower(str_replace(" ", "_", $valor)); ?>_<?=$contador;?>" <?= $checked; ?>/>
				<label class="filtrar_<?= strtolower(str_replace(" ", "_", $nombre_campo)); ?>" id="label_<?= strtolower(str_replace(" ", "_", $valor)); ?>_<?=$contador;?>" for="check_<?= strtolower(str_replace(" ", "_", $valor)); ?>_<?=$contador;?>"><?= $valor; ?></label>
				<span class="cantidad">(<?= $fila['totales']; ?>)</span>
			</fieldset>	
			<?php
		}
		?>
	</form>
	<?php
}
//Esta función ordena un array que contiene a su vez arrays de varios elementos recibiendo el índice como parámetro
function ordenarArrayDatos($arrayDatos, $pIndice){
	/*echo("<pre>");
	var_dump($pIndice);
	echo("</pre>");*/
	global $indice;
	$indice = $pIndice;
	$ordenado = usort($arrayDatos, function($a, $b) {
		global $indice;
		$retorno = 0;
		//Ojo, hay que tener en cuenta que el índice exista
		if (isset($a[$indice]) && isset($b[$indice]) ){
			//Modificado por pedro el 24/Septiembre/2019 ==> Con esta comparación no se ordenaban de manera alfabética:
			//$retorno = $a[$indice] == $b[$indice];
			//Utilizamos strcasecmp:
			$valor = strcasecmp($a[$indice], $b[$indice]);
			$retorno = ($valor > 0) ? 1 : 0;
		}
		return $retorno;
	});
	unset($indice);
	return($arrayDatos);
}

//------------------------------------------------------------------
// Voy a hacer una función que va a crear un span con su onclick
// para meterlo dónde corresponda
//------------------------------------------------------------------
function orderDropDown($opciones){
	$ordenesDisponibles = array();	// ==> Lista de "orden" disponibles (precio mayor a menor, stock, etc.)
	$filtradoActual = '';
	if (is_a($opciones, 'OpcionesWidget')) {
		$ordenesDisponibles = ($opciones->configuracion->ordenesDisponibles != NULL) ? $opciones->configuracion->ordenesDisponibles : $ordenesDisponibles;
		$filtradoActual = ($opciones->configuracion->filtradoActual != NULL) ? $opciones->configuracion->filtradoActual : $filtradoActual;
	}
	//Vamos a crear un dropdown (select - option) con los valores pasados:
	if (count($ordenesDisponibles) > 0){
		?>
		<select name="ordenProductos" title="<?=traducir('Ordenar productos por');?>">
			<option value="" ><?=traducir('Ordenar productos por:');?></option>
		<?php
		foreach ($ordenesDisponibles as $clave => $valor){
			if (is_array($valor)){
				if (count($valor) >= 2){
					$selected = ($filtradoActual == $valor[1]) ? 'selected="selected"': '';
			?>
			<option value="<?=$valor[1];?>" <?=$selected;?>><?=$valor[0];?></option>
			<?php
				}
			}
		}
		?>
		</select>
		<script id="<?=RemoteRequest::generateRandomString();?>">
		document.addEventListener('WSLE', function(event) {
			$('select[name="ordenProductos"]').on('change', function(event){
				event.stopPropagation();
				//Vamos a coger la clase:
				var data = { orderOfProducts:$(this).val() };
				console.log(data);
				WS_data_update(
					'Sesion',
					'set',
					data,
					'',
					function(data){
						location.reload();
					}
				);
			});
		});
		</script>
		<?php
	}
}
//Pedro 23/Septiembre/2019 ==> Selector de elementos por página:
function productsPerPageDropDown($opciones){
	$opciones = new ObOptions($opciones);
	$arrayElementosPagina = $opciones->getDefaultValue('arrayElementosPagina', array(10,20,50));
	$elementosPaginaActual = $opciones->getDefaultValue('elementosPaginaActual', 10);
	//Vamos a crear un dropdown (select - option) con los valores pasados:
	if (count($arrayElementosPagina) > 0){
		?>
		<select name="productsPerPage" title="<?=traducir('Productos a mostrar');?>">
		<?php
		foreach ($arrayElementosPagina as $clave => $valor){
			$selected = ($elementosPaginaActual == $valor) ? 'selected="selected"': '';
			?>
			<option value="<?=$valor;?>" <?=$selected;?>><?=$valor;?></option>
			<?php
		}
		?>
		</select>
		<script id="<?=RemoteRequest::generateRandomString();?>">
		document.addEventListener('WSLE', function(event) {
			$('select[name="productsPerPage"]').on('change', function(event){
				event.stopPropagation();
				//Vamos a coger la clase:
				var data = { elementosPaginaActual:$(this).val() };
				console.log(data);
				WS_data_update(
					'Sesion',
					'set',
					data,
					'',
					function(data){
						location.reload();
					}
				);
			});
		});
		</script>
		<?php
	}
}