<?php
/*
	Clase Blacklist_Keyword
	@version 1.0
*/

//11/Noviembre/2019 ==> Lista de palabras a excluir de la búsqueda
class SuperBlacklist_keyword extends Objeto{
	//Campos que debe llevar la clase de por sí
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

	//campos de la tabla y otros:
	public $codigo = 0;
	public $idioma = 'ES';
	public $objetoIdioma = NULL;
	public $texto = '';
	//Lista actual de palabras negativas en el idioma actual:
	private static $current_blacklist_keyword = array();
	
	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//static::$campos_tabla = BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}; //==> Comento esta línea porque creo que no sirve pa na
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (static::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias());
				$campos .= BaseDatos::dameCamposAlias(static::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' ) . 
				Idioma::getCampos();
			}
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= static::getJoin('Blacklist_keyword', 'idioma', 'Idioma', 'codigo');
		}
		$consulta .= ' ';
		
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}

	//Funciones de carga en la BD, van aquí arriba
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$id = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$idioma = isset($argumentos[1]) ? $argumentos[1] : '';	//Si en vez de NULL, nos pasan el idioma como cadena vacía es porque no se quiere aplicar este filtrado
		$frase = isset($argumentos[2]) ? $argumentos[2] : NULL;
		$limitar = isset($argumentos[3]) ? $argumentos[3] : true;

		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($id !== NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`codigo` = "' . $id . '" ';
		}
		if ($idioma !== '') {
			static::$whereSelect .= ( (static::$whereSelect != '') ? ' AND ' : '') . ' `' . static::getAlias() . '`.`idioma` = "' . $idioma . '" ';
		}
		if ($frase !== NULL) {
			static::$whereSelect .= ( (static::$whereSelect != '') ? ' AND ' : '') . ' `' . static::getAlias() . '`.`frase` = "' . $frase . '" ';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
	
    function __construct($params){
		//Vamos a decodificar los parámetros:
		$params = new ObOptions($params);

		//La fila es imprescindible para la carga dinámica de objetos en webStore
		$filaBlacklist_keyword = $params->getDefaultValue('filaBlacklist_keyword', NULL);
		//Aquí pongo el resto de de parámetros que podemos necesitar en la carga
		$ID = $params->getDefaultValue('ID', 0);
		$idioma = $params->getDefaultValue('idioma', idioma::getCurrentLanguajeCode());	//El idioma siempre es por defecto el "maestro"
		$texto = $params->getDefaultValue('texto', NULL);
		$fila = NULL;
		
		if ($filaBlacklist_keyword == NULL){
			if ($ID > 0) {
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM ' . static::getNombreTabla() . '
									WHERE ' . static::getWhereTabla($ID, $idioma, $texto);
				//echo("$sentencia_sql<br/>\n");
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}else{
			$fila = $filaBlacklist_keyword;
		}
		if($fila != null){
			$this->extractData($fila);
		}
    }
	
	private function extractData($fila){
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->idioma = $this->getProp($fila, 'idioma');
		$this->texto = $this->getProp($fila, 'texto');
		//Vamos a cargar el objeto idioma:
		$this->objetoIdioma = new Idioma(array('filaIdioma' => $fila, 'ID' => $this->idioma));
		//Aquí vamos a controlar que si no hay objeto idioma, cojamos el del idioma:
		if ( ($this->idioma == '') && ($this->objetoIdioma != NULL) && ($this->objetoIdioma->codigo != '') ){
			$this->idioma = $this->objetoIdioma->codigo;
		}
	}

    function __destruct(){
        
    }
	
	public static function initList(){
		$list = self::$current_blacklist_keyword;
		if (count(self::$current_blacklist_keyword) == 0){
			self::$current_blacklist_keyword = self::loadList();
		}
		return($list);
	}

	public static function filterWord($word){
		$return = true;
		$list = self::initList();
		$limit = count($list);
		$continue = true;
		for ($i = 0; ($i < $limit) && ($continue); $i++){
			$element = $list[$i];
			if ( strtoupper($element->texto) == strtoupper($word) ){
				//Hay que bloquear la frase
				$return = false;
				$continue = false;
			}
		}
		return($return);
	}
	
	public static function getPlural($word){
		$lang = idioma::getCurrentLanguajeCode();
		
		switch($lang){
			case 'ES':
			case 'es':
				//La z final de palabra se cambia por c
				//	z( |(?!\S))
				//A las palabras terminadas en consonante o en i se les añade es
				//	[^aeou]( |(?!\S))
				$word = preg_replace(
					array('/z( |(?!\\S))/i', '/([^aeou])( |(?!\\S))/i', '/([aeou])( |(?!\\S))/i'),
					array('c', '${1}es', '${1}s'),
					$word
				);
			break;
			default:
				$rules = array(
					'/([b-df-hj-np-tv-z]|[áíóú])$/i' => '\1es',
					'/([aeioué])$/i' => '\1s',
					'/([aiou])s$/i' => '\1',
					'/(e)s$/i' => '\1_'
				);
				foreach ($rules as $regex => $replace) {
					$word = preg_replace($regex, $replace, $word, 1, $count);
				}
				//Terminamos por quitar las tildes:	//31Marzo/2020 ==> las tildes se quitan al final
				//$word = str_replace(array('á','é','í','ó','ú'), array('a','e','i','o','u'), $word);
		}
		return($word);
	}
}
?>