<?php
/*
  Clase SuperDirecciones รณn
  @version 2.0
	//12/Abril/219 ==> Esta clase pasa a tener el formato Nuevo
 */

class SuperDirecciones Extends Objeto {
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

	public $codigo = 0;
    public $nombre = '';
    public $direccion = '';
    public $cod_postal = '';
    public $localidad = '';
    public $provincia = '';
    public $telefono = '';
    public $pais = 0;
	public $zona = 0;
	//Pedro 12/Abril/2019 ==> Guardamos el usuario:
	public $cliente = '';
	//Marina 22/Enero/2020 creamos un campo para almacenar un objeto pais
	public $objeto_pais = NULL; 
	
	//Deshabilitamos por ahora los arrays de datos extra, estoy trazando este objeto y necesito que sea más sencillo
	//Estos datos se usan para adjutnar campos a la dirección de envío (más nombres, más teléfonos, etc.)
    /*public $array_nombre = array();
    public $array_direccion = array();
    public $array_cod_postal = array();
    public $array_localidad = array();
    public $array_provincia = array();
    public $array_telefono = array();
    public $array_pais = array();*/

	
	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (static::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias());
				$campos .= BaseDatos::dameCamposAlias(static::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' ) . 
				Pais::getCampos();
			}
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= static::getJoin('Direcciones', 'pais', 'Pais', 'codigo');		//Cogemos el pais
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}  
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$cliente = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		
		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($codigo != NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`codigo` = \'' . $codigo . '\' ';
		}
		if ($cliente != NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`cliente` = \'' . $cliente . '\' ';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
    //function __construct($cliente, $codigo, $direccion, $cod_postal = '', $localidad = '', $provincia = '', $telefono = '', $nombre = '', $pais = '', $zona = 0) {
	function __construct($params) {
		//var_dump($params);
		$codigo = NULL;
		if (is_numeric($params)){
			$codigo = $params;
		}
		$params = new ObOptions($params);
		//La fila es imprescindible para la carga dinámica de objetos en webStore
		$filaDireccion = $params->getDefaultValue('filaDireccion', NULL);
		//Aquí pongo el resto de de parámetros que podemos necesitar en la carga
		$this->codigo = $params->getDefaultValue('codigo', $codigo);
		
				//Con el código cargado vamos a obtener los datos de la BD
		$fila = NULL;
		if ($filaDireccion != NULL){
			$fila = $filaDireccion;
		}else{
			//Pedro 24/Abril/2019 ==> NO tiene sentido cargar una dirección sin el código:
			if ( ($this->codigo > 0) && ($this->codigo != NULL) ){
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM ' . static::getNombreTabla() . ' 
									WHERE ' . static::getWhereTabla($this->codigo);
				//echo("<pre>{$sentencia_sql}\n</pre>");
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}
		if ($fila != NULL) {
			$this->extractData($fila);
		}
		
		//Aquí vamos a mantener los adjuntos de las direciones de envío por si en el futuro se mejora
        /*$this->array_direccion[] = $this->direccion;
        $this->array_cod_postal[] = $this->cod_postal;
        $this->array_localidad[] = $this->localidad;
        $this->array_provincia[] = $this->provincia;
        $this->array_nombre[] = $this->nombre;
        $this->array_telefono[] = $this->telefono;
        $this->array_pais[] = $this->pais;

        if ($cliente != '' AND $codigo > 0) {
            $sentenciaSQL = 'SELECT  `nombre_campo`, `valor` FROM `adjunto_direccion_envio`  WHERE `cliente` = \'' . $cliente . '\' AND `direccion_envio` = \'' . $codigo . '\';';
            //echo $sentenciaSQL;
            $conexionBD = dame_valor_variable_global('conexionBD', false);

            if ($conexionBD) {
                $resultado = mysqli_query($conexionBD, $sentenciaSQL);
                //var_dump(mysqli_fetch_array($resultado));
                while ($fila = mysqli_fetch_array($resultado)) {
                    $actual = 'array_' . $fila['nombre_campo'];
                    array_push($this->$actual, $fila['valor']);
                }
            }
        }*/
		//Ahora vamos a ver si nos han pasado algún dato nuevo en la dirección de envío para modificar el actual:
		$this->nombre = $params->getDefaultValue('nombre', $this->nombre);
		$this->direccion = $params->getDefaultValue('direccion', $this->direccion);
		$this->cod_postal = $params->getDefaultValue('cod_postal', $this->cod_postal);
		$this->localidad = $params->getDefaultValue('localidad', $this->localidad);
		$this->provincia = $params->getDefaultValue('provincia', $this->provincia);
		$this->zona = $params->getDefaultValue('zona', $this->zona);
		$this->telefono = $params->getDefaultValue('telefono', $this->telefono);
		$this->cliente = $params->getDefaultValue('cliente', $this->cliente);
		$this->pais = $params->getDefaultValue('pais', $this->pais);
		//Pedro 27/Enero/2020: Si no tenemos objeto país pero sí tenemos código del mismo, lo inicializamos:
		if ( ($this->objeto_pais == NULL) || ( ($this->objeto_pais->codigo == 0) && ($this->pais > 0) ) ){
			//var_dump($this->objeto_pais);
			$this->objeto_pais = new Pais($this->pais);
		}

		/*	//Para evitar recursividad, el cliente se manda al crear el objeto
		//Llegados a este punto vamos a controlar el cliente:
		if ($this->cliente == 0){
			$usuario = Usuario::logueado();
			if ($usuario != NULL){
				$this->cliente = $usuario->codigo;
			}
		}
		*/
		/*ob_start();
		var_dump($this);
		$data = ob_get_clean();
		FileSystem::log($data);*/
    }

    function __destruct() {
        
    }
	
	public function extractData($fila){
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->cliente = $this->getProp($fila, 'cliente');
		$this->nombre = $this->getProp($fila, 'nombre');
		$this->direccion = $this->getProp($fila, 'direccion');
		$this->cod_postal = $this->getProp($fila, 'cod_postal');
		$this->localidad = $this->getProp($fila, 'localidad');
		$this->provincia = $this->getProp($fila, 'provincia');
		$this->pais = $this->getProp($fila, 'pais');
		$this->objeto_pais = new Pais(array('filaPais' => $fila));
		//Pedro 27/Enero/2020 ==> Nos asegurmos de tener un objeto país:
		if ( ($this->objeto_pais->codigo == 0) && ($this->pais > 0) ){
			$this->objeto_pais = new Pais($this->pais);
		}
		$this->zona = $this->getProp($fila, 'zona');
		$this->telefono = $this->getProp($fila, 'telefono');
	}
	
    public function getArray($nombre_array = NULL) {
        $retorno = NULL;
        if ($nombre_array != NULL) {
            $nombre_array = 'array_' . $nombre_array;
            if (isset($this->$nombre_array)) {
                $retorno = $this->$nombre_array;
            }
        }
        return($retorno);
    }

	public function save(){
		//Hay que guardarla dirección de envío:
		$campo_codigo = '';
		$valor_codigo = '';
		//No podemos guardar una dirección sin cliente:
		if ($this->cliente != ''){
			if (intval($this->codigo) > 0){
				$campo_codigo = '`codigo`,';
				$valor_codigo = '\'' . $this->codigo . '\',';
			}

			$sentencia_sql = 'INSERT INTO `' . static::getNombreTablaSinAlias() . '` 
							( ' . $campo_codigo . ' `cliente`,  `nombre`, `direccion`, `cod_postal`, `localidad`, `provincia`, `pais`, `zona`, `telefono`)
							VALUES (' . $valor_codigo . ' \'' . $this->cliente . '\', \'' . $this->nombre . '\', \'' . $this->direccion . '\', \'' . $this->cod_postal . '\', \'' . 
							$this->localidad . '\', \'' . $this->provincia . '\', \'' . $this->pais . '\', \'' . $this->zona . '\', \'' . $this->telefono . '\' ) 
							ON DUPLICATE KEY UPDATE `cliente` = VALUES(`cliente`), `nombre` = VALUES(`nombre`),`direccion` = VALUES(`direccion`),`cod_postal` = VALUES(`cod_postal`),
								`localidad` = VALUES(`localidad`),`provincia` = VALUES(`provincia`),`pais` = VALUES(`pais`),`zona` = VALUES(`zona`),`telefono` = VALUES(`telefono`);';
			//echo($sentencia_sql . "\n");
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				//trazas:
				$bd->setConsultaSQL($sentencia_sql);
				//cogemos el código:
				if ($this->codigo == 0){
					$this->codigo = $bd->getAutonumerico();
					//Es conveniente actualizar al usuario para que sepa cual es su dirección por defecto
				}
			}
		}
		return($this);
	}

	public static function getUserDirs($opciones){
		
		$lista_direcciones = array();
		if ( (is_numeric($opciones)) || (is_string($opciones))){
			$opciones = array('codigoUsuario' => $opciones);
		}

		$opciones = new ObOptions($opciones);

		$objetoUsuario = $opciones->getDefaultValue('objetoUsuario', NULL);	// OjO, si aquí se usa el "logueado" tenemos una recursión, ya que esa función también hace un new usuario y volveríamos aquí 
		$codigoUsuario = $opciones->getDefaultValue('codigoUsuario', ( ($objetoUsuario != NULL) ? $objetoUsuario->codigo: '') );
		
		
		//Primero intentaremos sacar el código del objeto si es que no tenemos código y Sí objeto
		if ($codigoUsuario == ''){
			if ($objetoUsuario != NULL){
				$codigoUsuario = $objetoUsuario->codigo;
			}
		}
		//Si por aquí seguimos sin código, vamos a scar el de la sesión:
		if ($codigoUsuario != ''){
			$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . ' 
								WHERE ' . static::getWhereTabla(NULL, $codigoUsuario, false);
			//echo($sentencia_sql);
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				while($fila = $bd->getFila()){
					$lista_direcciones[] = new Direcciones(array('filaDireccion' => $fila));
				}
			}
		}

		return($lista_direcciones);
	}

	//Pedro 26/Julio/2019 ==> Proceso para borrar una dirección de envío:
	public function remove(){
		if ($this->codigo > 0){
			$sentencia_sql = 'DELETE FROM ' . static::getNombreTablaSinAlias() . ' WHERE `codigo` = ' . $this->codigo;
			//echo("$sentencia_sql\n");
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$this->codigo = 0;
				$this->cliente = '';
				$this->nombre = '';
				$this->direccion = '';
				$this->cod_postal = '';
				$this->localidad = '';
				$this->provincia = '';
				$this->pais = 0;
				$this->zona = '';
				$this->telefono = '';
			}
		}
	}
	
	public static function remoteRemove($data){
		ob_start();
		if (is_string($data)){
			$data = json_decode($data);
		}
		$cart = CabeceraCesta::getCart();
		$retorno = new stdClass();
		//echo("COMENZAMOS\n");
		$data = new ObOptions($data);	//Nos aseguramos de que "data" tenga el formato que necesitamos
		$codigo = $data->getDefaultValue('codigo', 0);
		//echo("recibido código: $codigo\n");

		//Vamos a quitarle al usuario la dirección de la lista:
		if ($cart->objeto_cliente != NULL){
			//echo("Vamos a borrar la dirección del cliente\n");
			$cart->objeto_cliente->removeAddress($codigo);
		}

		if ($cart->codigoDireccion == $codigo){
			//echo("La dirección que queremos borrar es la que hay en la cesta\n");
			//Hay que cambiar la dirección de envío:
			if (isset($cart->objeto_cliente) and (count($cart->objeto_cliente->direcciones) > 0) ){
				//Asignamos a la cesta la primera dirección que tenga el cliente:
				//var_dump($cart->objeto_cliente->direcciones[0]);
				$cart->setShippingDestination(array('objetoDireccion' => $cart->objeto_cliente->direcciones[0]));
				
			}else if (isset($cart->objeto_cliente)){
				//No hay más direcciones del cliente, hay que limpiar la de la cesta:
				$cart->clearShippingDestination();
			}
		}else{
			//echo("La dirección que queremos borrar NO ES la que hay en la cesta\n");
		}
		//Ahora borramos la dirección de la BD:
		//echo("Borramos la dirección (comentado):\n");
		$direccion = new Direcciones (array('codigo' => $codigo));
		$direccion->remove();
		unset($direccion);

		$msg = ob_get_clean();
		$retorno->response = $msg;
		$retorno = json_encode($retorno);
		return($retorno);
	}
}

?>