<?php
/*
	Clase Idioma
	@version 1.0
*/

//30/Septiembre/2019 ==> Añadimos la carga como objeto de WebStore
class SuperIdioma extends Objeto{
	//Campos que debe llevar la clase de por sí
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();
	
	//campos de la tabla y otros:
	public $codigo = '';
	public $iso3 = '';
	public $nombre = '';
	public $localizacion = '';
	public $disponible = false;
	public $codigo_bandera = '';
	private static $currentLanguaje = NULL;
	
	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}

	//Funciones de carga en la BD, van aquí arriba
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$id = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$disponible = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		$iso3 = isset($argumentos[3]) ? $argumentos[3] : NULL;
		$localizacion = isset($argumentos[4]) ? $argumentos[4] : NULL;

		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($id !== NULL) {
			static::$whereSelect .= ( (static::$whereSelect != '') ? ' AND ' : '') . ' `' . static::getAlias() . '`.`codigo` = \'' . $id . '\' ';
		}
		if ($disponible !== NULL) {
			static::$whereSelect .= ( (static::$whereSelect != '') ? ' AND ' : '') . ' `' . static::getAlias() . '`.`disponible` = 1 ';
		}
		
		if ($iso3 !== NULL) {
			static::$whereSelect .= ( (static::$whereSelect != '') ? ' AND ' : '') . ' `' . static::getAlias() . '`.`iso3` = \'' . $iso3 . '\' ';
		}
		
		if ($localizacion !== NULL) {
			static::$whereSelect .= ( (static::$whereSelect != '') ? ' AND ' : '') . ' `' . static::getAlias() . '`.`localizacion` = \'' . $localizacion . '\' ';
		}
		
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
	
    function __construct($params){
		//Vamos a decodificar los parámetros:
		//Por defecto nos van a mandar la cadena de texto:
		$frase = '';
		if (is_string($params)){
			$frase = $params;
		}
		$params = new ObOptions($params);

		//La fila es imprescindible para la carga dinámica de objetos en webStore
		$filaIdioma = $params->getDefaultValue('filaIdioma', NULL);
		//Aquí pongo el resto de de parámetros que podemos necesitar en la carga
		$ID = $params->getDefaultValue('ID', NULL);	//Si no nos han dicho en qué idioma, lo elegimos nosotros
		$activo = $params->getDefaultValue('activo', NULL);	//Si no nos han dicho en qué idioma, lo elegimos nosotros
		$iso3 = $params->getDefaultValue('iso3', NULL);	//Si no nos han dicho en qué idioma, lo elegimos nosotros
		$localizacion = $params->getDefaultValue('localizacion', NULL);	//Si no nos han dicho en qué idioma, lo elegimos nosotros
		$fila = NULL;
		//Si todos los parámetros que me han pasado son NULL, entonces vamos a coger el ID de configuración (util si no hay multi-idioma)
		if ( ($ID == NULL) && ($iso3 == NULL) && ($localizacion == NULL) ){
			$ID = Sesion::get('idioma', Shop::$configuracion->idioma);
		}
		if ($filaIdioma == NULL){
			if ( ($ID != NULL) || ($iso3 != NULL) || ($localizacion != NULL) || ($activo != NULL)){
				//Preparamos el FROM con las uniones correspondientes
				$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
									FROM ' . static::getNombreTabla() . '
									WHERE ' . static::getWhereTabla($ID, $activo, true, $iso3, $localizacion);
				
				//echo("$sentencia_sql<br />\n");
				$bd = new BaseDatos();
				if ($bd->isConectado()){
					$bd->setConsultaSQL($sentencia_sql);
					$fila = $bd->getFila();
				}
			}
		}else{
			$fila = $filaIdioma;
		}
		if($fila != null){
			$this->extractData($fila);
		}
    }
	
	private function extractData($fila){
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->iso3 = $this->getProp($fila, 'iso3');
		$this->localizacion = $this->getProp($fila, 'localizacion');
		$this->nombre = $this->getProp($fila, 'nombre');
		$this->disponible = $this->boolData($this->getProp($fila, 'disponible'));
		$this->codigo_bandera = $this->getProp($fila, 'codigo_bandera');
	}
	
    function __destruct(){
        
    }
	//Marina (31/10/19)
	public static function idiomaTodos(){
		$retorno = array();
		$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
						FROM ' . static::getNombreTabla() . '; ';
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while ($fila = $bd->getFila()){
				array_push($retorno, new Idioma(new OpcionesWidget(array('filaIdioma' => $fila))));
			}
		}
		return($retorno);
	}
	
	//Vamos a coger el idioma actual, La sesión manda, si no está seteada cogemos el de configuración.
		//En caso de estar seteada y ser igual que la de configuración, entonces borramos el idioma de la sesión.
		//Si no hay multi-idioma, no hacemos nada
	public static function getCurrentLanguajeCode(){
		//Si el módulo de multi-idioma está activo hacemos estas comprobaciones, si no, siempre ponemos el de configuración:
		$idioma = '';
		
		if (Module::is_active('multi-idioma')){
			//Lo que prima es el idioma de la sesión:
			$idioma_sesion = Sesion::get('idioma', '');
			//Si está seteado vamos a comprobar que está activo:
			if ($idioma_sesion != ''){
				$idioma = self::isActive($idioma_sesion);
			}

			if ( ($idioma == '') || ($idioma === false) ){
				//El idioma no está en la sesión, vamos a intentar sacarlo del navegador:
				if ( isset( $_SERVER[ 'HTTP_ACCEPT_LANGUAGE' ] ) ) {
					//Cargamos los lenguajes disponibles por el navegador
					$langs = self::getBrowserlanguajeList();
					$index = array_keys($langs);
					$counter = 0;
					$idioma = false;
					do{
						$lang = $langs[$index[$counter]];
						$idioma = self::isActiveByLocalization($lang);
						$counter++;
					}while ( ($idioma == false) && ($counter < count($langs)) );
				}
			}

			//Si el idioma sigue siendo nulo, cogemos el de configuracion:
			if ( ($idioma == '') || ($idioma === false) ){
				//Comentado por trazas
				$idioma = Shop::$configuracion->idioma;
			}
		}else{
			//Pedro 14/Abril/2020 ==> en algunos momentos se inenta obtener el idioma antes incluso de que esté la configuración cargada. Nos aseguramos de que esta exista
			if (is_a(Shop::$configuracion, 'Configuracion')){
				$idioma = Shop::$configuracion->idioma;
			}
		}
		return($idioma);
	}
	public static function getCurrentLanguaje($getCode = false){
		//Si ya tenemos un idioma cargado, no hacemos comprobaciones:
		$idioma = NULL;
		if (self::$currentLanguaje != NULL){
			$idioma = self::$currentLanguaje;
		}else{
			$idioma = self::getCurrentLanguajeCode();
			if ($idioma != ''){
				$idioma = new Idioma(array('ID' => $idioma, 'activo' => 1));
				self::$currentLanguaje = $idioma;
			}else{
				$idioma = NULL;
			}
		}
		if ( ($getCode) && ($idioma != NULL) ){
			$idioma = $idioma->codigo;
		}
		return($idioma);
	}
	
	//Asignamos un nuevo idioma a la web y devolvemos el objeto idioma que esté activo
	public static function setCurrentLanguaje($new_idioma){
		$objetoIdioma = NULL;
		//Cogemos el código de idioma de configuración:
		$idioma = Shop::$configuracion->idioma;
		if ( ($new_idioma != $idioma) && (Module::is_active('multi-idioma')) ){
			$objetoIdioma = new Idioma(array('ID' => $new_idioma, 'activo' => 1));
			Sesion::set('idioma', $new_idioma);
		}
		//Sólo devolvemos el objeto idioma si se ha podido cambiar el mismo:
		return($objetoIdioma);
	}
	
	public static function getActiveLanguajes($codesOnly = false){
		$avaiables = array();
		$avaiables = static::loadList(array('disponible' => '1', 'limit' => ' '));
		if ($codesOnly){
			$newAvaiables = array();
			foreach($avaiables as $key => $lang){
				$newAvaiables[] = $lang->codigo;
			}
			$avaiables = $newAvaiables;
		}
		return($avaiables);
	}
	
	//Pedro 22/Octubre/2019 ==> Indicamos si un idioma está activo.
	public static function isActive($langCode = ''){
		$return = false;
		
		if ( ($langCode != NULL) && ($langCode != '') ){
			$objetoIdioma = new Idioma(array('ID' => $langCode));
			if ($objetoIdioma->disponible){
				$return = $objetoIdioma->codigo;
			}
		}
		return($return);
	}
	
	public static function isActiveByLocalization($localization = ''){
		$return = false;
		if ( ($localization != NULL) && ($localization != '') ){
			$objetoIdioma = new Idioma(array('localizacion' => $localization));
			if ($objetoIdioma->disponible){
				$return = $objetoIdioma->codigo;
			}
		}
		return($return);
	}
	public static function isActiveByIso3($iso3 = ''){
		$return = false;
		
		if ( ($iso3 != NULL) && ($iso3 != '') ){
			$objetoIdioma = new Idioma(array('iso3' => $iso3));
			if ($objetoIdioma->disponible){
				$return = $objetoIdioma->codigo;
			}
		}
		return($return);
	}
	
	//Pedro 22/Octubre/2019 ==> Devolvemos un array con los idiomas soportados por el navegador
	private static function getBrowserlanguajeList() {
		$languageList = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
		$languages = array();
		$languageRanges = explode(',', trim($languageList));
		foreach ($languageRanges as $languageRange) {
			if (preg_match('/(\*|[a-zA-Z0-9]{1,8}(?:-[a-zA-Z0-9]{1,8})*)(?:\s*;\s*q\s*=\s*(0(?:\.\d{0,3})|1(?:\.0{0,3})))?/', trim($languageRange), $match)) {
				if (!isset($match[2])) {
					$match[2] = '1.0';
				} else {
					$match[2] = (string) floatval($match[2]);
				}
				/*if (!isset($languages[$match[2]])) {
					$languages[$match[2]] = array();
				}
				$languages[$match[2]][] = $match[1];*/
				$languages[$match[2]] = $match[1];
			}
		}
		krsort($languages);
		/*
		echo("<pre>");
		var_dump($languages);
		echo("</pre>");
		*/
		return($languages);
	}
	
	
}
?>