<?php
/**
	Clase Objeto
	//	04/Junio/2019 ==>  A partir de ahora SIEMPRE hay que hacer referencia a static para que mande la clase hija y no esta
*/

//ini_set('include_path', '..' . PATH_SEPARATOR . get_include_path());

class SuperObjeto {
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();
	
    function __construct(){
    }
    function __destruct(){
    }
	
	public static function getAllColumnsName(){
		$return = array();
		$select = 'SELECT COLUMN_NAME FROM information_schema.columns WHERE table_name= \'' . self::getNombreTablaSinAlias() . '\'';
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($select);
			while($fila = $bd->getFila()){
				$return[] = $fila['COLUMN_NAME'];
			}
		}
		return($return);
	}
	
	//Pedro 24/Diciembre/2019 ==> Para la exportación usamos una función similar pero preparada para esta tarea porque puede tener más campos a parte de los públicos
	public static function getAllExportableFields(){
		return(static::getAllPublicColumnsName());
	}
	public static function getAllPublicColumnsName($extrafields = NULL){
		static::initPublicFields();
		//Modificado por Pedro el 23/Diciembre/2019 ==> Añadimos la posibilidad de que nos den más campos y estos se añadan a la lista:
		$extrafields = ($extrafields == NULL) ? array() : $extrafields;
		$extrafields = (is_array($extrafields)) ? $extrafields : array();	//Nos aseguramos de que sea un array
		$return = static::getAllColumnsName();
		$return = array_intersect($return, static::$publicFieldList);
		//Añadimos los campos extra que nos piden:
		$return = array_merge($return, $extrafields);
		return($return);
	}
	
	public static function getNombreTabla(){
		static::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		return(static::$nombreTabla);
	}
	//Mediante esta función estableceré la correspondencia para aquellas tablas que no se llamen igual que las clases:
	public static function getTablaRelacionada($nombreTabla = NULL){
		//Cuando no nos pasen el nombre de la tabla lo calculamos a partir de la clase, Si no, lo hacemos así
		$resultado = ($nombreTabla == NULL) ? static::$nombreTabla : $nombreTabla;
		
		switch($resultado){
			case 'traduccionarticulo':
				$resultado = 'traducarti';
			break;
			case 'seoarticulo':
				$resultado = 'articulo_seo';
			break;
			case 'seoescaparate':
				$resultado = 'cesca_seo';
			break;
			case 'pedidocliente':
				$resultado = 'mc_pedcli';
			break;
			case 'lineapedidocliente':
				$resultado = 'ml_pedcli';
			break;
			case 'tipoenviocliente':
				$resultado = 'tipo_envio_cli';
			break;
			case 'formaspago':
				$resultado = 'formas_de_pago';
			break;
			case 'usuario':
				$resultado = 'cliente';
			break;
			case 'ebook':
				$resultado = 'descargas_ebook';
			break;
			case 'lineacesta':
				$resultado = 'tmp_linea_pedidos';
			break;
			case 'cabeceracesta':
				$resultado = 'tmp_cabecera_pedidos';
			break;
			case 'busqueda':
				$resultado = 'search_index';
			break;
			case 'ofertasregalo':
				$resultado = 'ofertas_regalo';
			break;
			case 'escaparate':
				$resultado = 'cescaparate';
			break;
			case 'lineaalbaran':
				$resultado = 'lin_albaran';
			break;
			case 'albaran':
				$resultado = 'cab_albaran';
			break;
			case 'direcciones':
				$resultado = 'direccion_envio';
			break;
			case 'tarifasporlocalidad':
				$resultado = 'tarifasporlo';
			break;
			case 'codigospromocionales':
				$resultado = 'codigos_promocionales';
			break;
			case 'module':
				$resultado = 'modules_list';
			break;
			//10/Julio/2019 ==> Añadimos los lotes
			case 'lote':
				$resultado = 'mc_lotes';
			break;
			case 'linealote':
				$resultado = 'ml_lotes';
			break;
			case 'empresa':
				$resultado = 'configuracion';
			break;
			case 'rangoenvio':
				$resultado = 'rango_envio';
			break;
		}
		//Si no nos han indicado tabla es porque queremos el nombre de la tabla desde dentro de la misma:
		if ($nombreTabla == NULL){
			static::$nombreTabla = $resultado;	//Aquí hay que referenciar a la clase final
		}
		return($resultado);
	}
	
	public static function getCampos(){
		//Vamos a ver desde qué clase estamos llamando y vamos a obtener la tabla de la base de datos
		self::getNombreTabla();		//ATENCIÓN, USAMOS EL SELF PORQUE NO QUEREMOS QUE SE EJECUTE LA FUNCIÓN HIJA
		self::getAlias();			//ATENCIÓN, USAMOS EL SELF PORQUE NO QUEREMOS QUE SE EJECUTE LA FUNCIÓN HIJA
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (static::$nombreTabla != ''){
			//include('comunes/diccionario/diccionario.php');
			//static::$campos_tabla = BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'};
			static::$campos_tabla = BaseDatos::dameCampos(static::$nombreTabla);
			static::$camposSelect = BaseDatos::dameCamposAlias(static::$campos_tabla, self::getAlias());
		}
		return(static::$camposSelect);
	}
	
	public static function getAlias(){
		if (static::$alias == ''){
			$nombreSinAlias = self::getNombreTablaSinAlias();
			//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
			if ($nombreSinAlias != ''){
				//include('comunes/diccionario/diccionario.php');
				//static::$alias = BaseDatos::$dictionary->{static::$nombreTabla . 'Alias'};
				static::$alias = BaseDatos::dameAlias($nombreSinAlias);
			}
		}
		//echo(static::$nombreTabla);
		return(static::$alias);
	}
	
	
	
	public static function getNombreTablaSinAlias(){
		$nombreTabla = self::getNombreTabla();	//ATENCIÓN!!!! aquí no se puede usar static por que si no estaríamos continuamente cargando el "nombreTabla" de la clase hija
		//Pedro 04/Junio/2019 ==> Antes necesitabamos el alias, ya no es necesario:
		$nombreTabla = explode(' as ', static::$nombreTabla);
		$nombreTabla = $nombreTabla[0];
		return(static::$nombreTabla);
	}
	
	public static function getWhereTabla(){
		return('');
	}
	
	//23/Agosto/2019 ==> Pedro:
	//	==> Copiamos esta función de la clase "Banner". Sirve para obtener una lista de objetos utilizando un filtrado
	public static function loadList($filter = NULL){
		$retorno = array();
		//28/Marzo/2019 ==> Cambiamos esta función para que use el where array:
		$whereTabla = ' 1 ';
		if ( (is_array($filter)) && (count($filter) > 0) ){
			$whereTabla = static::getWhereTablaArray( $filter );
		}
		$sentencia_sql = 'SELECT ' . static::getCampos() . ' FROM ' . static::getNombreTabla() . ( ($whereTabla != '') ? ' WHERE ' . $whereTabla : '');
		//echo("$sentencia_sql<br/>\n");
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			$nombreClase = get_called_class();
			$nombreFila = 'fila' . $nombreClase;
			/*echo("Cargamos: {$nombreClase} con el array {$nombreFila} y la fila:\n");
			echo("\n");*/
			while($fila = $bd->getFila()){
				$retorno[]= new $nombreClase(new OpcionesWidget(array($nombreFila => $fila)));
				//var_dump($fila);
			}
		}

		return($retorno);
	}
	
	// 23/Agosto/2019 ==> Pedro:
	//Basándonos en la función que carga una lista, hacemos una que nos diga cuantos elementos hay:
	public static function getCount($filter = NULL, $limit = false){
		$retorno = 0;
		$whereTabla = ' 1 ';
		if ( (is_array($filter)) && (count($filter) > 0) ){
			//OJO, si no limitamos hay que añadirlo 
			$filter['limit'] = '';
			//Ademas quitamos cualquier orden que pueda existir:
			$filter['order'] = '';
			$whereTabla = static::getWhereTablaArray( $filter );
		}

		$sentencia_sql = 'SELECT ' . static::getCampos() . '  FROM ' . static::getNombreTabla() . ( ($whereTabla != '') ? ' WHERE ' . $whereTabla : '');
		//echo("$sentencia_sql\n");
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			$retorno = $bd->getNumeroFilas();
		}

		return($retorno);
	}
	
	//Pedro 20/Marzo/2019 ==> Recibe un array con los campos y el orden y hace la select con dicho array:
	public static function getWhereTablaArray($fieldArray, $campo_recibido = NULL, $nivel = 0){
		if (!is_array($fieldArray)){
			$fieldArray = array();	// ==> SIEMPRE tiene que ser un array
		}
		//Siempre va a haber un limite, por defecto SIEMPRE se carga sólo 1 campo salvo que se especifique lo contrario (pasando la cadena vacía
		if ( !isset($fieldArray['limit']) ){
			$fieldArray['limit'] = ' ';
			if ($nivel == 0){
				$fieldArray['limit'] = ' LIMIT 1 ';
			}
		}
		//Pedro 23/Agosto/2019 ==> Añadimos también la posibilidad de que haya orden:
		if ( !isset($fieldArray['order']) ){
			$fieldArray['order'] = ' ';
			if ($nivel == 0){
				$fieldArray['order'] = '';
			}
		}
		
		$limite = $fieldArray['limit'];
		$orden = $fieldArray['order'];
		$where = '';
		unset($fieldArray['limit']);
		unset($fieldArray['order']);
		foreach ($fieldArray as $clave => $valor){
			$tabla = self::getNombreTablaSinAlias();
			$campo = ($campo_recibido == NULL) ? $clave : $campo_recibido;	//Cuando es un array pierdo el valor del campo, esto me lo soluciona
			
			$condicion = ' = ';
			$valor = (!is_array($valor)) ? ('\'' . $valor . '\'') : $valor;
			$operador = ' AND ';
			$campoCompuesto = self::getWeherePart($tabla, $campo);	// ==> Nos va a dar el formato: `alias`.`campo`
			if (is_array($valor)){
				//Si el contenido es un array, tiene que ser de esta manera:
					//$clave ==> Este es el nombre del campo
					//['tabla'] =  nombre de la tabla a la que accedemos, por defecto la actual
					//['condicion'] = condición a usar
					//['valor'] =  valor a igualar (por defecto '')
					//['operador'] =  AND, OR, XOR, etc.
				$tabla = (isset($valor['tabla'])) ? $valor['tabla'] : $tabla;
				$condicion = (isset($valor['condicion'])) ? $valor['condicion'] : $condicion;
				//echo("La condición es: $condicion\n<br>");
				$operador = (isset($valor['operador'])) ? $valor['operador'] : $operador;
				//echo("El operador es: $operador\n<br>");
				$valor = (isset($valor['valor'])) ? $valor['valor'] : $valor;
				//El valor puede venir sin las comillas y requerirlo:
				if ( (!is_array($condicion)) && (!is_array($valor) )){	//Hacemos una pequeña corrección si no estamos en un array
					if ( (strtoupper(trim($condicion)) == 'LIKE') OR (trim($condicion) == '=') OR (trim($condicion) == '') ){	//En estos casos vamos a trabajar SIEMPRE con una cadena
						$valor = '\'' . $valor . '\'';
					}
				}
				//echo("El valor es: $valor\n<br>");
				$campoCompuesto = self::getWeherePart($tabla, $campo);	// ==> Nos va a dar el formato: `alias`.`campo`
			}
			//Si ahora he cogido el valor y es un nuevo array, se trata de una where anidada, me llamo con recursividad
			if (is_array($valor)){
				//En este caso sabemos que lo que nos han mandado es para hacer una select:
				$where .= ' ' . ( ($where != '')? $operador: '') . self::getWhereTablaArray($valor, $campo, $nivel + 1);	//Cuando es un array pierdo el valor del campo, esto me lo soluciona
			}else{
				$where .= ' ' . ( ($where != '')? $operador: '') . $campoCompuesto . ' ' . $condicion . ' ' . $valor . ' ';
			}
		}
		$where = ( ($where != '') ? ' (' : '' ). $where . ( ($where != '') ? ') ' : '' );
		//Pedro 23/Agosto/2019 Si no hay where , ponemos un 1:
		$where = (trim($where) == '') ? ' 1 ' : $where;
		$where .= $orden . $limite;
		return($where);
	}
	
	public static function getJoin($tOrigen, $cOrigen, $tDestino, $cDestino, $listaCondiciones = NULL, $listaOperadores = NULL, $left = ' LEFT JOIN '){
		$sentencia = '';
		//Si no hemos recibido lista de condiciones, las inicializamos a "AND":
		$listaCondiciones = ($listaCondiciones == NULL) ? array(' AND ') : $listaCondiciones;
		//La lista operadores es igual, pero la inicializamos con '='
		$listaOperadores = ($listaOperadores == NULL) ? array(' = ') : $listaOperadores;
		//Esta función la modificaremos en un futuro para pasarle arrays de campos que comparar, por ahora se casa sólo 1 campo
		//Vamos a actuar de manera diferente según si es clase y es hija de "Objeto" o si no:
		$aliasDestino = '';
		$nombreTablaDestino = '';

		try{
			if (class_exists($tDestino)){
				if (is_subclass_of($tDestino, 'Objeto')){
					$aliasDestino = $tDestino::getAlias();
					$nombreTablaDestino = $tDestino::getNombreTabla(true);
				}
			}
		}catch(Exception $e){
			//Si pasa por aquí sabemos que la clase no existe
		}

		//Si alguno de los valores no está seteados, los cogemos de la manera tradicional
  		$nombreTablaDestino = ($nombreTablaDestino == '') ? $tDestino : $nombreTablaDestino;
		//$aliasDestino = ($aliasDestino == '') ? BaseDatos::$dictionary->{strtolower($nombreTablaDestino) . 'Alias'} : $aliasDestino;
		$aliasDestino = ($aliasDestino == '') ? BaseDatos::dameAlias($nombreTablaDestino) : $aliasDestino;
		
		//Esto no funciona si no es una subclase de "objeto"
		//if ( (is_subclass_of($tOrigen, 'Objeto')) && (is_subclass_of($tDestino, 'Objeto')) ){
			//Si alguno de los campos que tiene q ser array no lo es, lo inicializamos como tal
			if (!is_array($cOrigen)){
				$cOrigen = array($cOrigen);
			}
			if (!is_array($cDestino)){
				$cDestino = array($cDestino);
			}
			if (!is_array($listaCondiciones)){
				$listaCondiciones = array($listaCondiciones);
			}
			if (!is_array($listaOperadores)){
				$listaOperadores = array($listaOperadores);
			}
			if (count($cOrigen) > 0 && count($cDestino) > 0){
				$sentencia = $left . ' '. $nombreTablaDestino;
				//Si la sentencia no tiene el ' as ' es que no lleva alias, vamos a meterlo:
				if (strpos($sentencia, ' as ') === false) {
					$sentencia .= ' as `' . $aliasDestino . '` ';
				}
				$sentencia .=  ' on ( ';
				//Cogemos el array más grande:
				$limite = max(count($cOrigen), count($cDestino), count($listaCondiciones), count($listaOperadores));
				//Vamos a hacer un bucle for porque nos pueden mandar arrays con índices que no sean numéricos
				$where = '';
				//Por seguridad inicializo estas dos variables, pero ya me he asegurado de que ambos arrays tengan, al menos, 1 elemento
				$elementoOrigen = '';
				$elementoDestino = '';
				$condicion = '';
				$operador = '';
				for ($i = 0; $i < $limite; $i++){
					//Cogemos el último elemento disponible para los elementos, la condición y el operador
					$elementoOrigen = (isset($cOrigen[$i])) ? $cOrigen[$i] : $elementoOrigen;
					$elementoDestino = (isset($cDestino[$i])) ? $cDestino[$i] : $elementoDestino;
					$operador = (isset($listaOperadores[$i])) ? $listaOperadores[$i] : $operador;

					//Componemos las partes teniendo en cuenta que puede haber un literal. Usamos una función para no duplicar código
					$leftPart = self::getWeherePart($tOrigen, $elementoOrigen);
					$rightPart = self::getWeherePart($tDestino, $elementoDestino);
					if ( ($leftPart . $rightPart) != ''){
						$where .= ($where != '') ? $condicion : '';
						$where .= $leftPart . $operador . $rightPart;
					}
					//La condición la cogemos al final porque en la primera vuelta, nunca habrá condición
					$condicion = (isset($listaCondiciones[$i])) ? $listaCondiciones[$i] : $condicion;
				}
				$sentencia .= $where . ' ) ';
			}
		//}
		return($sentencia);
	}
	
	private static function getWeherePart($table, $field){
		//Siempre que recibamos una cadena que empieza por $, es un literal y no un campo de la tabla
		$part = '';
		if (substr($field, 0, 1) == '$'){
			$part = ' "' . substr($field, 1) . '" ';
		}else{
			//Ojo que puede que la tabla recibida no tenga clase asociada:
			$aliasDestino = '';
			try{
				if (class_exists($table)){
					if (is_subclass_of($table, 'Objeto')){
						$aliasDestino = $table::getAlias();
						$nombreTablaDestino = $table::getNombreTabla(true);
					}
				}
			}catch(Exception $e){
				//Si pasa por aquí sabemos que la clase no existe
			}
			//Si alguno de los valores no está seteados, los cogemos de la manera tradicional
			//$aliasDestino = ($aliasDestino == '') ? BaseDatos::$dictionary->{strtolower($table) . 'Alias'} : $aliasDestino;
			//Pedro 13/Noviembre/2019 ==> Metemos el alias SOLO si el campo existe en la tabla:
			$fieldExist = self::checkField($table, $field);
			if ( ($table != '') && ($fieldExist) ){
				$aliasDestino = ' `' . ( ($aliasDestino == '') ? BaseDatos::dameAlias($table) : $aliasDestino )  . '`.';
			}
			//echo("Alias : {$aliasDestino} <br/>\n");
			$part = ' ' . $aliasDestino . (($fieldExist)? '`' : '') . $field . (($fieldExist)? '`' : '') . ' ';
		}
		return($part);
	}
	
	//Creado por pedor el 13/Noviembre/2019 ==> Esta función comprueba si una tabla tiene un campo:
	public static function checkField($tableName, $field){
		$return = false;
		$dictionary = BaseDatos::$dictionary;
		$originalTableName = static::getTablaRelacionada(strtolower($tableName));
		$newTableName = $originalTableName . 'Campos';
		if ( (is_a($dictionary, 'BasicObject') ) && (isset($dictionary->$newTableName)) && (is_array($dictionary->$newTableName)) && (in_array($field, $dictionary->$newTableName)) ){
			$return = true;
		}
		//echo("Resultado de comprobar <b>{$field}</b> en <b>{$newTableName}</b> = " . (($return) ? ' <b>correcto</b> ' : ' incorrecto ') . "\n<br/>" );
		return($return);
	}
	
	public function getProp($array, $property, $alias = NULL){
		$retorno = NULL;
		$traza = false;
		if (is_array($array)){
			$alias = ($alias == NULL) ? static::$alias : $alias;
			$alias = ($alias == NULL) ? self::getAlias() : $alias;
			if (isset($array[$alias . '_' . $property])){
				$retorno = $array[$alias . '_' . $property];
			}
		}
		return($retorno);
	}
	
	public static function sGetProp($array, $property, $alias = NULL){
		$retorno = NULL;
		if (is_array($array)){
			$alias = ($alias == NULL) ? self::getAlias() : $alias;
			if (isset($array[$alias . '_' . $property])){
				$retorno = $array[$alias . '_' . $property];
			}
		}
		return($retorno);
	}

//Pedro 02/Mayo/2019 ==> Creamos funciones genéricas de update, e insert or update
//Ejemplo
//CodigosPromocionales::updateField('1234', 'codigo_promocional', 'ABC');		
	public static function updateField($conditionArray, $fieldName, $value, $deleteObjects = true){
		$updateFieldString = '';
		if (!is_array($fieldName)){
			$fieldName = array($fieldName);
		}
		if (!is_array($value)){
			$value = array($value);
		}
		if (!is_array($conditionArray)){
			$conditionArray = array($conditionArray);
		}
		
		//Vamos a purgar los campos:
		self::purgeFields($fieldName, $value, $deleteObjects);
		
		$paramsLimit = min( count($fieldName), count($value) );
		for ($i = 0; $i < $paramsLimit; $i++){
			$updateFieldString .= ( ($updateFieldString != '')? ', ' : '').  ' `' . $fieldName[$i] . '` = \'' . $value[$i] . '\' ';
		}
		$sentenciaWhere = call_user_func_array('static::getWhereTabla', $conditionArray);
		$sentencia_sql = 'UPDATE ' . static::getNombreTabla(true) . ' SET ' . $updateFieldString . '
						WHERE ' . $sentenciaWhere;
		
		
		/*echo("<!--");
		echo($sentencia_sql);
		echo("-->");*/
		
		
		//Para hacer el update tenemos que tener campos y where
		if ( (trim($updateFieldString) != '') && (trim($sentenciaWhere) != '') ){
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
			}
		}		
	}
	/*
	//Esta función se comenta porque es un agujero de seguridad 
	public static function remoteUpdateField($params){
		//Vamos a capturar la salida:
		$retorno = new stdClass();
		//Vamos a extraer de "data" los datos a los que vamos a enviar:
		$data = $params;
		if (is_string($data)){
			$data = json_decode($params);
			if ($data == NULL){
				$data = $params;
			}
		}
		$conditionArray = (isset($data->conditionArray)) ? $data->conditionArray : array();
		$fieldName = (isset($data->fieldName)) ? $data->fieldName : array();
		$value = (isset($data->value)) ? $data->value : array();
		$retorno->resultado = self::updateField($conditionArray, $fieldName, $value);

		//Capturamos la salida y la metemos en el msgs
		$retorno = json_encode($retorno);
		return($retorno);
	}
	*/
	//Pedro 02/Mayo/2019 ==> Creamos funciones genéricas de update, e insert or update
	//Ejemplo
	//CodigosPromocionales::insertOrUpdate(
	//	array('codigo_promocional', 'fecha_baja', 'descuento' , 'activo'),
	//	array('ABC', '20190502', 5, 1)
	//	);

	
	public static function insertOrUpdate($fieldName, $value, $deleteObjects = true){
		$updateFieldString = '';
		if (!is_array($fieldName)){
			$fieldName = array($fieldName);
		}
		if (!is_array($value)){
			$value = array($value);
		}
		//Vamos a purgar los campos:
		self::purgeFields($fieldName, $value, $deleteObjects);
		
		$paramsLimit = min( count($fieldName), count($value) );
		$fieldName = array_slice($fieldName, 0, $paramsLimit);
		$value = array_slice($value, 0, $paramsLimit);
		for ($i = 0; $i < $paramsLimit; $i++){
			$updateFieldString .= ( ($updateFieldString != '')? ', ' : '').  ' `' . $fieldName[$i] . '` = VALUES (`' . $fieldName[$i] . '`) ';
		}
		$sentencia_sql = 'INSERT INTO `' . self::getNombreTablaSinAlias() . '` ( `' . implode('`, `', $fieldName) . '`)
							VALUES ( \'' . implode('\', \'', $value) . '\') 
							ON DUPLICATE KEY UPDATE ' . $updateFieldString;
		
		//echo($sentencia_sql);
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
		}
		
	}
	
	//Mediate esta función haremos una purga de los campos de manera que sólo dejaremos strings y campos numéricos.
	public static function purgeFields(&$arrayFields, &$arrayValues, $deleteObjects = true){
		//Los campos booleanos se parsearán como 0,1 y el resto los parsearemos con la función de PHP o los eliminaremos según el caso (por defecto se eliminan)
		$arrayFields = array_values($arrayFields);
		$arrayValues = array_values($arrayValues);
		
		$limit = min(count($arrayFields), count($arrayValues));
		$finalArrayFields = array();
		$finalArrayValues = array();
		//Es interesante que si vamos a purgar un objeto, tengamos ya inicializados los campos que podemos purgar:
		if (empty(static::$publicFieldList)){
			self::initPublicFields();
		}
		for ($i = 0; $i < $limit; $i++){
			$campo = $arrayFields[$i];
			$valor = $arrayValues[$i];
			$deleteElement = false;
			//echo("Buscamos: " . $arrayFields[$i] . " en el array\n");
			//Antes de seguir vamos a tener en cuenta si ese campo está disponible para que se pueda actualizar:
			if (!in_array($campo, static::$publicFieldList)){
				$deleteElement = true;
			}else{
				if (is_bool($valor)){
					$valor = ($valor) ? 1 : 0;
				}else if ( (is_array($valor)) || (is_object($valor)) ){
					if ($deleteObjects){
						$deleteElement = true;
					}else{
						$valor = serialize($valor);
					}
				}
			}
			if (!$deleteElement){
				$finalArrayFields[] = $campo;
				$finalArrayValues[] = $valor;
			}
		}
		$arrayFields = $finalArrayFields;
		$arrayValues = $finalArrayValues;
	}
	
	//Esta función es un interfaz para que todas las clases hagan esto después. Se trata que no se puedan actualizar campos que no queramos
	public static function initPublicFields(){
		$fields = get_class_vars(get_called_class());
		//Los nombres de los campos son las las claves de este array:
		static::$publicFieldList = array_keys($fields);
		return(static::$publicFieldList);
	}
	public function fieldListRemove($element){
		$return = false;
		if ($pos = array_search($this->publicFieldList, $element)){
			$return = true;
			unset($this->publicFieldList[$pos]);
		}
		return($return);
	}
	
	/*
	//Esto es una puerta de seguridad abierta de par en par. Por eso comentamos esta función
	public static function remoteInsertOrUpdate($params){
		//Vamos a capturar la salida:
		$retorno = new stdClass();
		//Vamos a extraer de "data" los datos a los que vamos a enviar:
		$data = $params;
		if (is_string($data)){
			$data = json_decode($params);
			if ($data == NULL){
				$data = $params;
			}
		}
		$fieldName = (isset($data->fieldName)) ? $data->fieldName : array();
		$value = (isset($data->value)) ? $data->value : array();
		$retorno->resultado = self::insertOrUpdate($conditionArray, $fieldName, $value);

		//Capturamos la salida y la metemos en el msgs
		$retorno = json_encode($retorno);
		return($retorno);
	}
	*/
	
	//Pedro 08/Mayo/2019 ==> Con esta función componemos un hash único por instancia de cada clase 
		//Es conveniente que en cada clase se personalice esta función para obtener un hash más estable
	public function getHash(){
		//Vamos a coger los primeros 4 campos de la clase y a concatener sus valores:
		$hash = '';
		$array_campos = array_slice(get_object_vars($this), 0, 5);
		foreach($array_campos as $clave => $valor){
			if ( (is_string($valor)) || (is_numeric($valor)) ){
				$hash .= $valor;
			}
		}
		return($hash);
	}
	
	//Pedro 10/Julio/2019 ==> añadimos una función que nos crea un booleano a partir de un parámetro
	public function boolData($data){
		return( ($data) ? true : false );
	}
	
	//Pedro 30/Agosto/2019 ==> Adios verano. Vamos a hacer una clase que coja los campos recibidos en el formulario, y mire su correspondiente valor en la BD
		//Con todo ello creará el array de pares (nombre_campo ==> valor_campo)
	public static function createArrayTableFromForm(){
		$return = array();
		//Vamos a coger estos valores de los campos públicos:
		if (empty(static::$publicFieldList)){
			self::initPublicFields();
		}
		foreach (static::$publicFieldList as $nombre_variable => $nombre_campo_tabla){
			$variable_recibida = Getter::get($nombre_variable);

			if($variable_recibida != NULL){
				$return[$nombre_campo_tabla] = $variable_recibida;
			}
		}
		return($return);
	}
}




/*
	Pedro 15/Octubre/2019
	Pongo aquí un ejemplo de cómo se deben ejecutar funciones remotas:
	WS_data_update(
		'Clase',
		'funcion remota',
		datos,
		cadena_de_capas_a_actualizar,
		function(data){
			//Función a ejecutar cuando se termine
		}
	);
	
	



*/

?>