<?php

class SuperTarifasPorLocalidad extends Objeto {
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

    public $codigo = 0;
    public $tipo_envio = 0;
    public $localidad = '';
    public $provincia = '';
    public $importe_fijo = 0;
    public $importe_x_unidad = 0;
    public $reembolso = 0;
    public $recargo_reembolso = 0;
    public $porc_recargo_reembolso = 0;

	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$tipo_envio = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		if ($codigo != NULL){
			static::$whereSelect = ' `' . static::getAlias() . '`.`codigo` = ' . $codigo . ' ';
		}
		if ($tipo_envio != NULL){
			static::$whereSelect = ' `' . static::getAlias() . '`.`tipo_envio` = ' . $tipo_envio . ' ';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
    function __construct($opciones) {
		if (is_numeric($opciones)){
			$opciones = array('codigoTarifaPorLocalidad' => $opciones);
		}
		$opciones = new ObOptions($opciones);
		$codigoTarifaPorLocalidad = $opciones->getDefaultValue('codigoTarifaPorLocalidad', 0);
		$filaTarifaPorLocalidad = $opciones->getDefaultValue('filaTarifaPorLocalidad', NULL);
		
		$fila = NULL;
		//Si no hemos recibido fila usuario, vamos a hacer la select:
		if ($filaTarifaPorLocalidad == NULL){
			$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
							FROM `' . static::getNombreTabla() . '` `' . static::getAlias() . '`
							WHERE ' . static::getWhereTabla($codigo);
			//echo("$sentencia_sql");
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaTarifaPorLocalidad;
		}
		$this->extractData($fila);

    }

	public function extractData($fila){
		 if ($fila != NULL) {
			$this->codigo = $this->getProp($fila, 'codigo');
			$this->tipo_envio = $this->getProp($fila, 'tipo_envio');
			$this->localidad = $this->getProp($fila, 'localidad');
			$this->provincia = $this->getProp($fila, 'provincia');
			$this->importe_fijo = $this->getProp($fila, 'importe_fijo');
			$this->importe_x_unidad = $this->getProp($fila, 'importe_x_unidad');
			$this->reembolso = $this->getProp($fila, 'reembolso');
			$this->recargo_reembolso = $this->getProp($fila, 'recargo_reembolso');
			$this->porc_recargo_reembolso = $this->getProp($fila, 'porc_recargo_reembolso');
        }
	}
	
    function __destruct() {
        unset($this->codigo);
        unset($this->tipo_envio);
        unset($this->localidad);
        unset($this->provincia);
        unset($this->importe_fijo);
        unset($this->importe_x_unidad);
        unset($this->reembolso);
        unset($this->recargo_reembolso);
        unset($this->porc_recargo_reembolso);
    }
	
	public static function getAll($tipo_envio = 0){
		$retorno = array();
		if ($tipo_envio > 0){
			$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
							FROM `' . static::getNombreTabla() . '` `' . static::getAlias() . '` 
							WHERE ' . static::getWhereTabla(NULL, $tipo_envio, false);
			//echo("<pre>$sentencia_sql</pre>");
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				while ($fila = $bd->getFila()){
					$retorno[] = new TarifasPorLocalidad(array('filaTarifaPorLocalidad' => $fila));
				}
			}
		}
		return($retorno);
	}

}

?>
