<?php
//---------------------------------------------------------------------------------------------------------
// 05/Mayo/2020
// Versión 1.0 Header natural de la web. La cabecera con todos sus includes y resto de datos
//---------------------------------------------------------------------------------------------------------

//Vamos a coger la sección actual:
$seccion = Sections::$current_section;

//Si la sección es erronea, vamos a mostrar un 404
if ($seccion == 'error') {
    header('HTTP/1.0 404 Not Found');
}
$idioma = strtolower(Sesion::get('idioma'));
$idioma_local = getLocale();
//Ojo a las locales, por ahora las ponemos en español
setlocale(LC_ALL, $idioma_local);
//Pedro 07/Febrero/2020
//PERO LAS LOCALES NUMÉRICAS VAN EN INGLÉS PARA QUE SEAN 100% COMPATIBLES CON MySql. Esto es porque si no lo hacemos así nos mete los decimales como coma: ','
setlocale(LC_NUMERIC, 'en_US');

//Datos SEO principales. Si no los tenemos, hemos de cogerlos de configuración
$title_web = SEO::getTitle(Shop::$empresa->nombre);
$descripcion_web = SEO::getDescription(Shop::$configuracion->descripcion);
$keywords_web = SEO::getKeywords(Shop::$configuracion->meta);

/*
//Por ahora deshabilitamos la caché
//Vamos a poner una caché de 1 mes:
$seconds_to_cache = 2592000;
$ts = gmdate("D, d M Y H:i:s", time() + $seconds_to_cache) . " GMT";
header("Expires: $ts");
header("Pragma: cache");
header("Cache-Control: max-age=$seconds_to_cache");
*/
?>
    <head>
        <title><?= strip_tags($title_web); ?></title>
		<meta charset="UTF-8" >
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta http-equiv="Vary" content="Accept-Encoding"/>
        <meta name="language" content="<?= $idioma; ?>"/>
        <meta name="author" content="Arminet"/>
        <meta name="Copyright" content="Copyright ARMINET"/>
        <meta name="revisit-after" content="1 hour"/>
        <meta http-equiv="Cache-Control" content="public"/>
        <!--<meta http-equiv="EXPIRES" content="<?= date(DATE_RSS, time() + 2419200); ?>" />-->
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <meta name="description" content="<?=strip_tags(substr($descripcion_web, 0, 160)); ?>" />
        <meta name="keywords" content="<?= substr($keywords_web, 0, 250); ?>" />
        <meta name="title" content="<?=strip_tags($title_web); ?>" />
		<?php
        //Etiquetas que tenemos que añadir
        //Multi-idioma
        //Vamos a cargar todos los idiomas
        $sentencia_sql = "SELECT codigo, locale FROM idioma WHERE disponible = 1 AND UPPER(codigo) != '" . strtoupper($idioma) . "' ";
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            while ($fila = mysqli_fetch_array($resultado)) {
                ?>
                <link rel="alternate" href="<?= Shop::$configuracion->url_sin_idioma; ?><?= strtolower($fila['codigo']); ?>/" hreflang="<?= $fila['locale']; ?>">
                <?php
            }
        }
?>
	<link rel="shortcut icon" href="<?= Shop::$configuracion->url . 'favicon.ico'; ?>">
	<link rel="icon" href="<?= Shop::$configuracion->url; ?>favicon.ico">
    <link rel="apple-touch-icon" sizes="57x57" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="<?= Shop::$configuracion->url; ?>favicon/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="<?= Shop::$configuracion->url; ?><?=_WS_THEME_RESOURCE_DIR_;?>favicon/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?= Shop::$configuracion->url; ?><?=_WS_THEME_RESOURCE_DIR_;?>favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="<?= Shop::$configuracion->url; ?><?=_WS_THEME_RESOURCE_DIR_;?>favicon/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?= Shop::$configuracion->url; ?><?=_WS_THEME_RESOURCE_DIR_;?>favicon/favicon-16x16.png">
    <link rel="manifest" href="<?= Shop::$configuracion->url; ?><?=_WS_THEME_RESOURCE_DIR_;?>favicon/manifest.json">
    <meta name="msapplication-TileColor" content="#4666a0">
    <meta name="msapplication-TileImage" content="<?= Shop::$configuracion->url; ?>favicon/ms-icon-144x144.png">
    <meta name="theme-color" content="#4666a0">
<?php
//Aquí vamos a cargar los css y js de la cabecera:
Theme::loadMedia(_WS_MEDIA_TYPE_CSS, _WS_MEDIA_POSITION_TOP);
Theme::loadMedia(_WS_MEDIA_TYPE_JS, _WS_MEDIA_POSITION_TOP);
?>
    </head>
