<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Formulario de configuración general -->
<!-- ============================================================== -->
<?php

    //creamos un array para almacenar los campos del formulario
    $campos_formulario = Configuracion::createArrayTableFromForm();

    if(count($campos_formulario) > 0){
        Empresa::updateField(Shop::$configuracion->codigo, array_keys($campos_formulario), $campos_formulario);
        //Recargamos la configuración y la empresa
        //Shop::load();
        //Vamos a recargar la página para evitar que al hacer F5 pida actualizar variables
        Sesion::reloadPage(Shop::$configuracion->url . Sections::$current_section);
    }
    //recoger con getter el password y comprobar si es igual al valor que nosotros le vamos a poner
?>

 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <form class="form-horizontal" method="POST">
                    <div class="card-body row">
                        <div class="col-xs-12 col-lg-6">
                            <div class="form-group row">
                                <label for="servidor_portadas" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Servidor portadas');?></label>
                                <div class="col-sm-7">
                                    <input type="text" name="servidor_portadas" value="<?=Shop::$configuracion->servidor_portadas;?>" class="form-control" id="servidor_portadas" placeholder="<?= traducir('Servidor portadas');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="no_foto" class="col-sm-5 text-right control-label col-form-label"><?=traducir('No foto');?></label>
                                <div class="col-sm-7">
                                    <input type="text" name="no_foto" value="<?=Shop::$configuracion->no_foto;?>" class="form-control" id="no_foto" placeholder="<?= traducir('No foto');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="decimales" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Decimales');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="decimales" value="<?=intval(Shop::$configuracion->decimales);?>" class="form-control" id="decimales" placeholder="<?= traducir('Decimales');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="controlar_stock" class="label_check col-sm-5 text-right control-label col-form-label"><?=traducir('Controlar stock');?></label>
                                <div class="div_check col-sm-7">
                                    <input type="checkbox" name="controlar_stock" value="<?=Shop::$configuracion->controlar_stock;?>" class="form-control" id="controlar_stock" placeholder="<?= traducir('Controlar stock');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="ocultar_stock_0" class="label_check col-sm-5 text-right control-label col-form-label"><?=traducir('Ocultar stock 0');?></label>
                                <div class="div_check col-sm-7">
                                    <input type="checkbox" name="ocultar_stock_0" value="<?=Shop::$configuracion->ocultar_stock_0;?>" class="form-control" id="ocultar_stock_0">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="segundaMano" class="label_check col-sm-5 text-right control-label col-form-label"><?=traducir('Segunda mano');?></label>
                                <div class="div_check col-sm-7">
                                    <input type="checkbox" name="segundaMano" value="<?=Shop::$configuracion->segundaMano;?>" class="form-control" id="segundaMano">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="url_ebooks" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Url de ebooks');?></label>
                                <div class="col-sm-7">
                                    <input type="text" name="url_ebooks" value="<?=Shop::$configuracion->url_ebooks;?>" class="form-control" id="url_ebooks" placeholder="<?= traducir('Url de ebooks');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="limite_descargas_ebook" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Límite de descargas ebook');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="limite_descargas_ebook" value="<?=Shop::$configuracion->limite_descargas_ebook;?>" class="form-control" id="limite_descargas_ebook" placeholder="<?= traducir('Límite de descargas ebook');?>">
                                </div>
                            </div>
                        </div>




                        <div class="col-xs-12 col-lg-6">
                            <div class="form-group row">
                                <label for="elementos_por_pagina" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Elementos por página');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="elementos_por_pagina" value="<?=Shop::$configuracion->elementos_por_pagina;?>" class="form-control" id="elementos_por_pagina" placeholder="<?= traducir('Elementos por página');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="elementos_relacionados" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Elementos relacionados');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="elementos_relacionados" value="<?=Shop::$configuracion->elementos_relacionados;?>" class="form-control" id="elementos_relacionados" placeholder="<?= traducir('Elementos relacionados');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="elementos_hco_pedidos" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Elementos histórico de pedidos');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="elementos_hco_pedidos" value="<?=Shop::$configuracion->elementos_hco_pedidos;?>" class="form-control" id="elementos_hco_pedidos" placeholder="<?= traducir('Elementos histórico de pedidos');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="elementos_reservas" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Elementos reservas');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="elementos_reservas" value="<?=Shop::$configuracion->elementos_reservas;?>" class="form-control" id="elementos_reservas" placeholder="<?= traducir('Elementos reservas');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="elementos_pedidos_pendientes" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Elementos pedidos pendientes');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="elementos_pedidos_pendientes" value="<?=Shop::$configuracion->elementos_pedidos_pendientes;?>" class="form-control" id="elementos_pedidos_pendientes" placeholder="<?= traducir('Elementos pedidos pendientes');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="elementos_facturas" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Elementos facturas');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="elementos_facturas" value="<?=Shop::$configuracion->elementos_facturas;?>" class="form-control" id="elementos_facturas" placeholder="<?= traducir('Elementos facturas');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="elementos_albaranes" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Elementos albaranes');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="elementos_albaranes" value="<?=Shop::$configuracion->elementos_albaranes;?>" class="form-control" id="elementos_albaranes" placeholder="<?= traducir('Elementos albaranes');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="elementos_depositos" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Elementos depósitos');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="elementos_depositos" value="<?=Shop::$configuracion->elementos_depositos;?>" class="form-control" id="elementos_depositos" placeholder="<?= traducir('Elementos depósitos');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="num_novedades" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Novedades en página');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="num_novedades" value="<?=Shop::$configuracion->num_novedades;?>" class="form-control" id="num_novedades" placeholder="<?= traducir('Novedades en página');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="paginas_a_mostrar" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Páginas a mostrar');?></label>
                                <div class="col-sm-7">
                                    <input type="number" name="paginas_a_mostrar" value="<?=Shop::$configuracion->paginas_a_mostrar;?>" class="form-control" id="paginas_a_mostrar" placeholder="<?= traducir('Páginas a mostrar');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="busquedas_papeleria" class="label_check col-sm-5 text-right control-label col-form-label"><?=traducir('Búsquedas Papelería');?></label>
                                <div class="div_check col-sm-7">
                                    <input type="checkbox" name="busquedas_papeleria" value="<?=Shop::$configuracion->busquedas_papeleria;?>" class="form-control" id="busquedas_papeleria" placeholder="<?= traducir('Búsquedas Papelería');?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="campos_busqueda" class="col-sm-5 text-right control-label col-form-label"><?=traducir('Campos búsqueda');?></label>
                                <div class="col-sm-7">
                                    <input type="text" name="campos_busqueda" value="<?=Shop::$configuracion->campos_busqueda;?>" class="form-control" id="campos_busqueda" placeholder="<?= traducir('Campos búsqueda');?>">
                                </div>
                            </div>
                            
                        </div>

                        <?php
                            //añadimos un campo password que se compruebe antes de enviar en formulario
                        ?>
                        <div class="form-group col-xs-12 col-lg-6 guardar_cambios">
                            <label for="password_guardar_cambios" class="col-sm-12  control-label col-form-label"><strong><?=traducir('Password para guardar cambios');?></strong></label>
                            <div class="col-sm-12">
                                <input type="text" name="password_guardar_cambios" value="" class="form-control" id="password_guardar_cambios" placeholder="<?= traducir('Password requerida para guardar cambios');?>">
                            </div>
                        </div>
                    </div>
                    <div class="border-top">
                        <div class="card-body">
                            <button type="submit" class="btn btn-primary"><?= traducir('Guardar');?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>