<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Formulario de configuración de pedidos-->
<!-- ============================================================== -->
<?php

    //creamos un array para almacenar los campos del formulario
    $campos_formulario = Configuracion::createArrayTableFromForm();

    if(count($campos_formulario) > 0){
        Empresa::updateField(Shop::$configuracion->codigo, array_keys($campos_formulario), $campos_formulario);
        //Recargamos la configuración y la empresa
        //Shop::load();
        //Vamos a recargar la página para evitar que al hacer F5 pida actualizar variables
        Sesion::reloadPage(Shop::$configuracion->url . Sections::$current_section);
    }
    //recoger con getter el password y comprobar si es igual al valor que nosotros le vamos a poner
?>

 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <form class="form-horizontal" method="POST">
                    <div class="card-body">
                        <div class="form-group row">
                            <label for="importe_minimo" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Importe mínimo');?></label>
                            <div class="col-sm-3">
                                <input type="number" name="importe_minimo" value="<?=intval(Shop::$configuracion->importe_minimo);?>" class="form-control" id="importe_minimo" placeholder="<?= traducir('Importe mínimo');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="pedidos_sin_login" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Pedidos sin login');?></label>
                            <div class="div_check col-sm-3">
                                <input type="checkbox" name="pedidos_sin_login" value="<?=Shop::$configuracion->pedidos_sin_login;?>" class="form-control" id="pedidos_sin_login" placeholder="<?= traducir('Pedidos sin login');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="tipo_envio" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Tipo de envío');?></label>
                            <div class="col-sm-3">
                                <input type="number" name="tipo_envio" value="<?=Shop::$configuracion->tipo_envio;?>" class="form-control" id="tipo_envio" placeholder="<?= traducir('Tipo de envío');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="dias_borrado_pedidos_libros" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Días borrado pedidos libros');?></label>
                            <div class="col-sm-3">
                                <input type="number" name="dias_borrado_pedidos_libros" value="<?=Shop::$configuracion->dias_borrado_pedidos_libros;?>" class="form-control" id="dias_borrado_pedidos_libros" placeholder="<?= traducir('Días borrado pedidos libros');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="dias_borrado_pedidos_papeleria" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Días borrado pedidos papelería');?></label>
                            <div class="col-sm-3">
                                <input type="number" name="dias_borrado_pedidos_papeleria" value="<?=Shop::$configuracion->dias_borrado_pedidos_papeleria;?>" class="form-control" id="dias_borrado_pedidos_papeleria" placeholder="<?= traducir('Días borrado pedidos papelería');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="permitir_anular_pedidos_pendientes" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Permitir anular pedidos pendientes');?></label>
                            <div class="div_check col-sm-3">
                                <input type="checkbox" name="permitir_anular_pedidos_pendientes" value="<?=Shop::$configuracion->permitir_anular_pedidos_pendientes;?>" class="form-control" id="permitir_anular_pedidos_pendientes" placeholder="<?= traducir('Permitir anular pedidos pendientes');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="cliente_contado" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Cliente contado');?></label>
                            <div class="col-sm-3">
                                <input type="number" name="cliente_contado" value="<?=Shop::$configuracion->cliente_contado;?>" class="form-control" id="cliente_contado" placeholder="<?= traducir('Cliente contado');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="guardar_pedidos_bd" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Guardar pedidos bd');?></label>
                            <div class="div_check col-sm-3">
                                <input type="checkbox" name="guardar_pedidos_bd" value="<?=Shop::$configuracion->guardar_pedidos_bd;?>" class="form-control" id="guardar_pedidos_bd">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="envio_recogida_tienda" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Envío con recogida en tienda');?></label>
                            <div class="col-sm-4 col-lg-3">
                                <select name="envio_recogida_tienda" class="form-control" id="envio_recogida_tienda">
                                     <option value="0"><?=traducir('Sin tipo de envío');?></option>
                                    <?php

                                    $tipos_envio = array();
                                    $tipos_envio = TipoEnvioCliente::tipoEnvioTodos();

                                    foreach ($tipos_envio as $clave => $valor){
                                        $nombre = $valor->nombre;
                                    ?>
                                        <option value="<?=$valor->codigo;?>"><?= traducir($nombre);?></option>
                                    <?php
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <?php
                            //añadimos un campo password que se compruebe antes de enviar en formulario
                        ?>
                        <div class="form-group row">
                            <label for="password_guardar_cambios" class="col-sm-4 text-right control-label col-form-label"><strong><?=traducir('Password para guardar cambios');?></strong></label>
                            <div class="col-sm-8 col-lg-3">
                                <input type="text" name="password_guardar_cambios" value="" class="form-control" id="password_guardar_cambios" placeholder="<?= traducir('Password requerida para guardar cambios');?>">
                            </div>
                        </div>
                    </div>
                    <div class="border-top">
                        <div class="card-body">
                            <button type="submit" class="btn btn-primary"><?= traducir('Guardar');?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>