<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Formulario de configuración general -->
<!-- ============================================================== -->
<?php

    //creamos un array para almacenar los campos del formulario
    $campos_formulario = Configuracion::createArrayTableFromForm();

    if(count($campos_formulario) > 0){
        Empresa::updateField(Shop::$configuracion->codigo, array_keys($campos_formulario), $campos_formulario);
        //Recargamos la configuración y la empresa
        //Shop::load();
        //Vamos a recargar la página para evitar que al hacer F5 pida actualizar variables
        Sesion::reloadPage(Shop::$configuracion->url . Sections::$current_section);
    }
    //recoger con getter el password y comprobar si es igual al valor que nosotros le vamos a poner
?>

 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <form class="form-horizontal" method="POST">
                    <div class="card-body">

                        <div class="form-group row">
                            <label for="password_encriptado" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Password encriptado');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="password_encriptado" value="<?=Shop::$configuracion->password_encriptado;?>" class="form-control" id="password_encriptado" placeholder="<?= traducir('Password encriptado');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="captchaSiteKey" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Captcha Site Key');?></label>
                            <div class="col-sm-6">
                                <input type="text" name="captchaSiteKey" value="<?=Shop::$configuracion->captchaSiteKey;?>" class="form-control" id="captchaSiteKey" placeholder="<?= traducir('Captcha Site Key');?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="captchaClaveSecreta" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Captcha clave secreta');?></label>
                            <div class="col-sm-6">
                                <input type="text" name="captchaClaveSecreta" value="<?=Shop::$configuracion->captchaClaveSecreta;?>" class="form-control" id="captchaClaveSecreta" placeholder="<?= traducir('Captcha clave secreta');?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="cesta_login_inicio" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Cesta login inicio');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="cesta_login_inicio" value="<?=Shop::$configuracion->cesta_login_inicio;?>" class="form-control" id="cesta_login_inicio" placeholder="<?= traducir('Cesta login inicio');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="segundos_sesion" class=" col-sm-4 text-right control-label col-form-label"><?=traducir('Segundos sesión');?></label>
                            <div class=" col-sm-6">
                                <input type="number" name="segundos_sesion" value="<?=Shop::$configuracion->segundos_sesion;?>" class="form-control" id="segundos_sesion" placeholder="<?= traducir('Segundos sesión');?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="cookies_rules" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Cookies rules');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="cookies_rules" value="<?=Shop::$configuracion->cookies_rules;?>" class="form-control" id="cookies_rules" placeholder="<?= traducir('Cookies rules');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="registro_supervisado" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Registro supervisado');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="registro_supervisado" value="<?=Shop::$configuracion->registro_supervisado;?>" class="form-control" id="registro_supervisado" placeholder="<?= traducir('Registro supervisado');?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="registro_con_confirmacion" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Registro con confirmación');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="registro_con_confirmacion" value="<?=Shop::$configuracion->registro_con_confirmacion;?>" class="form-control" id="registro_con_confirmacion" placeholder="<?= traducir('Registro con confirmación');?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="https_on" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Https ON');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="https_on" value="<?=Shop::$configuracion->https_on;?>" class="form-control" id="https_on" placeholder="<?= traducir('Https ON');?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="sha1_password" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Password formato Sha1');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="sha1_password" value="<?=Shop::$configuracion->sha1_password;?>" class="form-control" id="sha1_password">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="google_api_id" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Google api ID');?></label>
                            <div class="col-sm-6">
                                <textarea name="google_api_id" class="form-control" id="google_api_id" placeholder="<?= traducir('Google api ID');?>"><?= traducir('%-Shop::$configuracion->google_api_id-%');?></textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="guardar_sesion_al_modificar" class="label_check col-sm-4 text-right control-label col-form-label"><?=traducir('Guardar sesión al modificar');?></label>
                            <div class="div_check col-sm-6">
                                <input type="checkbox" name="guardar_sesion_al_modificar" value="<?=Shop::$configuracion->guardar_sesion_al_modificar;?>" class="form-control" id="guardar_sesion_al_modificar" placeholder="<?= traducir('Guardar sesión al modificar');?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="blowfish" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Blowfish');?></label>
                            <div class="col-sm-6">
                                <input type="text" name="blowfish" value="<?=Shop::$configuracion->blowfish;?>" class="form-control" id="blowfish" placeholder="<?= traducir('Blowfish');?>">
                            </div>
                        </div>

                        <?php
                            //añadimos un campo password que se compruebe antes de enviar en formulario
                        ?>
                        <div class="form-group row">
                            <label for="password_guardar_cambios" class="col-sm-4 text-right control-label col-form-label"><strong><?=traducir('Password para guardar cambios');?></strong></label>
                            <div class="col-sm-6">
                                <input type="text" name="password_guardar_cambios" value="" class="form-control" id="password_guardar_cambios" placeholder="<?= traducir('Password requerida para guardar cambios');?>">
                            </div>
                        </div>
                    </div>
                    <div class="border-top">
                        <div class="card-body">
                            <button type="submit" class="btn btn-primary"><?= traducir('Guardar');?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>