<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Formulario de configuración general -->
<!-- ============================================================== -->
<?php

    //creamos un array para almacenar los campos del formulario
    $campos_formulario = Configuracion::createArrayTableFromForm();

    if(count($campos_formulario) > 0){
        Empresa::updateField(Shop::$configuracion->codigo, array_keys($campos_formulario), $campos_formulario);
        //Recargamos la configuración y la empresa
        //Shop::load();
        //Vamos a recargar la página para evitar que al hacer F5 pida actualizar variables
        Sesion::reloadPage(Shop::$configuracion->url . Sections::$current_section);
    }
    //recoger con getter el password y comprobar si es igual al valor que nosotros le vamos a poner
?>

 <!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <form class="form-horizontal" method="POST">
                    <div class="card-body">

                        <div class="form-group row">
                            <label for="descripcion" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Descripción');?></label>
                            <div class="col-sm-6">
                                <textarea name="descripcion" class="form-control" id="descripcion" placeholder="<?= traducir('Descripción');?>"><?= traducir(Shop::$configuracion->descripcion);?></textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="meta" class="col-sm-4 text-right control-label col-form-label"><?=traducir('Meta');?></label>
                            <div class="col-sm-6">
                                <textarea name="meta"  class="form-control" id="meta" placeholder="<?= traducir('Meta');?>"><?= traducir(Shop::$configuracion->meta);?></textarea>
                            </div>
                        </div>
                        
                        <?php
                            //añadimos un campo password que se compruebe antes de enviar en formulario
                        ?>
                        <div class="form-group row">
                            <label for="password_guardar_cambios" class="col-sm-4 text-right control-label col-form-label"><strong><?=traducir('Password para guardar cambios');?></strong></label>
                            <div class="col-sm-4">
                                <input type="text" name="password_guardar_cambios" value="" class="form-control" id="password_guardar_cambios" placeholder="<?= traducir('Password requerida para guardar cambios');?>">
                            </div>
                        </div>
                    </div>
                    <div class="border-top">
                        <div class="card-body">
                            <button type="submit" class="btn btn-primary"><?= traducir('Guardar');?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>