<?php

	//Proceso encargado de recibir los datos que se suban a la web
	//Las imágenes las  guardaremos SIEMPRE con un hash seguido de dos guiones bajos y el nombre de la foto (metiendo guiones bajos en vez de espacios):
	ob_start();
	$error = 0;
	if (count($_FILES) > 0){
		$now = new DateTime();
		$ruta_actual = Getter::get('ruta_actual', '');

		foreach($_FILES as $clave => $fichero){
			$timestamp = $now->getTimestamp();
			//Vamos a ver si la extensión es la correcta:
			$fileName = explode('.', $fichero['name']);
			$extension = '';
			if (count($fileName) > 1){
				$extension = $fileName[count($fileName) - 1];
			}
			$destination = '';
			switch (strtolower($extension)){	//Lo pasamos a minúsculas para que sea más fácil
				case 'jpg':
				case 'jpeg':
				case 'bmp':
				case 'gif':
				case 'png':
					//Es una imagen, ya añadiremos más elementos
					$destination = realpath(_WS_UPLOAD_IMAGES_DIR_ . DIRECTORY_SEPARATOR . $ruta_actual) . DIRECTORY_SEPARATOR . $timestamp . '__' . str_replace(' ', '_', $fichero['name']) ;
				break;
				default:
					$error = 406;
			}
			if ($destination != ''){
				if (!move_uploaded_file($fichero['tmp_name'], $destination)) {
					$error = 409;
				}
			}
		}
	}else{
		$error = 400;
	}
	/*
	//Con este código podemos generar una traza que se guardarán en la raíz del admin
	$data = ob_get_clean();
	if ($file = fopen('test.txt', 'a+')){
		fputs($file, $data);
		fclose($file);
	}
	*/
	if ($error > 0){
		//Ahora es el momento de devolver la respuesta:
		//Limpiamos la salida de pantalla
		ob_clean();
		//Vamos a indicar que el retorno es json:
		http_response_code($error);
	}