<?php

//---------------------------------------------------------------------------------------------------------
// 16/Enero/2015
// Versión 1.0 Widget con todos los datos relevantes de la ficha del artículo
// 13/01/2016
// version 1.1 Corregido el nombre de una variable  a la hora de igualar articulo con el articulo actual linea 111
//---------------------------------------------------------------------------------------------------------



function widget_articulo() {
	include('comunes/globals.php');
	//Aquí definimos una serie de parámetros que necesitamos
	$funcion_por_defecto = 'mini_ficha';
	$parametros_por_defecto = array();
	$parametros_recibidos = func_get_args();
	if (count($parametros_recibidos) == 0) {
		$parametros_recibidos[0] = $funcion_por_defecto;
	} else {
		if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
			$parametros_recibidos[0] = $funcion_por_defecto;
		}
	}
	$parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
	$retorno = false;
	//Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
	if (count($parametros_recibidos) > 0) {
		//Recogemos el nombre de la función de entre el resto de parámetros
		$nombre_funcion = $parametros_recibidos[0];
		//Quitamos el primer elemento de los parámetros, pues es el nombre de la función
		$parametros_recibidos = array_slice($parametros_recibidos, 1);
		//La ficha del artículo es un poco especial. Antes de cargar la función, vamos a ver si existe el fichero
		//Tenemos que comprobar si hay seleccionada una vista "especial" de la ficha
		$tipo_ficha_producto = Sesion::get('tipo_ficha_producto');

		$ruta_fichero = Theme::findFile($nombre_funcion . '_' . $tipo_ficha_producto . '.php');
		if ($ruta_fichero == NULL) {
			//No existe, vamos a coger la que haya solicitado el usuario
			$ruta_fichero = Theme::findFile($nombre_funcion . '.php');
		}
		
		if ($ruta_fichero != NULL) {
			//Tenemos que cargar el artículo
			if ($parametros_recibidos[0] != NULL) {
				$articulo_a_mostrar = $parametros_recibidos[0];
			} else {
				$articulo_a_mostrar = $articulo_actual;
			}
			//En el siguiente parámetro que reicba, entiendo que va el opciones Widget
			$opciones = NULL;
			if (count($parametros_recibidos) > 1) {
				$opciones = $parametros_recibidos[1];
			}
			$tipo_dato = gettype($articulo_a_mostrar);
			//echo("El tipo de dato recibido es: $tipo_dato<br />\n");
			if (($tipo_dato == 'integer') || ($tipo_dato == 'string')) {
				//Cargamos el objeto
				$articulo_a_mostrar = new Articulo($articulo_a_mostrar);
			}
			//var_dump($opciones);
			//Vamos a coger el valor del data-update que es quien determina en qué eventos javascript se recargará
			$data_update = isset($opciones->configuracion->data_update) ? $opciones->configuracion->data_update : '';
			$data_update = ($data_update != '') ? $data_update = 'data-update="' . $data_update . '"' : '';
			$tam_portada = Shop::$configuracion->tam_portada($nombre_funcion);
			//Vamos a usar una variable para meter la imagen del fichero
			//$capa_imagen = '<figure><img src="' . Shop::$configuracion->url . 'miniatura/' . $tam_portada[0] . '/' . $tam_portada[1] . '/' . $articulo_a_mostrar->ean . '.jpg" alt="' . $articulo_a_mostrar->nombre . '" width="' . $tam_portada[0] . '" height="' . $tam_portada[1] . '"/><figcaption>' . $articulo_a_mostrar->nombre . '</figcaption></figure>';
			$configuracionWidget = base64_encode(serialize(array(
				'widget' => 'articulo',
				'function' => $nombre_funcion,
				'opciones' => $articulo_a_mostrar->codigo
			)));
			?>
			<div id="ficha_producto_<?= $articulo_a_mostrar->codigo; ?>" class="contenedor_article" data-file="<?= $nombre_funcion; ?>" data-type="ficha_producto" <?=$data_update;?> data-configuration="<?=$configuracionWidget;?>">
				<?php
				if (($articulo_a_mostrar->no_web == 0) && ($articulo_a_mostrar->codigo > 0)) {
					include($ruta_fichero);
				} else {
					?>
					<p class="articulo_no_encontrado"><span class="error"><?= traducir('Error'); ?>.</span> <?= traducir('El artículo seleccionado no está disponible.'); ?></p>
					<?php
				}
				?>
			</div>
			<?php
			$retorno = true;
		} else {
			//Hay que ejecutar la función
			if (function_exists($nombre_funcion)) {
				$retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
			}
		}
	}
	return($retorno);
}

/**
 * 
 * @param type $tipo
 * @param type $lista_articulos
 * @return type
 */
function lista_articulos($tipo = 'mini_ficha', $lista_articulos = NULL) {
	include('comunes/globals.php');
	$retorno = FALSE;
	$ocultarCabecera = FALSE;
	if (is_a($tipo, 'OpcionesWidget')) {
		$opciones = $tipo;
		$tipo = ($opciones->configuracion->tipo != NULL) ? $opciones->configuracion->tipo : 'mini_ficha';
		$lista_articulos = ($opciones->configuracion->lista_articulos != NULL) ? $opciones->configuracion->lista_articulos : $lista_articulos;
		$ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
	}
	
	if ($lista_articulos != NULL) {
		if (!$ocultarCabecera) {
			?>
			<div class="<?= (__FUNCTION__); ?>">
				<?php
			}
			for ($i = 0; $i < count($lista_articulos); $i++) {
				$articulo_a_mostrar = $lista_articulos[$i];
				new Widget($_WH->GW('articulo', $tipo), $articulo_a_mostrar);
			}
			$retorno = true;
			if (!$ocultarCabecera) {
				?>
			</div>
			<?php
		}
	}
	return($retorno);
}

function escaparates_articulo($articulo = NULL) {
	include('comunes/globals.php');
	?>
	<div class="<?= (__FUNCTION__); ?>">
		<?php
		$tipo_dato = gettype($articulo);
		//echo("El tipo de dato recibido es: $tipo_dato<br />\n");
		if (($tipo_dato == 'integer') || ($tipo_dato == 'string')) {
			//Cargamos el objeto
			$articulo = new Articulo($articulo);
		}
		if ($articulo == NULL) {
			//$articulo = $articulo_a_mostrar; Comentamos la linea para corregir un fallo
			$articulo = $articulo_actual;
		}
		if ($articulo != NULL) {
			if (count($articulo->lista_escaparates) > 0) {
				//Vamos a utilizar el widget que ya tenemos hecho para mostrar una lista de escaparates
				?>
				<p class="cabecera_lista_escaparates"><?= traducir('Categorías'); ?>: </p>
				<?php
				//La siguiente línea es erronea porque muestra los hijos del escaparate actual. Esta función debe mostrar los escaparates del artículo
				//new Widget($_WH->GW("lista_escaparates", "lista_escaparates"), $escaparate_actual->hijos);
				new Widget($_WH->GW('lista_escaparates', 'lista_escaparates'), $articulo->lista_escaparates);
			}
		}
		?>
	</div>
	<?php
	return(true);
}

function temas_articulo($articulo = NULL) {
	include('comunes/globals.php');
	$tipo_dato = gettype($articulo);
	//echo("El tipo de dato recibido es: $tipo_dato<br />\n");
	if (($tipo_dato == 'integer') || ($tipo_dato == 'string')) {
		//Cargamos el objeto
		$articulo = new Articulo($articulo);
	}
	if ($articulo == NULL) {
		$articulo = $articulo_a_mostrar;
	}
	if ($articulo != NULL) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<p class="cabecera_lista_temas"><?= traducir('Temas de interés'); ?></p>
			<?php
			for ($i = 0; $i < count($articulo_a_mostrar->temas); $i++) {
				?>
				<p class="elemento_lista_temas"><a href="javascript:void(0);" title="<?= $articulo_a_mostrar->temas[$i]->nombre; ?>"><?= $articulo_a_mostrar->temas[$i]->nombre; ?></a></p>
				<?php
			}
			?>
		</div>
		<?php
	}
	return(true);
}

function portada($ean_articulo, $parametros) {
	include('comunes/globals.php');
	//Parámetros es un array, vamos a obtener sus valores
	$nombre_funcion = 'mini_ficha';
	$nombre_articulo = '';
	$armiBox = false;
	$funcion_armiBox = 'ficha_ampliada';
	$extraData = '';
	$ruta_local = 'miniatura';
	$formato = 'jpg';

	//Si parametros no es un array, no hacemos nada
	if (gettype($parametros) == 'array') {
		foreach ($parametros as $clave => $valor) {
			$$clave = $valor;
		}
	}

	//Vamos ahora a mostrar la imagen
	$tam_portada = Shop::$configuracion->tam_portada($nombre_funcion);
	//Si no hemos recibido EAN, cogemos el del artículo actual
	if ($ean_articulo == '') {
		if (isset($articulo_a_mostrar)) {
			$ean_articulo = $articulo_a_mostrar->ean;
			$nombre_articulo = $articulo_a_mostrar->nombre;
		}
	}
	//Si se usa el armibox, llamamos de nuevo a este widget para crear las capas pero sin armibox
	if ($armiBox) {
		$imagen_grande = new Widget($_WH->GW('articulo', 'imagen_articulo', 'modal', false), $ean_articulo, $funcion_armiBox, '', false);
		$imagen_peque = new Widget($_WH->GW('articulo', 'imagen_articulo', 'php', false), $ean_articulo, $nombre_funcion, $nombre_articulo, false);
		new Widget(LW_params(), $imagen_grande, $imagen_peque, 'a', 'onclick');
	} else {
		//Si no, símplemente creamos la imagen
		//No mostramos el div si no hay extradata
		if ($extraData == '') {
			?>
			<div class="<?= (__FUNCTION__); ?>">
				<?php
			}
			//Mostramos la imagen
			if ($nombre_articulo != '') {
				?>
				<figure>
					<?php
				}
				?>
				<img src="<?= Shop::$configuracion->url; ?><?= $ruta_local; ?>/<?= $tam_portada[0]; ?>/<?= $tam_portada[1]; ?>/<?= $ean_articulo; ?>.<?= $formato; ?>" alt="<?= $nombre_articulo; ?>" width="<?= $tam_portada[0]; ?>" height="<?= $tam_portada[1]; ?>" <?= $extraData; ?>  class="imagen_<?= $ean_articulo; ?>"/>
				<?php
				if ($nombre_articulo != "") {
					?>
					<figcaption><?= $nombre_articulo; ?></figcaption>
				</figure>
				<?php
			}
			if ($extraData == "") {
				?>
			</div>
			<?php
		}
	}
}

function imagen_articulo($ean_articulo = '', $nombre_funcion = 'mini_ficha', $nombre_articulo = '', $armiBox = false, $funcion_armiBox = 'ficha_ampliada', $extraData = '') {
	include('comunes/globals.php');
	//Hay sitios dónde el producto se guarda en la variable "articulo_a_mostrar" y otros en los que se guarda en "articulo_a_mostrar". Esto hay que unificarlo
	$array_tmp = array(
		'nombre_funcion' => $nombre_funcion,
		'nombre_articulo' => $nombre_articulo,
		'armiBox' => $armiBox,
		'funcion_armiBox' => $funcion_armiBox,
		'extraData' => $extraData);
	portada($ean_articulo, $array_tmp);
}

function lupa_articulo($opciones = NULL) {
	include('comunes/globals.php');
	$articulo = $articulo_actual;
	$tam_foto = 'lupa_articulo';
	$tam_ampliacion = 'ampliacion';
	$ruta_local = 'miniatura';
	$ruta_local_ampliacion = 'miniatura';
	$formato = 'jpg';
	$formato_ampliacion = 'jpg';
	if ($opciones == NULL) {
		$opciones = new OpcionesWidget();
	}
	$articulo = ($opciones->configuracion->articulo != NULL) ? $opciones->configuracion->articulo : $articulo;
	$tam_foto = ($opciones->configuracion->tam_foto != NULL) ? $opciones->configuracion->tam_foto : $tam_foto;
	$tam_ampliacion = ($opciones->configuracion->tam_ampliacion != NULL) ? $opciones->configuracion->tam_ampliacion : $tam_ampliacion;
	$ruta_local = ($opciones->configuracion->ruta_local != NULL) ? $opciones->configuracion->ruta_local : $ruta_local;
	$ruta_local_ampliacion = ($opciones->configuracion->ruta_local_ampliacion != NULL) ? $opciones->configuracion->ruta_local_ampliacion : $ruta_local_ampliacion;
	$formato = ($opciones->configuracion->formato != NULL) ? $opciones->configuracion->formato : $formato;
	$formato_ampliacion = ($opciones->configuracion->formato_ampliacion != NULL) ? $opciones->configuracion->formato_ampliacion : $formato_ampliacion;

	$tam_portada_original = Shop::$configuracion->tam_portada($tam_foto);
	$tam_portada_ampliacion = Shop::$configuracion->tam_portada($tam_ampliacion);

	if (is_a($articulo, 'Articulo')) {
		?>
		<div class="<?= (__FUNCTION__); ?>">
			<figure>
				<img src="<?= Shop::$configuracion->url; ?><?= $ruta_local; ?>/<?= $tam_portada_original[0]; ?>/<?= $tam_portada_original[1]; ?>/<?= $articulo->ean; ?>.<?= $formato; ?>" width="<?= $tam_portada_original[0]; ?>" height="<?= $tam_portada_original[1]; ?>" class="imagen_<?= $articulo->ean; ?>">
				<?php
				$nombre_script = 'script_' . incrementa_contador();
				?>
				<script type="text/javascript" id="<?=$nombre_script;?>">
				document.addEventListener('WSLE', function(event) {
					var objeto = getLastHtmlObject('<?= $nombre_script; ?>');
					armiLupa(objeto, "<?= Shop::$configuracion->url; ?><?= $ruta_local_ampliacion; ?>/<?= $tam_portada_ampliacion[0]; ?>/<?= $tam_portada_ampliacion[1]; ?>/<?= $articulo->ean; ?>.<?= $formato_ampliacion; ?>");
				});
				</script>
				<figcaption><?= $articulo->nombre; ?></figcaption>
			</figure>
		</div>
		<?php
	}
}

//Añadimos las nuevas funcionalidades de la ficha del artículo
include_once('articulo_extra.php');
?>