<?php

//---------------------------------------------------------------------------------------------------------
// 27/Enero/2015
// Versión 1.0 Versión unificada del buscador avanzado y del simple
//---------------------------------------------------------------------------------------------------------



function widget_carrousel() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'carrousel';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

/**
 * Si recibimos un fichero Slide en vez de un array de slides, siempre mostramos a este.
 * Si estamos en el caso anterior y además tenemos un incremento slide, se cargaran las plantillas de la forma "fichero_" + contador
 * En caso contrario se cargará el array.
 * Siempre se cargan el número de slides definido en numSlides, Si el array tiene menos objetos, repetiremos el último
 * El resto de parámetros son triviales
 * @param OpcionesWidget $opciones
 * @return type
 */
function carrousel($opciones = NULL) {
    include('comunes/globals.php');

    //Inicializamos variables:
    $ficheroSlide = 'slide';
    $ficheroLeftArrow = 'leftArrow';
    $ficheroRightArrow = 'rightArrow';
    $ocultarCabecera = false;
    $id = "carrousel" . incrementa_contador();
    $arraySlides = Array();
    $numSlides = 1;
    $hasIndicator = true;
    $hasArrow = true;
    $playOnLoad = true;
    $incrementoSlide = 0;
    $extraParams = NULL;
    $dataType = NULL;
    $interval = 3000;
	$pasoAPaso = false;

    //Variables de la función
    $contadorSlide = 0;
    //Nos aseguramos de que el "opciones"
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    //Seteamos las variables en función de "opciones" y su valor por defecto

    if (is_a($opciones, 'OpcionesWidget')) {
        $ficheroSlide = ($opciones->configuracion->ficheroSlide != NULL) ? $opciones->configuracion->ficheroSlide : $ficheroSlide;
        $ficheroLeftArrow = ($opciones->configuracion->ficheroLeftArrow != NULL) ? $opciones->configuracion->ficheroLeftArrow : $ficheroLeftArrow;
        $ficheroRightArrow = ($opciones->configuracion->ficheroRightArrow != NULL) ? $opciones->configuracion->ficheroRightArrow : $ficheroRightArrow;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        $id = ($opciones->configuracion->id != NULL) ? $opciones->configuracion->id : $id;
        $arraySlides = ($opciones->configuracion->arraySlides != NULL) ? $opciones->configuracion->arraySlides : $arraySlides;
        $numSlides = ($opciones->configuracion->numSlides != NULL) ? $opciones->configuracion->numSlides : $numSlides;
        $hasIndicator = ($opciones->configuracion->hasIndicator != NULL) ? $opciones->configuracion->hasIndicator : $hasIndicator;
        $hasArrow = ($opciones->configuracion->hasArrow != NULL) ? $opciones->configuracion->hasArrow : $hasArrow;
        $playOnLoad = ($opciones->configuracion->playOnLoad !== NULL) ? $opciones->configuracion->playOnLoad : $playOnLoad;
        $incrementoSlide = ($opciones->configuracion->incrementoSlide != NULL) ? $opciones->configuracion->incrementoSlide : $incrementoSlide;
        $extraParams = ($opciones->configuracion->extraParams != NULL) ? $opciones->configuracion->extraParams : $extraParams;
        $dataType = ($opciones->configuracion->dataType != NULL) ? $opciones->configuracion->dataType : $dataType;
        $interval = ($opciones->configuracion->interval !== NULL) ? $opciones->configuracion->interval : $interval;
		$pasoAPaso = ($opciones->configuracion->pasoAPaso !== NULL) ? $opciones->configuracion->pasoAPaso : $pasoAPaso;
    }

    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>"><!--Carrusel-->
		<?php
        }
        //Aquí va el código
        //No hay nada si no hay slides o slide base
        //$numSlides = (count($arraySlides) == 0) ? 0 : max($numSlides, count($arraySlides));
		$numSlides = max($numSlides, count($arraySlides));
        if ($numSlides > 0) {
            ?>

            <div id="<?= $id; ?>" class="carousel slide" <?= ($playOnLoad) ? 'data-ride="carousel"' : ''; ?> <?=($dataType != NULL) ? 'data-type="' . $dataType . '"':'';?> <?=($interval != NULL) ? 'data-interval="' . $interval . '"':'';?>>
                <?php
                //si tiene indicadores, los mostramos:
                if ($hasIndicator) {
                    ?>
                    <!-- Indicators -->
                    <ol class="carousel-indicators">
                        <?php
                        for ($countSlides = 0; $countSlides < $numSlides; $countSlides++) {
                            ?>
                            <li data-target="#<?= $id; ?>" data-slide-to="<?= $countSlides; ?>" <?= ($countSlides == 0) ? 'class="active"' : ''; ?>></li>
                            <?php
                        }
                        ?>
                    </ol>
                    <?php
                }
                ?>
                <!-- Wrapper for slides -->
                <div class="carousel-inner" role="listbox">
                    <?php
                    if ($numSlides > 0) {
                        for ($countSlides = 0; $countSlides < $numSlides; $countSlides++) {
                            //Si hay slides en el array, tenemos que coger la que corresponde
                            if (count($arraySlides) == 0) {
                                //No hay array, es siempre el fichero slide
                                $nuevaSlide = $slideAnterior = $ficheroSlide;
                            } else {
                                //Comprobamos si en el array hay slides y si no, cogemos la última q se usó
                                $nuevaSlide = $slideAnterior = (isset($arraySlides[$countSlides])) ? $arraySlides[$countSlides] : $slideAnterior;
                            }
                            //Si el fichero anteriormente seleccionado es el mismo al actual y hay incremento, se lo metemos:
                            if (($slideAnterior == $nuevaSlide)) {
                                if ($incrementoSlide > 0) {
                                    $nuevoFichero = $nuevaSlide . "_" . $contadorSlide;
                                    $contadorSlide++;
                                }
                            }
                            //Vamos a cargar la slide

                            $ficheroPerso = Theme::findFile($nuevaSlide . ".php");
                            if ($ficheroPerso != NULL) {
                                ?>
                                <div class="item <?= ($countSlides == 0) ? 'active' : ''; ?>">
                                    <?php
									/*var_dump($ficheroPerso);
									echo("<br>");*/
                                    include($ficheroPerso);
                                    ?>
                                </div>
                                <?php
                            }
                            $slideAnterior = $nuevaSlide;
                            ?>
                            <?php
                        }
                    }
                    ?>
                </div>
                <?php
                if ($hasArrow) {
                    ?>
                    <!-- Left and right controls -->
                    <a class="left carousel-control" href="#<?= $id; ?>" role="button" data-slide="prev">
                        <?php
                        $ficheroPerso = Theme::findFile($ficheroLeftArrow . ".php");
                        if ($ficheroPerso != NULL) {
                            include($ficheroPerso);
                        }
                        ?>
                    </a>
                    <a class="right carousel-control" href="#<?= $id; ?>" role="button" data-slide="next">
                        <?php
                        $ficheroPerso = Theme::findFile($ficheroRightArrow . ".php");
                        if ($ficheroPerso != NULL) {
                            include($ficheroPerso);
                        }
                        ?>

                    </a>
                    <?php
                }
                ?>
            </div>
            <?php
			//Modificado por Pedro el 18/Mayo/2018 ==> Corregimos esto para que se puedan poner varios sliders de productos simultaneos:
			if ($pasoAPaso){
				?>
				<script>
				document.addEventListener('WSLE', function(event) {
					$('#<?=$id;?> .item').each(function () {
						var next = $(this).next();
						if (!next.length) {
							next = $(this).siblings(':first');
						}
						next.children(':first-child').clone().appendTo($(this));

						for (var i = 0; i < <?=$numSlides - 2;?>; i++) {
							next = next.next();
							if (!next.length) {
								next = $(this).siblings(':first');
							}

							next.children(':first-child').clone().appendTo($(this));
						}
					});
                    //Vamos a poner las imágenes a manubrio
                    $('.carousel[data-type="multi"] .item').each(function () {
                        $(this).find('img').each(function(){
                            //Esto lo hacemos por el lazy load
                            if ( ($(this).attr('src') == null) || ($(this).attr('src').indexOf("loading.gif") >= 0) ){	//Si es nulo o la imagen es la de carga
                                //if ($(this).attr('data-src') != null){
                                    $(this).attr('src', $(this).attr('data-src'));
                                //}
                            }
                        });
                    });
				});
				</script>
				<?php
			}
        }
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
    <?php
    return(true);
}
?>