<?php

//---------------------------------------------------------------------------------------------------------
// 25/Noviembre/2015
// Versión 1.0 Cargamos un csv
//---------------------------------------------------------------------------------------------------------



function widget_adjuntos($nombre_funcion = 'ficheros_adjuntos') {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'ficheros_adjuntos';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function ficheros_adjuntos($opciones = NULL) {
    //echo'Ficheros adjuntos XD';
    include('comunes/globals.php');
    $fichero = 'catalogoView';
    $condicion = '';
    $activo = NULL;
    $ocultarCabecera = false;
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : $fichero;
        $condicion = ($opciones->configuracion->condicion != null) ? $opciones->configuracion->condicion : $condicion;
        $activo = ($opciones->configuracion->activo != null) ? $opciones->configuracion->activo : $activo;
        $catalogos = Catalogo::cargar_lista($condicion, $activo);
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        //var_dump($catalogos);
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
            }
            ?>
            <?php
            foreach ($catalogos as $key => $obj) {
                //var_dump($obj);
                $opciones->addProperty('catalogo', $obj);
                new Widget($_WH->GW('adjuntos', 'fichero_adjunto'), $opciones);
            }
            ?>
            <?php
            if (!$ocultarCabecera) {
                ?>
            </div>
            <?php
        }
        ?>
        <?php
    }
    return(true);
}

function fichero_adjunto($opciones = NULL) {
    //echo"Fichero Adjunto";
    include('comunes/globals.php');
    $fichero = 'catalogoView';
    $catalogo = NULL;
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $fichero = ($opciones->configuracion->fichero != NULL) ? $opciones->configuracion->fichero : $fichero;
        $catalogo = ($opciones->configuracion->catalogo != NULL) ? $opciones->configuracion->catalogo : $catalogo;
        if ($catalogo != NULL) {
            // echo 'hay catalogo';
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
                $ruta_fichero = Theme::findFile($fichero . '.php');
                if ($ruta_fichero != NULL) {
                    //No hacemos nada de esto si no existe el fichero	
                    //hacemos el include del fichero en cuestión
                    include($ruta_fichero);
                }
                ?>
            </div>
            <?php
        }
    }
}

function listaCondicionesCatalogo($opciones = NULL) {
    include('comunes/globals.php');
    $sentencia = 'SELECT DISTINCT  `condicion` FROM catalogo';
    if ($conexionBD) {
        $resultado = mysqli_query($conexionBD, $sentencia);
        ?>
        <ul>
            <?php
            while ($fila = mysqli_fetch_array($resultado)) {
                ?>
                <li><a href="<?= Shop::$configuracion->url ?>catalogos/<?= $fila['condicion'] ?>"><?= $fila['condicion'] ?></a></li>
                <?php
            }
            ?>
        </ul>
        <?php
    }
}
?>