<?php
	//---------------------------------------------------------------------------------------------------------
	// 03/Julio/2015
	// Versión 1.0 Extensión de widget de la cesta de la compra
	//---------------------------------------------------------------------------------------------------------

	

	function cesta_completaV2($opciones = NULL){
		//Esta cesta no tiene "div" porque utiliza la cesta completa de toda la vida
		include('comunes/globals.php');
		//Vamos a empezar por tratar las opciones:
		$html_cabecera = '';
		$separador = '';
		$fichero_lineas = 'linea_cesta';
        $widget_login = new Widget($_WH->GW('usuario', 'login', 'php', false), '', true);
        $widget_direcciones = new Widget($_WH->GW('direcciones_envio', 'muestra_datos_dir_predeterminada', 'php', false));
        $widget_datos_envio = new Widget($_WH->GW('usuario', 'peticion_datos_sin_registro', 'php', false));
        $widget_totales_cesta = new Widget($_WH->GW('cesta_compra', 'totales_cesta', 'php', false));
		if ( ($opciones != NULL) && (is_a($opciones, 'OpcionesWidget') ) ){
			if ($opciones->configuracion->html_cabecera != NULL){
				$html_cabecera = $opciones->configuracion->html_cabecera;
			}
			if ($opciones->configuracion->separador != NULL){
				$separador = $opciones->configuracion->separador;
			}
			if ($opciones->configuracion->fichero_lineas != NULL){
				$fichero_lineas = $opciones->configuracion->fichero_lineas;
			}
			if ($opciones->configuracion->widget_login != NULL){
				$widget_login = $opciones->configuracion->widget_login;
			}
			if ($opciones->configuracion->widget_direcciones != NULL){
				$widget_direcciones = $opciones->configuracion->widget_direcciones;
			}
			if ($opciones->configuracion->widget_datos_envio != NULL){
				$widget_datos_envio = $opciones->configuracion->widget_datos_envio;
			}
			if ($opciones->configuracion->widget_totales_cesta != NULL){
				$widget_totales_cesta = $opciones->configuracion->widget_totales_cesta;
			}
		}

		//Al final de todo el proceso, ejecutamos el 'cesta completa' pero pasándole los parámetros anteriores
		cesta_completa($html_cabecera, $separador, $fichero_lineas, $widget_login, $widget_direcciones, $widget_datos_envio, $widget_totales_cesta);
	}
	
	
	function totales_cesta($opciones = NULL){
		
		//Variables que intervienen en el proceso:
		$cod_cliente = 0;
		
		$datos_usuario = Usuario::logueado();
		if ($datos_usuario != NULL){
			$cod_cliente = $datos_usuario->codigo;
		}

		$ruta_fichero = 'totales_cesta';
		$tipoCapaContenedora = "div";
		$dataUpdate = 'cart';
		$calcular_totales_desde_cesta = false;
		if (is_a($opciones, 'OpcionesWidget') ){
			$ruta_fichero = ($opciones->configuracion->ruta_fichero != NULL) ? $opciones->configuracion->ruta_fichero : $ruta_fichero;
			$tipoCapaContenedora = ($opciones->configuracion->tipoCapaContenedora != NULL) ? $opciones->configuracion->tipoCapaContenedora : $tipoCapaContenedora;
			$dataUpdate = ($opciones->configuracion->dataUpdate != NULL) ? $opciones->configuracion->dataUpdate : $dataUpdate;
		}
		
		//aquí va el include:
		//echo('El fichero a incluir es: $ruta_fichero<br />\n');
		$ficheroOriginal = $ruta_fichero;
		if($tipoCapaContenedora != ''){
			$configuracionWidget = base64_encode(serialize(array(
				'widget' => 'cesta_compra',
				'function' => 'totales_cesta',
				'opciones' => $opciones
			)));
?>
<<?=$tipoCapaContenedora;?> class="contenedor_<?=(__FUNCTION__);?>" data-update="<?=$dataUpdate;?>" data-configuration="<?=$configuracionWidget;?>">
<?php
		}
		//Vamos a coger la cesta:
		$cart = CabeceraCesta::getCart();
		Theme::include_file($ruta_fichero . '.php', $cart);	//Le pasamos el objeto cesta
		if($tipoCapaContenedora != ''){
?>
</<?=$tipoCapaContenedora;?>>
<?php
		}
		
	}
include('cesta_completa.php');
?>
