<?php
//---------------------------------------------------------------------------------------------------------
// 23/Noviembre/2015
// Creamos la clase SuperDepósito
//---------------------------------------------------------------------------------------------------------

include('comunes/globals.php');


//---------------------------------------------------------------------------------------------------------
//----------------    SUPERDEPOSITO
//---------------------------------------------------------------------------------------------------------

class SuperDeposito{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

	public $codigo = 0;
	public $articulo = '';
	public $albaran = 0;
	public $cab_albaran = 0;
	public $fecha = '';
	public $cliente = '';
	public $cantidad = 0;
	public $cargo = '';
	public $dto = 0;
	public $cantidad_abonada = 0;
	public $cantidad_cargar = 0;
	public $cantidad_abonar = 0;
	public $pvp = 0;
	public $total = 0;
	public $facturar = false;
	public $fecha_vencimiento = 0;
	public $novedad = false;
	//Datos extra que utilizaremos para no tener que cargar todos los datos del cliente y el albarán:
	public $nombre_cliente = '';
	public $nombre_articulo = '';
	//public $ean = '';
	public $numero_albaran = '';
	
	function __construct($codigo, $cargar_articulo = false, $cargar_cliente = false, $cargar_albaran = false, $cargar_lineas_albaran = false, $cargar_articulos_albaran = false){
		include('comunes/globals.php');
		//Cargamos todos los datos de los lotes dependiendo lo que pasemos
		$sentencia_sql = 'SELECT deposito.codigo codigo, deposito.articulo articulo, deposito.cab_albaran cab_albaran, deposito.fecha fecha, deposito.cliente cliente, deposito.cantidad cantidad, deposito.cargo cargo, 
						deposito.dto dto, deposito.cantidad_abonada cantidad_abonada, deposito.cantidad_cargar cantidad_cargar, deposito.cantidad_abonar cantidad_abonar, deposito.pvp pvp, deposito.total total, 
						deposito.facturar facturar, deposito.fecha_vencimiento fecha_vencimiento, deposito.novedad novedad, 
						cliente.codigo cliente, cliente.nombre_legal nombre_cliente,
						articulo.nombre nombre_articulo, 
						cab_albaran.num_doc numero_albaran
						FROM cliente, articulo, deposito
						LEFT JOIN cab_albaran ON cab_albaran.codigo = deposito.cab_albaran 
						WHERE cliente.codigo_sinlib = deposito.cliente 
						AND articulo.codigo = deposito.articulo 
						AND deposito.codigo = '.$codigo;
		//echo('$sentencia_sql<br />\n');
		if ($conexionBD){
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
				if ($fila = mysqli_fetch_array($resultado)){
					$this->codigo = $fila['codigo'];
					$this->articulo = $fila['articulo'];
					$this->albaran = $fila['cab_albaran'];
					$this->cab_albaran = $fila['cab_albaran'];
					$this->fecha = date_create($fila['fecha']);
					$this->cliente = $fila['cliente'];
					$this->cantidad = $fila['cantidad'];
					$this->cargo = $fila['cargo'];
					$this->dto = $fila['dto'];
					$this->cantidad_abonada = $fila['cantidad_abonada'];
					$this->cantidad_cargar = $fila['cantidad_cargar'];
					$this->cantidad_abonar = $fila['cantidad_abonar'];
					$this->pvp = $fila['pvp'];
					$this->total = $fila['total'];
					$this->facturar = ($fila['facturar'])? true : false;
					$this->fecha_vencimiento = date_create($fila['fecha_vencimiento']);
					$this->novedad = ($fila['novedad'])? true : false;
					//Campos extra:
					$this->nombre_cliente = $fila['nombre_cliente'];
					$this->nombre_articulo = $fila['nombre_articulo'];
					//$this->ean = $fila['ean'];
					$this->numero_albaran = $fila['numero_albaran'];
				}
			}
			//Ahora toca tener en cuenta si tenemos que cargar cliente, articulo y albaran (con sus líneas y sus artículos.
			//Ojo que el código de cliente que estamos recibiendo es el de SINLIB.
			//Empezamos con el cliente. Cómo el código que tenemos es el código SINLIB, vamos a cargar el código de la web o el objeto cliente en todo caso:
			if ($cargar_cliente){
				$this->cliente = new Usuario($this->cliente);
			}
			if ($cargar_albaran){
				$this->albaran = new Albaran($this->albaran, $cargar_lineas_albaran, $cargar_articulos_albaran, $crear_objeto_cliente);
				//Si tenemos un objeto cliente, lo asignamos al albaran:
				if (is_a($this->cliente, 'Usuario')){
					$this->albaran->cliente = $this->cliente;
				}
			}
			if($cargar_articulo){
				$this->articulo = new Articulo($this->articulo);
			}
		}
	}
	
	function __destruct(){
		unset($this->codigo);
		unset($this->articulo);
		unset($this->albaran);
		unset($this->fecha);
		unset($this->cliente);
		unset($this->cantidad);
		unset($this->cargo);
		unset($this->dto);
		unset($this->cantidad_abonada);
		unset($this->cantidad_cargar);
		unset($this->cantidad_abonar);
		unset($this->pvp);
		unset($this->total);
		unset($this->facturar);
		unset($this->fecha_vencimiento);
		unset($this->novedad);
	}
	
}
?>