<?php
/*
  Clase SuperEmpresa
  @version 1.0
 */
class SuperEmpresa extends Objeto{
    public static $campos_tabla = array();
    public static $alias = '';
    public static $nombreTabla = '';
    public static $camposSelect = '';
    public static $whereSelect = '';
    public static $publicFieldList = array(
        'email_empresa' => 'email_empresa',
        'direccion_email' => 'email',
        'usuario_email' => 'usuario',
        'password_email' => 'password',
        'smtp_email' => 'smtp',
        'direccion_email_pedidos' => 'direccion_email_pedidos',
        'herbolib_modulo_distribucion' => 'herbolib_modulo_distribucion',
        'forzar_descuentos' => 'forzar_descuentos',
    );

    public $codigo = 0;
    public $nombre_legal = '';
    public $nombre = '';
    public $direccion_email = '';
    public $usuario_email = '';
    public $password_email = '';
    public $smtp_email = '';
    public $direccion = '';
    public $cod_postal = '';
    public $localidad = '';
    public $provincia = '';
    public $pais_empresa = '';
    public $objetoPais = '';
    public $cif = '';
    public $telefono_empresa = '';
    public $horario = '';
    public $iframe_gmaps = '';
    public $logo_email = '';
    public $email_empresa = '';
	public $direccion_email_pedidos = '';
    //Pedro 10/Febrero/2020 ==> Añadimos dos campos que intefieren directamente en el cálculo del PVP
    public $herbolib_modulo_distribucion = false;
    public $forzar_descuentos = false;


    public static function getCampos($soloPrincipal = NULL){
        static::$nombreTabla = strtolower(get_called_class());
        static::getTablaRelacionada();
        //Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
        $campos = BaseDatos::dameCamposAlias(static::$nombreTabla);
        return($campos);
    }
    
    public static function getNombreTabla($soloPrincipal = NULL, $tablasOrigen = NULL){
        static::$nombreTabla = strtolower(get_called_class());
        static::getTablaRelacionada();
        //Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
        $consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= static::getJoin('Configuracion', 'pais_empresa', 'Pais', 'codigo');
		}
		$consulta .= ' ';
		
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}

        return($consulta);
    }


    public static function getWhereTabla(){
        $argumentos = func_get_args();
        $codigo = isset($argumentos[0]) ? $argumentos[0] : NULL;
        if ($codigo != NULL){
            static::$whereSelect = ' `' . static::getAlias() . '`.`codigo` = ' . $codigo . ' ';
        }
        return(static::$whereSelect);
    }


    private function cargar_configuracionBD() {
        $resultado = false;

        $sentencia_sql = 'SELECT ' . static::getCampos() . ' 
                            FROM ' . static::getNombreTabla();/* . '
                            WHERE ' . static::getWhereTabla();*/
        //echo("$sentencia_sql<br />\n");
        $bd = new BaseDatos();
        if ($bd->isConectado()){
            $bd->setConsultaSQL($sentencia_sql);
            $fila = $bd->getFila();
            $this->extractData($fila);
             $resultado = true;
        }
        return($resultado);
    }

    public function extractData($fila){
        if ($fila != NULL) {
            $this->codigo =  $this->getProp($fila, 'codigo');
            $this->nombre_legal = $this->getProp($fila, 'nombre_legal');
            $this->nombre =  $this->getProp($fila, 'nombre_empresa');
            $this->direccion_email =  $this->getProp($fila, 'email');
            $this->usuario_email =  $this->getProp($fila, 'usuario');
            $this->password_email =  $this->getProp($fila, 'password');
            $this->smtp_email =  $this->getProp($fila, 'smtp');
            $this->direccion =  $this->getProp($fila, 'direccion_empresa');
            $this->cod_postal =  $this->getProp($fila, 'cod_postal');
            $this->localidad =  $this->getProp($fila, 'localidad');
            $this->provincia =  $this->getProp($fila, 'provincia');
            $this->pais_empresa =  $this->getProp($fila, 'pais_empresa');
            $this->pais_empresa =  $this->getProp($fila, 'pais_empresa');
            $this->objetoPais = new Pais(array('filaPais' => $fila));
            $this->cif =  $this->getProp($fila, 'cif');
            $this->telefono_empresa =  $this->getProp($fila, 'telefono_empresa');
            $this->horario = $this->getProp($fila, 'horario'); 
            $this->iframe_gmaps =  $this->getProp($fila, 'iframe_maps');
            $this->logo_email =  $this->getProp($fila, 'logo_email');
            $this->email_empresa =  $this->getProp($fila, 'email_empresa');
            $this->direccion_email_pedidos =  $this->getProp($fila, 'direccion_email_pedidos');
            //Si la empresa no tiene email declarado, cogemos el la dirección email utilizada en los envíos
            if ($this->email_empresa == '') {
                $this->email_empresa = $this->direccion_email;
            }
            //pedro 10/Febrero/2020 ==> Datos necesarios para el cálculo del PVP
            /*echo("<!--");
            var_dump($this->getProp($fila, 'forzar_descuentos'));
            echo("-->");*/
            $this->herbolib_modulo_distribucion = ($this->getProp($fila, 'herbolib_modulo_distribucion') == 0) ? false : true;
            $this->forzar_descuentos = ($this->getProp($fila, 'forzar_descuentos') == 0) ? false : true;
            
        }
    }


    //Constructor y destructor
    function __construct($ruta_configXML = NULL) {
        //Pedro 29/Agosto/2019 ==> La empresa se carga como la configuración, primero BD y sobre escribimos con el XML:
         $resultado = $this->cargar_configuracionBD();
        //Si existe un fichero xml no cargamos la configuracion de la base de datos
        if ($ruta_configXML != NULL) {
            $resultado = $this->cargar_configuracionXML($ruta_configXML);
        }
        if (!$resultado) {
            echo('Ha ocurrido un error al cargar los datos de la empresa<br />\n');
        }
    }

    function __destruct() {
        
    }

    private function cargar_configuracionXML($ruta_fichero) {
        $retorno = false;
        if (file_exists($ruta_fichero)) {
            $datos = simplexml_load_file($ruta_fichero);
            $this->nombre_legal = isset($datos->nombre_legal) ? (string) $datos->nombre_legal : $this->nombre_legal;
            $this->nombre = isset($datos->nombre_empresa) ? (string) $datos->nombre_empresa : $this->nombre;
            $this->direccion_email = isset($datos->email) ? (string) $datos->email : $this->direccion_email;
            $this->usuario_email = isset($datos->usuario) ? (string) $datos->usuario : $this->usuario_email;
            $this->password_email = isset($datos->password) ? (string) $datos->password : $this->password_email;
            $this->smtp_email = isset($datos->smtp) ? (string) $datos->smtp : $this->smtp_email;
            $this->direccion = isset($datos->direccion) ? (string) $datos->direccion : $this->direccion;
            $this->cod_postal = isset($datos->cod_postal) ? (string) $datos->cod_postal : $this->cod_postal;
            $this->localidad = isset($datos->localidad) ? (string) $datos->localidad : $this->localidad;
            $this->provincia = isset($datos->provincia) ? (string) $datos->provincia : $this->provincia;
            $this->pais_empresa = isset($datos->pais_empresa) ? (string) $datos->pais_empresa : $this->pais_empresa;
            $this->objetoPais = new Pais(array('ID' => $this->pais_empresa));
            $this->cif = isset($datos->cif) ? (string) $datos->cif : $this->cif;
            $this->telefono_empresa = isset($datos->telefono_empresa) ? (string) $datos->telefono_empresa : $this->telefono_empresa;
            $this->horario = isset($datos->horario) ? (string) $datos->horario : $this->horario;
            $this->iframe_gmaps = base64_decode((string) isset($datos->iframe_gmaps) ? $datos->iframe_gmaps : $this->iframe_gmaps);
            $this->logo_email = isset($datos->logo_email) ? (string) $datos->logo_email : $this->logo_email;
            $this->email_empresa = isset($datos->email_empresa) ? (string) $datos->email_empresa : $this->email_empresa;
            if ($this->email_empresa == '') {
                $this->email_empresa = $this->direccion_email;
            }
            //pedro 10/Febrero/2020 ==> Datos necesarios para el cálculo del PVP
            $this->herbolib_modulo_distribucion = isset($datos->herbolib_modulo_distribucion) ? (($datos->herbolib_modulo_distribucion == 0) ? false : true) : $this->herbolib_modulo_distribucion;
            $this->forzar_descuentos = isset($datos->forzar_descuentos) ? (($datos->forzar_descuentos == 0) ? false : true) : $this->forzar_descuentos;
           
            $retorno = true;
        }
        return($retorno);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (gettype($value) == 'string') {
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (is_object($value)) {
                    if (method_exists('"' . get_class($value) . '"', 'getJson')) {
                        $ejecutarJson = false;
                    }
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
            $resp = substr($resp, 0, -1) . "}";
            return $resp;
        }
    }

}

?>