<?php

class SuperLineaLote extends Objeto{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

	public $mc_lote = 0;
	public $objeto_lote = 0;
	public $codigo = 0;
	public $articulo = 0;
	public $objeto_articulo = NULL;
	public $cantidad = 0;
	public $pvp = 0;
	public $total = 0;
	public $optativa = 0;
	public $nueva_inclusion = 0;
	public $observaciones = '';
	//Estos campos son heredados del padre:
	public $trabaja_cantidades = false;
	public $trabaja_cantidades_pvp = false;
	//12/Julio/2019 ==> Como el lote puede tener un precio web, aquí ponemos la parte que corresponde a este artículo:
	public $precio_web = 0;	// => Se calculan desde la cabecera del lote
	public $base_precio_web = 0; // => Se calculan desde la cabecera del lote
	
	
	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//static::$campos_tabla = BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}; //==> Comento esta línea porque creo que no sirve pa na
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (static::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias());
				$campos .= BaseDatos::dameCamposAlias(static::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' ) . 
				Articulo::getCampos() . ' ';
			}
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  static::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= static::getJoin('LineaLote', 'articulo', 'Articulo', 'codigo'); //Queremos esta tabla con la de artículo
			$consulta .= Articulo::getNombreTabla(false);								//Cogemos los left join de artículo
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigoLote = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$codigoLinea = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$articulo = isset($argumentos[2]) ? $argumentos[2] : NULL;
		$limitar = isset($argumentos[3]) ? $argumentos[3] : true;
		
		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($codigoLote !== NULL) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' . static::getAlias() . '`.`mc_lote` = "' . $codigoLote . '" ';
		}
		if ($codigoLinea !== NULL) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' . static::getAlias() . '`.`codigo` = "' . $codigoLinea . '" ';
		}
		if ($articulo !== NULL) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' . static::getAlias() . '`.`articulo` = "' . $articulo . '" ';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}


	function __construct($codigo_lote = NULL, $codigo_linea_lote = NULL, $trabaja_cantidades_pvp = false, $trabaja_cantidades = false){
		//Inicialización de datos:
		$codigo_articulo = NULL;
		$fila_linea_lote = NULL;
		//Estos dos valores los podemos coger ya
		$this->trabaja_cantidades = $trabaja_cantidades;
		$this->trabaja_cantidades_pvp = $trabaja_cantidades_pvp;
		//Nos pueden haber pasado un objeto con las opciones:
		if (is_a($codigo_lote, 'Lote')){
			$this->objeto_lote = $codigo_lote;
			$codigo_lote = $this->objeto_lote->codigo;
		}
		//Vamos a ver si es un objeto lo que tenemos para cargarlo de manera normal
		if (is_object($codigo_lote) || is_array($codigo_lote)){
			$params = new ObOptions($codigo_lote);
			$codigo_lote = $params->getDefaultValue('codigo_lote', $codigo_lote);
			$codigo_linea_lote = $params->getDefaultValue('codigo_linea_lote', $codigo_linea_lote);
			$codigo_articulo = $params->getDefaultValue('codigo_articulo', NULL);
			$fila_linea_lote = $params->getDefaultValue('fila_linea_lote', NULL);
			//Aquí cogemos valores directamente para el objeto
			$this->objeto_lote = $params->getDefaultValue('objeto_lote', NULL);
			$this->trabaja_cantidades_pvp = $params->getDefaultValue('trabaja_cantidades_pvp', $this->objeto_lote->trabaja_cantidades_pvp);
			$this->trabaja_cantidades = $params->getDefaultValue('trabaja_cantidades', $this->objeto_lote->trabaja_cantidades);
			$this->objeto_articulo = $params->getDefaultValue('objeto_articulo', NULL);
		}
		//Si tenemos un objeto lote, podemos coget el trabaja cantidades y PVP del mismo:
		if ($this->objeto_lote != NULL){
			$this->trabaja_cantidades = $this->objeto_lote->trabaja_cantidades;
			$this->trabaja_cantidades_pvp = $this->objeto_lote->trabaja_cantidades_pvp;
		}
		
		//Carga de datos
		$fila = NULL;
		if ($fila_linea_lote == NULL){
			//Preparamos el FROM con las uniones correspondientes
			$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . '
								WHERE ' . static::getWhereTabla($codigo_lote, $codigo_linea_lote, $codigo_articulo);
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $fila_linea_lote;
		}
		
		//Si tenemos fila aquí la cargamos
		if($fila != null){
			$this->extractData($fila);
		}
		
		
		//Vamos a controlar que el lote que recibamos sea o no un objeto
		/*
		if (is_a($codigo_lote, 'Lote')){
			$this->objeto_lote = $codigo_lote;
			$this->mc_lote = $codigo_lote = $this->objeto_lote->codigo;
		}
		$sentencia_sql = "SELECT mc_lote, ml_lotes.codigo codigo, articulo.codigo articulo, cantidad, ml_lotes.pvp pvp, total, optativa, nueva_inclusion, ml_lotes.observaciones observaciones 
						FROM ml_lotes, articulo 
						WHERE ml_lotes.mc_lote = $codigo_lote 
						AND ml_lotes.codigo = $codigo_linea_lote 
						AND articulo.codigo = ml_lotes.articulo";

		//echo("$sentencia_sql<br />\n");
		if ($conexionBD){
			if ($resultado = mysqli_query($conexionBD, $sentencia_sql)){
				if ($fila = mysqli_fetch_array($resultado)){
					$this->mc_lote = $fila['mc_lote'];
					$this->codigo = $fila['codigo'];
					$this->cantidad = ($trabaja_cantidades) ? $fila['cantidad'] : 1;
					$this->articulo = $fila['articulo'];
					$this->objeto_articulo = new Articulo($this->articulo, NULL, $this->cantidad, (($this->objeto_lote != NULL) ? $this->objeto_lote : $this->mc_lote) );
					$this->pvp = ($trabaja_cantidades) ? $fila['pvp'] : $this->objeto_articulo->pvp_final;
					$this->total = ($trabaja_cantidades) ? $fila['total'] : $this->objeto_articulo->pvp_final * $this->cantidad;
					$this->optativa = $fila['optativa'];
					$this->nueva_inclusion = $fila['nueva_inclusion'];
					$this->observaciones = $fila['observaciones'];
				}
			}
		}
		$this->trabaja_cantidades = $trabaja_cantidades;
		$this->trabaja_cantidades_pvp = $trabaja_cantidades_pvp;
		*/
	}
	
	private function extractData($fila){
		$this->mc_lote = $this->getProp($fila, 'mc_lote');
		$this->codigo = $this->getProp($fila, 'codigo');
		$this->optativa = $this->getProp($fila, 'optativa');
		$this->nueva_inclusion = $this->getProp($fila, 'nueva_inclusion');
		$this->observaciones = $this->getProp($fila, 'observaciones');
		//Si no trabajamos ni con cantidades ni con precios, tenemos que poner estos valores a su valor por defecto:
		$this->cantidad = ($this->trabaja_cantidades | $this->trabaja_cantidades_pvp) ? $this->getProp($fila, 'cantidad') : 1;		
		$this->pvp = ($this->trabaja_cantidades | $this->trabaja_cantidades_pvp) ? $this->getProp($fila, 'pvp') : 0;
		$this->total = ($this->trabaja_cantidades | $this->trabaja_cantidades_pvp) ? $this->getProp($fila, 'total') : 0;
		//Ahora vamos a por el artículo:
		$this->articulo = $this->getProp($fila, 'articulo');
		//Llegados a este punto vamos a cargar el objeto artículo
		if ($this->objeto_articulo == NULL){
			//Vamos a cargar el artículo:
			$opciones = new OpcionesWidget(array(
				'ean_articulo' => $this->articulo,
				'linea_lote' => $this,
				'filaArticulo' => $fila
			));
			$this->objeto_articulo = new Articulo($opciones);
		}
		//Ahora vamos a asegurarnos de que los precios estén bien:
		if ( ($this->trabaja_cantidades | $this->trabaja_cantidades_pvp) && ($this->objeto_articulo != NULL) ){
			$this->objeto_articulo->pvpoferta = $this->pvp;
			$this->objeto_articulo->pvp_final = $this->pvp;
			$this->objeto_articulo->pvp_final_sin_dto = $this->pvp;
		}

		//Si el pvp lo cogemos de la ficha del artículo y tenemos artículo
		if ( ($this->trabaja_cantidades_pvp == false) && ($this->objeto_articulo != NULL) ){
			$this->pvp = $this->objeto_articulo->pvp_final;
			$this->total = $this->objeto_articulo->pvp_final * $this->cantidad;
		}
	}
	
	function __destruct(){
		unset($this->mc_lote);
		unset($this->codigo);
		unset($this->articulo);
		unset($this->objeto_articulo);
		unset($this->cantidad);
		unset($this->pvp);
		unset($this->total);
		unset($this->optativa);
		unset($this->nueva_inclusion);
		unset($this->observaciones);
	}
	
	public function cantidad_en_cesta(){
		$return = 1;
		$linea_cesta = CabeceraCesta::findInCart($this->objeto_articulo, array('lote' => $this->mc_lote));
		if ($linea_cesta != NULL){
			//En la cesta ya está multiplicada la cantidad
			$return = $linea_cesta->cantidad / $this->cantidad;
		}
		return($return);
	}
}

?>