<?php
/*
  Clase SuperTema
  @version 1.0
 */

class SuperTema extends Objeto {
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

    public $codigo = '';
    public $nombre = '';
    public $nombre_auxiliar = '';
    public $cdu = '';
    public $ttl = '';
    public $bic = '';
    public $edad_inicial = 0;
    public $edad_final = 0;
    public $traduccion = '';
	public $tipo = 'O';
	
	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada(); // ==> Con esto traducimos la tabla a un nombre de clase de webStore
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (static::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias());
				$campos .= BaseDatos::dameCamposAlias(static::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' );
				//Vamos con los campos de la traducción:
				$nombreTabla = 'traduc_tema';
				$campos .= BaseDatos::dameCamposAlias($nombreTabla);
			}
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		$idioma = Idioma::getCurrentLanguaje(true);
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Ahora vamos a componer el nombre de la tabla teniendo en cuenta si es sólo principal, si no o si es todo (NULL)
		$consulta = ' ';
		$aliasPropio = static::getAlias();
		//$aliasPropioCodigo = ' `' .  $aliasPropio . '`.`codigo` ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= static::$nombreTabla . ' as `' .  $aliasPropio . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			$consulta .= static::getJoin(get_called_class(), array('codigo', '$' . $idioma), 'traduc_tema', array('tema', 'idioma'));
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}
		//echo($consulta);
		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$limitar = isset($argumentos[1]) ? $argumentos[1] : true;
		
		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($codigo != NULL) {
			static::$whereSelect = ' `' . static::getAlias() . '`.`codigo` = \'' . $codigo . '\' ';
		}

		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}
	
    //Constructor y destructor
    function __construct($tema = NULL) {
        //include('comunes/globals.php');
        /*$sentencia_sql = "SELECT codigo, nombre, nombre_auxiliar, cdu, ttl, bic, edad_inicial, edad_final
							FROM tema WHERE codigo = '$tema'";*/
		//Ojo que el tema puede que sea un "OpcionesWidget"
		$filaEscaparate = NULL;
		if (is_a($tema, 'OpcionesWidget')){
			//Recogemos las opciones del 'OpcionesWidget'
			$opciones = $tema;
			$tema = '';
			$tema = ($opciones->configuracion->tema !== NULL) ? $opciones->configuracion->tema : $tema;
			$filaTema = ($opciones->configuracion->filaTema !== NULL) ? $opciones->configuracion->filaTema : $filaTema;
		}
					
		$sentencia_sql = $sentencia_sql = 'SELECT ' . static::getCampos() . ' '
							. 'FROM ' . static::getNombreTabla() . ' '
							. 'WHERE ' . static::getWhereTabla($tema) . ';';
        //echo("$sentencia_sql<br />\n");
		if ($filaTema == NULL){
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				//echo($sentencia_sql);
				$bd->setConsultaSQL($sentencia_sql);
				if (!$fila = $bd->getFila()){
					$fila = NULL;
				}
			}
		}else{
			$fila = $filaTema;
		}
		//$aliasTraducTema = BaseDatos::$dictionary->{'traduc_tema' . 'Alias'};
		$aliasTraducTema = BaseDatos::dameAlias('traduc_tema');
        if ($fila != NULL){
			$this->codigo = $fila[static::getAlias() . '_' . 'codigo'];
			$this->nombre = $fila[static::getAlias() . '_' . 'nombre'];
			$this->nombre_auxiliar = $fila[static::getAlias() . '_' . 'nombre_auxiliar'];
			$this->cdu = $fila[static::getAlias() . '_' . 'cdu'];
			$this->ttl = $fila[static::getAlias() . '_' . 'ttl'];
			$this->bic = $fila[static::getAlias() . '_' . 'bic'];
			$this->edad_inicial = $fila[static::getAlias() . '_' . 'edad_inicial'];
			$this->edad_final = $fila[static::getAlias() . '_' . 'edad_final'];
			$this->tipo = $fila[static::getAlias() . '_' . 'tipo'];
			$this->traduccion = $fila[$aliasTraducTema . '_' . 'texto'];
			//Vamos a cargar ahora los grupos:
        }
    }

    function __destruct() {
        
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

	public static function cargarDesdeArticulo($articulo){
		//Vamos a componernos desde aquí una select que nos de los temas con su lef join con la tabla temasarti
		/*$campos_temasarti = BaseDatos::dameCamposAlias(
					BaseDatos::$dictionary->{'temasarti' . 'Campos'}, 
					BaseDatos::$dictionary->{'temasarti' . 'Alias'}
				);
				*/
		$campos_temasarti = BaseDatos::dameCamposAlias('temasarti');
		//$alias_temasarti = BaseDatos::$dictionary->{'temasarti' . 'Alias'};
		$alias_temasarti = BaseDatos::dameAlias('temasarti');
		$sentencia_sql = $sentencia_sql = 'SELECT ' . static::getCampos() . ', ' . $campos_temasarti . ' '
							. 'FROM ' . static::getNombreTabla() . ', `temasarti` as `' . $alias_temasarti . '` '
							. 'WHERE `' . $alias_temasarti . '`.`articulo` = ' . $articulo . ' AND `' . $alias_temasarti . '`.`tema` = `' . static::getAlias() . '`.`codigo` '
							. static::getWhereTabla(NULL, false) . ';';
		//echo("$sentencia_sql\n<br>");
		$listaTemas = array();
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while ($fila = $bd->getFila()){
				$opciones = new OpcionesWidget(array('filaTema' => $fila));
				$listaTemas[] = new Tema($opciones);
			}
		}
		//var_dump($listaTemas);
		return($listaTemas);
	}

}

?>