<?php
//version 1.0
//14/01/2019
//Se crea esta clase para poder gestionar las zonas de la base de datos pero sin hacer más caso a la misma, no hay carga ni nada más

class SuperZona extends Objeto{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

    public $codigo = 0;
    public $nombre = '';
    public $pais = 0;
    public $provincia = '';
    public $codigo_postal_inicial = "";
	public $codigo_postal_final = "";

	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		$campos = '';
		if (static::$nombreTabla != ''){
			//Esta tabla no tiene campos relacionados
			$campos = ' ' . BaseDatos::dameCamposAlias(static::$nombreTabla);
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL, $tablasOrigen = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		$consulta = ' `' . static::$nombreTabla . '` as `' .  static::getAlias() . '` ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}

		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$limitar = isset($argumentos[0]) ? $argumentos[0] : true;
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}

    function __construct($opciones) {

    }

    function __destruct() {
        unset($this->codigo);
        unset($this->nombre);
        unset($this->pais);
        unset($this->provincia);
        unset($this->codigo_postal_inicial);
        unset($this->codigo_postal_final);
    }

	public function extractData($fila){
		if ($fila != NULL) {
			$this->codigo = $this->getProp($fila, 'codigo');
			$this->nombre = $this->getProp($fila, 'nombre');
			$this->pais = $this->getProp($fila, 'pais');
			$this->provincia = $this->getProp($fila, 'provincia');
			$this->codigo_postal_inicial = $this->getProp($fila, 'codigo_postal_inicial');
			$this->codigo_postal_final = $this->getProp($fila, 'codigo_postal_final');
        }
	}
	
	public static function getLocal($country = NULL, $zipCode = NULL){
		$return = '';
		if ( ( ($country == NULL) || ($zipCode == NULL) ) && (Usuario::logueado() != NULL) ){
			$user = Usuario::logueado();
			$dir = $user->getCurrentDirection();	
			$country = ($country == NULL) ? $dir->pais : $country;
			$zipCode = ($zipCode == NULL) ? $dir->cod_postal : $zipCode;
		}
		if ( ($country != NULL) && ($zipCode != NULL) ){
			$return = ' (`' . static::getAlias() . '`.`pais` = \'' . $country . '\' AND (\'' . $zipCode . '\' BETWEEN `' . static::getAlias() . '`.`codigo_postal_inicial` AND `' . static::getAlias() . '`.`codigo_postal_final`) ) ';
		}
		return($return);
	}
	
	public static function getCity($country = NULL, $zipCode = NULL){
		$return = '';
		if ( ( ($country == NULL) || ($zipCode == NULL) ) && (Usuario::logueado() != NULL) ){
			$user = Usuario::logueado();
			$dir = $user->getCurrentDirection();
			$country = ($country == NULL) ? $dir->pais : $country;
			$zipCode = ($zipCode == NULL) ? $dir->cod_postal : $zipCode;
		}
		if ( ($country != NULL) && ($zipCode != NULL) ){
			$return = ' (`' . static::getAlias() . '`.`pais` = \'' . $country . '\' AND `' . static::getAlias() . '`.`provincia` = LEFT(\'' . $zipCode . '\' , 2) ) ';
			
		}
		return($return);
	}
	
	public static function getCountry($country = NULL){
		$return = '';
		if ( ($country == NULL) && (Usuario::logueado() != NULL) ){
			$user = Usuario::logueado();
			$dir = $user->getCurrentDirection();
			$country = ($country == NULL) ? $dir->pais : $country;
		}
		if ($country != NULL){
			$return = ' (`' . static::getAlias() . '`.`pais` = \'' . $country . '\' AND `' . static::getAlias() . '`.`provincia` = \'\' AND `' . static::getAlias() . '`.`codigo_postal_inicial` = \'0\' AND `' . static::getAlias() . '`.`codigo_postal_final` = \'0\' ) ';
			
		}
		return($return);
	}
	public static function getGlobal(){
		$return = ' (`' . static::getAlias() . '`.`pais` = 0 AND `' . static::getAlias() . '`.`provincia` = \'\' AND `' . static::getAlias() . '`.`codigo_postal_inicial` = \'0\' AND `' . static::getAlias() . '`.`codigo_postal_final` = \'0\' ) ';
		return($return);
	}

}

/*
//Con esta select podría obtener la zona de envío más restrictiva. La dejo aquí por si en un futuro la necesito o algo similar
SELECT IFNULL(
	(SELECT `codigo` FROM `zona` WHERE `pais` = "34" AND ("18100" BETWEEN `codigo_postal_inicial` AND `codigo_postal_final`) LIMIT 1)
	, IFNULL(
		(SELECT `codigo` FROM `zona` WHERE `pais` = "34" AND `provincia` = LEFT("18100" , 2) LIMIT 1)
		, IFNULL (
			(SELECT `codigo` FROM `zona` WHERE `pais` = "34" AND `provincia` = "" AND `codigo_postal_inicial` = "0" AND `codigo_postal_final` = 0  LIMIT 1)
			, (SELECT `codigo` FROM `zona` WHERE `pais` = 0 AND `provincia` = "" AND `codigo_postal_inicial` = "0" AND `codigo_postal_final` = 0  LIMIT 1)
		)
	)
) zona;
*/
?>