<?php
/*
	Clase SuperSections para las secciones de la web
	@version 1.0
*/


class SuperWSMinificator{
	
	//TODO => Si se modifica la sesión hay que limpiar los "media"
	public static function fixWSPaths($content){
		//Vamos a transformar "resultado" si es CSS porque la librería no pone los "@import" al principio del fichero
		$ultima_posicion = 0;
		$tmp_import = '';
		do{
			//echo("vuelta $contador\n");
			$existen = mb_strpos  ( $content, 'url(', $ultima_posicion);
			if ($existen !== false){
				$existen += 3;
				//Tenemos una ruta, vamos a obtenerla entera
				//echo("Buscaos desde la posición $existen<br>");
				$ultima_posicion = $punto_y_coma = mb_strpos ( $content, ')', $existen );
				//Cortamos la cadena de texto:
				$tmp_import = mb_substr($content, $existen, ($punto_y_coma - $existen), 'utf-8');	// ==> Con esto tenemos la ruta completa sin comillas, ni paréntesis ni punto y coma
				//echo("Encontrada: $tmp_import<br>");
				//Si la cadena Import tiene dentro "http" entonces no seguimos
				if (mb_strpos(strtoupper($tmp_import), 'HTTP') === false){
					//Pedro 05/Mayo/2020 ==> Vamos a ir cortando la cadena para que al reemplazar lo hagamos sólo una vez:
					$parte_izquierda = mb_substr($content, 0, $existen);
					$parte_derecha = mb_substr($content, $punto_y_coma + 1);
					//Vamos a quitar las comillas simples y dobles:
					$buscar = array('(', ')', '\'', '"');
					$reemplazo = '';
					$ruta_limpia = static::mb_str_replace ( $buscar , $reemplazo , $tmp_import);
					$interrogacion = mb_strpos($ruta_limpia, '?');
					if ($interrogacion !== false){
						$ruta_limpia = substr_replace ( $ruta_limpia, '' , $interrogacion );
					}
					//echo("Hay que hacer reemplazo, ruta local $ruta_limpia<br>");
					//Vamos a obtener el "dirname" del fichero que se ha cargado:
					//$ruta_original = dirname($clave);
					//Para ver dónde está el fichero necesitamos saber dónde está realmente:
					// Pedro 04/Mayo/2020 ==> Vamos a corregir la ruta teniendo en cuenta que puede estar en un tema padre
					$nombreFichero = basename($ruta_limpia);	//Cojo el nombre del fichero a buscar
					//echo("El fichero a incluir es $nombreFichero<br>");
					$ruta_relativa = Theme::findFile($nombreFichero);	//Cojo la ruta del fichero con su nombre incluido
					//echo("Su ruta absoluta es $ruta_relativa<br>");
					$ruta_relativa = static::mb_str_replace(_WS_DIR_, '', $ruta_relativa);	//Quito de la ruta la carpeta de webStore para convertir la ruta en relativa
					//echo("Su ruta relativa es $ruta_relativa<br>");
					//$ruta_relativa = _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_HTML_DIR_ . _WS_CSS_FOLDER;
					
					//Hay que echar atrás estos directorios:
					// dynamic/hash/media/css ==> son 4 elementos
					//$nueva_ruta = '("../../../../' . $ruta_relativa . $ruta_limpia . '")';	//la ruta limpia no la necesito
					$nueva_ruta = '../../../../' . $ruta_relativa;	//Nueva ruta para encontrar el fichero, sustituimos sólo rutas
					//Vamos a quitar la sentencia de valor:
					//echo("Cambio $ruta_limpia por $nueva_ruta<br>");
					//$content = static::mb_str_replace ( $ruta_limpia , $nueva_ruta , $content);
					$content = $parte_izquierda . '(\'' . $nueva_ruta . '\')' . $parte_derecha;
				}
			}
		}while( ($existen !== false)  );

		$imports = '';
		$tmp_import = '';
		//Ahora cogemos los imports para llevárnoslos arriba
		//Pedro 13/Mayo/2020 ==> 
		/*
		do{
			//Primero es obtener la posición del primer import:
			$existen = mb_strpos  ( $content, '@import' );
			if ($existen !== false){
				//Pedro 13/Mayo/2020 ==> Tenemos que tener en cuenta que algunas fuentes llevan un punto y coma en su url
				//Vamos a buscar el siguiente punto y coma siempre que no haya abierto una comilla (simple o doble) o un paréntesis
				$sinAbrir = false;
				$caracter = '';
				$caracterFin = '';
				//Vamos a buscar un caracter de apertura hasta que haya un salto de línea:
				
				//Tenemos un import, vamos a obtener el ; que haya al final:
				$punto_y_coma = mb_strpos  ( $content, ';', $existen );
				//Cortamos la cadena de texto:
				$tmp_import = mb_substr($content, $existen, ($punto_y_coma - $existen + 1));
				$imports .= $tmp_import;
				//Vamos a quitar la sentencia de valor:
				$content = static::mb_str_replace ($tmp_import, '', $content);
			}
		}while($existen !== false);
		*/
		$matches = array();
		preg_match("/(@import.+[\(\'\"].+[\'\"\)];)/U", $content, $matches,PREG_OFFSET_CAPTURE,0);	//OJO al modificador U para que sea perezosa y busque el menor número de resultados posibles
		//var_dump($matches);
		if (is_array($matches) && count($matches)){
			foreach($matches as $key => $value){
				//cada elemento [0] Es una de las frases:
				$tmp_import = $value[0];
				//Si la cadena no está en la cadena de importación, entonces hay que meterla y hacer el reemplazo:
				if (strpos($imports, $tmp_import) === false) {
					$imports .= $tmp_import;
					$content = static::mb_str_replace ($tmp_import, '', $content);
				}
			}
		}
		
		//Vamos a quitar los \n:
		//$content = static::mb_str_replace ( "\n" , '' , $content);
		
		//return($imports);
		return($imports . ' ' . $content);
		//return($content);
	}
	
	//Pedro 05/Mayo/2019 ==> Por ahora sólo quitamos los tags y los saltos de línea, más adelante minificaremos este código:
	public static function removeTag($tags, $source){
		$result = false;
		if (!(is_array($tags))){
			$tags = array($tags);
		}
		$result = static::mb_str_replace($tags, '', $source);
		return($result);
	}
	
	public static function simpleClean($string){
		$result = static::mb_str_replace(array("\n", "\r", "\t"), '', $string);
		return($result);
	}
	
	public static function mb_str_replace($search, $replace, $subject, &$count = 0) {
		if (!is_array($subject)) {
			// Normalize $search and $replace so they are both arrays of the same length
			$searches = is_array($search) ? array_values($search) : array($search);
			$replacements = is_array($replace) ? array_values($replace) : array($replace);
			$replacements = array_pad($replacements, count($searches), '');

			foreach ($searches as $key => $search) {
				$parts = mb_split(preg_quote($search), $subject);
				$count += count($parts) - 1;
				$subject = implode($replacements[$key], $parts);
			}
		} else {
			// Call mb_str_replace for each subject in array, recursively
			foreach ($subject as $key => $value) {
				$subject[$key] = mb_str_replace($search, $replace, $value, $count);
			}
		}

		return $subject;
	}
}
