<?php
/*
*	Al incluir este fichero se inicializa todo el core de webStore
*	@version 1.0.0
*	@date 2018/28/06
*
*/

//Necesitamos la ruta del core de webStore
define('_WS_CORE_DIR_', realpath(dirname(__FILE__)) . '/');

//Cargamos la constantes de webStore
include(_WS_CORE_DIR_ . '_defines.php');

set_error_handler(function ($severity, $message, $file, $line, $context){
		echo('<pre>');
		echo('	Error in file: ' . $file . '
		In line: ' . $line . '
		');
		print_r($message);
		echo('</pre>');
	}
);
//08/Mayo/2019 ==> Capturamos los errores graves
register_shutdown_function(function(){
        $error = error_get_last();
        if(null !== $error)
        {
            echo 'Caught at shutdown';
			var_dump($error);
        }
    });

try{
	//Por compatibilidad con webStore:
	//Para que todo webStore viejo cargue bien con los "include" que hace, vamos a definir un include_path
	set_include_path(get_include_path() . PATH_SEPARATOR . _WS_DIR_);
	
	//Importante que existan los directorios dinámicos:
	$dirList = array(
			_WS_DYNAMIC_DIR_ . 'cache', 
			_WS_DYNAMIC_DIR_ . 'classes', 
			_WS_DYNAMIC_DIR_ . 'controlFiles', 
			_WS_DYNAMIC_DIR_ . 'controllers',
			_WS_DYNAMIC_DIR_ . 'file_index',
			_WS_DYNAMIC_DIR_ . 'media', 
			_WS_DYNAMIC_DIR_ . 'sections'
			);
	//echo("<pre>");
	foreach($dirList as $clave => $dir){
		//echo("creamos $dir<br />\n");
		if (!file_exists($dir)){
			@mkdir($dir);
		}
	}
	//echo("</pre>");
	
	//Incluimos los ficheros necesarios para el funcionamiento de webStore
	include_once(_WS_REQUIRED_DIR_ . 'autoload.php');			//Auto carga de clases lo primero
	//Teniendo el autoload hecho, vamos a cargar la sesión, configuracion, etc.:
	//Vamos a arrancar el motor de bases de datos:
	BaseDatos::initDB();
	//Y creamos el diccionario
	BaseDatos::getDictionary();
	
	//Esta línea que viene ahora se debe de cargar de otra manera:
	//Cargamos la configuración local para esta instalación de webStore
	//include_once(_WS_REQUIRED_DIR_ . 'local.php');	// ==> Pedro - 07/Febrero/2019 ==> Este fichero lo cargará el index a utilizar. Lo que se hace es que dónde haya un index que cargue webStore debe haber un "local"
														// Encargado de indicar de dónde se cargan las secciones y el resto de elementos
		
	//Cargamos la tienda ==> lo hacemos antes que la sesión porque la misma se configura desde la tienda
	Shop::load();
	//Iniciamos la sesión:
	//No hacemos el session_start() si se han enviado cabeceras (se ha cargado wordpress, por ejempo)
	if ( (!headers_sent()) && (session_status() == PHP_SESSION_NONE) ){
		session_start();
	}
	Sesion::init();
	
	//Inicializamos la compatibilidad con el viejo webStore porque es posible que en alguna acción necesitemos de alguna funcionalidad aún no actualizada
	include_once(_WS_REQUIRED_DIR_ . 'compatibility.php');		//Inicializamos la compatibilidad con el viejo webStore
	
	//En este momento procesamos la info de los módulos
	//Por ahora sólo vamos a cargar un fichero en el que tenemos las acciones para ejecutarlas:

	//TODO ==> 16/Junio/2019 ==> desactivamos las acciones así, ahora le vamos a dar el control a los módulos
	$accion = Getter::get('accion', NULL);
	//var_dump($accion);
	if ($accion !== NULL){
		Module::checkModuleActions();	//Controlamos si los módulos están actualizados	
		Module::execModulesActions();	//Ejecutamos las acciones teniendo en cuenta las recibidas y las activas por los módulos
	}
/*
	
	Module::execModuleActions();	//Cargamos las acciones
*/
	
	//Ahora ejecutamos otros procesos necesarios
	include_once(_WS_REQUIRED_DIR_ . 'view.php');				//capturamos y comprimimos la salida de pantalla
	
	//Ya no hay login
	//Controlamos el usuario que esté logueado o haya datos de envío
	//include_once(_WS_DIR_ . 'comunes/login.php');	//=>Controlamos el login y el registro, por ahora aquí, después lo haremos bien con una clase

	//29/Enero/2019 ==> Antes aquí se recargaba la web. Ahora esto lo hacemos en el index, pues será quien, si es necesario recargar la web lo hará o, en caso contrario, mostrará el contenido, lo cual es más eficiente
	
	//Vamos a inicializar variables globales que necesitamos, en primer lugar vamos a cargar los ficheros de plantilla:
	//Si no tenemos  tema que cargar, no lo hacemos: (Pedro 15/Julio/2019)
	if ( (_WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_HTML_DIR_) != ''){
		//Pedro 07/Abril/2020 ==> si hay configuración del tema, la cargamos:
		if (file_exists(_WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . 'theme_config.php')){
			include(_WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . 'theme_config.php');
		}
		//Llegados a este punto puede que se hayan inicializado los ficheros del tema por eso controlamos que sea así:
		if (!Theme::isLoaded()){
			Theme::loadFiles();
		}
	}
	
	

	
}catch (Exception $e){
	echo('<pre>');
	print_r($e);
	echo('</pre>');
}


Sesion::commit();