<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Filtrado de articulos -->
<!-- ============================================================== -->
<?php  
  $parametrosPlantilla = Theme::getLastParamList();
  $camposTabla = Theme::getLastParam('camposTabla');
  $filasTabla = Theme::getLastParam('filasTabla');
  $seccion = Theme::getLastParam('seccion');
?>


<!-- ============================================================== -->
<!-- FILTRADO DE articulos -->
<!-- ============================================================== -->

<div class="card m-b-0 border-top">
  <div class="card-header" id="headingTwo">
    <h5 class="mb-0">
      <a class="collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
        <i class="m-r-5 fa mdi mdi-filter" aria-hidden="true"></i>
          <span><?=traducir('Filtrado');?></span>
      </a>
    </h5>
  </div>
  <?php
    //filtrar por: nombre, codigo, ean, precio desde hasta,  un radiobutton (no_web)con visibles, no visibles o todos 
    //Vamos a crear las variables para cada campo del formulario
    $ordenActual = Getter::get('ord', '');
    $elementosXPagina = Getter::get('exp', 10);

    $codigo = Getter::get('codigo', '');
    $ean = Getter::get('ean', '');
    $nombre = Getter::get('nombre', '');
    $precio_desde = Getter::get('precio_desde', '');
    $precio_hasta = Getter::get('precio_hasta', '');
    $visibilidad = Getter::get('visibilidad', '');


    $where = array();
    $reemplazo = array('\'', '"', '%');
    //Section::setParam($paramName, $value);

    if ($codigo != ''){
      $where['codigo'] = $codigo;
    }

    if ($ean != ''){
       $where['ean'] = array('condicion' => 'LIKE', 'campo' => 'ean', 'valor' =>'%' . $ean . '%');
    }

    if ($nombre != ''){
      $nombre_filtro = str_replace($reemplazo, '', $nombre);
      $nombre_filtro = explode(' ', $nombre_filtro);
      $subWhere = '';
      $or = '';
      $subArray = array();
      foreach($nombre_filtro as $clave => $valor){
        $subArray[] = array('condicion' => 'LIKE', 'campo' => 'nombre', 'operador' => 'OR', 'valor' => '%' . $valor . '%');
      }
      $where['nombre'] = $subArray;
    }

    $where_precio = array();
    if ($precio_desde != ''){
      $where_precio[] = array('condicion' => '>=', 'campo' => 'pvp', 'operador' => 'AND', 'valor' => $precio_desde);
    }

    if ($precio_hasta != ''){
      $where_precio[] = array('condicion' => '<=', 'campo' => 'pvp', 'operador' => 'AND', 'valor' => $precio_hasta);
    }

    if (count($where_precio) > 0){
      $where['pvp'] = $where_precio; 
    }

    if ($visibilidad != ''){
      if($visibilidad == 1){
       $where['no_web'] = 0;
      }else if($visibilidad == 2){
        $where['no_web'] = 1;
      }
    }


    Sections::setParam('filtro', $where);
  ?>
  <div id="collapseTwo" class="collapse <?=(count($where) > 0) ? 'show' : '';?>" aria-labelledby="headingTwo" data-parent="#accordionExample">
    <div class="card-body">
      <div class="row">
      <!-- FORMULARIO DE FILTRADO DE ARTICULOS-->
        <form class="form-horizontal col-12" method="POST" action="<?=Shop::$configuracion->url . $seccion;?>">
            <div class="card-body">
              <h4 class="card-title"><?=traducir('Filtrar lista');?></h4>
              <input type="hidden" name="ord"  value="<?=$ordenActual;?>">
              <input type="hidden" name="exp"  value="<?=$elementosXPagina?>">

              <div class="row">
                <div class="col-12 row">
                  <div class="form-group col-lg-2">
                    <label for="fcod" class="col-md-12 font-bold"><?=traducir('Código');?></label>
                    <input type="text" name="codigo"  value="<?=$codigo;?>" class="form-control" id="fcod" placeholder="<?=traducir('Código');?>">
                  </div>
                  <div class="form-group col-lg-2">
                    <label for="fean" class="col-md-12 font-bold"><?=traducir('EAN');?></label>
                    <input type="text" name="ean"  value="<?=$ean;?>"  class="form-control" id="fean" placeholder="<?=traducir('EAN');?>">
                  </div>
                  <div class="form-group col-lg-4">
                    <label for="fname" class="col-md-12 font-bold"><?=traducir('Nombre');?></label>
                    <input type="text" name="nombre"  value="<?=$nombre;?>" class="form-control" id="fname" placeholder="<?=traducir('Nombre');?>">
                  </div>
                  <div class="form-group col-lg-4">
                    <div class="row">
                      <div class="col-6">
                        <label for="fprecio" class="col-12 font-bold"><?=traducir('Precio desde: ');?></label>
                        <input type="text" name="precio_desde"  value="<?=$precio_desde;?>" class="form-control" id="fprecio" placeholder="<?=traducir('Precio desde');?>">
                      </div>
                      <div class="col-6">
                        <label for="fprecio" class="col-12 font-bold"><?=traducir('Precio hasta: ');?></label>
                        <input type="text" name="precio_hasta"  value="<?=$precio_hasta;?>" class="form-control" id="fprecio" placeholder="<?=traducir('Precio hasta');?>">
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-12 row">
                <div class="col-12 row">
                  <div class="col-12 row">
                    <label class="col-12 font-bold"><?=traducir('Visibilidad');?></label>
                    <div class="col-md-12">
                      <div class="custom-control custom-radio col-1">
                          <input type="radio" class="custom-control-input" id="customControlValidation1" value="1" <?=($visibilidad == 1)? 'checked' : '';?> name="visibilidad">
                          <label class="custom-control-label" for="customControlValidation1"><?=traducir('Visibles');?></label>
                      </div>
                      <div class="custom-control custom-radio col-1">
                          <input type="radio" class=" custom-control-input" id="customControlValidation2" value="2" <?=($visibilidad == 2)? 'checked' : '';?> name="visibilidad">
                          <label class="custom-control-label " for="customControlValidation2"><?=traducir('Ocultos');?></label>
                      </div>
                      <div class="custom-control custom-radio col-1">
                          <input type="radio" class="custom-control-input" id="customControlValidation3" value="3" <?=($visibilidad == 3)? 'checked' : '';?> name="visibilidad">
                          <label class="custom-control-label" for="customControlValidation3"><?=traducir('Todos');?></label>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

            </div>
            <div class="border-top">
                <div class="card-body">
                  <?php
                    if (count($where) > 0){
                      //componemos la lista de parámetros a utilizar
                      $parametrosFinales = ($ordenActual != '') ? 'ord=' . $ordenActual : '';
                      //Elementos X Pagina
                      $parametrosFinales .= ( ($parametrosFinales != '' && $elementosXPagina != '') ? '&' : '') .  (($elementosXPagina != '') ? 'exp=' . $elementosXPagina : '');
                     
                      //Componemos en enlace "base sobre el que añadir la página a la que navegar"
                      $enlace = Shop::$configuracion->url . Sections::$current_section . ( ($parametrosFinales != '') ? '?' : '') . $parametrosFinales;
                  ?>
                      <a href="<?=$enlace;?>"><button type="button" class="btn btn-danger"><?=traducir('Borrar filtro');?></button></a>
                  <?php
                    }
                  ?> 
                    <button type="submit" class="btn btn-primary"><?=traducir('Filtrar');?></button>
                </div>
            </div>
        </form>
      </div>
    </div>
  </div>
</div>


