<!-- ============================================================== -->
<!-- Marina (23/08/2019)  Filtrado de email -->
<!-- ============================================================== -->
<?php  
  $parametrosPlantilla = Theme::getLastParamList();
  $camposTabla = Theme::getLastParam('camposTabla');
  $filasTabla = Theme::getLastParam('filasTabla');
  $seccion = Theme::getLastParam('seccion');

?>


<!-- ============================================================== -->
<!-- FILTRADO DE EMAIL -->
<!-- ============================================================== -->

<div class="card m-b-0 border-top">
  <div class="card-header" id="headingTwo">
    <h5 class="mb-0">
      <a class="collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
        <i class="m-r-5 fa mdi mdi-filter" aria-hidden="true"></i>
          <span><?=traducir('Filtrado');?></span>
      </a>
    </h5>
  </div>
  <?php
    //filtrar por: enviados, no enviados, todos, fecha, destinatario, asunto
    //Vamos a crear las variables para cada campo del formulario
    $ordenActual = Getter::get('ord', '');
    $elementosXPagina = Getter::get('exp', 10);

    $id = Getter::get('id', '');
    $destinatario = Getter::get('destinatario', '');
    $asunto = Getter::get('asunto', '');
    $texto_error = Getter::get('texto_error', '');
    $fecha_desde = Getter::get('fecha_desde', '');
    $fecha_hasta = Getter::get('fecha_hasta', '');
    $enviado = Getter::get('enviado', 2);
    //comprobar si enviado es 0 o 1  y en funcion de eso rellenar la variable estado

    $where = array();
    $reemplazo = array('\'', '"', '%');
    //Section::setParam($paramName, $value);


    if ($id != ''){
      $where['ID'] = $id;
    }

    if ($fecha_desde != '' && $fecha_hasta != ''){
      $fecha_hora_desde = $fecha_desde . ' 00:00:00';
      $fecha_hora_hasta = $fecha_hasta . ' 23:59:59';
      //var_dump('desde ' . $fecha_hora_desde.' hasta '.$fecha_hora_hasta);
      $subArray = array();
      $subArray[] = array('condicion' => 'BETWEEN', 
                          'campo' => 'fecha', 
                          'operador' => 'AND', 
                          'valor' => 'CAST("' . $fecha_hora_desde . '" AS DATETIME) AND CAST("' . $fecha_hora_hasta . '" AS DATETIME)');
      $where['fecha'] = $subArray;

    }else if ($fecha_desde != '' && $fecha_hasta == ''){
      $fecha_hora_desde = $fecha_desde . ' 00:00:00';
      $subArray = array();
      $subArray[] = array('condicion' => '>=', 
                          'campo' => 'fecha', 
                          'operador' => 'AND', 
                          'valor' => 'CAST("' . $fecha_hora_desde . '" AS DATETIME)');
      $where['fecha'] = $subArray;

    }else if ($fecha_desde == '' && $fecha_hasta != ''){
      $fecha_hora_hasta = $fecha_hasta . ' 23:59:59';
      $subArray = array();
      $subArray[] = array('condicion' => '<=', 
                          'campo' => 'fecha', 
                          'operador' => 'AND', 
                          'valor' => 'CAST("' . $fecha_hora_hasta . '" AS DATETIME) AND CAST("' . $fecha_hora_hasta . '" AS DATETIME)');
      $where['fecha'] = $subArray;
    }

    if ($destinatario != ''){
       //var_dump($destinatario);
      $nombre_filtro = str_replace($reemplazo, '', $destinatario);
      $nombre_filtro = explode(' ', $nombre_filtro);
      $subWhere = '';
      $or = '';
      $subArray = array();
      foreach($nombre_filtro as $clave => $valor){
        $subArray[] = array('condicion' => 'LIKE', 'campo' => 'destinatario', 'operador' => 'OR', 'valor' => '%' . $valor . '%');
      }
      var_dump($subArray);
      $where['destinatario'] = $subArray;
    }

    if ($asunto != ''){
      $nombre_filtro = str_replace($reemplazo, '', $asunto);
      $nombre_filtro = explode(' ', $nombre_filtro);
      $subWhere = '';
      $or = '';
      $subArray = array();
      foreach($nombre_filtro as $clave => $valor){
        $subArray[] = array('condicion' => 'LIKE', 'campo' => 'asunto', 'operador' => 'OR', 'valor' => '%' . $valor . '%');
      }
      $where['asunto'] = $subArray;
    }

    if($enviado != 2){ 
      $where['enviado'] = $enviado;
    }

    Sections::setParam('filtro', $where);
  ?>
  <div id="collapseTwo" class="collapse <?=(count($where) > 0) ? 'show' : '';?>" aria-labelledby="headingTwo" data-parent="#accordionExample">
    <div class="card-body">
      <div class="row">
      <!-- FORMULARIO DE FILTRADO DE EMAIL-->
        <form class="form-horizontal col-12" method="POST" action="<?=Shop::$configuracion->url . $seccion;?>">
            <div class="card-body">
              <h4 class="card-title"><?=traducir('Filtrar lista');?></h4>
              <input type="hidden" name="ord"  value="<?=$ordenActual;?>">
              <input type="hidden" name="exp"  value="<?=$elementosXPagina?>">

              <div class="row">
                <div class="col-12 row">
                  <div class="form-group col-lg-2">
                    <label class="col-12 font-bold"><?=traducir('Enviado');?></label>
                    <div class="col-md-12">
                      <div class="custom-control custom-radio col-md-12">
                          <input type="radio" class="custom-control-input" id="customControlValidation1" value="2" <?=($enviado == 2)? 'checked' : '';?> name="enviado">
                          <label class="custom-control-label" for="customControlValidation1"><?=traducir('Todos');?></label>
                      </div>
                      <div class="custom-control custom-radio col-md-12">
                          <input type="radio" class="custom-control-input" id="customControlValidation2" value="1" <?=($enviado == 1)? 'checked' : '';?> name="enviado">
                          <label class="custom-control-label " for="customControlValidation2"><?=traducir('Enviados');?></label>
                      </div>
                      <div class="custom-control custom-radio col-md-12">
                          <input type="radio" class="custom-control-input" id="customControlValidation3" value="0" <?=($enviado == 0)? 'checked' : '';?> name="enviado">
                          <label class="custom-control-label" for="customControlValidation3"><?=traducir('No enviados');?></label>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-lg-2 filtrado_fecha">
                    <label class="col-12 font-bold"><?=traducir('Fecha de envío');?></label>
                    <div class="col-md-12">
                      <label for="ffede" class="font-bold"><?=traducir('Desde: ');?></label>
                      <input type="date" name="fecha_desde"  value="<?=$fecha_desde;?>"  class="form-control" id="ffede" placeholder="<?=traducir('Desde');?>">
                    </div>
                    <div class="col-md-12">
                      <label for="ffeha" class="font-bold"><?=traducir('Hasta: ');?></label>
                      <input type="date" name="fecha_hasta"  value="<?=$fecha_hasta;?>"  class="form-control" id="ffeha" placeholder="<?=traducir('Hasta');?>">
                    </div>
                  </div>
                  <div class="form-group col-lg-3">
                    <label for="fdes" class="col-md-12 font-bold"><?=traducir('Destinatario');?></label>
                    <input type="text" name="destinatario"  value="<?=$destinatario;?>"  class="form-control" id="fdes" placeholder="<?=traducir('Destinatario');?>">
                  </div>
                  <div class="form-group col-lg-3">
                    <label for="fasun" class="col-md-12 font-bold"><?=traducir('Asunto');?></label>
                    <input type="text" name="asunto"  value="<?=$asunto;?>" class="form-control" id="fasun" placeholder="<?=traducir('Asunto');?>">
                  </div>
                </div>
              </div>
            </div>
            <div class="border-top">
                <div class="card-body">
                    <button type="submit" class="btn btn-primary"><?=traducir('Filtrar');?></button>
                  <?php
                    if (count($where) > 0){
                      //componemos la lista de parámetros a utilizar
                      $parametrosFinales = ($ordenActual != '') ? 'ord=' . $ordenActual : '';
                      //Elementos X Pagina
                      $parametrosFinales .= ( ($parametrosFinales != '' && $elementosXPagina != '') ? '&' : '') .  (($elementosXPagina != '') ? 'exp=' . $elementosXPagina : '');
                     
                      //Componemos en enlace "base sobre el que añadir la página a la que navegar"
                      $enlace = Shop::$configuracion->url . Sections::$current_section . ( ($parametrosFinales != '') ? '?' : '') . $parametrosFinales;
                    ?>

                      <a href="<?=$enlace;?>"><button type="button" class="btn btn-danger"><?=traducir('Borrar filtro');?></button></a>
                    <?php
                    }
                  ?> 

                </div>
            </div>
        </form>
      </div>
    </div>
  </div>
</div>


