<?php
	include_once('local.php');	// ==> Lo hacemos con un include para no tener que editar el index en cada cliente (Pedro 07/Febrero/2019)
	//Arrancamos el core de webStore
	include('../core/initWebStore.php');

	error_reporting(E_ALL);

	//Vamos a cargar el control de secciones:
	//Álvaro 050219 Tarea 5170: Ahora, en vez de hacer un include de sectioncontrol.php, vamos ahora a llamar a esa funcion estática de sections.php
	//include_once(_WS_CORE_DIR_ . 'sectionControl.php');
	Sections::sectionControl();
	

	//Una vez que se ha controlado todo esto, vamos a mostrar el contenido, pero ojo, si la web hay que recargarla lo hacemos sin más
	//Si hay que recargar la web, lo hacemos aquí
	if (Sesion::getReloadPage()) {
		//header('location:' . $url_sin_parametros); ==> la web se va a recargar a si misma
		//echo("Vamos a recargar");
		Sesion::reloadPage($_SERVER["REQUEST_URI"]);
	}else{
		//Si la sección es completa la cargamos directamente:
		$completa = Sections::getAttr('completa');
		if ($completa){
			Theme::showContent();
		}else{
			//cargamos el fichero de la sección, según la sección, la plantilla puede ser diferente
			$ficheroPlantilla = Sections::getAttr('plantilla');
			if ( ($ficheroPlantilla != NULL) && ($ficheroPlantilla != '') ){
				Theme::include_file($ficheroPlantilla);
			}
		}
		
		$absoluta = Sections::getAttr('absoluta');
		//Si la sección no es absoluta mostramos lo siguiente:
		if (!$absoluta){
		
		//WebStore tiene algunos Scripts que son independientes del tema, vienen SIEMPRE de serie:
		//Es muy importante programar en javascript que si se ha cargado la web se lance el evento de WSLE (Web Store Load Event
?>
<script>
var auxFunc = window.onload;
auxFunc = (auxFunc == null) ? function(){} : auxFunc;
window.onload = function() {auxFunc(); var event = new Event('WSLE'); document.dispatchEvent(event); };
</script>
<?php
			//Pedro 19/Junio/2019 ==> Hacemos que la función "remote request" sea diferente en cada sesión
			//Primero llamamos a la función:
			 RemoteRequest::WS_data_update();
			 //Este trozo es diferente que en el index normal, aquí metemos la llamada al remote request
?>
<script>
	WS_data_update = function(controller, method, data, event, callback){
		<?=RemoteRequest::get_WS_data_update();?>(controller, method, data, event, callback);
	};
</script>
<?php
		}
			//Para asegurarnos de que se guarde en la sesión todo, hacemos un commit
		Sesion::commit();
	}



ob_end_flush();

//Lo último es desconectarnos de la base de datos
BaseDatos::closeConexion();
