<?php
//---------------------------------------------------------------------------------------------------------
// 30/Septiembre/2014
// Versión 1.0 Header natural de la web. La cabecera con todos sus includes y resto de datos
//---------------------------------------------------------------------------------------------------------
// 03/Marzo/2015
// Versión 1.1 Modificamos los datos referentes a la cesta para hacerlas más versátil y más encapsulada
//---------------------------------------------------------------------------------------------------------
//Si la sección es erronea, vamos a mostrar un 404



if ($seccion == 'error') {
    header('HTTP/1.0 404 Not Found');
}
$idioma = strtolower(Sesion::get('idioma'));
$idioma_local = getLocale();
//Ojo a las locales, por ahora las ponemos en español
setlocale(LC_ALL, $idioma_local);

//Datos SEO principales. Si no los tenemos, hemos de cogerlos de configuración
$title_web = ($title_web == '') ? Shop::$empresa->nombre : $title_web;
$descripcion_web = ($descripcion_web == '') ? Shop::$configuracion->descripcion : $descripcion_web;
$keywords_web = ($keywords_web == '') ? Shop::$configuracion->meta : $keywords_web;

//Vamos a poner una caché de 1 mes:
$seconds_to_cache = 2592000;
$ts = gmdate("D, d M Y H:i:s", time() + $seconds_to_cache) . " GMT";
header("Expires: $ts");
header("Pragma: cache");
header("Cache-Control: max-age=$seconds_to_cache");
?>
<!DOCTYPE html>
<html lang="es">
    <head>
        <title><?= strip_tags($title_web); ?></title>
		<meta charset="UTF-8" >
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta http-equiv="Vary" content="Accept-Encoding"/>
        <meta name="language" content="<?= $idioma; ?>"/>
        <meta name="author" content="Arminet"/>
        <meta name="Copyright" content="Copyright ARMINET"/>
        <meta name="revisit-after" content="7 day"/>
        <meta http-equiv="Cache-Control" content="public"/>
        <meta http-equiv="EXPIRES" content="<?= date(DATE_RSS, time() + 2419200); ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <meta name="description" content="<?=strip_tags(substr($descripcion_web, 0, 160)); ?>" />
        <meta name="keywords" content="<?= substr($keywords_web, 0, 250); ?>" />
        <meta name="title" content="<?=strip_tags($title_web); ?>" />
        <?php
		/*
		//Ya no se cargan los estilos y JS así
		//Ahora, antes de añadir otros datos de cabecera, vamos a lanzar ya la carga de ficheros de estilos y javascript:
        loadFile('js/jquery-3.2.1.min.js');
        //No cargamos nada de esto si la sección es "error"
        if ($seccion != 'error') {
            //---------------------------------------------------------------------------------------------------------
            //estilos y javascript base
            //---------------------------------------------------------------------------------------------------------	
			//CSS
            loadFile('css/bootstrap.min.css', '', true);
			loadFile('css/estilo.css', '', true);
            loadFile('css/widget.css', '', true);
			loadFile('css/animate.css', '', true);
            loadFile('css/' . $seccion . '.css', '', true);
			//Si la sección tiene su ccss "imprimir" lo cargamos
			loadFile('css/' . $seccion . '_imprimir.css', ' media="print" ', '', true);
			//Javascript
			loadFile('js/cesta.js', '', true);
			loadFile('js/captcha.js', '', true);
			loadFile('js/components.js', '', true);
			loadFile('js/customAjax.js', '', true);
			loadFile('js/direcciones_envio.js', '', true);
			loadFile('js/functionStack.js', '', true);
			loadFile('js/script.js', '', true);
			loadFile('js/selectoresProducto.js', '', true);
			loadFile('js/bootstrap.min.js', '', true);
			//Ahora cargamos el script de la sección si existiese
			loadFile('js/' . $seccion . '.js', '', true);
			
			//Vamos a mostrar los ficheros juntos:
			loadFile('datosUnificados/style.css', '', false, '&contenidoEstilosUnidos=' . $contenidoEstilosUnidos);
			loadFile('datosUnificados/script.js', '', false, '&contenidoScriptsUnidos=' . $contenidoScriptsUnidos);
		}	
		*/
		
		
        //Etiquetas que tenemos que añadir
        //Multi-idioma
        //Vamos a cargar todos los idiomas
        $sentencia_sql = "SELECT codigo, locale FROM idioma WHERE disponible = 1 AND UPPER(codigo) != '" . strtoupper($idioma) . "' ";
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            while ($fila = mysqli_fetch_array($resultado)) {
                ?>
                <link rel="alternate" href="<?= Shop::$configuracion->url_sin_idioma; ?><?= strtolower($fila['codigo']); ?>/" hreflang="<?= $fila['locale']; ?>">
                <?php
            }
        }

        //RSS:
        //<link rel="alternate" type="application/atom+xml" href="http://php.net/releases/feed.php" title="PHP Release feed">
        //<link rel="alternate" type="application/atom+xml" href="http://php.net/feed.atom" title="PHP: Hypertext Preprocessor">
        //Una URL canónica es la que sirve el contenido real de la página, por si hay contenido duplicado
        //<link rel="canonical" href="http://php.net/manual/es/function.setcookie.php">
        //Consultar aquí: http://blog.solucionesc2.com/como-usar-rel-canonical-c2-seo
        //URL CORTA
        //<link rel="shorturl" href="http://php.net/setcookie">
        //BUSCADOR, especificación
        /* // ==> DESACTIVADO POR AHORA
		$fichero_a_incluir = Theme::findFile('buscador_interno.php');
        //Si tenemos fichero para incluir, lo incluimos, en caso contrario no incluimos nada
        if ($fichero_a_incluir != NULL) {
            ?>
            <link rel="search" type="application/opensearchdescription+xml" href="<?= Shop::$configuracion->url . $fichero_a_incluir; ?>" title="<?= traducir('Buscador de') . ' ' . Shop::$empresa->nombre; ?>">
            <?php
        }*/
        //Consultar aquí: http://www.opensearch.org/Specifications/OpenSearch/1.1
        //Buscador de google
        ?>
        <script type="application/ld+json">
            {
            "@context": "http://schema.org",
            "@type": "WebSite",
            "url": "<?= Shop::$configuracion->url; ?>",
            "potentialAction": {
            "@type": "SearchAction",
            "target": "<?= Shop::$configuracion->url; ?>buscar/{search_term_string}",
            "query-input": "required name=search_term_string"
            }
            }
        </script>
<?php
//INDEXACIÓN DE ESTE CONTENIDO
//<link rel="contents" href="http://php.net/manual/es/index.php">
//<link rel="index" href="http://php.net/manual/es/ref.network.php">
//<link rel="prev" href="http://php.net/manual/es/function.pfsockopen.php">
//<link rel="next" href="http://php.net/manual/es/function.setrawcookie.php">
?>
        <link rel="shortcut icon" href="<?= Shop::$configuracion->url . 'favicon.ico'; ?>">
<?php
        //De nuevo no cargamos esto si estamos en la sección de error
        if ($seccion != 'error') {
            ?>

            <?php //Por último añadimos las funciones que "beben" de la configuración ?>
            <script type="text/javascript">
                //Captha site keys
                captchaArray = new captchaElements();
                //Vamos a asignar los valores pendientes en las cookies
    <?php
    if (count($cookies_por_asignar) > 0) {
        foreach ($cookies_por_asignar as $clave => $valor) {
            ?>
            <?= $valor; ?>
            <?php
        }
    }
    ?>
            </script>
            <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit&hl=<?= $idioma; ?>" async defer></script>
    <?php
}
//Ahora vamos a cargar el analytics:
$fichero_a_incluir = Theme::include_file('analytics.php');
//Si tenemos fichero para incluir, lo incluimos, en caso contrario no incluimos nada
/*if ($fichero_a_incluir != NULL) {
    include($fichero_a_incluir);
}*/
?>
    </head>
