<?php

//---------------------------------------------------------------------------------------------------------
// 13/Febrero/2015
// Versión 1.0 Widget que crea la capa del "captcha"
//---------------------------------------------------------------------------------------------------------



function widget_captcha() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'captcha';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function captcha($theme = 'light') {
    include('comunes/globals.php');
    $ocultarCabecera = false;
    $id = 'captcha_' . incrementa_contador();
    if (($theme != NULL) && (is_a($theme, "OpcionesWidget"))) {
        $opciones = $theme;
        $theme = 'light';
        if (is_a($opciones, 'OpcionesWidget')) {
            $theme = ($opciones->configuracion->theme != NULL) ? $opciones->configuracion->theme : $theme;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        }
    }
    ?>
    <input type="hidden" name="verificado" value="verificado"/>
    <?php
    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>" id="<?= $id; ?>">
            <?php
        }
        ?>
        <?php
//Aquí no metemos nada porque el captcha sólo necesita un div con su ID
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
	<?php
	$nombre_script = 'script_' . incrementa_contador();
	?>
    <input id="token_<?= $id; ?>" type="hidden" name="tokenGoogle"/>
    <script type="text/javascript" id ="<?=$nombre_script;?>">
	document.addEventListener('WSLE', function(event) {
        ;(function () {
            var elementObjetive = getLastHtmlObject('<?=$nombre_script;?>');
            var callback_<?= $id; ?> = function (response) {
                elementObjetive.val(response);
            };
            //Hay que añadir este captcha a la lista disponible
            captchaArray.add('<?= $id; ?>', callback_<?= $id; ?>, '<?= $theme; ?>');
            //Vamos a buscar el formulario padre dónde está metido este id
            elementObjetive.closest('form').on('submit', function (event) {
                //Si el elemento está vacío, no dejamos que se haga el submit
                //console.log($("#token_<?= $id; ?>"));
                var token = elementObjetive.val();
                if (token == "") {
                    event.preventDefault();
                    event.stopPropagation();
                    alert("<?= traducir('Debe rellenar el captcha de seguridad'); ?>");
                }
            });
        }());
	});
    </script>
    <?php
    return(true);
}
?>