<?php

//---------------------------------------------------------------------------------------------------------
// 12/Enero/2015
// Versión 1.0 Widget que engloba los enlaces de los textos legales
//---------------------------------------------------------------------------------------------------------



function widget_filtrados_orden_pedidos_ventas() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'form_filtrado';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function form_filtrado($opciones = NULL) {
    include('comunes/globals.php');
    $ocultarCabecera = false;

    //Procesamos las opciones
    $componentes = array();
    $clase_filtrado = 'form_filtrado';
    $texto_deshacer = 'Quitar filtro';
    if (is_a($opciones, 'OpcionesWidget')) {
        $componentes = $opciones->elementos;
        $clase_filtrado = ($opciones->configuracion->clase_filtrado !== NULL) ? $opciones->configuracion->clase_filtrado : $clase_filtrado;
        $texto_deshacer = ($opciones->configuracion->texto_deshacer !== NULL) ? $opciones->configuracion->texto_deshacer : $texto_deshacer;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera !== NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }

    if (count($componentes) > 0) {
        ?>
        <?php
        if (!$ocultarCabecera) {
            ?>
            <div class="<?= (__FUNCTION__); ?>">
                <?php
            }
            ?>
            <form class="<?= $clase_filtrado; ?>" action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" method="post">
                <?php
                $boton_para_limpiar_filtro = false;
                foreach ($componentes as $clave => $valor) {
                    //Vamos a coger los  valores del componente
                    $nombre = (isset($valor->nombre)) ? $valor->nombre : '';
                    $texto = (isset($valor->texto)) ? $valor->texto : '';
                    $tipo = (isset($valor->tipo)) ? $valor->tipo : '';
                    $name = (isset($valor->name)) ? $valor->name : '';
                    $valor_x_defecto = (isset($valor->valor_x_defecto)) ? $valor->valor_x_defecto : '';
                    $etiqueta_detras = (isset($valor->etiqueta_detras)) ? $valor->etiqueta_detras : true;
                    //Si tenemos valor_x_defecto, hay que mostar el botón para limpiar el filtrado
                    if ($valor_x_defecto != '') {
                        $boton_para_limpiar_filtro = true;
                    }
                    //Según el tipo de campo, hay que hacer una cosa u otra
                    $etq_valor_x_defecto = '';
                    switch ($tipo) {
                        case 'textarea':

                            break;
                        default:
                            //Por defecto siempre es un imput normal
                            //Tenemos que tener cuidado, cuando sean fechas, hay que meter el selector de fechas
                            $etq_valor_x_defecto = ' value="' . $valor_x_defecto . '" ';
                            if ($tipo == 'fecha') {
                                $tipo = 'date';
                            } else if (($tipo == 'check') || ('checkbox')) {
                                $tipo = 'checkbox';
                                $etq_valor_x_defecto = $valor_x_defecto;
                            } else {
                                $tipo = 'text';
                            }
                            if (!$etiqueta_detras) {
                                ?>
                                <label class="label_<?= $clase_filtrado; ?>_<?= $nombre; ?>" ><?= $texto; ?></label>
                                <input type="<?= $tipo; ?>" name="<?= $name; ?>" class="input_<?= $clase_filtrado; ?>_<?= $nombre; ?>" <?= $etq_valor_x_defecto; ?>/>
                                <?php
                            } else {
                                ?>
                                <input type="<?= $tipo; ?>" name="<?= $name; ?>" class="input_<?= $clase_filtrado; ?>_<?= $nombre; ?>" <?= $etq_valor_x_defecto; ?>/>
                                <label class="label_<?= $clase_filtrado; ?>_<?= $nombre; ?>" ><?= $texto; ?></label>
                                <?php
                            }
                    }
                }
                $nombre_script = 'script_' . incrementa_contador();
                ?>
                <input type="submit" name="filtrar" class="boton" value="<?= traducir('Filtrar'); ?>" />
                <?php
                //Si hay que añadir el botón para limpiar, lo añaimos aquí
                if ($boton_para_limpiar_filtro) {
                    ?>
                    <a href="javascript:void(0)" title="<?= $texto_deshacer; ?>" class="boton"><?= $texto_deshacer; ?></a>
                    <script id="<?= $nombre_script; ?>">
					document.addEventListener('WSLE', function(event) {
                        ;(function () {
                            var elemento = getLastHtmlObject('<?= $nombre_script; ?>');
                            elemento.on("click", function (event) {
                                document.cookie = "limpiar_filtrado=limpiar; domain=<?= $dominio; ?>;path=<?= $carpeta; ?>;";
                                //Ahora recargamos la web en la que estamos
                                location.reload();
                            });
                        })();
					});
                    </script>
                    <?php
                }
                $nombre_script = 'script_' . incrementa_contador();
                ?>
            </form>
            <script id="<?= $nombre_script; ?>">
			document.addEventListener('WSLE', function(event) {
                ;(function () {
                    var formulario = getLastHtmlObject('<?= $nombre_script; ?>');
                    formulario.on("submit", function (event) {
                        event.preventDefault();
                        //Vamos a coger todos los elementos del formulario y a meterlos en widgets
                        $(this).find("input").each(function () {
                            var nombre = $(this).attr("name");
                            var valor = "";
                            if ($(this).prop("type") == "checkbox") {
                                valor = ($(this).is(":checked")) ? "checked" : "";
                            } else {
                                valor = $(this).val();
                            }
                            document.cookie = nombre + "=" + valor + "; domain=<?= $dominio; ?>;path=<?= $carpeta; ?>;";
                        });

                        //Ahora recargamos la web en la que estamos
                        location.reload();
                    });
                })();
			});
            </script>
            <?php
            if (!$ocultarCabecera) {
                ?>
            </div>
            <?php
        }
        ?>
        <?php
    }
    return(true);
}

function form_orden($opciones = NULL) {
    include('comunes/globals.php');

    //Procesamos las opciones
    $texto = '';
    $campo_orden = '';
    $tipo_orden = '';
    $orden = 'codigo';
    $clase_orden = 'form_orden';
    $ocultarCabecera = false;
    if (is_a($opciones, 'OpcionesWidget')) {
        $clase_orden = ($opciones->configuracion->clase_orden !== NULL) ? $opciones->configuracion->clase_orden : $clase_orden;
        $texto = ($opciones->configuracion->texto !== NULL) ? $opciones->configuracion->texto : $texto;
        $campo_orden = ($opciones->configuracion->campo_orden !== NULL) ? $opciones->configuracion->campo_orden : $campo_orden;
        //Cogemos el orden acutal
        $orden = ($opciones->configuracion->orden_actual !== NULL) ? $opciones->configuracion->orden_actual : 'codigo';
        $tipo_orden = ($opciones->configuracion->tipo_orden_actual !== NULL) ? $opciones->configuracion->tipo_orden_actual : 'DESC';
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera !== NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
    }
    if ($tipo_orden == NULL) {
        $tipo_orden = 'ASC';
    } else if (strtoupper($tipo_orden == 'ASC')) {
        $tipo_orden = 'DESC';
    } else {
        $tipo_orden = 'ASC';
    }
    ?>
    <?php
    if (!$ocultarCabecera) {
        ?>
        <div class="<?= (__FUNCTION__); ?>">
            <?php
        }
        ?>
        <form class="<?= $clase_orden; ?>" action="<?= parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH); ?>" method="post">
            <input type="hidden" name="orden" value="<?= $campo_orden; ?>" />
            <input type="hidden" name="tipo_orden" value="<?= $tipo_orden; ?>" />
            <?php
            //Vamso a crear un identificador para facilitarle las cosas al script
            $nombre_script = "script_" . incrementa_contador();
            //Creamos el botón que enviará el formulario
            ?>

            <a href="javascript:void(0);" title="<?= traducir($texto); ?>" class="a_<?= $clase_orden; ?>">
                <?= $texto; ?>
                <?php
                //Hay que tener en cuenta si el orden actual es el mismo que marca este campo:
                $clase = 'ordenar';
                $texto = '';
                if ($campo_orden == $orden) {
                    $clase = 'actual';
                    if ($tipo_orden == 'ASC') {
                        $clase .= '_descendente';
                        $texto = traducir('Invertir orden');
                    } else {
                        $clase .= '_ascendente';
                        $texto = traducir('Invertir orden');
                    }
                }
                ?>
                <span class="<?= $clase; ?>"><?= $texto; ?></span>
            </a>
            <script id="<?= $nombre_script; ?>">
			document.addEventListener('WSLE', function(event) {
                ;(function () {
                    var elemento = getLastHtmlObject('<?= $nombre_script; ?>');
                    elemento.on("click", function (event) {
                        $(this).parent("form.<?= $clase_orden; ?>").find("input").each(function () {
                            var nombre = $(this).attr("name");
                            var valor = $(this).val();
                            //console.log(valor);
                            document.cookie = nombre + "=" + valor + "; domain=<?= $dominio; ?>;path=<?= $carpeta; ?>;";
                        });

                        elemento.parent("form.<?= $clase_orden; ?>").submit();
                    });
                })();
			});
            </script>
        </form>
        <?php
        if (!$ocultarCabecera) {
            ?>
        </div>
        <?php
    }
    ?>
    <?php
}
?>