<?php
/*
  Class SuperFactura
 */

class SuperFactura {
    public static $campos_tabla = array();
    public static $alias = '';
    public static $nombreTabla = '';
    public static $camposSelect = '';
    public static $whereSelect = '';
    public static $publicFieldList = array();


    public $codigo = 0;
    public $num_doc = 0;
    public $cliente = '';
    public $tipo_doc = '';
    public $tipo_doc_nombre = '';
    public $fecha = 0;
    public $fecha_date_format;
    public $iva1 = 0;
    public $iva2 = 0;
    public $iva3 = 0;
    public $iva4 = 0;
    public $recargo1 = 0;
    public $recargo2 = 0;
    public $recargo3 = 0;
    public $recargo4 = 0;
    public $base1 = 0;
    public $base2 = 0;
    public $base3 = 0;
    public $base4 = 0;
    public $imp_iva1 = 0;
    public $imp_iva2 = 0;
    public $imp_iva3 = 0;
    public $imp_iva4 = 0;
    public $imp_recargo1 = 0;
    public $imp_recargo2 = 0;
    public $imp_recargo3 = 0;
    public $imp_recargo4 = 0;
    public $bruto1 = 0;
    public $bruto2 = 0;
    public $bruto3 = 0;
    public $bruto4 = 0;
    public $total = 0;
    public $n_albaranes = 0;
    public $albaranes = array();

    function __construct($codigo = 0, $crear_objetos_albaranes = false, $crear_objetos_linea = false, $crear_objetos_articulo = false, $crear_objeto_cliente = false) {
        //Cargamos todos los datos de la factura
        include('comunes/globals.php');
        $sentencia_sql = "SELECT factura.codigo, num_doc, cliente.codigo cliente, tipo_doc, tipo_doc_nombre, fecha, iva1, iva2, iva3, iva4, recargo1, recargo2, recargo3, recargo4, base1, base2, base3, base4, imp_iva1, imp_iva2, imp_iva3, imp_iva4, imp_recargo1, imp_recargo2, imp_recargo3, imp_recargo4, bruto1, bruto2, bruto3, bruto4, total
						FROM cliente, factura 
						WHERE factura.codigo = $codigo 
						AND factura.cliente = cliente.codigo_sinlib";
        //echo("$sentencia_sql<br />\n");
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->codigo = $fila['codigo'];
                    $this->num_doc = $fila['num_doc'];
                    if (is_a($crear_objeto_cliente, 'Usuario')) {
                        $this->cliente = $crear_objeto_cliente;
                    } else {
                        $this->cliente = ($crear_objeto_cliente) ? new Usuario($fila['cliente']) : NULL;
                    }
                    $this->tipo_doc = $fila['tipo_doc'];
                    $this->tipo_doc_nombre = $fila['tipo_doc_nombre'];
                    $this->fecha = $fila['fecha'];
                    $this->fecha_date_format = date_create($this->fecha);
                    $this->iva1 = $fila['iva1'];
                    $this->iva2 = $fila['iva2'];
                    $this->iva3 = $fila['iva3'];
                    $this->iva4 = $fila['iva4'];
                    $this->recargo1 = $fila['recargo1'];
                    $this->recargo2 = $fila['recargo2'];
                    $this->recargo3 = $fila['recargo3'];
                    $this->recargo4 = $fila['recargo4'];
                    $this->base1 = $fila['base1'];
                    $this->base2 = $fila['base2'];
                    $this->base3 = $fila['base3'];
                    $this->base4 = $fila['base4'];
                    $this->imp_iva1 = $fila['imp_iva1'];
                    $this->imp_iva2 = $fila['imp_iva2'];
                    $this->imp_iva3 = $fila['imp_iva3'];
                    $this->imp_iva4 = $fila['imp_iva4'];
                    $this->imp_recargo1 = $fila['imp_recargo1'];
                    $this->imp_recargo2 = $fila['imp_recargo2'];
                    $this->imp_recargo3 = $fila['imp_recargo3'];
                    $this->imp_recargo4 = $fila['imp_recargo4'];
                    $this->bruto1 = $fila['bruto1'];
                    $this->bruto2 = $fila['bruto2'];
                    $this->bruto3 = $fila['bruto3'];
                    $this->bruto4 = $fila['bruto4'];
                    $this->total = $fila['total'];
                }
            }
        }

        $sentencia_sql = 'SELECT codigo FROM cab_albaran WHERE factura = ' . $this->codigo;
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            $this->n_albaranes = mysqli_num_rows($resultado);
        }

        if ($crear_objetos_albaranes) {
            $this->cargar_albaranes($crear_objetos_linea, $crear_objetos_articulo, $crear_objeto_cliente);
        }
    }

    function cargar_albaranes($crear_objetos_linea = false, $crear_objetos_articulo = false, $crear_objeto_cliente = false) {
        include('comunes/globals.php');
        $sentencia_sql = 'SELECT codigo FROM cab_albaran WHERE factura = ' . $this->codigo;
        if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
            while ($fila = mysqli_fetch_array($resultado)) {
                $this->albaranes[] = new Albaran($fila['codigo'], $crear_objetos_linea, $crear_objetos_articulo, $crear_objeto_cliente);
            }
        }
    }

    function __destruct() {
        unset($this->codigo);
        unset($this->num_doc);
        unset($this->cliente);
        unset($this->tipo_doc);
        unset($this->tipo_doc_nombre);
        unset($this->fecha);
        unset($this->iva1);
        unset($this->iva2);
        unset($this->iva3);
        unset($this->iva4);
        unset($this->recargo1);
        unset($this->recargo2);
        unset($this->recargo3);
        unset($this->recargo4);
        unset($this->base1);
        unset($this->base2);
        unset($this->base3);
        unset($this->base4);
        unset($this->imp_iva1);
        unset($this->imp_iva2);
        unset($this->imp_iva3);
        unset($this->imp_iva4);
        unset($this->imp_recargo1);
        unset($this->imp_recargo2);
        unset($this->imp_recargo3);
        unset($this->imp_recargo4);
        unset($this->bruto1);
        unset($this->bruto2);
        unset($this->bruto3);
        unset($this->bruto4);
        unset($this->total);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>