<?php

class SuperTipoEnvioCliente extends Objeto{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

    public $codigo = 0;
    public $nombre = '';
    public $importe_fijo = 0;
    public $importe_unidad = 0;
    public $reembolso = 0;
    public $recargo_reembolso = 0;
    public $porc_rec_reembolso = 0;
    public $privado = 0;
    public $pais = 0;
    public $transferencia = 0;
    public $pasarela = 0;
    public $tipo_pasarela = 0;
    public $cuenta_bancaria = '';
    public $sin_pago = 0;
    public $sin_envio = 0;
	//public $rangosEnvios = array();
    //public $tarifasPorLocalidad = array();
    public $flag_utf8 = false;
    public $descripcion = "";
    public $requiere_pago = true;
	public $productos_destino = true;
	//Pedro 11/Agosto/2020 ==> Añaidimos el campo "excluido" que vamos a obtener del rango de envío que haya activo:
	public $excluido = 0;

	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		$campos = '';
		if (static::$nombreTabla != ''){
			$campos = ' ';
			if ($soloPrincipal || $soloPrincipal === NULL){
				//$campos .= BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias());
				$campos .= BaseDatos::dameCamposAlias(static::$nombreTabla);
			}
			if ($soloPrincipal === false || $soloPrincipal === NULL){
				$campos .= ( (trim($campos) != ' ') ? ', ' : '' ) . 
				Zona::getCampos() . ', '. 
				BaseDatos::dameCamposAlias('traduc_tipo_envio') . ', '. 
				RangoEnvio::getCampos();
			}
			if ($soloPrincipal == NULL){
				static::$camposSelect = $campos;
			}
		}
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL, $tablasOrigen = NULL){
		$idioma = Idioma::getCurrentLanguaje(true);
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		
		$consulta = ' ';
		if ($soloPrincipal || $soloPrincipal === NULL){
			$consulta .= '`' . static::$nombreTabla . '` as `' .  static::getAlias() . '` ';
		}
		if ($soloPrincipal === false || $soloPrincipal === NULL){
			//Cuando queramos una select real calculada en función de la zona necesitamos los rangos de envío que son el nexo entre la zona y el tipo de envío
			$consulta .= static::getJoin(get_called_class(), array('codigo', '$' . $idioma), 'traduc_tipo_envio', array('tipo_envio', 'idioma')) .
			', ' . RangoEnvio::getNombreTabla() . 
			', ' . Zona::getNombreTabla() .
			' ';
		}
		$consulta .= ' ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}

		return($consulta);
	}
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$limitar = isset($argumentos[1]) ? $argumentos[1] : true;
		$importe = isset($argumentos[2]) ? $argumentos[2] : NULL;
		$pais = isset($argumentos[3]) ? $argumentos[3] : NULL;
		$cp = isset($argumentos[4]) ? $argumentos[4] : NULL;
		$productos_destino = isset($argumentos[5]) ? $argumentos[5] : 'T';
		//Localidad y país los vamos a coget con una función en la zona
		//Vamos a componer la where un poco más complicada
			//Pedro 18/Mayo/2020 ==> Vamos a componer una select que nos dé sólo tipo de envío si es posible satisfacerlo para la zonta actual
		$txtZona = ' (
			' . Zona::getLocal($pais, $cp) . '
		OR
			' . Zona::getCity($pais, $cp) . '
		OR
			' . Zona::getCountry($pais) . '
		OR
			' . Zona::getGlobal() . '
		) ';
		//Si el importe que nos han pasado es NULL cargamos la cesta:
		if ($importe === NULL){
			//Pedro 07/Septiembre/2020 ==> Cuando estamos creando un tipo de envío, no queremos que se cree una cesta, no es algo necesario
			$cesta = CabeceraCesta::getCart(false);
			$importeCesta = $cesta->importe;
		}else{
			$importeCesta = $importe;
		}

		//$aliasTEXZ = BaseDatos::dameAlias('tipo_envio_por_zona');
		$aliasZona = Zona::getAlias();
		$aliasRango = RangoEnvio::getAlias();
		
		//Esta clase es especial porque SIEMPRE va a llevar unida la zona y el rango de envío, por eso la where va a estar inicializada:
		static::$whereSelect  = '
		`' . $aliasRango . '`.`zona` = `' . $aliasZona . '`.`codigo`
		AND `' . $aliasRango . '`.`tipo_envio_cliente` = `'. self::getAlias() . '`.`codigo` 
		AND (' . $importeCesta . ' BETWEEN `' . $aliasRango . '`.`rango_inferior` AND `' . $aliasRango . '`.`rango_superior`)
		AND ' . $txtZona . '
		AND ' . $aliasZona . '.`orden` = (
					SELECT MIN(`' . $aliasZona . '`.`orden`)
						FROM  `' . RangoEnvio::getNombreTablaSinAlias() . '` as `' . $aliasRango . '`, `' . Zona::getNombreTablaSinAlias() . '` as `' . $aliasZona . '`
						WHERE
						 `' . $aliasRango . '`.`tipo_envio_cliente` = '. self::getAlias() . '.`codigo` 
						 AND `' . $aliasRango . '`.`zona` = `' . $aliasZona . '`.`codigo`
						AND ' . $txtZona . '
						GROUP BY `' . $aliasRango . '`.`tipo_envio_cliente` LIMIT 1
					)
		';
		
		if ($codigo !== NULL){
			static::$whereSelect .= ' AND  `' . static::getAlias() . '`.`codigo` = ' . $codigo . ' ';
		}
		
		//Pedro 26/Mayo/2020 ==> Vamos a teneren cuenta los productos destino para que no cargue los tipos de envío equivocados:
		if ($productos_destino != 'T'){
			//Si nos especifican un tipo de producto sólo podemos mostrar los tipos de envío para ese producto y para todos
			static::$whereSelect .= ' AND (`' . static::getAlias() . '`.`productos_destino` = \'' . $productos_destino . '\' 
			OR `' . static::getAlias() . '`.`productos_destino` = \'T\')';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
		// PEDRO 19/Mayo/2020
		//Esta where no es como las demás, para mostrar un tipo de envío, se deben cumplir los requisitos (país, provincia, rango, etc...)
		//Para solucionar esto se han añadido las zonas de envío. En estas se usa una tabla asociativa entre zonas y tipos de envío.
		//Sin embargo existe una segunda asociación, que son los rangos de envío con las zonas y con los tipos de envío. 
		//Esto hace, siempre y cuando rellenemos los rangos de envío, que la tabla asociativa sea redundante. por ello vamos a hacer
		//que los rangos de envío sean OBLIGATORIOS y vamos a prescindir de la tabla asociativa
	}

    function __construct($opciones) {
        if (is_numeric($opciones)){
			$opciones = array('codigoEnvio' => $opciones);
		}
		$opciones = new ObOptions($opciones);
		$filaTipoEnvio = $opciones->getDefaultValue('filaTipoEnvio', NULL);
		$codigo = $opciones->getDefaultValue('codigoEnvio', NULL);
		$cargarRangosEnvio = $opciones->getDefaultValue('cargarRangosEnvio', true);
		$cargarTarifasLocalidad = $opciones->getDefaultValue('cargarTarifasLocalidad', true);
		$importe = $opciones->getDefaultValue('importe', NULL);
		$pais = $opciones->getDefaultValue('pais', NULL);
		$codigo_postal = $opciones->getDefaultValue('codigo_postal', NULL);
		$productos_destino = $opciones->getDefaultValue('productos_destino', 'T');
		$fila = NULL;
		ob_start();
		$text = ob_get_clean();
		//FileSystem::log('Componemos la select del tipo de envío con los datos ' . $text);
		//Si no hemos recibido fila usuario, vamos a hacer la select:
		if ($filaTipoEnvio == NULL){	//Para las pruebas vamos a obligar a que se haga una select
			$sentencia_sql = 'SELECT ' . static::getCampos() .
							' FROM ' . static::getNombreTabla() . 
							' WHERE ' . static::getWhereTabla($codigo, true, $importe, $pais, $codigo_postal, $productos_destino);
			//echo($sentencia_sql);
			//FileSystem::log($sentencia_sql);
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
				$fila = $bd->getFila();
			}
		}else{
			$fila = $filaTipoEnvio;
		}
		$this->extractData($fila);
/*
		//Pedro 25/Mayo/2020 ==> Ya no hay que hacer esto
        if ($cargarRangosEnvio) {
            $this->cargarRangosEnvio();
        }
        if ($cargarTarifasLocalidad) {
            $this->cargarTarifasPorLocalidad();
        }
*/
    }

    function __destruct() {
        unset($this->codigo);
        unset($this->nombre);
        unset($this->importe_fijo);
        unset($this->importe_unidad);
        unset($this->reembolso);
        unset($this->recargo_reembolso);
        unset($this->porc_rec_reembolso);
        unset($this->privado);
        unset($this->pais);
        unset($this->transferencia);
        unset($this->pasarela);
        unset($this->tipo_pasarela);
        unset($this->cuenta_bancaria);
        unset($this->sin_pago);
        unset($this->sin_envio);
	    unset($this->productos_destino);
    }

	public function extractData($fila){
		 if ($fila != NULL) {
			$this->codigo = (int) $this->getProp($fila, 'codigo');
			$this->nombre = $this->getProp($fila, 'nombre');
			//$this->importe_fijo = $this->getProp($fila, 'importe_fijo');
			//Pedro 19/Mayo/2020 ==> Cogemos el importe fijo de los rangos
			$this->importe_fijo = $this->getProp($fila, 'importe', RangoEnvio::getAlias());
			$this->importe_unidad = $this->getProp($fila, 'importe_unidad');
			$this->reembolso = $this->getProp($fila, 'reembolso');
			$this->reembolso = ($this->reembolso == 0) ? false : true;
			$this->recargo_reembolso = $this->getProp($fila, 'recargo_reembolso');
			$this->porc_rec_reembolso = $this->getProp($fila, 'porc_rec_reembolso');
			$this->privado = $this->getProp($fila, 'privado');
			$this->pais = $this->getProp($fila, 'pais');
			$this->transferencia = $this->getProp($fila, 'transferencia');
			$this->pasarela = $this->getProp($fila, 'pasarela');
			$this->tipo_pasarela = $this->getProp($fila, 'tipo_pasarela');
			$this->cuenta_bancaria = $this->getProp($fila, 'cuenta_bancaria');
			$this->sin_pago = $this->getProp($fila, 'sin_pago');
			$this->sin_pago = ($this->sin_pago == 0) ? false : true;
			$this->sin_envio = $this->getProp($fila, 'sin_envio');
			$this->descripcion = $this->getProp($fila, 'descripcion', BaseDatos::dameAlias('traduc_tipo_envio'));
			if ($this->sin_pago || $this->reembolso) {
				$this->requiere_pago = false;
			}
			$this->productos_destino = $this->getProp($fila, 'productos_destino');
			$this->excluido = $this->getProp($fila, 'excluido', RangoEnvio::getAlias());
			$this->excluido = ($this->excluido == 1) ? true : false;
        }
		ob_start();
		//var_dump($this);
		$txt = ob_get_clean();
		//FileSystem::log($txt);
	}
	/*
    function cargarRangosEnvio() {
        include('comunes/globals.php');
        $sentencia_sql = 'SELECT codigo '
                . 'FROM rango_envio '
                . 'WHERE tipo_envio_cliente = ' . $this->codigo;
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                while ($fila = mysqli_fetch_array($resultado)) {
                    $this->rangosEnvios[] = new RangoEnvio($fila['codigo']);
                }
            }
        }
    }
	*/
/*
    function cargarTarifasPorLocalidad() {
		$this->tarifasPorLocalidad = TarifasPorLocalidad::getAll($this->codigo);
    }
*/
	public static function tipoEnvioTodos(){
		$retorno = array();
		//Pedro 26/Mayo/2020 ==> Añadimos aquí el control del tipo de producto que haya en la cesta para no mostrar los tipos de envío que no se puedan elegir
		$sentencia_sql = 'SELECT ' . static::getCampos() . ' 
						FROM ' . static::getNombreTabla() . '
						WHERE ' . static::getWhereTabla(NULL, false, NULL, NULL, NULL, CabeceraCesta::staticGetProductType()) . '; ';
		/*ob_start();
		echo("<!--
		$sentencia_sql
		-->");
		$texto = ob_get_clean();
		FileSystem::log($texto);*/
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			while ($fila = $bd->getFila()){
				array_push($retorno, new TipoEnvioCliente(new OpcionesWidget(array('filaTipoEnvio' => $fila))));
			}
		}
		return($retorno);
	}

    /**
     * Nos devuelve los gastos de envío
	 * Si a esta función le pasamos una localidad, no la coge de la cesta y te dice los gastos de envio.
     * */
    public function getGastosEnvio($localidad = '', $cart = NULL) {
		//Pedro 19/Mayo/2020 ==> A partir de ahora los gastos de envío los cogemos directamente del rango:
		$localImporteTotal = $this->importe_fijo;
		$cart = ($cart == NULL) ? CabeceraCesta::getCart() : $cart;
		$cart->cantidad;
		if ($this->importe_unidad > 0) {
			$localImporteTotal += $cart->cantidad * $this->importe_unidad;
		}
		if ($this->reembolso) {
			//Si hay porcentaje de recargo de reembolso lo sumamos
			if ( $this->porc_rec_reembolso > 0) {
				//$retorno = ($retorno * $gastos["porc_recargo_reembolso"]) / 100;
				$localImporteTotal += ( ($cart->importe + $localImporteTotal) *  $this->porc_rec_reembolso) / 100;
			}
			//Es un reembolso, así que hay que calcular los gastos x reembolso
			$localImporteTotal += $this->recargo_reembolso;
		}
        return($localImporteTotal);
    }

}

?>