<?php

/*
  Clase SuperModule
  @version 1.0
  //Esta clase será, en el futuro la encargada de cargar un módulo para su uso
  //Estados de los módulos
  //No disponible	==> 0
  //disponible		==> 2
  //instalado		==> 3
  //Activo			==> 4
  
  //Este módulo extiende objeto y hace una carga de la BD, pero en sí no se corresponde con una entidad de la misma
  // y por ello está en la carpeta de controladores. Es más importante su contribución como controlador que como clase
 */

class SuperModule extends Objeto{
	//Pedro 16/Mayo/2019 ==> La vista por defecto del módulo la guardo aquí:
	private $templateFile = '';
	//Lista de módulos cargados:
	private static $loadedModules = array();
	//Lista de módulos totales:
	private static $modulesList = array();
	//Opciones a cargar en el módulo
	public $options = NULL;
	//Opciones que se le paasrán a la vista
	public $viewOptions = NULL;
	//data update que se va a utilizar:
	private $data_update = '';
	public static $_MODULE_NOT_AVAILABLE_ = 0;
	public static $_MODULE_AVAILABLE_ = 2;
	public static $_MODULE_INSTALLED_ = 3;
	public static $_MODULE_ACTIVE_ = 4;
	protected static $activeActions = array();
	protected static $actionList = array();
	
	

	public static function getCampos(){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (self::$nombreTabla != ''){
			self::$campos_tabla = BaseDatos::dameCampos(self::$nombreTabla);
			self::$camposSelect = BaseDatos::dameCamposAlias(self::$nombreTabla) . ' ';
		}
		return(self::$camposSelect);
	}
	
	public static function getNombreTabla(){
		self::$nombreTabla = strtolower(get_called_class());
		self::getTablaRelacionada();
		//Vamos a simplificar, cogemos el nombre de la tabla usando la función de la clase padre:
		self::$nombreTabla = self::$nombreTabla . ' `' .  self::getAlias() . '`  ';
		return(self::$nombreTabla);
	}  
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$codigo = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$nombre = isset($argumentos[1]) ? $argumentos[1] : NULL;
		$limitar = isset($argumentos[2]) ? $argumentos[2] : true;
		
		//include('comunes/globals.php');
		self::$whereSelect = '';
		if ($codigo != NULL) {
			self::$whereSelect .= ' `' . self::getAlias() . '`.`id` = "' . $codigo . '" ';
		}
		if ($nombre != NULL) {
			self::$whereSelect .= ' `' . self::getAlias() . '`.`nombre` = "' . $nombre . '" ';
		}
		if ($limitar){
			self::$whereSelect .= ' LIMIT 1 ';
		}
		return(self::$whereSelect);
	}
	
	
    //Constructor y destructor
    public function __construct() {    }
	
	public static function initModuleList(){
		if (empty(self::$modulesList)){
			self::loadModuleList();
		}
	}
	public static function loadModuleList(){
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			$sentencia = ' SELECT ' . self::getCampos() . 
						' FROM '. self::getNombreTabla();
			//echo($sentencia);
			$bd->setConsultaSQL($sentencia);
			while($fila = $bd->getFila()){
				self::$modulesList[static::sGetProp($fila, 'nombre')] = static::sGetProp($fila, 'estado');
			}
		}
	}
	
	

    public function __destruct() {
        
    }
	
	//Pedro 16/Mayo/2016 ==> Esta función instancia el módulo y lo devuelve a la variable correspondiente
	//public static function instantiate($moduleName, $functionOptions = array(), $moduleOptions = ''){
	//Pedro 16Mayo/2019 ==> En vez de llamar a instantiate, llamaremos a este módulo pasándole el nombre de la clase
	// ACLARACIÓN ==> Argumentos es un array con los argumentos pasados. Sólo se tendrán en cuenta los dos primeros elementos:
	//	1 .- Opciones para actualizar el módulo vía javascript (data-update, templateFile, etc.
	//	2 .- Opciones que pasarle a la función "exec" que se encargará de procesar el módulo
						
	public static function __callStatic ($moduleName, $arguments){
		$functionOptions = (isset($arguments[0])) ? $arguments[0] : array();
		$moduleOptions = (isset($arguments[1])) ? $arguments[1] : '';
		//Para trabajar con el módulo, vamos a ponerlo en minúscula:
		$moduleName = strtolower($moduleName);
		$object = NULL;				//Objeto que vamos a devolverá
		//Vamos a procesar las opciones para la función de llamada al widget
		$functionOptions = new ObOptions($functionOptions);
		$templateFile = $functionOptions->getDefaultValue('templateFile', '');
		$data_update = $functionOptions->getDefaultValue('data_update', '');
		//Lo primero y más importante es asegurarnos de que la lista de módulos está cargada:
		static::initModuleList();
		//Si el módulo No está disponible, no podemos instanciarlo:
		if (static::is_active($moduleName)){
			//Módulo disponible, vamos a cargar el php si es necesario:
			/*
			//Pedro 13/Julio/2020 ==> Los módulos se cargan ahora con otra función:
			//-------------------
			//Pedro 14/Mayo/2020 ==> Vamos a hacer que se cargue el módulo personalizado:
			$modulePath = _WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_MODULES_DIR_ . strtolower($moduleName) .  '/' . strtolower($moduleName) . '.php';
			//FileSystem::log("Cargamos el fichero $modulePath");
			if (!file_exists($modulePath)){
				//Si no está personalizado, cargamos el bueno
				$modulePath = _WS_MODULES_DIR_ . strtolower($moduleName) .  '/' . strtolower($moduleName) . '.php';
				//FileSystem::log("No existe, así que cargamos el fichero $modulePath");
			}
			$moduleLoaded = false;
			//Vamos a tratar de cargar el fichero .php de este módulo
			//var_dump(self::$loadedModules);
			if ( (!isset(self::$loadedModules[$moduleName])) && (file_exists($modulePath)) ){
				//FileSystem::log("Módulo no cargado, vamos a cargar el fichero: $modulePath");
				$moduleLoaded = true;
				include_once($modulePath);
				self::$loadedModules[$moduleName] = 1;
				//Pedro 13/Julio/2020 ==> Si el fichero está cargado lo indicamos
			}else if (isset(self::$loadedModules[$moduleName])){
				$moduleLoaded = true;
			}
			*/
			$moduleLoaded = self::load($moduleName);
			//Si el fichero .php del módulo está cargado, vamso a ejecutarlo:
			if ($moduleLoaded){
				$className = ucfirst(strtolower($moduleName));
				$object = new $className;
				//Asignamos las diferentes opciones al widget:
				if ($moduleOptions != NULL){
					$object->setOptions($moduleOptions);
				}
				if ($templateFile != ''){
					$object->setTemplateFile($templateFile);
					//echo("estamos cargando $templateFile\n");
				}
				if ($data_update != ''){
					$object->setData_update($data_update);
				}
			}
		}
		return($object);
	}
	public function setOptions($options){
		//$this->options = new ObOptions($options);
		$this->options = $options;
	}
	public function setViewOptions($options){
		//$this->options = new ObOptions($options);
		$this->viewOptions = $options;
	}
	public function setTemplateFile($templateFile){
		$this->templateFile = $templateFile;
	}
	public function setData_update($data_update){
		$this->data_update = $data_update;
	}
	public function getFunctionOptions(){
		return(
			array(
				'templateFile' => $this->templateFile, 
				'data_update' => $this->data_update
				)
		);
	}
	public function getModuleOptions(){
		return($this->options);
	}
	public function getViewOptions(){
		return($this->viewOptions);
	}
	
	public static function getName($codigo){
		$nombre = '';
		$bd = new BaseDatos();
		$sentencia = ' SELECT ' . self::getCampos() . 
					' FROM '. self::getNombreTabla() .
					' WHERE ' . self::getWhereTabla($codigo);
		$bd->setConsultaSQL($sentencia);
		while($fila = $bd->getFila()){
			$nombre = static::sGetProp($fila, 'nombre');
		}
		return($nombre);
	}
	
	
	//Función vacía que vamos a utilizar como molde para que los módulos la heredn
	//public function execute(){/* Aquí los módulos tienen que ejecutar su lógica */}
	//------------------------------------------------------------------------------------------------
	// estas funciones son para cargar los componentes (viejos módulos también llamados widgets)
	//------------------------------------------------------------------------------------------------
	public static function loadComponent($module, $component, $options){	//Ojo que esta función es sólo para widgets
		//Esta función, por ahora la vamos a usar para cargar los widgets de las versiones antiguas de webStore
		ob_start();
		new Widget(array('nombre' => $module, 'funcion' => $component), $options);
		$retorno = ob_get_clean();
		return($retorno);
	}

	public static function loadEncryptedComponent($data){
		//Esta función, por ahora la vamos a usar para cargar los widgets de las versiones antiguas de webStore
		//Recibimos el componente encriptado:
		$newData = unserialize(base64_decode($data));
		//var_dump($data);
		//Pedro 17/Mayo/2019:
		//Llegados a este punto ya podemos ejecutar módulos. Es por ello que en esta función vamos a dar prioridad a que exista un módulo con el nombre recibido:
		$moduleName = $newData['widget'];
		$return = array();
		self::initModuleList();
		if (isset(self::$modulesList[$moduleName])){
			$moduleName = $newData['widget'];
			$fixedParams = $newData['function'];
			$variableParams = $newData['opciones'];
			$module = Module::$moduleName($fixedParams, $variableParams);
			//var_dump($module);
			$return = array('hash' => $data, 'content' => $module->__toString());
		}else{
			$return = array('hash' => $data, 'content' => static::loadComponent($newData['widget'], $newData['function'], $newData['opciones']));
		}
		return($return);
		//return($data);
	}
	//------------------------------------------------------------------------------------------------
	// estas funciones son para cargar los componentes (viejos módulos también llamados widgets)
	//------------------------------------------------------------------------------------------------

	
	//------------------------------------------------------------------------------------------------
	// ACCIONES ==>Con estas funciones gestionamos las acciones
	//------------------------------------------------------------------------------------------------
	//Empezamos por la parte sencilla, añadimos una acción a los módulos
	protected static function addAction($action = NULL){
		if ($action != NULL){
			$className = strtolower(get_called_class());	//EN MINÚSCULAS SIEMPRE
			self::$activeActions[$className . '_' . $action] = true;
		}
		return(self::$activeActions);
	}
	//Inicializamos las acciones de los módulos, lo 
	public static function initActions(){
		//La idea es que esta función se sobreEscriba en cada módulo
		foreach(static::$actionList as $key => $value){
			self::addAction($value);
		}
	}
	//Inicializamos las acciones disponibles para cada módulo activo:
	public static function checkModuleActions(){
		self::initModuleList();	//Nos aseguramos de tener los módulos activos cargados
		foreach(self::$modulesList as $moduleName => $estado){
			//Si el estado es el 4, cogemos inicializamos las acciones de ese módulos:
			if ($estado == static::$_MODULE_ACTIVE_){
				
				//Pedro 13/Julio/2020 ==> A partir de ahora se usa sólo la función de load para cargar/checkear si un módulo está cargado en memoria:
				$moduleLoaded = static::load($moduleName);
				//Pedro 13/Julio/2020 ==> Si el módulo está cargado tiramos de sus acciones:
				if ($moduleLoaded){
					$camelModuleName = ucfirst($moduleName);
					$camelModuleName::initActions();	//De esta forma rellenamos las acciones disponibles en los módulos
					//Cargamos las acciones del módulo si las hubiese
					$rutaFicheroAcciones = _WS_MODULES_DIR_ . $moduleName . '/actions.php';
					//Pedro 28/Mayo/2020 ==> Personalizamos las acciones:
					$rutaFicheroAcciones = _WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_MODULES_DIR_ . strtolower($moduleName) .  '/' . 'actions.php';
					if (!file_exists($rutaFicheroAcciones)){
						//Si no está personalizado, cargamos el bueno
						$rutaFicheroAcciones = _WS_MODULES_DIR_ . strtolower($moduleName) .  '/' . 'actions.php';
					}
					if (file_exists($rutaFicheroAcciones)){
						include($rutaFicheroAcciones);
					}
				}
				/*
				//Incluimos el fichero del módulo (su clase principal):
				//Pedro 28/Mayo/2020 ==> Personalizamos el módulo a cargar
				$modulePath = _WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_MODULES_DIR_ . strtolower($moduleName) .  '/' . strtolower($moduleName) . '.php';
				if (!file_exists($modulePath)){
					//Si no está personalizado, cargamos el bueno
					$modulePath = _WS_MODULES_DIR_ . strtolower($moduleName) .  '/' . strtolower($moduleName) . '.php';
				}
				//Si no está definida la clase del módulo no hacemos nada
				if (!class_exists(ucfirst($moduleName), false)){
					if (file_exists($modulePath)){
						include($modulePath);
						//Pedro 28/Mayo/2020 ==> Si esto ocurre hay que antoar la clase como cargada
						self::$loadedModules[$moduleName] = 1;
						$camelModuleName = ucfirst($moduleName);
						$camelModuleName::initActions();	//De esta forma rellenamos las acciones disponibles en los módulos
						//Cargamos las acciones del módulo si las hubiese
						$rutaFicheroAcciones = _WS_MODULES_DIR_ . $moduleName . '/actions.php';
						//Pedro 28/Mayo/2020 ==> Personalizamos las acciones:
						$rutaFicheroAcciones = _WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_MODULES_DIR_ . strtolower($moduleName) .  '/' . 'actions.php';
						if (!file_exists($rutaFicheroAcciones)){
							//Si no está personalizado, cargamos el bueno
							$rutaFicheroAcciones = _WS_MODULES_DIR_ . strtolower($moduleName) .  '/' . 'actions.php';
						}
						if (file_exists($rutaFicheroAcciones)){
							include($rutaFicheroAcciones);
						}
					}
				}*/
			}
		}
	}
	//El último paso es ejecutar las acciones de cada módulo siempre y cuando las tenga definiads
	public static function execModulesActions(){
		$accion = Getter::get('accion', array());
		if (!is_array($accion)){
			$accion = array($accion);
		}
		foreach($accion as $clave => $nombreAccion){
			//Ejecutamos la acción si está está permitida en el módulo
			$tmp_nombre_modulo = explode(' ', $nombreAccion);
			$nombre_modulo = (isset($tmp_nombre_modulo[0])) ? $tmp_nombre_modulo[0] : $nombre_modulo;
			$nombreAccion = (isset($tmp_nombre_modulo[1])) ? $tmp_nombre_modulo[1] : $nombreAccion;
			//Será el módulo el encargado de ejecutar su propia acción
			$camelModuleName = ucfirst($nombre_modulo);
			$camelModuleName::execAction($nombreAccion);
		}
	}
	//Si el módulo tiene la acción definida, la ejecutamos. En un futuro esto se hará también desde una BD
	protected static function execAction($actionName){
		//¿Existe la acción declarada en el módulo con el que estamos trabajando?
		//Vamos a definirla:
		$completeName = strtolower(get_called_class()) . '_' . $actionName;
		if (isset(self::$activeActions[$completeName])){
			if (function_exists($completeName)){
				$completeName();	//ejecutamos la función en cuestión
			}
		}
	}
	//Añadimos con controlador de la acción a la web: (en el futuro estaría bien que si el módulo tiene esta vista cargada, se use
	public static function insertActionController($controller, $actionName){
		?>
		<input type="hidden" name="accion[]" value="<?=$controller . ' ' . $actionName;?>">
		<?php
	}
	
	//------------------------------------------------------------------------------------------------
	// ACCIONES ==>Con estas funciones gestionamos las acciones
	//------------------------------------------------------------------------------------------------
	
	
	//------------------------------------------------------------------------------------------------
	// funciones relacionadas con la carga de módulos
	//------------------------------------------------------------------------------------------------
		//Pedro 16/Mayo/2019
	function __toString() {
		$nombreModulo = strtolower(get_called_class());
		$content = '';
		//Pedro 28/Mayo/2020 ==> Un módulo activo no se mostrará:
		if (static::is_active($nombreModulo)){
			//Ejecutamos el módulo para que pueda hacer otras cosas
			$this->execute();
			//$me = new stdclass();
			$me = new ObOptions($this->getViewOptions());
			$me->name = $nombreModulo;
			//Esta función es la encargada de mostrar la vista del módulo. 
			//Nos aseguramos de que esta contenga algo:
			$this->templateFile = ($this->templateFile != '') ? $this->templateFile : ($me->name);
			//y de que haya un data-update:
			$this->data_update = ($this->data_update != '') ? $this->data_update : ($me->name);
			if (strtoupper(substr($this->templateFile, -4)) != '.PHP'){
				$this->templateFile .= '.php';
			}
			//Ahora mismo, para simplificar vamos a hacer que la vista se busque, primero en la carpeta "modules" del tema y después en la carpeta módules:
			$personalizedPath = _WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_MODULES_DIR_ . $me->name .  '/views/' . $this->templateFile;
			$realPath = _WS_MODULES_DIR_ . $me->name .  '/views/' . $this->templateFile;
			
			ob_start();
			//Vamos a crear el div de inicio:
			$configuracionWidget = base64_encode(serialize(array(
				'widget' => $me->name,
				'function' => $this->getFunctionOptions(),	//Se pasan los datos de la vista y el data-update
				'opciones' => $this->getModuleOptions()		//Se guardan las opciones del Módulo, no las que se pasan a la vista
			)));
			?>
			<div data-update="<?=$this->data_update;?>" data-configuration="<?=$configuracionWidget;?>">
			<?php
				if (file_exists($personalizedPath)){
					include_once($personalizedPath);
				}else if (file_exists($realPath)){
					include_once($realPath);
				}
			?>
			</div>
			<?php
			$content = ob_get_clean();
		}
        return ($content);
    }
	//------------------------------------------------------------------------------------------------
	// funciones relacionadas con la carga de módulos
	//------------------------------------------------------------------------------------------------


	//Funciones que nos van a decir si un módulo está o no activo:
	public static function is_available($name){
		return(self::is_in_state($name, self::$_MODULE_AVAILABLE_));
	}
	
	public static function is_not_available($name){
		return(self::is_in_state($name, self::$_MODULE_NOT_AVAILABLE_));
	}
	
	public static function is_installed($name){
		return(self::is_in_state($name, self::$_MODULE_INSTALLED_));
	}
	
	public static function is_active($name){
		return(self::is_in_state($name, self::$_MODULE_ACTIVE_));
	}
	
	private static function is_in_state($name, $state){
		$return = false;
		self::initModuleList();
		if (static::getModuleState($name) == $state){
			$return = true;
		}
		return($return);
	}
	
	private static function getModuleState($name){
		$return = -1;
		self::initModuleList();
		$list = self::$modulesList;
		if (isset($list[$name])){
			$return = $list[$name];
		}
		return($return);
	}
	
	//Pedro 13/Julio/2020 ==> Vamos a hacer una única función que cargue el módulo:
	public static function load($moduleName){
		$moduleLoaded = (isset(self::$loadedModules[$moduleName])) ? true : false;
		$modulePath = _WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_MODULES_DIR_ . strtolower($moduleName) .  '/' . strtolower($moduleName) . '.php';
		//Si el módulo no está cargado seguimos:
		if (!$moduleLoaded){
			//FileSystem::log("Cargamos el fichero $modulePath");
			if (!file_exists($modulePath)){
				//Si no está personalizado, cargamos el bueno
				$modulePath = _WS_MODULES_DIR_ . strtolower($moduleName) .  '/' . strtolower($moduleName) . '.php';
				//FileSystem::log("No existe, así que cargamos el fichero $modulePath");
			}
			//Si pasa por aquí es porque el módulo no está cargado, hay que cargarlo
			if ( file_exists($modulePath)) {
				//FileSystem::log("Módulo no cargado, vamos a cargar el fichero: $modulePath");
				$moduleLoaded = true;
				include_once($modulePath);
				self::$loadedModules[$moduleName] = 1;
				//Pedro 13/Julio/2020 ==> Si el fichero está cargado lo indicamos
			}
		}
		return($moduleLoaded);
	}
}
