<?php
//---------------------------------------------------------------------------------------------------------
// 08/Noviembre/2018 ==> Módulo encargado de los pagos a redsys
//---------------------------------------------------------------------------------------------------------
//Los módulos heredan los atributos de la clase Module:
/*	$templateFile = '';
	$loadedModules = array();
	$modulesList = array();
	$options = NULL;
	$data_update = '';
*/

class Ceca_pasarela extends Module{
	//Definimos la lista de acciones que ejecutará este módulo
	protected static $actionList = array('');
	
	//Ahora metemos los datos de este módulo
	private $url_pago = 'https://pgw.ceca.es/tpvweb/tpv/compra.action';	// ==> Entorno real
	//private $url_pago = 'https://tpv.ceca.es/tpvweb/tpv/compra.action';	// ==> Pruebas
	private $MerchantID = '213115041';
	private $AcquirerBIN = '0000554013';
	private $TerminalID = '00000003';
	private $claveEnciptacion = '6E9T60I4';
	private $Num_operacion = '0';
	private $Importe = '0';
	private $TipoMoneda = '978';
	private $Exponente = '2';
	private $URL_OK = '';
	private $URL_NOK = '';
	private $Firma = '';
	private $Cifrado = 'SHA2';
	private $Idioma = '1';
	private $Pago_soportado = 'SSL';
	private $Descripcion = '';
	private $Pago_elegido = '';
	private $datos_acs_20 = '';
	private $firma_acs_20 = '';

	//Función que instala el módulo
	public function install(){
		
	}
	
	//Función que desinstala el módulo
	public function uninstall(){
		
	}
	
	
	//constructor:
	public function __construct() {
		//Vamos a inicializar algunas variables
		$this->URL_OK = Shop::$configuracion->url . 'resultado_ceca';
		$this->URL_NOK = Shop::$configuracion->url . 'cesta/';
	}

	//Esta función es la encargada de ejecutar del módulo lo que sea necesario:
	public function execute(){
		$opciones_recibidas = new ObOptions($this->getModuleOptions());	//Recogemos las opciones que nos puedan haber mandado
		//Vamos a controlar de las opciones recibidas en qué estamos:
		$chequear_pago = $opciones_recibidas->getDefaultValue('chequear_pago', false);
		if ($chequear_pago){
			$options = $this->checkPago($opciones_recibidas);
		}else{
			$options = $this->generarFormularioPasarela();
		}
		//Lo último es asignar las opciones a la vista
		$this->setViewOptions($options);
	}

	private function generarFormularioPasarela(){
		//Ojo, el número de pedido NO es el código si no un contador usado para no repetir:
		$cart = CabeceraCesta::getCart();
		$cart->incrementarNumeroPedido();
		//Estas variables se asignan en función de la cesta
		$this->Importe = str_pad(number_format($cart->importe + $cart->g_envio, 2, '', ''), 12, '0', STR_PAD_LEFT);
		$this->Num_operacion = str_pad($cart->numero_pedido, 12, '0', STR_PAD_LEFT);
		$this->URL_OK = Shop::$configuracion->url . 'finalizar_compra/' . $this->Num_operacion;
		$options = new stdClass();
		$cadena_firma = $this->claveEnciptacion . $this->MerchantID . $this->AcquirerBIN . $this->TerminalID . $this->Num_operacion . 
		$this->Importe . $this->TipoMoneda . $this->Exponente . $this->Cifrado . $this->URL_OK . $this->URL_NOK;
		$cadena_encriptada = hash('sha256', $cadena_firma);
		//Vamos a componer las opciones:
		$options->url_pago = $this->url_pago;
		$options->MerchantID = $this->MerchantID;
		$options->AcquirerBIN = $this->AcquirerBIN;
		$options->TerminalID = $this->TerminalID;
		$options->claveEnciptacion = $this->claveEnciptacion;
		$options->Num_operacion = $this->Num_operacion;
		$options->Importe = $this->Importe;
		$options->TipoMoneda = $this->TipoMoneda;
		$options->Exponente = $this->Exponente;
		$options->URL_OK = $this->URL_OK;
		$options->URL_NOK = $this->URL_NOK;
		$options->Firma = $cadena_encriptada;
		$options->cadena_firma = $cadena_firma;
		$options->Cifrado = $this->Cifrado;
		$options->Idioma = $this->Idioma;
		$options->Pago_soportado = $this->Pago_soportado;
		$options->Descripcion = $this->Descripcion;
		$options->Pago_elegido = $this->Pago_elegido;
		$options->datos_acs_20 = $this->datos_acs_20;
		$options->firma_acs_20 = $this->firma_acs_20;

		return($options);
	}
	
	private function checkPago($opciones_recibidas){
		//Vamos a capturar la salida:
		ob_start();

		$templateFile = 'resultado_compra_incorrecta.php';
		$options = new stdClass();
		$opciones_recibidas = new ObOptions($opciones_recibidas);
		$MerchantID = $opciones_recibidas->getDefaultValue('MerchantID', '');
		$AcquirerBIN = $opciones_recibidas->getDefaultValue('AcquirerBIN', '');
		$Num_operacion = $opciones_recibidas->getDefaultValue('Num_operacion', '');
		$Importe = $opciones_recibidas->getDefaultValue('Importe', '');
		$TipoMoneda = $opciones_recibidas->getDefaultValue('TipoMoneda', '');
		$Exponente = $opciones_recibidas->getDefaultValue('Exponente', '');
		$Referencia = $opciones_recibidas->getDefaultValue('Referencia', '');
		$Firma = $opciones_recibidas->getDefaultValue('Firma', '');
		$Codigo_pedido = $opciones_recibidas->getDefaultValue('Codigo_pedido', '');
		$Codigo_cliente = $opciones_recibidas->getDefaultValue('Codigo_cliente', '');
		$Codigo_comercio = $opciones_recibidas->getDefaultValue('Codigo_comercio', '');
		$Num_aut = $opciones_recibidas->getDefaultValue('Num_aut', '');
		$BIN = $opciones_recibidas->getDefaultValue('BIN', '');
		$FinalPAN = $opciones_recibidas->getDefaultValue('FinalPAN', '');
		$Cambio_moneda = $opciones_recibidas->getDefaultValue('Cambio_moneda', '');
		$Idioma = $opciones_recibidas->getDefaultValue('Idioma', '');
		$Pais = $opciones_recibidas->getDefaultValue('Pais', '');
		$Tipo_tarjeta = $opciones_recibidas->getDefaultValue('Tipo_tarjeta', '');
		$Descripcion = $opciones_recibidas->getDefaultValue('Descripcion', '');
		
		//Teniendo los datos vamos a cargar la cesta con el código recibido:
		$cesta = new CabeceraCesta(array(
			'numero_pedido' => intval($Num_operacion),
			'fusionarCesta' => false	//EXTREMADAMENTE IMPORTANTE, ESTE PROCESO SE EJECUTA SIN USUARIO Y LA CESTA TIENE USUARIO. HAY QUE EVITAR QUE INTENTE FUSIONAR
		));
		
		//Es el momento de mostrar los elementos a modo de traza:
?>
Hemos recibido esta informacion de la pasarela:
MerchantID: <?=$MerchantID;?>
AcquirerBIN: <?=$AcquirerBIN;?>
Num_operacion: <?=$Num_operacion;?>
Importe: <?=$Importe;?>
TipoMoneda: <?=$TipoMoneda;?>
Exponente: <?=$Exponente;?>
Referencia: <?=$Referencia;?>
Firma: <?=$Firma;?>
Codigo_pedido: <?=$Codigo_pedido;?>
Codigo_cliente: <?=$Codigo_cliente;?>
Codigo_comercio: <?=$Codigo_comercio;?>
Num_aut: <?=$Num_aut;?>
BIN: <?=$BIN;?>
FinalPAN: <?=$FinalPAN;?>
Cambio_moneda: <?=$Cambio_moneda;?>
Idioma: <?=$Idioma;?>
Pais: <?=$Pais;?>
Tipo_tarjeta: <?=$Tipo_tarjeta;?>
Descripcion: <?=$Descripcion;?>
<?php
		
		//Vamos a calcular la firma con los parámetros recibidos:
		$firma_calculada = $this->claveEnciptacion . $this->MerchantID  .$this->AcquirerBIN . $this->TerminalID .
			str_pad($cesta->numero_pedido, 12, '0', STR_PAD_LEFT) . 
			str_pad(number_format($cesta->importe + $cesta->g_envio, 2, '', ''), 12, '0', STR_PAD_LEFT) . 
			$this->TipoMoneda . $this->Exponente . $Referencia;
		$firma_calculada = hash('sha256', $firma_calculada);
?>
Firma calculada: <?=$firma_calculada;?>
<?php
		//Teniendo toda esta información, vamos a calcular la firma recibida
		if ( $firma_calculada === $Firma ){

			//Finalizamos la compra:
			if ($Num_operacion > 0){
				if ($cesta->codigo > 0){
					//Vamos a asegurarnos de que todo es correcto:
					$ready = $cesta->readyToFinish();
					echo("Ready es : {$ready}<br/>");
					if ($ready >= 200){
						$pedido = $cesta->finish();
						//Vamos a dar el pedido por pagado:
						if ($pedido != NULL){
							$pedido->pagado();
							$templateFile = 'resultado_compra_correcta.php';
							?>
							----------------------------------------------------------------------------------------------------------------------------------------
							----------------------------------------------------------------------------------------------------------------------------------------
																	CORRECTO, PEDIDO FINALIZADO CON CÓDIGO <?=$pedido->codigo;?>
							----------------------------------------------------------------------------------------------------------------------------------------
							----------------------------------------------------------------------------------------------------------------------------------------
							<?php
						}else{
							?>
							----------------------------------------------------------------------------------------------------------------------------------------
							----------------------------------------------------------------------------------------------------------------------------------------
																INCORRECTO, Error al crear el pedido
							----------------------------------------------------------------------------------------------------------------------------------------
							----------------------------------------------------------------------------------------------------------------------------------------
							<?php
						}
					}else{
						?>
						----------------------------------------------------------------------------------------------------------------------------------------
						----------------------------------------------------------------------------------------------------------------------------------------
															INCORRECTO, PEDIDO NO FINALIZADO CON ERROR <?=$ready;?>
						----------------------------------------------------------------------------------------------------------------------------------------
						----------------------------------------------------------------------------------------------------------------------------------------
						<?php
					}
				}else{
					var_dump($cesta);
					?>
					----------------------------------------------------------------------------------------------------------------------------------------
					----------------------------------------------------------------------------------------------------------------------------------------
						EL PEDIDO NO SE HA PODIDO FINALIZAR PORQUE EL CÓDIGO DE PEDIDO RECIBIDO NO COINCIDE CON NINGUNA CESTA EXISTENTE EN LA BASE DE DATOS
					----------------------------------------------------------------------------------------------------------------------------------------
					----------------------------------------------------------------------------------------------------------------------------------------
					<?php
				}
			}else{
				?>
				----------------------------------------------------------------------------------------------------------------------------------------
				----------------------------------------------------------------------------------------------------------------------------------------
									  EL PEDIDO NO SE HA PODIDO FINALIZAR PORQUE EL CÓDIGO DE PEDIDO RECIBIDO ES 0
				----------------------------------------------------------------------------------------------------------------------------------------
				----------------------------------------------------------------------------------------------------------------------------------------
				<?php
			}
		}else{
			//Ha ocurrido un error, vamos a enviar un email a la empresa informando:
			?>
			----------------------------------------------------------------------------------------------------------------------------------------
			----------------------------------------------------------------------------------------------------------------------------------------
										EL PEDIDO NO SE HA PODIDO FINALIZAR PORQUE LAS FIRMAS NO COINCIDEN
			----------------------------------------------------------------------------------------------------------------------------------------
			----------------------------------------------------------------------------------------------------------------------------------------
			<?php
		}
		
		//Enviamos un email a la empresa con los datos técnicos de la pasarela
		$texto = ob_get_clean();
		Email::sendMail(array(
			'destinatario' => Shop::$empresa->direccion_email . ',' . Shop::$empresa->nombre_legal,
			//'destinatario' => 'pedro@arminet.es,Pedro',
			'asunto' => 'Resultado intento pago pasarela ',
			'contenido' => 'Hemos recibido un intento de pago. Estos son los datos técnicos:<br/>
			'. $texto
		));
		$this->setTemplateFile($templateFile);
		return($options);
	}

}